/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.geom.Point2D;
import java.util.List;
import org.systemsbiology.biotapestry.util.Vector2D;

public class DistanceMeasurer {
    private DistanceMeasurer() {
    }

    public static Vector2D calcDistances(List points) {
        int pSize = points.size();
        Vector2D[][] vecs = new Vector2D[pSize][pSize];
        for (int i = 0; i < pSize; ++i) {
            for (int j = i + 1; j < pSize; ++j) {
                Vector2D pDiff;
                Point2D pi = (Point2D)points.get(i);
                Point2D pj = (Point2D)points.get(j);
                vecs[i][j] = pDiff = new Vector2D(pi, pj);
                vecs[j][i] = pDiff;
            }
        }
        Vector2D horzAxis = new Vector2D(1.0, 0.0);
        double cutoff = 1.0 / Math.sqrt(2.0);
        int numH = 0;
        int numV = 0;
        double sumH = 0.0;
        double sumV = 0.0;
        for (int i = 0; i < pSize; ++i) {
            double vertMin = Double.POSITIVE_INFINITY;
            Vector2D vertVec = null;
            double horzMin = Double.POSITIVE_INFINITY;
            Vector2D horzVec = null;
            for (int j = 0; j < pSize; ++j) {
                if (i == j) continue;
                Vector2D currVec = vecs[i][j];
                double currDist = currVec.length();
                Vector2D norm = currVec.normalized();
                double dot = Math.abs(horzAxis.dot(norm));
                if (dot < cutoff) {
                    if (!(currDist < vertMin)) continue;
                    vertMin = currDist;
                    vertVec = currVec;
                    continue;
                }
                if (!(currDist < horzMin)) continue;
                horzMin = currDist;
                horzVec = currVec;
            }
            if (vertVec != null) {
                ++numV;
                sumV += Math.abs(vertVec.getY());
            }
            if (horzVec == null) continue;
            ++numH;
            sumH += Math.abs(horzVec.getX());
        }
        double avgH = numH == 0 ? 0.0 : sumH / (double)numH;
        double avgV = numV == 0 ? 0.0 : sumV / (double)numV;
        return new Vector2D(avgH, avgV);
    }
}

