/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

public class DoubMinMax
implements Cloneable {
    public static final int EQUALS = 0;
    public static final int IS_PROPER_SUPERSET = 1;
    public static final int IS_PROPER_SUBSET = 2;
    public static final int IS_DISJOINT = 3;
    public static final int INTERSECTS = 4;
    public double min;
    public double max;

    public DoubMinMax() {
    }

    public DoubMinMax(double val) {
        this.min = val;
        this.max = val;
    }

    public DoubMinMax(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public DoubMinMax(DoubMinMax other) {
        this.min = other.min;
        this.max = other.max;
    }

    public Object clone() {
        try {
            DoubMinMax newVal = (DoubMinMax)super.clone();
            return newVal;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public int hashCode() {
        return (int)Math.round(this.min + this.max);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof DoubMinMax)) {
            return false;
        }
        DoubMinMax otherMM = (DoubMinMax)other;
        return this.min == otherMM.min && this.max == otherMM.max;
    }

    public boolean contained(double val) {
        return val >= this.min && val <= this.max;
    }

    public boolean outsideOrOnBoundary(double val) {
        return val <= this.min || val >= this.max;
    }

    public DoubMinMax union(DoubMinMax other) {
        DoubMinMax retval = new DoubMinMax();
        retval.min = this.min < other.min ? this.min : other.min;
        retval.max = this.max > other.max ? this.max : other.max;
        return retval;
    }

    public DoubMinMax init() {
        this.min = Double.NEGATIVE_INFINITY;
        this.max = Double.POSITIVE_INFINITY;
        return this;
    }

    public DoubMinMax inverseInit() {
        this.max = Double.NEGATIVE_INFINITY;
        this.min = Double.POSITIVE_INFINITY;
        return this;
    }

    public void update(int newVal) {
        if ((double)newVal < this.min) {
            this.min = newVal;
        }
        if ((double)newVal > this.max) {
            this.max = newVal;
        }
    }

    public void update(double newVal) {
        if (newVal < this.min) {
            this.min = newVal;
        }
        if (newVal > this.max) {
            this.max = newVal;
        }
    }

    public int evaluate(DoubMinMax other) {
        if (this.min == other.min && this.max == other.max) {
            return 0;
        }
        if (this.min >= other.min && this.max <= other.max) {
            return 1;
        }
        if (this.min <= other.min && this.max >= other.max) {
            return 2;
        }
        if (this.max < other.min || this.min > other.max) {
            return 3;
        }
        return 4;
    }

    public String toString() {
        return "min: " + this.min + " max: " + this.max;
    }
}

