/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.NumberEditor;
import org.systemsbiology.biotapestry.util.ProtoDouble;
import org.systemsbiology.biotapestry.util.ResourceManager;

public class DoubleEditor
extends JTextField
implements TableCellEditor,
NumberEditor {
    private JFrame topWindow_;
    private ArrayList listeners_ = new ArrayList();
    private ProtoDouble origValue_;
    private int currRow_ = -1;
    private int currColumn_ = -1;
    boolean neverEdited_;
    private boolean blanksOK_;

    public DoubleEditor(JFrame topWindow) {
        this(topWindow, false);
    }

    public DoubleEditor(JFrame topWindow, boolean blanksOK) {
        this.topWindow_ = topWindow;
        this.neverEdited_ = true;
        this.blanksOK_ = blanksOK;
    }

    public static void triggerWarning(JFrame top) {
        ResourceManager rMan = ResourceManager.getManager();
        JOptionPane.showMessageDialog(top, rMan.getString("doubleEditor.notADouble"), rMan.getString("doubleEditor.errorTitle"), 0);
    }

    public static void triggerWarningWithTag(JFrame top, String tag, String val) {
        ResourceManager rMan = ResourceManager.getManager();
        String format = rMan.getString("doubleEditor.taggedNotADouble");
        String desc = MessageFormat.format(format, tag, val);
        JOptionPane.showMessageDialog(top, desc, rMan.getString("doubleEditor.errorTitle"), 0);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        try {
            this.currRow_ = row;
            this.currColumn_ = column;
            if (value == null) {
                this.setText(null);
            } else {
                this.setText(((ProtoDouble)value).textValue);
            }
            table.setRowSelectionInterval(row, row);
            table.setColumnSelectionInterval(column, column);
            this.origValue_ = (ProtoDouble)value;
            this.neverEdited_ = false;
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
        return this;
    }

    public int getCurrRow() {
        return this.currRow_;
    }

    public int getCurrColumn() {
        return this.currColumn_;
    }

    public boolean entryIsValid() {
        return this.currRow_ != -1 && this.currColumn_ != -1;
    }

    public void addCellEditorListener(CellEditorListener l) {
        try {
            this.listeners_.add(l);
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public void cancelCellEditing() {
        try {
            this.editingCanceled();
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public Object getCellEditorValue() {
        ProtoDouble retval = null;
        try {
            retval = new ProtoDouble(this.getText());
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
        return retval;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public void removeCellEditorListener(CellEditorListener l) {
        try {
            this.listeners_.remove(l);
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean stopCellEditing() {
        try {
            this.editingStopped();
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
        return true;
    }

    private void editingCanceled() {
        this.setText(this.origValue_ == null ? null : this.origValue_.textValue);
        ChangeEvent cev = new ChangeEvent(this);
        ArrayList lCopy = new ArrayList(this.listeners_);
        Iterator lit = lCopy.iterator();
        while (lit.hasNext()) {
            CellEditorListener cel = (CellEditorListener)lit.next();
            cel.editingCanceled(cev);
        }
        this.currRow_ = -1;
        this.currColumn_ = -1;
    }

    private void editingStopped() {
        if (!this.neverEdited_) {
            String text = this.getText();
            if (!this.blanksOK_ || text == null || !text.trim().equals("")) {
                ProtoDouble test = new ProtoDouble(this.getText());
                if (!test.valid) {
                    this.setText(this.origValue_ == null ? null : this.origValue_.textValue);
                    DoubleEditor.triggerWarning(this.topWindow_);
                }
            }
        }
        ChangeEvent cev = new ChangeEvent(this);
        ArrayList lCopy = new ArrayList(this.listeners_);
        Iterator lit = lCopy.iterator();
        while (lit.hasNext()) {
            CellEditorListener cel = (CellEditorListener)lit.next();
            cel.editingStopped(cev);
        }
        this.currRow_ = -1;
        this.currColumn_ = -1;
    }
}

