/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.Component;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import org.systemsbiology.biotapestry.util.ExceptionHandler;

public abstract class EditableComboBoxEditor
extends JComboBox
implements TableCellEditor {
    private ArrayList listeners_;
    private Object origValue_;
    private int currRow_;
    private int currColumn_;

    public EditableComboBoxEditor(Object valueObject) {
        this.valueFill(valueObject);
        this.listeners_ = new ArrayList();
        this.currRow_ = -1;
        this.currColumn_ = -1;
        this.setEditable(true);
    }

    public Object getOriginalValue() {
        return this.origValue_;
    }

    public abstract void valueFill(Object var1);

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        try {
            if (value == null) {
                return this;
            }
            this.currRow_ = row;
            this.currColumn_ = column;
            this.setSelectedItem(this.valueToDisplayString(value));
            this.origValue_ = value;
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
        return this;
    }

    public abstract String valueToDisplayString(Object var1);

    public int getCurrRow() {
        return this.currRow_;
    }

    public int getCurrColumn() {
        return this.currColumn_;
    }

    public String getCurrValue() {
        String retval = null;
        try {
            JTextComponent jtc = (JTextComponent)this.getEditor().getEditorComponent();
            retval = jtc.getText();
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
        return retval;
    }

    public boolean entryIsValid() {
        return this.currRow_ != -1 && this.currColumn_ != -1;
    }

    public void addCellEditorListener(CellEditorListener l) {
        try {
            this.listeners_.add(l);
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public void cancelCellEditing() {
        try {
            this.editingCanceled();
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public abstract Object displayStringToValue(String var1);

    public Object getCellEditorValue() {
        Object retval = null;
        try {
            retval = this.displayStringToValue(this.getCurrValue());
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
        return retval;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public void removeCellEditorListener(CellEditorListener l) {
        try {
            this.listeners_.remove(l);
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean stopCellEditing() {
        try {
            this.editingStopped();
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
        return true;
    }

    private void editingCanceled() {
        this.currRow_ = -1;
        this.currColumn_ = -1;
        if (this.origValue_ != null) {
            this.setSelectedItem(this.valueToDisplayString(this.origValue_));
        }
        ChangeEvent cev = new ChangeEvent(this);
        ArrayList lCopy = new ArrayList(this.listeners_);
        Iterator lit = lCopy.iterator();
        while (lit.hasNext()) {
            CellEditorListener cel = (CellEditorListener)lit.next();
            cel.editingCanceled(cev);
        }
    }

    private void editingStopped() {
        this.currRow_ = -1;
        this.currColumn_ = -1;
        ChangeEvent cev = new ChangeEvent(this);
        ArrayList lCopy = new ArrayList(this.listeners_);
        Iterator lit = lCopy.iterator();
        while (lit.hasNext()) {
            CellEditorListener cel = (CellEditorListener)lit.next();
            cel.editingStopped(cev);
        }
    }
}

