/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.JTextComponent;
import org.systemsbiology.biotapestry.util.EditableComboBoxEditor;
import org.systemsbiology.biotapestry.util.ExceptionHandler;

public class EditableComboBoxEditorTracker
implements ItemListener,
CaretListener {
    private EditableComboBoxEditor comboEdit_;
    private AbstractTableModel table_;
    private int ignoreCount_;

    public EditableComboBoxEditorTracker(EditableComboBoxEditor comboEdit, AbstractTableModel table) {
        this.comboEdit_ = comboEdit;
        this.table_ = table;
        comboEdit.addItemListener(this);
        JTextComponent jtc = (JTextComponent)comboEdit.getEditor().getEditorComponent();
        jtc.addCaretListener(this);
    }

    public void itemStateChanged(ItemEvent e) {
        try {
            if (this.comboEdit_.entryIsValid()) {
                int cc = this.comboEdit_.getCurrColumn();
                int cr = this.comboEdit_.getCurrRow();
                String si = (String)this.comboEdit_.getSelectedItem();
                this.table_.setValueAt(this.comboEdit_.displayStringToValue(si), cr, cc);
            }
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public void caretUpdate(CaretEvent e) {
        try {
            if (this.comboEdit_.entryIsValid()) {
                int cc = this.comboEdit_.getCurrColumn();
                int cr = this.comboEdit_.getCurrRow();
                String si = this.comboEdit_.getCurrValue();
                this.table_.setValueAt(this.comboEdit_.displayStringToValue(si), cr, cc);
            }
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }
}

