/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.systemsbiology.biotapestry.ui.dialogs.ExceptionDialog;
import org.systemsbiology.biotapestry.util.ResourceManager;

public class ExceptionHandler {
    private static ExceptionHandler singleton_;
    private JFrame topWindow_;
    private boolean paintException_ = false;
    private boolean headless_;
    private boolean inProcess_;
    private String outOfMemoryMessage_;
    private String outOfMemoryTitle_;

    public void displayException(Exception ex) {
        String jVer = System.getProperty("java.version");
        String jVend = System.getProperty("java.vendor");
        String os = System.getProperty("os.name");
        String version = "Java version = " + jVer + " vendor = " + jVend + " operating system = " + os;
        if (this.headless_) {
            if (this.inProcess_) {
                throw new HeadlessException(ex);
            }
            System.err.println(version);
            ex.printStackTrace();
            return;
        }
        if (this.topWindow_ == null) {
            System.err.println("Exception reporter not initialized");
            System.err.println(version);
            ex.printStackTrace();
            return;
        }
        System.err.println(version);
        ex.printStackTrace();
        ExceptionDialog ed = new ExceptionDialog(this.topWindow_, ex, version);
        ed.setVisible(true);
    }

    public void displayOutOfMemory(OutOfMemoryError oom) {
        if (this.headless_) {
            oom.printStackTrace();
            throw oom;
        }
        if (this.topWindow_ == null) {
            System.err.println("Out of memory (Exception reporter not initialized)");
            oom.printStackTrace();
            throw oom;
        }
        oom.printStackTrace();
        JOptionPane.showMessageDialog(this.topWindow_, this.outOfMemoryMessage_, this.outOfMemoryTitle_, 0);
        throw oom;
    }

    public void displayPaintException(Exception ex) {
        if (this.paintException_) {
            System.err.println("Extra paint exceptions continue");
            ex.printStackTrace();
            return;
        }
        this.paintException_ = true;
        this.displayException(ex);
    }

    public void initialize(JFrame topWindow) {
        this.headless_ = false;
        this.topWindow_ = topWindow;
    }

    public void initializeForHeadless(boolean inProcess) {
        this.headless_ = true;
        this.inProcess_ = inProcess;
        this.topWindow_ = null;
    }

    public static synchronized ExceptionHandler getHandler() {
        if (singleton_ == null) {
            singleton_ = new ExceptionHandler();
        }
        return singleton_;
    }

    private ExceptionHandler() {
        ResourceManager rMan = ResourceManager.getManager();
        this.outOfMemoryMessage_ = rMan.getString("errorMsg.outOfMemory");
        this.outOfMemoryTitle_ = rMan.getString("errorMsg.outOfMemoryTitle");
    }

    public static class HeadlessException
    extends RuntimeException {
        private Exception wrapped_;

        HeadlessException(Exception wrapped) {
            this.wrapped_ = wrapped;
        }

        public Exception getWrappedException() {
            return this.wrapped_;
        }
    }
}

