/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.Dimension;
import java.awt.Insets;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class FixedJButton
extends JButton {
    public static final int BOTH_FIXED = 0;
    public static final int VERT_ONLY_FIXED = 1;
    public static final int HORZ_ONLY_FIXED = 2;
    private int which_;

    public FixedJButton(String name) {
        super(name);
        this.which_ = 0;
    }

    public FixedJButton(int which, String name) {
        super(name);
        this.which_ = which;
    }

    public FixedJButton(String name, int reduce) {
        super(name);
        this.which_ = 0;
        Border bord = this.getBorder();
        if (bord instanceof CompoundBorder) {
            CompoundBorder comp = (CompoundBorder)bord;
            Insets bIn = comp.getInsideBorder().getBorderInsets(this);
            Border outBord = comp.getOutsideBorder();
            Border eBord = BorderFactory.createEmptyBorder(bIn.top, bIn.left - reduce, bIn.bottom, bIn.right - reduce);
            CompoundBorder nComp = BorderFactory.createCompoundBorder(outBord, eBord);
            this.setBorder(nComp);
        } else {
            Insets bIn = bord.getBorderInsets(this);
            Border eBord = BorderFactory.createEmptyBorder(bIn.top, bIn.left - reduce, bIn.bottom, bIn.right - reduce);
            this.setBorder(eBord);
        }
    }

    public FixedJButton(Icon icon) {
        super(icon);
        this.which_ = 0;
    }

    public FixedJButton(Icon icon, int reduce) {
        super(icon);
        this.which_ = 0;
        Border bord = this.getBorder();
        if (bord instanceof CompoundBorder) {
            CompoundBorder comp = (CompoundBorder)bord;
            Insets bIn = comp.getInsideBorder().getBorderInsets(this);
            Border outBord = comp.getOutsideBorder();
            Border eBord = BorderFactory.createEmptyBorder(bIn.top, bIn.left - reduce, bIn.bottom, bIn.right - reduce);
            CompoundBorder nComp = BorderFactory.createCompoundBorder(outBord, eBord);
            this.setBorder(nComp);
        } else {
            Insets bIn = bord.getBorderInsets(this);
            Border eBord = BorderFactory.createEmptyBorder(bIn.top, bIn.left - reduce, bIn.bottom, bIn.right - reduce);
            this.setBorder(eBord);
        }
    }

    public Dimension getPreferredSize() {
        Dimension ps = super.getPreferredSize();
        if (this.getIcon() != null) {
            ps.width = ps.height;
        }
        return ps;
    }

    public Dimension getMinimumSize() {
        if (this.which_ == 0) {
            return this.getPreferredSize();
        }
        if (this.which_ == 1) {
            int w = super.getMinimumSize().width;
            int h = this.getPreferredSize().height;
            return new Dimension(w, h);
        }
        if (this.which_ == 2) {
            int h = super.getMinimumSize().height;
            int w = this.getPreferredSize().width;
            return new Dimension(w, h);
        }
        throw new IllegalArgumentException();
    }

    public Dimension getMaximumSize() {
        if (this.which_ == 0) {
            return this.getPreferredSize();
        }
        if (this.which_ == 1) {
            int w = super.getMaximumSize().width;
            int h = this.getPreferredSize().height;
            return new Dimension(w, h);
        }
        if (this.which_ == 2) {
            int h = super.getMaximumSize().height;
            int w = this.getPreferredSize().width;
            return new Dimension(w, h);
        }
        throw new IllegalArgumentException();
    }

    public static FixedJButton miniFactory(String name, int reduce) {
        boolean isAMac = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
        if (isAMac) {
            String letter = name.substring(0, 1);
            URL img = FixedJButton.class.getResource("/org/systemsbiology/biotapestry/images/Mac" + letter + ".png");
            if (img == null) {
                img = FixedJButton.class.getResource("/org/systemsbiology/biotapestry/images/MacBlank.png");
            }
            ImageIcon pix = new ImageIcon(img);
            FixedJButton retval = new FixedJButton(pix);
            return retval;
        }
        return new FixedJButton(name, reduce);
    }
}

