/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.systemsbiology.biotapestry.util.DoubMinMax;

public class GoodnessChart
extends JPanel {
    private SortedMap progress_;

    public GoodnessChart() {
        this.setBackground(Color.white);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 200);
    }

    public void setProgress(SortedMap progress) {
        this.progress_ = progress;
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.drawingGuts(g2);
    }

    private void drawingGuts(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        BasicStroke selectedStroke = new BasicStroke(1.0f, 2, 0);
        g2.setStroke(selectedStroke);
        Dimension screenDim = this.getSize();
        g2.setColor(Color.white);
        Rectangle bg = new Rectangle(0, 0, screenDim.width, screenDim.height);
        g2.fill(bg);
        if (this.progress_ == null || this.progress_.isEmpty()) {
            return;
        }
        g2.setColor(Color.blue);
        DoubMinMax dmm = new DoubMinMax();
        dmm.inverseInit();
        int numProg = this.progress_.size();
        Iterator pit = this.progress_.keySet().iterator();
        while (pit.hasNext()) {
            Integer key = (Integer)pit.next();
            Double val = (Double)this.progress_.get(key);
            dmm.update(val);
        }
        int barsForShow = Math.max(numProg, 10);
        int barWidth = (int)Math.floor((double)screenDim.width / (double)barsForShow);
        double maxBarHeight = screenDim.height;
        int count = 0;
        pit = this.progress_.keySet().iterator();
        while (pit.hasNext()) {
            Integer key = (Integer)pit.next();
            Double val = (Double)this.progress_.get(key);
            int startx = count++ * barWidth;
            int barHeight = (int)Math.round(maxBarHeight * (val / dmm.max));
            int ul = screenDim.height - (int)Math.round(maxBarHeight * (val / dmm.max));
            Rectangle drawIt = new Rectangle(startx, ul, barWidth, barHeight);
            g2.fill(drawIt);
        }
    }

    public static void main(String[] argv) {
        GoodnessChart msc = new GoodnessChart();
        TreeMap<Integer, Double> allProgress = new TreeMap<Integer, Double>();
        allProgress.put(new Integer(0), new Double(3024.0));
        allProgress.put(new Integer(1), new Double(2956.0));
        allProgress.put(new Integer(2), new Double(2458.0));
        msc.setProgress(allProgress);
        JFrame frame = new JFrame();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.getContentPane().add(msc);
        frame.pack();
        frame.setSize(new Dimension(400, 300));
        frame.show();
    }
}

