/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.util.ArrayList;
import java.util.List;
import org.systemsbiology.biotapestry.util.MultiLineRenderSupport;

public class LineBreaker {
    public static String fixBreaksForTrim(String breakDef, String untrimmed) {
        int utl;
        if (breakDef == null) {
            return null;
        }
        String trimmed = untrimmed.trim();
        int tl = trimmed.length();
        if (tl == (utl = untrimmed.length())) {
            return breakDef;
        }
        int frontIndex = untrimmed.indexOf(trimmed);
        int backIndex = frontIndex + tl;
        List breaks = MultiLineRenderSupport.parseBreaks(breakDef);
        int count = 0;
        while (count < breaks.size()) {
            Integer brk = (Integer)breaks.get(count);
            int brkVal = brk;
            if (brkVal <= frontIndex || brkVal > backIndex) {
                breaks.remove(count);
                continue;
            }
            breaks.set(count, new Integer(brkVal - frontIndex));
            ++count;
        }
        return MultiLineRenderSupport.buildBreaks(breaks);
    }

    public static String resolveNameChange(String breakDef, LineBreakChangeSteps steps) {
        int numSteps = steps.stepChanges.size();
        if (breakDef == null || numSteps == 0) {
            return breakDef;
        }
        List breaks = MultiLineRenderSupport.parseBreaks(breakDef);
        block5: for (int i = 0; i < numSteps; ++i) {
            ChangeStep cs = (ChangeStep)steps.stepChanges.get(i);
            if (i == 0 && cs.oldString == null && cs.type == 1 && cs.length == cs.newString.length()) continue;
            switch (cs.type) {
                case 1: {
                    LineBreaker.calcInsert(breaks, cs);
                    continue block5;
                }
                case 0: {
                    LineBreaker.calcDelete(breaks, cs);
                    continue block5;
                }
                case 2: {
                    LineBreaker.calcReplace(breaks, cs);
                    continue block5;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return MultiLineRenderSupport.buildBreaks(breaks);
    }

    private static void calcInsert(List breaks, ChangeStep cs) {
        int numBr = breaks.size();
        for (int j = 0; j < numBr; ++j) {
            Integer brk = (Integer)breaks.get(j);
            int brkVal = brk;
            if (brkVal < cs.index) continue;
            breaks.set(j, new Integer(brkVal + cs.length));
        }
    }

    private static void calcDelete(List breaks, ChangeStep cs) {
        int numBr = breaks.size();
        int deathMin = cs.index;
        int deathMax = cs.index + cs.length;
        boolean ghostAdded = false;
        int count = 0;
        while (count < breaks.size()) {
            Integer brk = (Integer)breaks.get(count);
            int brkVal = brk;
            if (brkVal < deathMin) {
                ++count;
                continue;
            }
            if (brkVal >= deathMin && brkVal < deathMax) {
                if (!ghostAdded) {
                    breaks.set(count, new Integer(deathMin));
                    ghostAdded = true;
                    ++count;
                    continue;
                }
                breaks.remove(count);
                continue;
            }
            breaks.set(count, new Integer(brkVal - cs.length));
            ++count;
        }
    }

    private static void calcReplace(List breaks, ChangeStep cs) {
        List res = LineBreaker.fragToRe(breaks, cs.index, cs.length, cs.fragment1);
        List newbrks = LineBreaker.bestBreakFits(res, cs.step2Length, cs.fragment2);
        newbrks = LineBreaker.bestBreakFitsSecondPass(res, newbrks, cs.step2Length, cs.fragment2);
        int numBr = breaks.size();
        int deathMin = cs.index;
        int deathMax = cs.index + cs.length;
        int fragDiff = cs.step2Length - cs.length;
        int newCount = 0;
        int count = 0;
        while (count < breaks.size()) {
            Integer brk = (Integer)breaks.get(count);
            int brkVal = brk;
            if (brkVal < deathMin) {
                ++count;
                continue;
            }
            if (brkVal >= deathMin && brkVal < deathMax) {
                Integer newBreak = (Integer)newbrks.get(newCount);
                int newBreakVal = newBreak;
                if (newBreakVal != -1) {
                    breaks.set(count, new Integer(deathMin + newBreakVal));
                    ++count;
                    ++newCount;
                    continue;
                }
                breaks.remove(count);
                ++newCount;
                continue;
            }
            breaks.set(count, new Integer(brkVal + fragDiff));
            ++count;
        }
    }

    private static List fragToRe(List breaks, int fragStart, int fragLen, String fragment) {
        ArrayList<char[]> retval = new ArrayList<char[]>();
        int numBr = breaks.size();
        int fragEnd = fragStart + fragLen;
        for (int j = 0; j < numBr; ++j) {
            Integer brk = (Integer)breaks.get(j);
            int brkVal = brk;
            if (brkVal < fragStart || brkVal > fragEnd) continue;
            int fragIndx = brkVal - fragStart;
            char[] addMe = new char[2];
            if (fragIndx == 0) {
                addMe[0] = '\u0000';
                addMe[1] = fragment.charAt(0);
            } else if (fragIndx == fragLen) {
                addMe[0] = fragment.charAt(fragLen - 1);
                addMe[1] = '\u0000';
            } else {
                addMe[0] = fragment.charAt(fragIndx - 1);
                addMe[1] = fragment.charAt(fragIndx);
            }
            retval.add(addMe);
        }
        return retval;
    }

    private static List bestBreakFits(List res, int fragLen, String newFragment) {
        ArrayList<Integer> retval = new ArrayList<Integer>();
        int numRe = res.size();
        int currIndex = 0;
        for (int currRe = 0; currRe < numRe; ++currRe) {
            char[] re = (char[])res.get(currRe);
            if (re[0] == '\u0000') {
                retval.add(new Integer(0));
                continue;
            }
            if (re[1] == '\u0000') {
                retval.add(new Integer(fragLen - 1));
                continue;
            }
            boolean didMatch = false;
            for (int i = currIndex; i < fragLen - 1; ++i) {
                if (newFragment.charAt(i) != re[0] || newFragment.charAt(i + 1) != re[1]) continue;
                retval.add(new Integer(i + 1));
                currIndex = i + 1;
                didMatch = true;
                break;
            }
            if (didMatch) continue;
            retval.add(new Integer(-100 - currRe));
        }
        return retval;
    }

    private static int getNextBreak(List breaks, int fragLen, int currBr) {
        int numBr = breaks.size();
        for (int i = currBr + 1; i < numBr; ++i) {
            Integer brk = (Integer)breaks.get(i);
            int brkVal = brk;
            if (brkVal < 0) continue;
            return brkVal;
        }
        return fragLen - 1;
    }

    private static List bestBreakFitsSecondPass(List res, List breaks, int fragLen, String newFragment) {
        ArrayList<Integer> retval = new ArrayList<Integer>();
        int numBr = breaks.size();
        int lastBrk = 0;
        for (int i = 0; i < numBr; ++i) {
            boolean hasPostSpace;
            Integer brk = (Integer)breaks.get(i);
            int brkVal = brk;
            if (brkVal >= 0) {
                retval.add(brk);
                lastBrk = brkVal;
                continue;
            }
            int nextBrk = LineBreaker.getNextBreak(breaks, fragLen, i);
            String fragToChk = newFragment.substring(lastBrk, nextBrk);
            int currRe = -brkVal - 100;
            char[] re = (char[])res.get(currRe);
            boolean hasPreSpace = re[0] == ' ';
            boolean bl = hasPostSpace = re[1] == ' ';
            if (hasPreSpace || hasPostSpace) {
                int useThis = fragToChk.indexOf(32);
                if (useThis != -1) {
                    lastBrk = useThis + lastBrk;
                    if (hasPreSpace) {
                        ++lastBrk;
                    }
                    retval.add(new Integer(lastBrk));
                    ++lastBrk;
                    continue;
                }
                retval.add(new Integer(-1));
                continue;
            }
            retval.add(new Integer(-1));
        }
        return retval;
    }

    public static String massageLineBreaks(String breakDef, String baseName) {
        if (breakDef == null) {
            return null;
        }
        List breaks = MultiLineRenderSupport.parseBreaks(breakDef);
        int numBrk = breaks.size();
        int baseLen = baseName.length();
        ArrayList<Integer> retval = new ArrayList<Integer>();
        int lastBrk = -1;
        for (int i = 0; i < numBrk; ++i) {
            Integer brk = (Integer)breaks.get(i);
            int brkVal = brk;
            if (brkVal >= baseLen || lastBrk != 1 && brkVal == lastBrk) continue;
            retval.add(brk);
            lastBrk = brkVal;
        }
        return MultiLineRenderSupport.buildBreaks(retval);
    }

    public static void main(String[] argv) {
        try {
            String str3 = "This \nis a test str\ning";
            String insertLoc = "test";
            String frag = "foo";
            LineBreaker.insertTest(str3, insertLoc, frag);
            str3 = "This \nis a testy\ntesty\ntesty str\ning";
            String delete = "testytestytesty ";
            LineBreaker.deleteTest(str3, delete);
            str3 = "This \nis a testytestytesty str\ning \ntoo";
            delete = "testytestytesty ";
            LineBreaker.deleteTest(str3, delete);
            str3 = "This \nis a testytestytesty str\ning \ntoo";
            delete = "too";
            LineBreaker.deleteTest(str3, delete);
            str3 = "This \nis a testytestytesty str\ning \ntoo";
            delete = "testytestytesty";
            String replace = "zippy";
            LineBreaker.replaceTest(str3, delete, replace);
            str3 = "This \nis a testy\ntesty\ntesty str\ning \ntoo";
            delete = "testytestytesty";
            replace = "testytestytesty";
            LineBreaker.replaceTest(str3, delete, replace);
            str3 = "This \nis a testy\ntesty\ntesty str\ning \ntoo";
            delete = "testytestytesty";
            replace = "tastytastytasty";
            LineBreaker.replaceTest(str3, delete, replace);
            str3 = "This \nis a \ntestytestytesty \nstr\ning \ntoo";
            delete = "testytestytesty";
            replace = "xxxxxxxxxxxxxxx";
            LineBreaker.replaceTest(str3, delete, replace);
            str3 = "This \nis a \ntestytestytesty str\ning \ntoo";
            delete = "testytestytesty";
            replace = "xxxxxxxxxxxxxxx";
            LineBreaker.replaceTest(str3, delete, replace);
            str3 = "This \nis a te\nsty \ntesty\n test\ny str\ning \ntoo";
            delete = "testy testy testy";
            replace = "xesxx xxxxx xxxty";
            LineBreaker.replaceTest(str3, delete, replace);
        }
        catch (Exception ioex) {
            System.err.println(ioex);
            ioex.printStackTrace();
        }
    }

    private static void insertTest(String str3, String insertLoc, String frag) {
        LineBreakChangeSteps steps = new LineBreakChangeSteps();
        String str1 = MultiLineRenderSupport.stripBreaks(str3);
        ChangeStep cs1 = new ChangeStep(1, 0, str1.length(), str1, null);
        steps.addChange(cs1);
        int index1 = str1.indexOf(insertLoc);
        String str2 = str1.substring(0, index1) + frag + str1.substring(index1);
        ChangeStep cs2 = new ChangeStep(1, index1, frag.length(), str2, str1);
        steps.addChange(cs2);
        LineBreaker.showIt(str3, str2, steps);
    }

    private static void deleteTest(String str3, String delete) {
        LineBreakChangeSteps steps = new LineBreakChangeSteps();
        String str1 = MultiLineRenderSupport.stripBreaks(str3);
        ChangeStep cs1 = new ChangeStep(1, 0, str1.length(), str1, null);
        steps.addChange(cs1);
        int index1 = str1.indexOf(delete);
        String str2 = str1.substring(0, index1) + str1.substring(index1 + delete.length());
        ChangeStep cs2 = new ChangeStep(0, index1, delete.length(), str2, str1);
        steps.addChange(cs2);
        LineBreaker.showIt(str3, str2, steps);
    }

    private static void replaceTest(String str3, String delete, String replace) {
        LineBreakChangeSteps steps = new LineBreakChangeSteps();
        String str1 = MultiLineRenderSupport.stripBreaks(str3);
        ChangeStep cs1 = new ChangeStep(1, 0, str1.length(), str1, null);
        steps.addChange(cs1);
        int index1 = str1.indexOf(delete);
        String str2 = str1.substring(0, index1) + str1.substring(index1 + delete.length());
        ChangeStep cs2 = new ChangeStep(0, index1, delete.length(), str2, str1);
        steps.addChange(cs2);
        String str4 = str2.substring(0, index1) + replace + str2.substring(index1);
        ChangeStep cs3 = new ChangeStep(1, index1, replace.length(), str4, str2);
        steps.addChange(cs3);
        LineBreaker.showIt(str3, str4, steps);
    }

    private static void showIt(String str3, String str4, LineBreakChangeSteps steps) {
        System.out.println("postOp: " + str4);
        String breaks = MultiLineRenderSupport.genBreaks(str3);
        System.out.println("old breaks " + breaks);
        String newBrks = LineBreaker.resolveNameChange(breaks, steps);
        System.out.println("new breaks " + newBrks);
        System.out.println("was>" + str3 + "<");
        String broken = MultiLineRenderSupport.applyLineBreaks(str4, newBrks);
        System.out.println("now>" + broken + "<");
        System.out.println("-----------------------------------------------");
    }

    public static class ChangeStep {
        public static final int DELETE = 0;
        public static final int INSERT = 1;
        public static final int REPLACE = 2;
        public String oldString;
        public String newString;
        public int index;
        public int length;
        public int step2Length;
        public int type;
        public String fragment1;
        public String fragment2;

        public ChangeStep(int type, int index, int length, String newString, String oldString) {
            this.oldString = oldString;
            this.newString = newString;
            this.index = index;
            this.length = length;
            this.type = type;
            if (this.type == 1) {
                this.fragment1 = newString.substring(index, index + length);
            } else if (this.type == 0) {
                this.fragment1 = oldString == null ? "" : oldString.substring(index, index + length);
            } else {
                throw new IllegalArgumentException();
            }
        }

        public String toString() {
            return "ChangeStep: " + this.oldString + " " + this.newString + " " + this.index + " " + this.length + " " + this.step2Length + " " + this.type + " " + this.fragment1 + " " + this.fragment2;
        }

        public ChangeStep mergeToReplacement(ChangeStep secondStep) {
            return null;
        }
    }

    public static class LineBreakChangeSteps {
        public ArrayList stepChanges = new ArrayList();

        public void addChange(ChangeStep change) {
            int numCh = this.stepChanges.size();
            if (numCh > 0) {
                ChangeStep lastChange = (ChangeStep)this.stepChanges.get(numCh - 1);
                if (lastChange.type == 0 && change.type == 1 && lastChange.index == change.index) {
                    lastChange.type = 2;
                    lastChange.newString = change.newString;
                    lastChange.step2Length = change.length;
                    lastChange.fragment2 = change.fragment1;
                } else {
                    this.stepChanges.add(change);
                }
            } else {
                this.stepChanges.add(change);
            }
        }

        public void clearChanges() {
            this.stepChanges.clear();
        }

        public String toString() {
            return "LineBreakChangeSteps: " + this.stepChanges.toString();
        }

        public LineBreakChangeSteps lastStepsOnly() {
            LineBreakChangeSteps retval = new LineBreakChangeSteps();
            int myLen = this.stepChanges.size();
            if (myLen > 0) {
                retval.addChange((ChangeStep)this.stepChanges.get(myLen - 1));
            }
            return retval;
        }
    }
}

