/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.analysis.GraphColorer;
import org.systemsbiology.biotapestry.analysis.Link;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.CornerOracle;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkProperties;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.util.AsynchExitRequestException;
import org.systemsbiology.biotapestry.util.BTProgressMonitor;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.NonConvergenceException;
import org.systemsbiology.biotapestry.util.Pattern;
import org.systemsbiology.biotapestry.util.PatternGrid;
import org.systemsbiology.biotapestry.util.RecoveryDOFAnalyzer;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;

public class LinkPlacementGrid {
    private static final int STOP = 0;
    private static final int OK = 1;
    private static final int CONTINUE = 2;
    private static final int NO_CORNER = 0;
    private static final int STRAIGHT_CORNER = 1;
    private static final int SINGLE_BEND_CORNER = 2;
    private static final int COMPLEX_CORNER = 3;
    private static final int MULTI_CORNER = 4;
    private static final int NOT_RUN = 0;
    private static final int VERT_RUN = 1;
    private static final int HORZ_RUN = 2;
    private static final int BAD_RUN = 3;
    private static final int NO_CLEANUP_ = 0;
    private static final int DID_CLEANUP_ = 1;
    private static final int RECOV_STEP_NO_CODE_ = -1;
    private static final int RECOV_STEP_CORE_FAILED_ = 0;
    private static final int RECOV_STEP_CORE_NO_TURN_ = 1;
    private static final int RECOV_STEP_CORE_NO_TURN_NO_JUMP_ = 2;
    private static final int RECOV_STEP_EMBEDDED_JUMP_FAILED_ = 3;
    private static final int RECOV_STEP_CORE_OK_ = 4;
    public static final int NONE = 0;
    public static final int NORTH = 1;
    public static final int EAST = 2;
    public static final int SOUTH = 4;
    public static final int WEST = 8;
    public static final int DIAGONAL = 16;
    public static final int IS_EMPTY = 0;
    public static final int IS_NODE = 1;
    public static final int IS_NODE_INBOUND_OK = 2;
    public static final int IS_CORNER = 3;
    public static final int IS_PAD = 4;
    public static final int IS_RUN = 5;
    public static final int IS_DEGENERATE = 6;
    public static final int IS_RESERVED_DEPARTURE_RUN = 7;
    public static final int IS_RESERVED_ARRIVAL_RUN = 8;
    public static final int IS_GROUP = 9;
    public static final int IS_RESERVED_MULTI_LINK_ARRIVAL_RUN = 10;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    private HashMap groups_ = new HashMap();
    private HashMap patternx_ = new HashMap();
    private HashMap userData_ = new HashMap();
    private HashMap gauss_ = new HashMap();
    private Rectangle bounds_ = null;
    private double sqrt2o2_ = Math.sqrt(2.0) / 2.0;
    private HashSet drawnLinks_ = new HashSet();

    public boolean isEmpty(Rectangle rect) {
        Rectangle cRect = LinkPlacementGrid.rectConversion(rect);
        PatternIterator it = new PatternIterator(false, false);
        while (it.hasNext()) {
            GridContents gc;
            Point pt = (Point)it.next();
            if (!cRect.contains(pt) || (gc = this.getGridContents(pt, false)) == null) continue;
            return false;
        }
        return true;
    }

    public LinkPlacementGrid subset(Rectangle rect) {
        LinkPlacementGrid retval = new LinkPlacementGrid();
        retval.bounds_ = (Rectangle)rect.clone();
        PatternIterator it = new PatternIterator(false, false);
        while (it.hasNext()) {
            Point pt = (Point)it.next();
            if (!retval.bounds_.contains(pt)) continue;
            GridContents gc = this.getGridContents(pt, false);
            retval.patternx_.put(pt.clone(), gc.clone());
        }
        Iterator git = this.groups_.keySet().iterator();
        while (git.hasNext()) {
            String gid = (String)git.next();
            Rectangle gRect = (Rectangle)this.groups_.get(gid);
            Rectangle2D retPart = gRect.createIntersection(retval.bounds_);
            if (!(retPart.getHeight() > 0.0) || !(retPart.getWidth() > 0.0)) continue;
            retval.groups_.put(gid, UiUtil.rectFromRect2D(retPart));
        }
        retval.drawnLinks_ = new HashSet(this.drawnLinks_);
        return retval;
    }

    public void dropLink(String srcID, Genome genome, String overlayID) {
        PatternIterator acit = new PatternIterator(false, false);
        ArrayList deadList = new ArrayList();
        HashMap<Point, GridContents> holdMods = new HashMap<Point, GridContents>();
        while (acit.hasNext()) {
            Point cellPt = (Point)acit.next();
            GridContents gc = this.getGridContents(cellPt, false);
            if (!this.lookForSource(srcID, gc) || this.dropLinkReference(gc, srcID, cellPt, deadList)) continue;
            holdMods.put(cellPt, gc);
        }
        Iterator mit = holdMods.keySet().iterator();
        while (mit.hasNext()) {
            Point cellPt = (Point)mit.next();
            GridContents gc = (GridContents)holdMods.get(cellPt);
            this.writeBackModifiedGridContents(cellPt, gc);
        }
        int dlnum = deadList.size();
        for (int i = 0; i < dlnum; ++i) {
            Point dead = (Point)deadList.get(i);
            this.dropFromPattern(dead);
        }
        this.drawnLinkAccounting(genome, srcID, overlayID);
    }

    public void debugPatternGrid(boolean skipGroups) {
        PatternGrid retval = new PatternGrid();
        PatternIterator kit = new PatternIterator(!skipGroups, false);
        while (kit.hasNext()) {
            Point pt = (Point)kit.next();
            GridContents gval = this.getGridContents(pt);
            if (gval == null || skipGroups && this.cellIsGroupOnly(gval)) continue;
            retval.fill(pt.x, pt.y, "X");
        }
        System.out.println(retval);
    }

    public PatternGrid extractPatternGrid(boolean skipGroups) {
        PatternGrid retval = new PatternGrid();
        PatternIterator kit = new PatternIterator(!skipGroups, false);
        while (kit.hasNext()) {
            Point pt = (Point)kit.next();
            GridContents gval = this.getGridContents(pt);
            if (gval == null || skipGroups && this.cellIsGroupOnly(gval)) continue;
            retval.fill(pt.x, pt.y, "");
        }
        return retval;
    }

    public Map findBadModuleCells(boolean ignoreBacktracks) {
        HashMap badRuns = new HashMap();
        PatternIterator kit = new PatternIterator(false, false);
        while (kit.hasNext()) {
            Set moduleOverlap;
            Point pt = (Point)kit.next();
            GridContents gval = this.getGridContents(pt);
            if (gval == null) continue;
            Set badCell = this.hasBadCellContents(gval);
            if (!(badCell == null || ignoreBacktracks && badCell.size() <= 1)) {
                this.addForBadCell(badCell, pt, badRuns, false);
            }
            if ((moduleOverlap = this.hasBadModuleCollisions(gval)) == null) continue;
            this.addForBadCell(moduleOverlap, pt, badRuns, true);
        }
        return badRuns.isEmpty() ? null : badRuns;
    }

    private void addForBadCell(Set badCell, Point pt, Map badRuns, boolean isForMod) {
        HashMap<String, DecoInfo> forPt = (HashMap<String, DecoInfo>)badRuns.get(pt);
        if (forPt == null) {
            forPt = new HashMap<String, DecoInfo>();
            badRuns.put(pt, forPt);
        }
        Iterator bcit = badCell.iterator();
        while (bcit.hasNext()) {
            String key = (String)bcit.next();
            DecoInfo di = this.getUserData(pt, key);
            if (di == null) continue;
            forPt.put(key, di);
        }
        if (isForMod) {
            DecoInfo di4mod = new DecoInfo(true);
            forPt.put("__WJRL_DECO_BOGUS_KEY__", di4mod);
        }
    }

    public Set findBadRuns() {
        HashSet badRuns = new HashSet();
        PatternIterator kit = new PatternIterator(false, false);
        while (kit.hasNext()) {
            Set badCell;
            Point pt = (Point)kit.next();
            GridContents gval = this.getGridContents(pt);
            if (gval == null || (badCell = this.hasBadCellContents(gval)) == null) continue;
            badRuns.addAll(badCell);
        }
        return badRuns.isEmpty() ? null : badRuns;
    }

    public Set getNodeOverlaps() {
        HashSet<Point> badPoints = new HashSet<Point>();
        PatternIterator kit = new PatternIterator(false, false);
        while (kit.hasNext()) {
            Point pt = (Point)kit.next();
            GridContents gval = this.getGridContents(pt);
            if (gval == null || !this.hasNodeOverlap(gval)) continue;
            badPoints.add(pt);
        }
        return badPoints;
    }

    private Set hasBadCellContents(GridContents gc) {
        HashSet<String> retval = new HashSet<String>();
        if (gc == null) {
            return null;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            if (gc.entry.cornerType() == 4) {
                retval.add(gc.entry.id);
                return retval;
            }
            return null;
        }
        int size = gc.extra.size();
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (currEntry.type != 3 && currEntry.type != 4 && currEntry.type != 5) continue;
            retval.add(currEntry.id);
        }
        boolean gottaCorner = false;
        boolean gottaVertRun = false;
        boolean gottaHorzRun = false;
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            int corType = currEntry.cornerType();
            if (corType == 4) {
                return retval;
            }
            if (corType != 0) {
                if (gottaCorner || gottaVertRun || gottaHorzRun) {
                    return retval;
                }
                gottaCorner = true;
                continue;
            }
            int runType = currEntry.runDirection();
            if (runType == 0) continue;
            if (runType == 3) {
                return retval;
            }
            if (runType == 1) {
                if (gottaCorner || gottaVertRun) {
                    return retval;
                }
                gottaVertRun = true;
                continue;
            }
            if (runType != 2) continue;
            if (gottaCorner || gottaHorzRun) {
                return retval;
            }
            gottaHorzRun = true;
        }
        return null;
    }

    private Set hasBadModuleCollisions(GridContents gc) {
        HashSet<String> retval = new HashSet<String>();
        if (gc == null) {
            return null;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            return null;
        }
        boolean gottaModule = false;
        int size = gc.extra.size();
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (currEntry.type == 3 || currEntry.type == 5) {
                retval.add(currEntry.id);
            }
            if (currEntry.type != 9) continue;
            gottaModule = true;
        }
        if (gottaModule && !retval.isEmpty()) {
            return retval;
        }
        return null;
    }

    private boolean hasNodeOverlap(GridContents gc) {
        if (gc == null) {
            return false;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            return false;
        }
        int size = gc.extra.size();
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry1 = (GridEntry)gc.extra.get(i);
            for (int j = 0; j < size; ++j) {
                GridEntry currEntry2;
                if (i == j || !currEntry1.hasNodeCollision(currEntry2 = (GridEntry)gc.extra.get(j))) continue;
                return true;
            }
        }
        return false;
    }

    public int getClosestPoint(String srcID, Point target, Point result, Set ignore, Set okGroups, Set linksFromSource) throws NonConvergenceException {
        int retval = 0;
        double minDist = Double.POSITIVE_INFINITY;
        Point currResult = null;
        PatternIterator kit = new PatternIterator(false, false);
        while (kit.hasNext()) {
            double distance;
            Point2D.Double ptr;
            int cellType;
            GridContents gval;
            Point pt = (Point)kit.next();
            if (ignore.contains(pt) || (gval = this.getGridContents(pt)) == null || (cellType = this.lookForLaunchCell(srcID, gval, okGroups, linksFromSource)) == 0 || this.notOverMyGenePad(srcID, null, ptr = new Point2D.Double(pt.x, pt.y)) || !((distance = new Vector2D(ptr, target).length()) < minDist)) continue;
            currResult = pt;
            minDist = distance;
            retval = cellType;
        }
        if (currResult == null) {
            throw new NonConvergenceException();
        }
        result.setLocation(currResult);
        return retval;
    }

    public boolean notOverMyGenePad(String srcID, String trgID, Point2D candidate) {
        return false;
    }

    public Set getRunAlternatives(String srcID, Point original, int origType, Set ignore) {
        HashSet<PointAlternative> retval = new HashSet<PointAlternative>();
        retval.add(new PointAlternative(original, origType, 0));
        GridContents gc = this.getGridContents(original);
        if (gc.extra != null) {
            return retval;
        }
        HashSet<Integer> checkVec = new HashSet<Integer>();
        GridEntry entry = gc.entry;
        if (entry.entryCount > 1) {
            return retval;
        }
        if ((entry.exits & 1) != 0 || (entry.entries & 1) != 0) {
            checkVec.add(new Integer(1));
        }
        if ((entry.exits & 4) != 0 || (entry.entries & 4) != 0) {
            checkVec.add(new Integer(4));
        }
        if ((entry.exits & 2) != 0 || (entry.entries & 2) != 0) {
            checkVec.add(new Integer(2));
        }
        if ((entry.exits & 8) != 0 || (entry.entries & 8) != 0) {
            checkVec.add(new Integer(8));
        }
        Iterator cvit = checkVec.iterator();
        block0: while (cvit.hasNext()) {
            Point intPt;
            GridContents currGc;
            Integer dir = (Integer)cvit.next();
            Vector2D vec = LinkPlacementGrid.getVector(dir);
            Point2D newPt = (Point2D)original.clone();
            while ((currGc = this.getGridContents(intPt = new Point((int)(newPt = vec.add(newPt)).getX(), (int)newPt.getY()))) != null) {
                if (this.isSingleRunForSource(currGc, srcID)) {
                    if (currGc.extra != null || ignore.contains(intPt)) continue;
                    retval.add(new PointAlternative((Point)intPt.clone(), 5, 0));
                    continue;
                }
                if (currGc.extra != null) continue block0;
                GridEntry currEntry = currGc.entry;
                if (!currEntry.id.equals(entry.id) || currEntry.type != 3 || ignore.contains(intPt)) continue block0;
                retval.add(new PointAlternative((Point)intPt.clone(), 3, 0));
                continue block0;
            }
        }
        return retval;
    }

    private List getBestDirections(Point start, Point2D scaleStart, Point2D end) {
        Vector2D direct = new Vector2D(scaleStart, end);
        List exits = this.getPossibleExits(start);
        if (exits == null) {
            return null;
        }
        TreeMap bestest = new TreeMap(Collections.reverseOrder());
        Iterator eit = exits.iterator();
        while (eit.hasNext()) {
            Vector2D pExit = (Vector2D)eit.next();
            double dot = direct.dot(pExit);
            Double dotObj = new Double(dot);
            ArrayList<Integer> dirs = (ArrayList<Integer>)bestest.get(dotObj);
            if (dirs == null) {
                dirs = new ArrayList<Integer>();
                bestest.put(dotObj, dirs);
            }
            dirs.add(new Integer(LinkPlacementGrid.getDirection(pExit)));
        }
        ArrayList retval = new ArrayList();
        Iterator bvit = bestest.values().iterator();
        while (bvit.hasNext()) {
            ArrayList nextList = (ArrayList)bvit.next();
            retval.addAll(nextList);
        }
        return retval.isEmpty() ? null : retval;
    }

    public PointAlternative chooseBestAlternative(String src, String trg, String linkID, Point end, Set nearby, Point orig, int origType, Set okGroups, boolean isStart) {
        Point2D.Double ptEnd = new Point2D.Double(end.getX(), end.getY());
        double bestDist = 0.0;
        HashMap<PointAlternative, TravelResult> bestCorners = new HashMap<PointAlternative, TravelResult>();
        HashMap<PointAlternative, TravelResult> bestRuns = new HashMap<PointAlternative, TravelResult>();
        HashMap<PointAlternative, TravelResult> farCorners = new HashMap<PointAlternative, TravelResult>();
        HashMap<PointAlternative, TravelResult> farRuns = new HashMap<PointAlternative, TravelResult>();
        HashSet<PointAlternative> orthoCorners = new HashSet<PointAlternative>();
        HashSet<PointAlternative> orthoRuns = new HashSet<PointAlternative>();
        HashSet groupBlockers = okGroups != null ? new HashSet() : null;
        Iterator nit = nearby.iterator();
        while (nit.hasNext()) {
            PointAlternative noDirAlt = (PointAlternative)nit.next();
            Point2D.Double ptOnRun = new Point2D.Double(noDirAlt.point.getX(), noDirAlt.point.getY());
            List bestDirs = this.getBestDirections(noDirAlt.point, ptOnRun, end);
            if (bestDirs == null) continue;
            int numDirs = bestDirs.size();
            for (int i = 0; i < numDirs; ++i) {
                Integer dir = (Integer)bestDirs.get(i);
                int bestDir = dir;
                PointAlternative dirAlt = (PointAlternative)noDirAlt.clone();
                dirAlt.dir = bestDir;
                Vector2D travel = new Vector2D(ptOnRun, ptEnd);
                Vector2D bestVec = LinkPlacementGrid.getVector(bestDir);
                double fullDist = travel.dot(bestVec);
                if (fullDist < 0.0) continue;
                if (fullDist == 0.0) {
                    if (noDirAlt.type == 3) {
                        orthoCorners.add(dirAlt);
                        continue;
                    }
                    orthoRuns.add(dirAlt);
                    continue;
                }
                Point2D ptStart = bestVec.add(ptOnRun);
                TravelResult res = this.analyzeTravel(src, ptStart, bestVec, trg, ptEnd, linkID, okGroups, groupBlockers, isStart);
                double offset = new Vector2D(orig, ptOnRun).length();
                if (res.travelDistance > bestDist) {
                    bestDist = res.travelDistance;
                }
                if (offset < fullDist) {
                    if (dirAlt.type == 3) {
                        bestCorners.put(dirAlt, res);
                        continue;
                    }
                    if (dirAlt.type != 5) continue;
                    bestRuns.put(dirAlt, res);
                    continue;
                }
                if (dirAlt.type == 3) {
                    farCorners.put(dirAlt, res);
                    continue;
                }
                if (dirAlt.type != 5) continue;
                farRuns.put(dirAlt, res);
            }
        }
        PointAlternative retval = this.bestAlternative(bestCorners, orig, bestDist);
        if (retval != null) {
            return retval;
        }
        retval = this.bestAlternative(bestRuns, orig, bestDist);
        if (retval != null) {
            return retval;
        }
        retval = this.bestAlternative(farCorners, orig, bestDist);
        if (retval != null) {
            return retval;
        }
        retval = this.bestAlternative(farRuns, orig, bestDist);
        if (retval != null) {
            return retval;
        }
        if (!orthoCorners.isEmpty()) {
            return this.bestOrtho(orthoCorners, orig);
        }
        if (!orthoRuns.isEmpty()) {
            return this.bestOrtho(orthoRuns, orig);
        }
        return null;
    }

    public PointAlternative chooseBestAlternativeCloseToTarg(String src, String trg, String linkID, Point end, Set nearby, Point orig, int origType, Set okGroups, boolean isStart) {
        Point2D.Double ptEnd = new Point2D.Double(end.getX(), end.getY());
        double bestDist = 0.0;
        HashMap<PointAlternative, TravelResult> bestCorners = new HashMap<PointAlternative, TravelResult>();
        HashMap<PointAlternative, TravelResult> bestRuns = new HashMap<PointAlternative, TravelResult>();
        HashSet<PointAlternative> orthoCorners = new HashSet<PointAlternative>();
        HashSet<PointAlternative> orthoRuns = new HashSet<PointAlternative>();
        HashMap<PointAlternative, Double> runFracs = new HashMap<PointAlternative, Double>();
        HashMap<Integer, Double> bestFracForDir = new HashMap<Integer, Double>();
        HashSet groupBlockers = okGroups != null ? new HashSet() : null;
        Iterator nit = nearby.iterator();
        while (nit.hasNext()) {
            PointAlternative noDirAlt = (PointAlternative)nit.next();
            Point2D.Double ptOnRun = new Point2D.Double(noDirAlt.point.getX(), noDirAlt.point.getY());
            List bestDirs = this.getBestDirections(noDirAlt.point, ptOnRun, end);
            if (bestDirs == null) continue;
            int numDirs = bestDirs.size();
            for (int i = 0; i < numDirs; ++i) {
                Integer dir = (Integer)bestDirs.get(i);
                int bestDir = dir;
                PointAlternative dirAlt = (PointAlternative)noDirAlt.clone();
                dirAlt.dir = bestDir;
                Vector2D bestVec = LinkPlacementGrid.getVector(bestDir);
                Point2D ptStart = bestVec.add(ptOnRun);
                Vector2D travel = new Vector2D(ptStart, ptEnd);
                double fullDist = travel.dot(bestVec);
                if (fullDist < 0.0) continue;
                if (fullDist == 0.0) {
                    if (noDirAlt.type == 3) {
                        orthoCorners.add(dirAlt);
                        continue;
                    }
                    orthoRuns.add(dirAlt);
                    continue;
                }
                TravelResult res = this.analyzeTravel(src, ptStart, bestVec, trg, ptEnd, linkID, okGroups, groupBlockers, isStart);
                if (res.travelDistance > bestDist) {
                    bestDist = res.travelDistance;
                }
                double currFrac = res.travelDistance / fullDist;
                Double currFracObj = new Double(currFrac);
                Integer bestDirObj = new Integer(bestDir);
                Double bestFrac = (Double)bestFracForDir.get(bestDirObj);
                if (bestFrac == null || currFrac > bestFrac) {
                    bestFracForDir.put(bestDirObj, currFracObj);
                }
                runFracs.put(dirAlt, currFracObj);
                if (dirAlt.type == 3) {
                    bestCorners.put(dirAlt, res);
                    continue;
                }
                if (dirAlt.type != 5) continue;
                bestRuns.put(dirAlt, res);
            }
        }
        PointAlternative retval = this.bestAlternative(bestRuns, end, runFracs, bestFracForDir);
        if (retval != null && ((TravelResult)bestRuns.get((Object)retval)).travelDistance == 0.0) {
            retval = null;
        }
        PointAlternative retvalCor = this.bestAlternative(bestCorners, end, runFracs, bestFracForDir);
        if (retval != null && ((TravelResult)bestRuns.get((Object)retval)).travelDistance == 0.0) {
            retval = null;
        }
        if (retvalCor != null) {
            if (retval == null) {
                return retvalCor;
            }
            return retval.point.distance(retvalCor.point) <= 2.0 ? retvalCor : retval;
        }
        if (retval != null) {
            return retval;
        }
        if (!orthoCorners.isEmpty()) {
            return this.bestOrtho(orthoCorners, end);
        }
        if (!orthoRuns.isEmpty()) {
            return this.bestOrtho(orthoRuns, end);
        }
        return null;
    }

    public PointAlternative bestAlternative(Map alts, Point orig, Map runFracs, Map bestFracPerDir) {
        HashMap<Integer, PointAlternative> bestPAPerDir = new HashMap<Integer, PointAlternative>();
        HashMap<Integer, Integer> bestCrossingPerDir = new HashMap<Integer, Integer>();
        HashMap<Integer, Double> bestOffsetPerDir = new HashMap<Integer, Double>();
        HashMap<Integer, Double> bestAbsPerDir = new HashMap<Integer, Double>();
        double bestOffsetOfAll = Double.POSITIVE_INFINITY;
        Iterator ait = alts.keySet().iterator();
        while (ait.hasNext()) {
            Integer dirObj;
            double bestFrac;
            PointAlternative alt = (PointAlternative)ait.next();
            double runFrac = (Double)runFracs.get(alt);
            if (runFrac != (bestFrac = ((Double)bestFracPerDir.get(dirObj = new Integer(alt.dir))).doubleValue())) continue;
            Point2D.Double ptOnRun = new Point2D.Double(alt.point.getX(), alt.point.getY());
            double offset = new Vector2D(orig, ptOnRun).length();
            Double bestOffset = (Double)bestOffsetPerDir.get(dirObj);
            if (bestOffset != null && !(offset <= bestOffset)) continue;
            if (bestOffset == null || offset < bestOffset) {
                bestOffsetPerDir.put(dirObj, new Double(offset));
                bestCrossingPerDir.remove(dirObj);
                if (offset < bestOffsetOfAll) {
                    bestOffsetOfAll = offset;
                }
            }
            TravelResult res = (TravelResult)alts.get(alt);
            Integer bestCrossing = (Integer)bestCrossingPerDir.get(dirObj);
            if (bestCrossing != null && res.crossings > bestCrossing) continue;
            bestCrossingPerDir.put(dirObj, new Integer(res.crossings));
            bestPAPerDir.put(dirObj, alt);
            bestAbsPerDir.put(dirObj, new Double(res.travelDistance));
        }
        Iterator bopdit = bestOffsetPerDir.keySet().iterator();
        while (bopdit.hasNext()) {
            Integer dirObj = (Integer)bopdit.next();
            double offset = (Double)bestOffsetPerDir.get(dirObj);
            if (offset == bestOffsetOfAll) continue;
            bestPAPerDir.remove(dirObj);
        }
        PointAlternative retval = null;
        double bestAbs = Double.NEGATIVE_INFINITY;
        Iterator bpadit = bestPAPerDir.keySet().iterator();
        while (bpadit.hasNext()) {
            Integer dirObj = (Integer)bpadit.next();
            double abs = (Double)bestAbsPerDir.get(dirObj);
            if (!(abs > bestAbs)) continue;
            retval = (PointAlternative)bestPAPerDir.get(dirObj);
            bestAbs = abs;
        }
        return retval;
    }

    public PointAlternative bestAlternative(Map alts, Point orig, double bestVal) {
        PointAlternative retval = null;
        int bestCrossing = Integer.MAX_VALUE;
        double bestOffset = Double.POSITIVE_INFINITY;
        Iterator ait = alts.keySet().iterator();
        while (ait.hasNext()) {
            PointAlternative alt = (PointAlternative)ait.next();
            TravelResult res = (TravelResult)alts.get(alt);
            Point2D.Double ptOnRun = new Point2D.Double(alt.point.getX(), alt.point.getY());
            double offset = new Vector2D(orig, ptOnRun).length();
            if (res.travelDistance != bestVal) continue;
            if (offset < bestOffset) {
                retval = alt;
                bestCrossing = res.crossings;
                bestOffset = offset;
                continue;
            }
            if (offset != bestOffset || res.crossings >= bestCrossing) continue;
            retval = alt;
            bestCrossing = res.crossings;
        }
        return retval;
    }

    public PointAlternative bestOrtho(Set alts, Point orig) {
        PointAlternative retval = null;
        double bestOffset = Double.POSITIVE_INFINITY;
        Iterator ait = alts.iterator();
        while (ait.hasNext()) {
            PointAlternative alt = (PointAlternative)ait.next();
            Point2D.Double ptOnRun = new Point2D.Double(alt.point.getX(), alt.point.getY());
            double offset = new Vector2D(orig, ptOnRun).length();
            if (!(offset < bestOffset)) continue;
            retval = alt;
            bestOffset = offset;
        }
        return retval;
    }

    public List getPossibleExits(Point exitPt) {
        GridContents gc = this.getGridContents(exitPt);
        if (gc == null) {
            return null;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            return gc.entry.availableExits();
        }
        int size = gc.extra.size();
        List retval = null;
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (currEntry.type == 9 || currEntry.type != 5 && currEntry.type != 3) continue;
            retval = currEntry.availableExits();
            return retval;
        }
        throw new IllegalArgumentException();
    }

    private int getEntryDirectionForSrc(Point pt, String srcID) {
        GridContents gc = this.getGridContents(pt);
        if (gc == null) {
            return 0;
        }
        int i = 0;
        List entries = this.linkEntriesForSource(srcID, gc);
        int numEntries = entries.size();
        if (i < numEntries) {
            GridEntry currEntry = (GridEntry)entries.get(i);
            return currEntry.entries;
        }
        return 0;
    }

    private List linkEntriesForSource(String srcID, GridContents gc) {
        ArrayList<GridEntry> retval = new ArrayList<GridEntry>();
        if (gc == null) {
            return retval;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            if (gc.entry.id.equals(srcID) && gc.entry.type != 1 && gc.entry.type != 2) {
                retval.add(gc.entry);
            }
            return retval;
        }
        int size = gc.extra.size();
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (!currEntry.id.equals(srcID) || currEntry.type == 1 || currEntry.type == 2) continue;
            retval.add(currEntry);
        }
        return retval;
    }

    public Map buildExemptions() {
        HashMap retval = new HashMap();
        PatternIterator kit = new PatternIterator(false, false);
        while (kit.hasNext()) {
            Point pt = (Point)kit.next();
            GridContents gval = this.getGridContents(pt);
            if (gval == null) continue;
            this.lookForExemption(gval, retval);
        }
        return retval;
    }

    private void lookForExemption(GridContents gc, Map exemptions) {
        if (gc == null) {
            return;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            return;
        }
        HashSet<String> nodes = new HashSet<String>();
        HashSet<String> links = new HashSet<String>();
        int size = gc.extra.size();
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (currEntry.type == 1 || currEntry.type == 2) {
                nodes.add(currEntry.id);
            }
            if (currEntry.type != 3 && currEntry.type != 5) continue;
            links.add(currEntry.id);
        }
        Iterator nit = nodes.iterator();
        while (nit.hasNext()) {
            String nodeID = (String)nit.next();
            Iterator lit = links.iterator();
            while (lit.hasNext()) {
                String srcID = (String)lit.next();
                HashSet<String> exempt = (HashSet<String>)exemptions.get(srcID);
                if (exempt == null) {
                    exempt = new HashSet<String>();
                    exemptions.put(srcID, exempt);
                }
                exempt.add(nodeID);
            }
        }
    }

    public boolean linkForSourceIsPresent(String srcID, Genome genome, String overlayID) {
        HashSet drawnForSource = this.drawnLinksForID(genome, srcID, overlayID);
        PatternIterator kit = new PatternIterator(false, false);
        while (kit.hasNext()) {
            Point pt = (Point)kit.next();
            GridContents gval = this.getGridContents(pt);
            if (gval == null || !this.lookForSource(srcID, gval)) continue;
            if (drawnForSource.isEmpty()) {
                System.err.println("Incorrect drawnLinks status:" + this.drawnLinks_);
            }
            return true;
        }
        if (!drawnForSource.isEmpty()) {
            System.err.println("Incorrect drawnForSource status:" + drawnForSource);
        }
        return false;
    }

    public Set allLinksDrawnForSource(String srcID, Genome genome, String overlayID) {
        return this.drawnLinksForID(genome, srcID, overlayID);
    }

    public boolean linkIsDrawn(String linkID, String overlayID) {
        if (overlayID != null) {
            throw new IllegalArgumentException();
        }
        return this.drawnLinks_.contains(linkID);
    }

    public boolean linkIsPresentAtPoint(String srcID, Point pt) {
        GridContents gval = this.getGridContents(pt);
        if (gval == null) {
            return false;
        }
        return this.lookForSource(srcID, gval);
    }

    public boolean rerouteAllowed(String src, Point2D start, Point2D oldEnd, Point2D newEnd, String trg, Set okGroups, List awayBranchPts, List backBranchPts, boolean isStart) {
        Point startPt = new Point((int)start.getX() / 10, (int)start.getY() / 10);
        Point newEndPt = new Point((int)newEnd.getX() / 10, (int)newEnd.getY() / 10);
        Vector2D branchVec = new Vector2D(oldEnd, newEnd);
        ArrayList<Point> ignorePts = new ArrayList<Point>();
        int backNum = backBranchPts.size();
        for (int i = 0; i < backNum; ++i) {
            Point2D ignoreBack = (Point2D)backBranchPts.get(i);
            Point2D ignorePt = branchVec.add(ignoreBack);
            ignorePts.add(new Point((int)ignorePt.getX() / 10, (int)ignorePt.getY() / 10));
        }
        Point2D.Double startPtD = new Point2D.Double(startPt.x, startPt.y);
        Point2D.Double newEndPtD = new Point2D.Double(newEndPt.x, newEndPt.y);
        Point chkPt = new Point();
        Vector2D runVec = new Vector2D(start, newEnd);
        runVec = runVec.normalized();
        WalkValues walk = this.getWalkValues(runVec, startPtD, newEndPtD, 1);
        for (int x = walk.startX; x != walk.endX; x += walk.incX) {
            for (int y = walk.startY; y != walk.endY; y += walk.incY) {
                GridContents gc;
                int currentCrossings;
                chkPt.setLocation(x, y);
                if (chkPt.equals(startPt) || ignorePts.contains(chkPt) || (currentCrossings = this.checkForTravelCountCrossings(gc = this.getGridContents(x, y), src, trg, null, okGroups, walk, null, null, isStart, false)) >= 0) continue;
                return false;
            }
        }
        int awayNum = awayBranchPts.size();
        for (int i = 0; i < awayNum; ++i) {
            Point2D away = (Point2D)awayBranchPts.get(i);
            if (backBranchPts.contains(away)) continue;
            Point2D newAwayStart = branchVec.add(away);
            Point loneAwayPt = new Point((int)away.getX() / 10, (int)away.getY() / 10);
            Point newAwayStartPt = new Point((int)newAwayStart.getX() / 10, (int)newAwayStart.getY() / 10);
            Point2D.Double loneAwayPtD = new Point2D.Double(loneAwayPt.x, loneAwayPt.y);
            Point2D.Double newAwayStartPtD = new Point2D.Double(newAwayStartPt.x, newAwayStartPt.y);
            Vector2D awayRunVec = new Vector2D(newAwayStart, away);
            awayRunVec = awayRunVec.normalized();
            walk = this.getWalkValues(awayRunVec, newAwayStartPtD, loneAwayPtD, 1);
            for (int x = walk.startX; x != walk.endX; x += walk.incX) {
                for (int y = walk.startY; y != walk.endY; y += walk.incY) {
                    GridContents gc;
                    int currentCrossings;
                    chkPt.setLocation(x, y);
                    if (chkPt.equals(newAwayStartPt) || chkPt.equals(loneAwayPt) || (currentCrossings = this.checkForTravelCountCrossings(gc = this.getGridContents(x, y), src, trg, null, okGroups, walk, null, null, isStart, false)) >= 0) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static Rectangle rectConversion(Rectangle orig) {
        return new Rectangle(orig.x / 10, orig.y / 10, orig.width / 10, orig.height / 10);
    }

    public static void pointConversion(Point2D orig, Point2D newPt2D, Point newPt) {
        newPt.setLocation((int)orig.getX() / 10, (int)orig.getY() / 10);
        if (newPt2D != null) {
            newPt2D.setLocation(newPt.x, newPt.y);
        }
    }

    private void pointListConversion(List orig, List newPts2D, List newPts) {
        int size = orig.size();
        for (int i = 0; i < size; ++i) {
            Point2D origPt = (Point2D)orig.get(i);
            Point newPt = new Point((int)origPt.getX() / 10, (int)origPt.getY() / 10);
            newPts.add(newPt);
            newPts2D.add(new Point2D.Double(newPt.x, newPt.y));
        }
    }

    public boolean orthoPlanAllowed(String src, LinkSegment segGeom, String trg, Set okGroups, boolean isStart, boolean isEnd) {
        ArrayList<Point2D> segCorners = new ArrayList<Point2D>();
        segCorners.add(segGeom.getStart());
        segCorners.add(segGeom.getEnd());
        ArrayList orthoPathCornerPts = new ArrayList();
        ArrayList orthoPathCornersPtDs = new ArrayList();
        this.pointListConversion(segCorners, orthoPathCornersPtDs, orthoPathCornerPts);
        Point startPt = (Point)orthoPathCornerPts.get(0);
        Point endPt = (Point)orthoPathCornerPts.get(1);
        if (startPt.equals(endPt)) {
            return true;
        }
        Point2D startPtD = (Point2D)orthoPathCornersPtDs.get(0);
        Point2D endPtD = (Point2D)orthoPathCornersPtDs.get(1);
        Point chkPt = new Point();
        Vector2D runVec = new Vector2D(startPtD, endPtD);
        if (!(runVec = runVec.normalized()).isCanonical()) {
            return true;
        }
        WalkValues walk = this.getWalkValues(runVec, startPtD, endPtD, 1);
        for (int x = walk.startX; x != walk.endX; x += walk.incX) {
            for (int y = walk.startY; y != walk.endY; y += walk.incY) {
                Node node;
                chkPt.setLocation(x, y);
                GridContents gc = this.getGridContents(x, y);
                int currentCrossings = this.checkForTravelCountCrossings(gc, src, trg, null, okGroups, walk, null, null, isStart, false);
                if (currentCrossings == -1) {
                    return false;
                }
                if (currentCrossings != -2 || (node = Database.getDB().getGenome().getNode(GenomeItemInstance.getBaseID(trg))).getNodeType() == 5) continue;
                return false;
            }
        }
        return true;
    }

    public boolean pointInsideNode(Point pt, String nodeID) {
        GridContents gc = this.getGridContents(pt);
        if (gc == null) {
            return false;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            return gc.entry.type == 1;
        }
        int size = gc.extra.size();
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (currEntry.type != 1) continue;
            return true;
        }
        return false;
    }

    public Rectangle displacementRange(Point2D start, Point2D end, Vector2D displacement, List shorterStarts, List longerLoneStarts) {
        Point startPt = new Point();
        Point2D.Double startPtD = new Point2D.Double();
        LinkPlacementGrid.pointConversion(start, startPtD, startPt);
        Point endPt = new Point();
        Point2D.Double endPtD = new Point2D.Double();
        LinkPlacementGrid.pointConversion(end, endPtD, endPt);
        ArrayList shorterStartPts = new ArrayList();
        ArrayList shorterStartPtDs = new ArrayList();
        this.pointListConversion(shorterStarts, shorterStartPtDs, shorterStartPts);
        ArrayList longerLoneStartPts = new ArrayList();
        ArrayList longerLoneStartPtDs = new ArrayList();
        this.pointListConversion(longerLoneStarts, longerLoneStartPtDs, longerLoneStartPts);
        MinMax xRange = new MinMax();
        MinMax yRange = new MinMax();
        xRange.init();
        yRange.init();
        Vector2D runVec = new Vector2D(startPtD, endPtD);
        runVec = runVec.normalized();
        WalkValues walk = this.getWalkValues(runVec, startPtD, endPtD, 1);
        xRange.update(walk.startX);
        xRange.update(walk.endX);
        yRange.update(walk.startY);
        yRange.update(walk.endY);
        Vector2D scaledDisplacement = displacement.scaled(0.1);
        Vector2D normDisplacement = displacement.normalized();
        int longerNum = longerLoneStartPtDs.size();
        for (int i = 0; i < longerNum; ++i) {
            Point2D loneStartD = (Point2D)longerLoneStartPtDs.get(i);
            Point2D loneEndD = scaledDisplacement.add(loneStartD);
            walk = this.getWalkValues(normDisplacement, loneStartD, loneEndD, 1);
            xRange.update(walk.startX);
            xRange.update(walk.endX);
            yRange.update(walk.startY);
            yRange.update(walk.endY);
        }
        Rectangle retval = new Rectangle(xRange.min, yRange.min, xRange.max - xRange.min, yRange.max - yRange.min);
        return retval;
    }

    public boolean displacementAllowed(String src, Point2D start, Point2D end, Vector2D displacement, String trg, Set okGroups, List shorterStarts, List longerLoneStarts, boolean isStart) {
        Point startPt = new Point();
        Point2D.Double startPtD = new Point2D.Double();
        LinkPlacementGrid.pointConversion(start, startPtD, startPt);
        Point endPt = new Point();
        Point2D.Double endPtD = new Point2D.Double();
        LinkPlacementGrid.pointConversion(end, endPtD, endPt);
        ArrayList shorterStartPts = new ArrayList();
        ArrayList shorterStartPtDs = new ArrayList();
        this.pointListConversion(shorterStarts, shorterStartPtDs, shorterStartPts);
        ArrayList longerLoneStartPts = new ArrayList();
        ArrayList longerLoneStartPtDs = new ArrayList();
        this.pointListConversion(longerLoneStarts, longerLoneStartPtDs, longerLoneStartPts);
        Point chkPt = new Point();
        Vector2D runVec = new Vector2D(startPtD, endPtD);
        runVec = runVec.normalized();
        WalkValues walk = this.getWalkValues(runVec, startPtD, endPtD, 1);
        for (int x = walk.startX; x != walk.endX; x += walk.incX) {
            for (int y = walk.startY; y != walk.endY; y += walk.incY) {
                GridContents gc;
                int currentCrossings;
                chkPt.setLocation(x, y);
                if (chkPt.equals(startPt) || chkPt.equals(endPt) || shorterStartPts.contains(chkPt) || (currentCrossings = this.checkForTravelCountCrossings(gc = this.getGridContents(x, y), src, trg, null, okGroups, walk, null, null, isStart, false)) >= 0) continue;
                return false;
            }
        }
        Vector2D scaledDisplacement = displacement.scaled(0.1);
        Vector2D normDisplacement = displacement.normalized();
        int longerNum = longerLoneStartPtDs.size();
        Point endChk = new Point();
        for (int i = 0; i < longerNum; ++i) {
            Point2D loneStartD = (Point2D)longerLoneStartPtDs.get(i);
            Point2D loneEndD = scaledDisplacement.add(loneStartD);
            Point loneStart = (Point)longerLoneStartPts.get(i);
            endChk.setLocation(loneEndD.getX(), loneEndD.getY());
            walk = this.getWalkValues(normDisplacement, loneStartD, loneEndD, 1);
            for (int x = walk.startX; x != walk.endX; x += walk.incX) {
                for (int y = walk.startY; y != walk.endY; y += walk.incY) {
                    GridContents gc;
                    int currentCrossings;
                    chkPt.setLocation(x, y);
                    if (chkPt.equals(loneStart) || (currentCrossings = this.checkForTravelCountCrossings(gc = this.getGridContents(x, y), src, trg, null, okGroups, walk, null, null, isStart, false)) >= 0) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean routeAllowed(String src, String trg, Point2D start, Point2D end, Set okGroups, boolean isStart) {
        Point startPt = new Point();
        Point2D.Double startPtD = new Point2D.Double();
        LinkPlacementGrid.pointConversion(start, startPtD, startPt);
        Point endPt = new Point();
        Point2D.Double endPtD = new Point2D.Double();
        LinkPlacementGrid.pointConversion(end, endPtD, endPt);
        Point chkPt = new Point();
        Vector2D runVec = new Vector2D(startPtD, endPtD);
        runVec = runVec.normalized();
        WalkValues walk = this.getWalkValues(runVec, startPtD, endPtD, 1);
        for (int x = walk.startX; x != walk.endX; x += walk.incX) {
            for (int y = walk.startY; y != walk.endY; y += walk.incY) {
                GridContents gc;
                int currentCrossings;
                chkPt.setLocation(x, y);
                if (chkPt.equals(startPt) || chkPt.equals(endPt) || (currentCrossings = this.checkForTravelCountCrossings(gc = this.getGridContents(x, y), src, trg, null, okGroups, walk, null, null, isStart, false)) >= 0) continue;
                return false;
            }
        }
        return true;
    }

    public int getLinkCrossingsForSource(String srcID) {
        PatternIterator kit = new PatternIterator(false, false);
        int retval = 0;
        while (kit.hasNext()) {
            Point pt = (Point)kit.next();
            GridContents gval = this.getGridContents(pt);
            if (gval == null || !this.lookForSource(srcID, gval)) continue;
            retval += this.otherLinkCount(srcID, gval);
        }
        return retval;
    }

    public int getLinkCrossingsForSource(String src, Point2D pt) {
        Point start = new Point((int)pt.getX() / 10, (int)pt.getY() / 10);
        int retval = 0;
        Set allCells = this.getAllLinkCells(src, start);
        Iterator cellit = allCells.iterator();
        while (cellit.hasNext()) {
            Point cpt = (Point)cellit.next();
            GridContents gc = this.getGridContents(cpt);
            retval += this.otherLinkCount(src, gc);
        }
        return retval;
    }

    private void getNextPointsForEntry(GridEntry entry, Point currPt, Set points) {
        if ((entry.exits & 1) != 0) {
            points.add(new Point(currPt.x, currPt.y - 1));
        }
        if ((entry.exits & 4) != 0) {
            points.add(new Point(currPt.x, currPt.y + 1));
        }
        if ((entry.exits & 2) != 0) {
            points.add(new Point(currPt.x + 1, currPt.y));
        }
        if ((entry.exits & 8) != 0) {
            points.add(new Point(currPt.x - 1, currPt.y));
        }
    }

    public void getNextPointsForContents(String srcID, GridContents gc, Point currPt, Set points) {
        if (gc == null) {
            return;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            if (gc.entry.id.equals(srcID) && gc.entry.type != 1 && gc.entry.type != 2) {
                this.getNextPointsForEntry(gc.entry, currPt, points);
            }
            return;
        }
        int size = gc.extra.size();
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (!currEntry.id.equals(srcID) || currEntry.type == 1 || currEntry.type == 2) continue;
            this.getNextPointsForEntry(currEntry, currPt, points);
        }
    }

    public Set getAllLinkCells(String srcID, Point start) {
        HashSet retval = new HashSet();
        this.getAllLinkCellsRecursive(srcID, start, retval);
        return retval;
    }

    private void getAllLinkCellsRecursive(String srcID, Point start, Set retval) {
        GridContents gc = this.getGridContents(start);
        if (!this.lookForSource(srcID, gc)) {
            return;
        }
        retval.add(start);
        HashSet nextPoints = new HashSet();
        this.getNextPointsForContents(srcID, gc, start, nextPoints);
        Iterator npit = nextPoints.iterator();
        while (npit.hasNext()) {
            Point pt = (Point)npit.next();
            if (retval.contains(pt)) continue;
            this.getAllLinkCellsRecursive(srcID, pt, retval);
        }
    }

    private void drawLinkFromPoints(String linkSrc, List pointList, CornerOracle corc, Set linkIDs) {
        GeneralPath myPath = new GeneralPath();
        Iterator sit = pointList.iterator();
        boolean isFirst = true;
        Point2D last = null;
        while (sit.hasNext()) {
            Point2D pt = (Point2D)sit.next();
            if (!isFirst) {
                myPath.moveTo((float)last.getX(), (float)last.getY());
                myPath.lineTo((float)pt.getX(), (float)pt.getY());
            }
            isFirst = false;
            last = pt;
        }
        this.drawLink(linkSrc, myPath, corc, linkIDs);
    }

    public void drawLinkWithUserData(String linkSrc, DecoratedPath path, CornerOracle corc, Set linkIDs) {
        this.drawLinkGuts(linkSrc, path.getPath(), corc, path.getData(), linkIDs);
    }

    public void drawLink(String linkSrc, GeneralPath path, CornerOracle corc, Set linkIDs) {
        this.drawLinkGuts(linkSrc, path, corc, null, linkIDs);
    }

    private void drawLinkGuts(String linkSrc, GeneralPath path, CornerOracle corc, Map dataMap, Set linkIDs) {
        double[] coords = new double[6];
        double[] origCurr = new double[2];
        double[] origNew = new double[2];
        double[] forcedCurr = new double[]{Double.MAX_VALUE, Double.MAX_VALUE};
        double[] forcedNew = new double[2];
        DecoInfo startData = null;
        Point2D.Double dataKey = new Point2D.Double(0.0, 0.0);
        PathIterator pit = path.getPathIterator(null);
        while (!pit.isDone()) {
            int segType = pit.currentSegment(coords);
            switch (segType) {
                case 0: {
                    origCurr[0] = coords[0];
                    origCurr[1] = coords[1];
                    forcedCurr[0] = UiUtil.forceToGridValue(coords[0], 10.0);
                    forcedCurr[1] = UiUtil.forceToGridValue(coords[1], 10.0);
                    if (dataMap == null) break;
                    ((Point2D)dataKey).setLocation(origCurr[0], origCurr[1]);
                    startData = (DecoInfo)dataMap.get(dataKey);
                    break;
                }
                case 1: {
                    origNew[0] = coords[0];
                    origNew[1] = coords[1];
                    forcedNew[0] = UiUtil.forceToGridValue(coords[0], 10.0);
                    forcedNew[1] = UiUtil.forceToGridValue(coords[1], 10.0);
                    this.padTweaks(origCurr, origNew, forcedCurr, forcedNew);
                    this.fillForLink(linkSrc, forcedCurr[0], forcedCurr[1], forcedNew[0], forcedNew[1], corc, startData);
                    origCurr[0] = origNew[0];
                    origCurr[1] = origNew[1];
                    forcedCurr[0] = forcedNew[0];
                    forcedCurr[1] = forcedNew[1];
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            pit.next();
        }
        this.drawnLinks_.addAll(linkIDs);
    }

    public void padTweaks(double[] origCurr, double[] origNew, double[] forcedCurr, double[] forcedNew) {
        int direction = LinkPlacementGrid.getDirectionFromCoords(forcedCurr[0], forcedCurr[1], forcedNew[0], forcedNew[1]);
        switch (direction) {
            case 0: {
                return;
            }
            case 8: {
                if (forcedCurr[0] > origCurr[0]) {
                    forcedCurr[0] = forcedCurr[0] - 10.0;
                }
                if (!(forcedNew[0] < origNew[0])) break;
                forcedNew[0] = forcedNew[0] + 10.0;
                break;
            }
            case 4: {
                if (forcedCurr[1] < origCurr[1]) {
                    forcedCurr[1] = forcedCurr[1] + 10.0;
                }
                if (!(forcedNew[1] > origNew[1])) break;
                forcedNew[1] = forcedNew[1] - 10.0;
                break;
            }
            case 2: {
                if (forcedCurr[0] < origCurr[0]) {
                    forcedCurr[0] = forcedCurr[0] + 10.0;
                }
                if (!(forcedNew[0] > origNew[0])) break;
                forcedNew[0] = forcedNew[0] - 10.0;
                break;
            }
            case 1: {
                if (forcedCurr[1] > origCurr[1]) {
                    forcedCurr[1] = forcedCurr[1] - 10.0;
                }
                if (!(forcedNew[1] < origNew[1])) break;
                forcedNew[1] = forcedNew[1] + 10.0;
                break;
            }
            case 16: {
                return;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public boolean canDrawLink(String linkSrc, LinkProperties props, Map linkMap, Map targMap, Map tupMap) {
        Iterator pit = linkMap.keySet().iterator();
        while (pit.hasNext()) {
            PointPair pair = (PointPair)pit.next();
            if (pair.end == null || this.canFillForLink(linkSrc, pair.start.getX(), pair.start.getY(), pair.end.getX(), pair.end.getY(), props, linkMap, targMap, tupMap)) continue;
            return false;
        }
        return true;
    }

    public void addNode(Pattern pat, Pattern inbound, String id, int px, int py, int strictness) {
        int maxX = pat.getWidth();
        int maxY = pat.getHeight();
        for (int x = 0; x < maxX; ++x) {
            for (int y = 0; y < maxY; ++y) {
                if (pat.getValue(x, y) == null) continue;
                GridEntry entry = inbound != null && inbound.getValue(x, y) != null ? new GridEntry(id, 2, 0, 0, false) : new GridEntry(id, 1, 0, 0, false);
                int xval = px + x;
                int yval = py + y;
                this.installModifiedGridContents(xval, yval, entry);
            }
        }
    }

    public void addGroup(Rectangle rect, String groupID) {
        Rectangle use = null;
        if (this.bounds_ != null) {
            Rectangle2D choppedPart = rect.createIntersection(this.bounds_);
            if (choppedPart.getHeight() > 0.0 && choppedPart.getWidth() > 0.0) {
                use = UiUtil.rectFromRect2D(choppedPart);
            }
        } else {
            use = (Rectangle)rect.clone();
        }
        if (use != null) {
            this.groups_.put(groupID, use);
        }
    }

    public void reserveTerminalRegion(TerminalRegion termReg, String tag, boolean multiArrive) {
        int tagVal = termReg.type == 1 ? 7 : (multiArrive ? 10 : 8);
        int numPt = termReg.getNumTravelPoints();
        if (numPt == 0) {
            return;
        }
        for (int i = 0; i < numPt; ++i) {
            Point pt = termReg.getTravelPoint(i);
            GridEntry entry = new GridEntry(tag, tagVal, LinkPlacementGrid.getReverse(termReg.direction), termReg.direction, false);
            this.installModifiedGridContents(pt, entry);
        }
    }

    public boolean terminalRegionCanBeReserved(TerminalRegion termReg) {
        int numPt = termReg.getNumTravelPoints();
        if (numPt == 0) {
            return true;
        }
        boolean retval = true;
        for (int i = 0; i < numPt; ++i) {
            Point pt = termReg.getTravelPoint(i);
            GridContents gc = this.getGridContents(pt);
            if (gc == null || this.isOKForTerminal(gc)) continue;
            return false;
        }
        return true;
    }

    public TerminalRegion getDepartureRegion(String id, Vector2D vec, Set okGroups, Point start, int max) {
        GridContents gc;
        int y;
        int x;
        WalkValues walk = this.getWalkValues(vec, start, null, 1);
        if (okGroups != null) {
            int grSlot = 0;
            int genResult = 1;
            for (x = walk.startX; x != walk.endX && grSlot < max; x += walk.incX) {
                for (y = walk.startY; y != walk.endY && grSlot < max; y += walk.incY) {
                    gc = this.getGridContents(x, y);
                    okGroups.addAll(this.getCellGroupContents(gc));
                    genResult = this.generateDeparture(gc, id, null, walk);
                    if (genResult == 0) {
                        grSlot = max;
                        continue;
                    }
                    ++grSlot;
                }
            }
        }
        boolean[] slots = new boolean[max];
        int currSlot = 0;
        for (x = walk.startX; x != walk.endX; x += walk.incX) {
            for (y = walk.startY; y != walk.endY; y += walk.incY) {
                gc = this.getGridContents(x, y);
                int genResult = this.generateDeparture(gc, id, okGroups, walk);
                if (genResult == 0) {
                    return new TerminalRegion(id, start, slots, walk.exitDirection, 1);
                }
                if (genResult == 1) {
                    slots[currSlot++] = true;
                } else if (genResult == 2) {
                    ++currSlot;
                } else {
                    throw new IllegalStateException();
                }
                if (currSlot != max) continue;
                return new TerminalRegion(id, start, slots, walk.exitDirection, 1);
            }
        }
        return new TerminalRegion(id, start, slots, walk.exitDirection, 1);
    }

    public TerminalRegion getArrivalRegion(String srcID, String targID, String linkID, Set okGroups, Vector2D vec, Point end, int max) {
        GridContents gc;
        int y;
        int x;
        WalkValues walk = this.getWalkValues(vec, end, null, -1);
        if (okGroups != null) {
            int grSlot = 0;
            int genResult = 1;
            for (x = walk.startX; x != walk.endX && grSlot < max; x += walk.incX) {
                for (y = walk.startY; y != walk.endY && grSlot < max; y += walk.incY) {
                    gc = this.getGridContents(x, y);
                    okGroups.addAll(this.getCellGroupContents(gc));
                    genResult = this.generateArrival(gc, srcID, targID, linkID, null, walk);
                    if (genResult == 0) {
                        grSlot = max;
                        continue;
                    }
                    ++grSlot;
                }
            }
        }
        boolean[] slots = new boolean[max];
        int currSlot = 0;
        for (x = walk.startX; x != walk.endX; x += walk.incX) {
            for (y = walk.startY; y != walk.endY; y += walk.incY) {
                gc = this.getGridContents(x, y);
                int genResult = this.generateArrival(gc, srcID, targID, linkID, okGroups, walk);
                if (genResult == 0) {
                    return new TerminalRegion(srcID, end, slots, walk.entryDirection, 0);
                }
                if (genResult == 1) {
                    slots[currSlot++] = true;
                } else if (genResult == 2) {
                    ++currSlot;
                } else {
                    throw new IllegalStateException();
                }
                if (currSlot != max) continue;
                return new TerminalRegion(srcID, end, slots, walk.entryDirection, 0);
            }
        }
        return new TerminalRegion(srcID, end, slots, walk.entryDirection, 0);
    }

    public TerminalRegion getEmergencyArrivalRegion(String srcID, String targID, String linkID, Set okGroups, Vector2D vec, Point end) {
        boolean[] slots = new boolean[1];
        WalkValues walk = this.getWalkValues(vec, end, null, -1);
        GridContents gc = this.getGridContents(end.x, end.y);
        if (okGroups != null) {
            okGroups.addAll(this.getCellGroupContents(gc));
        }
        if (this.canGenerateEmergencyArrival(gc, srcID, targID, linkID, okGroups, walk.entryDirection)) {
            slots[0] = true;
            return new TerminalRegion(srcID, end, slots, walk.entryDirection, 0);
        }
        return null;
    }

    public List recoverValidFirstTrack(String src, String trg, String linkID, TerminalRegion departure, TerminalRegion arrival, GoodnessParams goodness, Set okGroups, boolean force, int entryPref, RecoveryDataForLink recoverForLink, Map recoveryDataMap, Map departures, Map arrivals, Set unseenLinks, boolean strictOKGroups) {
        Set exemptions = recoverForLink.getEnclosingSource().getExemptions();
        ArrayList retval = new ArrayList();
        this.gauss_.clear();
        goodness.differenceNormalize = 1.0 / this.gaussian(0.0, goodness.differenceSigma);
        goodness.normalize = 1.0;
        goodness.normalize = 1.0 / this.goodness(goodness, 1.0, 0, 0);
        IterationChecker checker = new IterationChecker(100);
        Point start = departure.start;
        if (arrival.getNumPoints() == 0) {
            return retval;
        }
        Point end = arrival.getPoint(0);
        List threePts = this.buildRecoverPointList(start, end, recoverForLink, 0);
        if (threePts == null) {
            return null;
        }
        List tempMasks = this.temporaryMaskForRecovery(src, recoveryDataMap, departures, arrivals, unseenLinks);
        Point2D startPt = (Point2D)threePts.get(0);
        Point2D endPt = (Point2D)threePts.get(1);
        Vector2D departDir = new Vector2D(startPt, endPt).normalized();
        Vector2D arriveDir = arrival.getTerminalVector();
        try {
            TravelTurn initTurn = this.buildInitRecoveryTurn(departDir, threePts);
            Vector2D canStart = departDir.isCanonical() ? departDir : departDir.canonical().normalized();
            int maxDepth = recoverForLink.getPointCount() + 15;
            int rsval = this.recoverStep(src, trg, linkID, new Point2D.Double(end.x, end.y), canStart, arriveDir, initTurn, retval, maxDepth, 0, goodness, checker, true, force, okGroups, entryPref, recoverForLink, exemptions, null, strictOKGroups);
            if (rsval == 4) {
                this.clearRecoveryMasks(tempMasks);
                this.convertTerminalRegion(departure);
                this.convertTerminalRegion(arrival);
                this.commitTemps(linkID);
                recoverForLink.commitAllRevisedPoints();
                return retval;
            }
            if (rsval == 3) {
                this.clearRecoveryMasks(tempMasks);
                recoverForLink.popAllRevisedPoints();
                return retval;
            }
        }
        catch (NonConvergenceException ncex) {
            if (checker.limitExceeded()) {
                // empty if block
            }
        }
        this.clearRecoveryMasks(tempMasks);
        recoverForLink.popAllRevisedPoints();
        return retval;
    }

    private void clearRecoveryMasks(List masks) {
        int numSkips = masks.size();
        for (int i = numSkips - 1; i >= 0; --i) {
            PlanOrPoint pop = (PlanOrPoint)masks.get(i);
            if (pop.plan != null) {
                this.removeTempForPlan(pop.plan);
                continue;
            }
            this.removeTemp(pop.point, true);
        }
    }

    private List temporaryMaskForRecovery(String src, Map recoveryDataMap, Map departures, Map arrivals, Set unseenLinks) {
        ArrayList<PlanOrPoint> tempPlans = new ArrayList<PlanOrPoint>();
        Iterator rdmkit = recoveryDataMap.keySet().iterator();
        while (rdmkit.hasNext()) {
            String srcKey = (String)rdmkit.next();
            if (srcKey.equals(src)) continue;
            HashSet<PointPair> seenPairs = new HashSet<PointPair>();
            RecoveryDataForSource rdfs = (RecoveryDataForSource)recoveryDataMap.get(srcKey);
            Iterator linkit = rdfs.segListPerLink.keySet().iterator();
            while (linkit.hasNext()) {
                String linkID = (String)linkit.next();
                if (!unseenLinks.contains(linkID)) continue;
                RecoveryDataForLink rdfl = new RecoveryDataForLink(rdfs, linkID);
                TerminalRegion arrive = (TerminalRegion)arrivals.get(linkID);
                Point end = new Point(10000, 16234);
                if (arrive != null) {
                    end = arrive.start;
                }
                int currDepth = 0;
                Point start = null;
                TerminalRegion depart = (TerminalRegion)departures.get(linkID);
                if (depart == null) {
                    currDepth = 1;
                } else {
                    start = depart.start;
                }
                List tempoPts = this.buildRecoverPointList(start, end, rdfl, currDepth++);
                while (tempoPts != null && tempoPts.size() >= 2) {
                    Point2D tmp1;
                    TravelPlan tempPlan = null;
                    Point2D tmp0 = (Point2D)tempoPts.get(0);
                    PointPair chkKey = new PointPair(tmp0, tmp1 = (Point2D)tempoPts.get(1));
                    if (!seenPairs.contains(chkKey)) {
                        if (this.recoverPointListStartsOrtho(tempoPts)) {
                            Point2D tmp2;
                            Vector2D turnVector = null;
                            if (this.recoverPointListIsOrtho(tempoPts) && tempoPts.size() == 3 && !tmp1.equals(tmp2 = (Point2D)tempoPts.get(2))) {
                                turnVector = new Vector2D(tmp1, tmp2).normalized();
                            }
                            tempPlan = new TravelPlan(tmp0, tmp1, null, new Vector2D(tmp0, tmp1).normalized(), turnVector);
                            this.addTempForPlan(tempPlan, srcKey, false, null);
                            tempPlans.add(new PlanOrPoint(tempPlan, null));
                        } else {
                            this.addTempEntryForDiagonalCorner(tmp1, srcKey);
                            tempPlans.add(new PlanOrPoint(null, tmp1));
                        }
                    }
                    seenPairs.add(chkKey);
                    tempoPts = this.buildRecoverPointList(start, end, rdfl, currDepth++);
                }
            }
        }
        return tempPlans;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NewCorner recoverValidAddOnTrack(String src, String trg, String linkID, Layout lo, TerminalRegion arrival, List points, GoodnessParams goodness, Set okGroups, boolean force, int entryPref, RecoveryDataForLink recoverForLink, Map recoveryDataMap, Map departures, Map arrivals, Set unseenLinks, Genome genome, FontRenderContext frc, Set linksFromSource, boolean strictOKGroups) {
        RecoveryPointData rpd;
        LinkSegmentID lsid;
        if (arrival == null || arrival.getNumPoints() == 0) {
            return null;
        }
        Point end = arrival.getPoint(0);
        Point2D.Double endPt = new Point2D.Double(end.getX(), end.getY());
        Point start = null;
        this.gauss_.clear();
        goodness.differenceNormalize = 1.0 / this.gaussian(0.0, goodness.differenceSigma);
        goodness.normalize = 1.0;
        goodness.normalize = 1.0 / this.goodness(goodness, 1.0, 0, 0);
        List tempMasks = this.temporaryMaskForRecovery(src, recoveryDataMap, departures, arrivals, unseenLinks);
        RecoveryDataForSource rds = (RecoveryDataForSource)recoveryDataMap.get(src);
        Set exemptions = recoverForLink.getEnclosingSource().getExemptions();
        int numExist = recoverForLink.getPointCount();
        Point testPt = new Point();
        Point2D.Double testPt2D = new Point2D.Double();
        HashSet<LinkSegmentID> noRecovery = new HashSet<LinkSegmentID>();
        for (int i = numExist - 1; i >= 0; --i) {
            lsid = recoverForLink.getPointKey(i);
            rpd = recoverForLink.getEnclosingSource().getRpd(lsid);
            if (rpd == null) continue;
            LinkPlacementGrid.pointConversion(rpd.point, testPt2D, testPt);
            if (this.isReachable(testPt2D, src, trg, linkID, null, exemptions, false)) continue;
            noRecovery.add(lsid);
        }
        Iterator nrit = noRecovery.iterator();
        while (nrit.hasNext()) {
            lsid = (LinkSegmentID)nrit.next();
            rpd = recoverForLink.getEnclosingSource().getRpd(lsid);
            rpd.tagAsUnreachable();
        }
        HashSet<Object> ignore = new HashSet<Object>();
        LaunchAnalysis la = null;
        PointAlternativeForRecovery lastDitch = null;
        PointAlternative nextTry = null;
        List pafrList = this.getPointAlternativesForRecovery(src, arrival, rds, recoverForLink, linksFromSource);
        int index = -1;
        if (pafrList == null) {
            LinkSegmentID srcBound = recoverForLink.getSourceBoundPoint();
            index = recoverForLink.getSourceBoundIndex();
            if (index != -1) {
                Point2D targPt = recoverForLink.getPoint(srcBound);
                Point dummyPt = new Point();
                Point2D.Double targPt2D = new Point2D.Double();
                LinkPlacementGrid.pointConversion(targPt, targPt2D, dummyPt);
                la = this.generateLaunchAlternatives(targPt2D, src, linkID, okGroups, genome, lo, frc, unseenLinks, linksFromSource);
                nextTry = la.extractNextAlternative();
            }
            if (nextTry == null) {
                lastDitch = this.lastDitchForRecovery(src, linkID, lo, arrival, okGroups, recoverForLink, linksFromSource, 0);
            }
        }
        if (pafrList == null && nextTry == null && lastDitch == null) {
            this.clearRecoveryMasks(tempMasks);
            return null;
        }
        int pafrIndex = 0;
        int maxIndex = pafrList == null ? 0 : pafrList.size();
        Vector2D arriveDir = arrival.getTerminalVector();
        do {
            IterationChecker checker = new IterationChecker(100);
            List threePts = null;
            RecoveryDataForLink truncatedRFL = null;
            int type = 0;
            int bestDir = 0;
            boolean letsTry = false;
            if (pafrList != null || lastDitch != null) {
                PointAlternativeForRecovery pafr = pafrList != null ? (PointAlternativeForRecovery)pafrList.get(pafrIndex) : lastDitch;
                type = pafr.pa.type;
                start = pafr.pa.point;
                bestDir = pafr.pa.dir;
                end = pafr.end;
                threePts = pafr.threePts;
                truncatedRFL = pafr.truncatedRFL;
                letsTry = true;
            } else if (nextTry != null) {
                start = nextTry.point;
                type = nextTry.type;
                Set nearby = this.getRunAlternatives(src, start, type, ignore);
                PointAlternative choose = this.chooseBestAlternative(src, trg, linkID, end, nearby, start, type, okGroups, false);
                if (choose == null) {
                    Iterator nit = nearby.iterator();
                    while (nit.hasNext()) {
                        PointAlternative pit = (PointAlternative)nit.next();
                        ignore.add(pit.point.clone());
                    }
                } else {
                    type = choose.type;
                    start = choose.point;
                    bestDir = choose.dir;
                    Point2D.Double shifted = new Point2D.Double(choose.point.getX(), choose.point.getY());
                    threePts = this.buildRecoverPointList(shifted, endPt, truncatedRFL = new RecoveryDataForLink(recoverForLink, index), 0);
                    if (threePts != null) {
                        letsTry = true;
                    }
                }
            }
            if (!letsTry) continue;
            Vector2D departDir = LinkPlacementGrid.getVector(bestDir);
            Point2D scaleStart = new Point2D.Double(start.getX(), start.getY());
            scaleStart = departDir.add(scaleStart);
            try {
                TravelTurn initTurn = this.buildInitRecoveryTurn(departDir, threePts);
                int maxDepth = truncatedRFL.getPointCount() + 15;
                int rsval = this.recoverStep(src, trg, linkID, new Point2D.Double(end.x, end.y), departDir, arriveDir, initTurn, points, maxDepth, 0, goodness, checker, false, force, okGroups, entryPref, truncatedRFL, exemptions, null, strictOKGroups);
                if (rsval == 4) {
                    this.clearRecoveryMasks(tempMasks);
                    this.convertTerminalRegion(arrival);
                    this.addTempEntryForRun(scaleStart, src, bestDir);
                    this.commitTemps(linkID);
                    recoverForLink.commitAllRevisedPoints();
                    return new NewCorner(type, new Point2D.Double((double)start.x * 10.0, (double)start.y * 10.0), bestDir);
                }
                if (rsval != 3) {
                    // empty if block
                }
            }
            catch (NonConvergenceException ncex) {
                if (checker.limitExceeded()) {
                    // empty if block
                }
            }
            recoverForLink.popAllRevisedPoints();
        } while (!(pafrList != null ? ++pafrIndex >= maxIndex : lastDitch != null || (nextTry = la.extractNextAlternative()) == null));
        this.clearRecoveryMasks(tempMasks);
        return null;
    }

    private List getPointAlternativesForRecovery(String src, TerminalRegion arrival, RecoveryDataForSource rds, RecoveryDataForLink recoverForLink, Set linksFromSource) {
        ArrayList<PointAlternativeForRecovery> retval = new ArrayList<PointAlternativeForRecovery>();
        if (arrival == null || arrival.getNumPoints() == 0) {
            return null;
        }
        Point end = arrival.getPoint(0);
        Point2D.Double endPt = new Point2D.Double(end.getX(), end.getY());
        int numExist = recoverForLink.getPointCount();
        Point testPt = new Point();
        Point2D.Double testPt2D = new Point2D.Double();
        Vector2D lastRun = null;
        Point2D lastPoint = endPt;
        for (int i = numExist - 1; i >= 0; --i) {
            LinkPlacementGrid.pointConversion(recoverForLink.getPoint(i), testPt2D, testPt);
            GridContents gval = this.getGridContents(testPt);
            if (gval != null) {
                int cellType = this.lookForLaunchCell(src, gval, null, linksFromSource);
                if (cellType != 0) {
                    int entryForCell;
                    Vector2D departDir = lastRun == null ? new Vector2D(testPt2D, endPt).normalized() : lastRun;
                    if (departDir.isZero()) {
                        lastRun = recoverForLink.getInboundRun(i);
                        lastPoint = (Point2D)testPt2D.clone();
                        continue;
                    }
                    Vector2D canonDepart = LinkPlacementGrid.isOrthogonal(departDir) ? departDir : this.getClosestCanonical(departDir);
                    PointAlternative pa = new PointAlternative(testPt, cellType, LinkPlacementGrid.getDirection(canonDepart));
                    List launchOptions = this.modifiedRecoveryLaunch(pa, entryForCell = this.getEntryDirectionForSrc(testPt, src), departDir, src, rds, linksFromSource, lastPoint);
                    if (launchOptions == null || launchOptions.isEmpty()) {
                        return null;
                    }
                    int numOptions = launchOptions.size();
                    for (int j = 0; j < numOptions; ++j) {
                        RecoveryDataForLink truncatedRFL;
                        PointAlternative npa = (PointAlternative)launchOptions.get(j);
                        Point2D.Double shifted = null;
                        if (npa.point.equals(testPt)) {
                            shifted = testPt2D;
                            truncatedRFL = new RecoveryDataForLink(recoverForLink, i + 1);
                        } else {
                            shifted = new Point2D.Double(npa.point.getX(), npa.point.getY());
                            truncatedRFL = new RecoveryDataForLink(recoverForLink, i + 1);
                        }
                        List threePts = this.buildRecoverPointList(shifted, endPt, truncatedRFL, 0);
                        if (threePts == null) continue;
                        retval.add(new PointAlternativeForRecovery(npa, threePts, end, truncatedRFL));
                    }
                    return retval.isEmpty() ? null : retval;
                }
                if (this.linkIsPresentAtPoint(src, testPt)) {
                    return null;
                }
            }
            lastRun = recoverForLink.getInboundRun(i);
            lastPoint = (Point2D)testPt2D.clone();
        }
        return null;
    }

    private PointAlternativeForRecovery lastDitchForRecovery(String src, String linkID, Layout lo, TerminalRegion arrival, Set okGroups, RecoveryDataForLink recoverForLink, Set linksFromSource, int chopIndex) {
        BusProperties bp = lo.getLinkProperties(linkID);
        if (bp.isDirect()) {
            return null;
        }
        LinkSegment rseg = bp.getRootSegment();
        PointAlternative pa = this.degeneratePoint(rseg, src, okGroups, linksFromSource);
        if (pa == null) {
            return null;
        }
        List exits = this.getPossibleExits(pa.point);
        if (exits.isEmpty()) {
            return null;
        }
        Vector2D useVec = (Vector2D)exits.get(0);
        pa.dir = LinkPlacementGrid.getDirection(useVec);
        Point end = arrival.getPoint(0);
        Point2D.Double endPt = new Point2D.Double(end.getX(), end.getY());
        RecoveryDataForLink truncatedRFL = new RecoveryDataForLink(recoverForLink, chopIndex + 1);
        Point2D.Double strtPt = new Point2D.Double(pa.point.getX(), pa.point.getY());
        List threePts = this.buildRecoverPointList(strtPt, endPt, truncatedRFL, 0);
        if (threePts == null) {
            return null;
        }
        return new PointAlternativeForRecovery(pa, threePts, end, truncatedRFL);
    }

    public List getValidFirstTrack(String src, String trg, String linkID, TerminalRegion departure, TerminalRegion arrival, GoodnessParams goodness, Set okGroups, boolean force, int entryPref, Set linksFromSource) {
        ArrayList<Point2D.Double> retval = new ArrayList<Point2D.Double>();
        int numDep = departure.getNumPoints();
        int numArr = arrival.getNumPoints();
        if (numDep == 0 || numArr == 0) {
            return retval;
        }
        this.gauss_.clear();
        goodness.differenceNormalize = 1.0 / this.gaussian(0.0, goodness.differenceSigma);
        goodness.normalize = 1.0;
        goodness.normalize = 1.0 / this.goodness(goodness, 1.0, 0, 0);
        IterationChecker checker = new IterationChecker(100);
        List bestStarts = this.pickStartIndex(departure, arrival);
        int numStart = bestStarts.size();
        for (int i = 0; i < numStart; ++i) {
            StartIndex sp = (StartIndex)bestStarts.get(i);
            Point start = departure.getPoint(sp.index);
            Point end = arrival.getPoint(0);
            Vector2D departDir = sp.direction;
            Vector2D arriveDir = arrival.getTerminalVector();
            try {
                TravelTurn initTurn = this.buildInitTurn(src, start, departDir, trg, end, linkID, okGroups);
                if (!this.jumpStep(src, trg, linkID, new Point2D.Double(end.x, end.y), LinkPlacementGrid.getVector(departure.direction), arriveDir, initTurn, retval, 15, 0, goodness, checker, true, force, okGroups, entryPref, null)) continue;
                retval.add(0, new Point2D.Double(start.getX() * 10.0, start.getY() * 10.0));
                int cleanVal = this.cleanupRoughDraft(retval, new Point2D.Double(departure.start.getX() * 10.0, departure.start.getY() * 10.0), true, src, trg, okGroups, departure, arrival, null, linksFromSource, linkID);
                if (cleanVal == 0) {
                    this.convertTerminalRegion(departure);
                    this.convertTerminalRegion(arrival);
                    this.commitTemps(linkID);
                }
                return retval;
            }
            catch (NonConvergenceException ncex) {
                if (checker.limitExceeded()) break;
            }
        }
        return retval;
    }

    private int cleanupRoughDraft(List retval, Point2D start, boolean isFromPad, String src, String trg, Set okGroups, TerminalRegion depart, TerminalRegion arrive, NewCorner changedStart, Set linksFromSource, String linkID) {
        List shorterS;
        ArrayList chopped = new ArrayList();
        int retType = this.chopLoops(retval, start, chopped);
        if (retType != 0) {
            retval.clear();
            retval.addAll(chopped);
        }
        List shorter = retval;
        while (shorter != null) {
            shorter = this.chopToShorterBackward(retval, start, src, trg, okGroups);
            if (shorter == null) continue;
            retType = retType == 0 ? 1 : retType;
            retval.clear();
            retval.addAll(shorter);
        }
        List shorterF = retval;
        while (shorterF != null) {
            shorterF = this.chopToShorterForward(retval, start, src, trg, okGroups);
            if (shorterF == null) continue;
            retType = retType == 0 ? 1 : retType;
            retval.clear();
            retval.addAll(shorterF);
        }
        if (!isFromPad && (shorterS = this.lookForAlternateLaunch(retval, start, src, trg, okGroups, changedStart, linksFromSource)) != null) {
            retType = retType == 0 ? 1 : retType;
            retval.clear();
            retval.addAll(shorterS);
        }
        if (retType != 0) {
            this.clearTemps();
            if (depart != null) {
                this.dropTerminalRegion(depart);
            }
            this.dropTerminalRegion(arrive);
            Point2D strt = !isFromPad ? start : null;
            Point2D.Double end = new Point2D.Double(arrive.start.getX() * 10.0, arrive.start.getY() * 10.0);
            MyCornerOracle mco = new MyCornerOracle(strt, end);
            ArrayList<Point2D> drawList = new ArrayList<Point2D>(retval);
            drawList.add(0, start);
            drawList.add(end);
            HashSet<String> linkIDs = new HashSet<String>();
            linkIDs.add(linkID);
            this.drawLinkFromPoints(src, drawList, mco, linkIDs);
        }
        return retType;
    }

    public InkValues getLinkInk(String src) {
        int inkCount = 0;
        int simpleBendCount = 0;
        int complexCount = 0;
        PatternValueIterator vit = new PatternValueIterator(false);
        while (vit.hasNext()) {
            GridContents gc = (GridContents)vit.next();
            if (!this.lookForSource(src, gc)) continue;
            ++inkCount;
            int ctype = this.cornerType(gc);
            if (ctype == 2) {
                ++simpleBendCount;
                continue;
            }
            if (ctype != 3) continue;
            ++complexCount;
        }
        return new InkValues(inkCount, simpleBendCount, complexCount);
    }

    public NewCorner getValidAddOnTrack(String src, String trg, String linkID, TerminalRegion arrival, List points, GoodnessParams goodness, Set okGroups, boolean force, int entryPref, Genome genome, Layout lo, FontRenderContext frc, Set omitted, Set linksFromSource) {
        int numArr;
        HashSet<Object> ignore = new HashSet<Object>();
        Point start = new Point();
        int n = numArr = arrival == null ? 0 : arrival.getNumPoints();
        if (numArr == 0) {
            return null;
        }
        this.gauss_.clear();
        goodness.differenceNormalize = 1.0 / this.gaussian(0.0, goodness.differenceSigma);
        goodness.normalize = 1.0;
        goodness.normalize = 1.0 / this.goodness(goodness, 1.0, 0, 0);
        Point end = arrival.getPoint(0);
        Point2D.Double targPt = new Point2D.Double(end.x, end.y);
        LaunchAnalysis la = this.generateLaunchAlternatives(targPt, src, linkID, okGroups, genome, lo, frc, omitted, linksFromSource);
        block2: while (true) {
            Point2D.Double chooseConv;
            PointAlternative pa;
            if ((pa = la.extractNextAlternative()) == null) {
                return null;
            }
            int type = pa.type;
            start = pa.point;
            IterationChecker checker = new IterationChecker(25);
            Set nearby = this.getRunAlternatives(src, start, type, ignore);
            PointAlternative choose = this.chooseBestAlternativeCloseToTarg(src, trg, linkID, end, nearby, start, type, okGroups, false);
            if (choose == null) {
                Iterator nit = nearby.iterator();
                while (true) {
                    if (!nit.hasNext()) continue block2;
                    PointAlternative pit = (PointAlternative)nit.next();
                    ignore.add(pit.point.clone());
                }
            }
            BusProperties bp = lo.getLinkProperties(linkID);
            LinkProperties.DistancedLinkSegID dlsegID = bp.intersectBusSegment(genome, null, lo, chooseConv = new Point2D.Double(choose.point.getX() * 10.0, choose.point.getY() * 10.0), frc, omitted, 5.0);
            if (dlsegID == null) {
                // empty if block
            }
            start = choose.point;
            type = choose.type;
            Point2D scaleStart = new Point2D.Double(start.getX(), start.getY());
            int bestDir = choose.dir;
            Vector2D arriveDir = arrival.getTerminalVector();
            Vector2D departDir = LinkPlacementGrid.getVector(bestDir);
            scaleStart = departDir.add(scaleStart);
            try {
                TravelTurn initTurn = this.buildInitTurn(src, scaleStart, departDir, trg, end, linkID, okGroups);
                if (this.jumpStep(src, trg, linkID, new Point2D.Double(end.x, end.y), departDir, arriveDir, initTurn, points, 15, 0, goodness, checker, false, force, okGroups, entryPref, null)) {
                    int cleanVal;
                    NewCorner changedStart = new NewCorner(type, null, bestDir);
                    if (points.size() == 0) {
                        points.add(0, new Point2D.Double(scaleStart.getX() * 10.0, scaleStart.getY() * 10.0));
                    }
                    if ((cleanVal = this.cleanupRoughDraft(points, new Point2D.Double((double)start.x * 10.0, (double)start.y * 10.0), false, src, trg, okGroups, null, arrival, changedStart, linksFromSource, linkID)) == 0) {
                        this.convertTerminalRegion(arrival);
                        this.addTempEntryForRun(scaleStart, src, bestDir);
                        this.commitTemps(linkID);
                    }
                    if (changedStart.point == null) {
                        return new NewCorner(type, new Point2D.Double((double)start.x * 10.0, (double)start.y * 10.0), bestDir);
                    }
                    changedStart.point = new Point2D.Double(changedStart.point.getX() * 10.0, changedStart.point.getY() * 10.0);
                    return changedStart;
                }
            }
            catch (NonConvergenceException ncex) {
                if (checker.limitExceeded()) {
                    // empty if block
                }
            }
            ignore.add(start.clone());
            if (ignore.size() > 80) break;
        }
        return null;
    }

    private LaunchAnalysis generateLaunchAlternatives(Point2D targPt, String src, String linkID, Set okGroups, Genome genome, Layout lo, FontRenderContext frc, Set omitted, Set linksFromSource) {
        BusProperties bp = lo.getLinkProperties(linkID);
        Set candidateStarts = genome.getOutboundLinks(src);
        candidateStarts.removeAll(omitted);
        HashSet<LinkSegmentID> candSegs = new HashSet<LinkSegmentID>();
        LinkSegmentID degen = null;
        Iterator csit = candidateStarts.iterator();
        while (csit.hasNext()) {
            String candID = (String)csit.next();
            List segsForLink = bp.getBusLinkSegmentsForOneLink(genome, null, candID);
            int numsfl = segsForLink.size();
            for (int i = 0; i < numsfl; ++i) {
                LinkSegmentID segID = (LinkSegmentID)segsForLink.get(i);
                if (!segID.isForSegment()) continue;
                LinkSegment seg = bp.getSegment(segID);
                if (seg.isDegenerate()) {
                    degen = segID;
                    continue;
                }
                if (!seg.isOrthogonal()) continue;
                candSegs.add(segID);
            }
        }
        if (candSegs.isEmpty()) {
            candSegs.add(degen);
        }
        LaunchAnalysis la = this.analyzeSegs(targPt, candSegs, bp, src, okGroups, linksFromSource);
        return la;
    }

    private LaunchAnalysis analyzeSegs(Point2D targPt, Set candSegs, BusProperties bp, String srcID, Set okGroups, Set linksFromSource) {
        Integer noKey = new Integer(0);
        LaunchAnalysis retval = new LaunchAnalysis();
        Iterator csit = candSegs.iterator();
        while (csit.hasNext()) {
            ArrayList<PointAlternative> ptsForDist;
            LinkSegmentID segID = (LinkSegmentID)csit.next();
            LinkSegment seg = bp.getSegment(segID);
            PointAlternative pa = seg.isDegenerate() ? this.degeneratePoint(seg, srcID, okGroups, linksFromSource) : this.closestPoint(targPt, seg, srcID, okGroups, linksFromSource);
            if (pa == null) continue;
            Point2D.Double usePt = new Point2D.Double(pa.point.x, pa.point.y);
            Vector2D trav = new Vector2D(usePt, targPt);
            Double sidt = new Double(trav.length());
            Integer binKey = this.getVectorBin(trav);
            if (binKey.equals(noKey)) continue;
            TreeMap<Double, ArrayList<PointAlternative>> distForBin = (TreeMap<Double, ArrayList<PointAlternative>>)retval.binnedResults.get(binKey);
            if (distForBin == null) {
                distForBin = new TreeMap<Double, ArrayList<PointAlternative>>();
                retval.binnedResults.put(binKey, distForBin);
            }
            if ((ptsForDist = (ArrayList<PointAlternative>)distForBin.get(sidt)) == null) {
                ptsForDist = new ArrayList<PointAlternative>();
                distForBin.put(sidt, ptsForDist);
            }
            ptsForDist.add(pa);
        }
        TreeMap<Double, Integer> buildOrder = new TreeMap<Double, Integer>();
        Iterator brkit = retval.binnedResults.keySet().iterator();
        while (brkit.hasNext()) {
            Integer binKey = (Integer)brkit.next();
            TreeMap distForBin = (TreeMap)retval.binnedResults.get(binKey);
            Double minDist = (Double)distForBin.firstKey();
            buildOrder.put(minDist, binKey);
        }
        retval.bestOrder.addAll(buildOrder.values());
        return retval;
    }

    private PointAlternative degeneratePoint(LinkSegment seg, String srcID, Set okGroups, Set linksFromSource) {
        Point2D startPt = seg.getStart();
        Point griddedStart = new Point();
        Point2D.Double griddedStart2D = new Point2D.Double();
        LinkPlacementGrid.pointConversion(startPt, griddedStart2D, griddedStart);
        GridContents gval = this.getGridContents(griddedStart);
        int cellType = this.lookForLaunchCell(srcID, gval, okGroups, linksFromSource);
        if (cellType != 0 && !this.notOverMyGenePad(srcID, null, griddedStart2D)) {
            return new PointAlternative(griddedStart, cellType, 0);
        }
        return null;
    }

    private PointAlternative closestPoint(Point2D targPt, LinkSegment seg, String srcID, Set okGroups, Set linksFromSource) {
        Point2D startPt = seg.getStart();
        Point2D endPt = seg.getEnd();
        Point griddedStart = new Point();
        Point griddedEnd = new Point();
        Point2D.Double griddedStart2D = new Point2D.Double();
        Point2D.Double griddedEnd2D = new Point2D.Double();
        LinkPlacementGrid.pointConversion(startPt, griddedStart2D, griddedStart);
        LinkPlacementGrid.pointConversion(endPt, griddedEnd2D, griddedEnd);
        Vector2D trav = seg.getRun();
        if (trav.isZero()) {
            return null;
        }
        WalkValues walk = this.getWalkValues(trav, griddedStart2D, griddedEnd2D, 1);
        double minDist = Double.POSITIVE_INFINITY;
        PointAlternative minPt = null;
        Point2D.Double testPt = new Point2D.Double();
        Point keyPt = new Point();
        for (int x = walk.startX; x != walk.endX; x += walk.incX) {
            for (int y = walk.startY; y != walk.endY; y += walk.incY) {
                Vector2D checkVec;
                double checkDist;
                int cellType;
                ((Point2D)testPt).setLocation(x, y);
                keyPt.setLocation(x, y);
                GridContents gval = this.getGridContents(keyPt);
                if (gval == null || (cellType = this.lookForLaunchCell(srcID, gval, okGroups, linksFromSource)) == 0 || this.notOverMyGenePad(srcID, null, testPt) || !((checkDist = (checkVec = new Vector2D(testPt, targPt)).length()) < minDist)) continue;
                minDist = checkDist;
                if (minPt == null) {
                    minPt = new PointAlternative((Point)keyPt.clone(), cellType, 0);
                    continue;
                }
                minPt.point.setLocation(testPt);
                minPt.type = cellType;
            }
        }
        return minPt;
    }

    private List modifiedRecoveryLaunch(PointAlternative orig, int entryForCell, Vector2D outbound, String srcID, RecoveryDataForSource rds, Set linksFromSource, Point2D nextPoint) {
        Point chkPt;
        List exits;
        boolean canGoOutbound;
        List jumpedFrom;
        PointAlternative jiPA;
        ArrayList<PointAlternative> retval = new ArrayList<PointAlternative>();
        if (entryForCell == 0) {
            retval.add(orig);
            return retval;
        }
        if (!outbound.isCanonical()) {
            outbound = outbound.canonical();
        }
        outbound = outbound.normalized();
        Point startPt = orig.point;
        if (orig.type == 5) {
            int exitForCell = GridEntry.getCardinalOppositeDirection(entryForCell);
            Vector2D currentRun = LinkPlacementGrid.getVector(exitForCell);
            List runPAs = this.walkForModifiedRecoveryLaunchOption(orig, currentRun, startPt, exitForCell, outbound, srcID, linksFromSource, nextPoint);
            if (runPAs != null && !runPAs.isEmpty()) {
                retval.addAll(runPAs);
            }
            return retval;
        }
        Point2D jumped = rds.getJumpIntoPoint(orig.point);
        if (jumped != null && (jiPA = this.modifiedRecoveryLaunchOption(jumped, outbound, srcID, linksFromSource)) != null) {
            retval.add(jiPA);
        }
        if ((jumpedFrom = rds.getJumpFromPoints(orig.point)) != null) {
            int numJf = jumpedFrom.size();
            for (int i = 0; i < numJf; ++i) {
                Point2D jumpedPoint = (Point2D)jumpedFrom.get(i);
                PointAlternative joPA = this.modifiedRecoveryLaunchOption(jumpedPoint, outbound, srcID, linksFromSource);
                if (joPA == null) continue;
                retval.add(joPA);
            }
        }
        if (!(canGoOutbound = (exits = this.getPossibleExits(chkPt = new Point((int)((Point2D)startPt).getX(), (int)((Point2D)startPt).getY()))).contains(outbound))) {
            Vector2D tryMeAlso;
            Vector2D tryMe = new Vector2D(startPt, nextPoint);
            Vector2D tryMeBest = this.getClosestCanonical(tryMe);
            if (exits.contains(tryMeBest)) {
                retval.add(new PointAlternative((Point)chkPt.clone(), orig.type, LinkPlacementGrid.getDirection(tryMeBest)));
            }
            if (exits.contains(tryMeAlso = this.getSecondClosestCanonical(tryMe))) {
                retval.add(new PointAlternative((Point)chkPt.clone(), orig.type, LinkPlacementGrid.getDirection(tryMeAlso)));
            }
        } else {
            retval.add(orig);
        }
        return retval;
    }

    private List walkForModifiedRecoveryLaunchOption(PointAlternative orig, Vector2D currentRun, Point2D startPt, int exitForCell, Vector2D outbound, String srcID, Set linksFromSource, Point2D nextPoint) {
        WalkValues walk = this.getWalkValues(currentRun, startPt, null, 1);
        ArrayList<PointAlternative> retval = new ArrayList<PointAlternative>();
        PointAlternative retvalOne = orig;
        PointAlternative retvalZero = null;
        Point keyPt = new Point();
        for (int x = walk.startX; x != walk.endX; x += walk.incX) {
            for (int y = walk.startY; y != walk.endY; y += walk.incY) {
                keyPt.setLocation(x, y);
                if (x == walk.startX && y == walk.startY) {
                    Vector2D toNext;
                    List exits = this.getPossibleExits(keyPt);
                    boolean canGoOutbound = exits.contains(outbound);
                    if (!canGoOutbound || !(toNext = new Vector2D(keyPt, nextPoint).normalized()).equals(outbound)) continue;
                    retvalZero = new PointAlternative((Point)keyPt.clone(), 5, LinkPlacementGrid.getDirection(outbound));
                    continue;
                }
                GridContents gval = this.getGridContents(keyPt);
                if (gval == null) {
                    if (retvalZero != null) {
                        retval.add(retvalZero);
                    }
                    if (retvalOne != null) {
                        retval.add(retvalOne);
                    }
                    return retval;
                }
                int cellType = this.lookForLaunchCell(srcID, gval, null, linksFromSource);
                if (cellType != 0) {
                    Vector2D toNext;
                    List exits = this.getPossibleExits(keyPt);
                    boolean canGoOutbound = exits.contains(outbound);
                    if (canGoOutbound && (toNext = new Vector2D(keyPt, nextPoint).normalized()).equals(outbound)) {
                        retvalZero = new PointAlternative((Point)keyPt.clone(), cellType, LinkPlacementGrid.getDirection(outbound));
                    }
                    int exitDir = canGoOutbound ? LinkPlacementGrid.getDirection(outbound) : exitForCell;
                    retvalOne = new PointAlternative((Point)keyPt.clone(), cellType, exitDir);
                    continue;
                }
                if (!this.linkIsPresentAtPoint(srcID, keyPt)) {
                    if (retvalZero != null) {
                        retval.add(retvalZero);
                    }
                    if (retvalOne != null) {
                        retval.add(retvalOne);
                    }
                    return retval;
                }
                retvalOne = null;
            }
        }
        if (retvalZero != null) {
            retval.add(retvalZero);
        }
        if (retvalOne != null) {
            retval.add(retvalOne);
        }
        return retval;
    }

    private PointAlternative modifiedRecoveryLaunchOption(Point2D startPt, Vector2D outbound, String srcID, Set linksFromSource) {
        Point keyPt = new Point((int)startPt.getX(), (int)startPt.getY());
        GridContents gval = this.getGridContents(keyPt);
        if (gval == null) {
            return null;
        }
        int cellType = this.lookForLaunchCell(srcID, gval, null, linksFromSource);
        if (cellType != 0) {
            int exitDir;
            List exits = this.getPossibleExits(keyPt);
            int entryForCell = this.getEntryDirectionForSrc(keyPt, srcID);
            int straightExit = GridEntry.getCardinalOppositeDirection(entryForCell);
            if (exits.contains(outbound)) {
                exitDir = LinkPlacementGrid.getDirection(outbound);
            } else if (exits.contains(LinkPlacementGrid.getVector(straightExit))) {
                exitDir = straightExit;
            } else if (exits.size() > 0) {
                exitDir = LinkPlacementGrid.getDirection((Vector2D)exits.get(0));
            } else {
                return null;
            }
            PointAlternative retval = new PointAlternative(keyPt, cellType, exitDir);
            return retval;
        }
        return null;
    }

    public void convertRunToCorner(Point2D split, String src, int dir) {
        Point address = new Point((int)split.getX() / 10, (int)split.getY() / 10);
        GridContents gc = this.getGridContents(address);
        GridEntry entry = this.extractTargetedEntry(src, gc, 5);
        entry.type = 3;
        entry.exits |= dir;
        this.writeBackModifiedGridContents(address, gc);
    }

    public void addCornerDirection(Point2D split, String src, int dir) {
        Point address = new Point((int)split.getX() / 10, (int)split.getY() / 10);
        GridContents gc = this.getGridContents(address);
        GridEntry entry = this.extractTargetedEntry(src, gc, 3);
        entry.exits |= dir;
        this.writeBackModifiedGridContents(address, gc);
    }

    private GridEntry extractTargetedEntry(String src, GridContents gc, int type) {
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            if (!gc.entry.id.equals(src) || gc.entry.type != type) {
                throw new IllegalArgumentException();
            }
            return gc.entry;
        }
        int size = gc.extra.size();
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (currEntry.type == 9 || !currEntry.id.equals(src) || currEntry.type != type) continue;
            return currEntry;
        }
        throw new IllegalArgumentException();
    }

    private GridContents getGridContents(Point cellPt) {
        return this.getGridContents(cellPt, true);
    }

    private GridContents getGridContents(int x, int y) {
        return this.getGridContents(new Point(x, y));
    }

    private GridContents getGridContents(Point cellPt, boolean needGroups) {
        GridContents gc = (GridContents)this.patternx_.get(cellPt);
        if (gc != null) {
            gc = (GridContents)gc.clone();
        }
        if (needGroups) {
            List groupEntries = this.generateGroups(cellPt);
            gc = this.foldInGroups(groupEntries, gc);
        }
        return gc;
    }

    private void dropFromPattern(Point cellPt) {
        this.patternx_.remove(cellPt);
    }

    private List generateGroups(Point pt) {
        ArrayList<GridEntry> retval = new ArrayList<GridEntry>();
        Iterator git = this.groups_.keySet().iterator();
        while (git.hasNext()) {
            String groupID = (String)git.next();
            Rectangle rect = (Rectangle)this.groups_.get(groupID);
            int grpX = rect.x / 10;
            int grpY = rect.y / 10;
            int grpW = rect.width / 10;
            int grpH = rect.height / 10;
            if (pt.x < grpX || pt.y < grpY || pt.x >= grpX + grpW || pt.y >= grpY + grpH) continue;
            GridEntry entry = new GridEntry(groupID, 9, 0, 0, false);
            retval.add(entry);
        }
        return retval;
    }

    private GridContents foldInGroups(List groupEntries, GridContents gc) {
        int numGrp = groupEntries.size();
        for (int i = 0; i < numGrp; ++i) {
            GridEntry entry = (GridEntry)groupEntries.get(i);
            if (gc == null) {
                gc = new GridContents(entry);
                continue;
            }
            gc.mergeContents(entry);
        }
        return gc;
    }

    private boolean dropGroupEntries(GridContents gc) {
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            return gc.entry.type == 9;
        }
        int size = gc.extra.size();
        for (int i = size - 1; i >= 0; --i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (currEntry.type != 9) continue;
            gc.extra.remove(i);
        }
        size = gc.extra.size();
        if (size == 0) {
            return true;
        }
        if (size == 1) {
            gc.entry = (GridEntry)gc.extra.get(0);
            gc.extra = null;
        }
        return false;
    }

    private void installModifiedGridContents(Point cellPt, GridEntry entry) {
        if (entry == null) {
            return;
        }
        if (this.bounds_ != null && !this.bounds_.contains(cellPt)) {
            return;
        }
        GridContents gc = (GridContents)this.patternx_.get(cellPt);
        if (gc == null) {
            gc = new GridContents(entry);
            this.patternx_.put(cellPt, gc);
        } else {
            gc.mergeContents(entry);
        }
    }

    private void installModifiedGridContents(int xval, int yval, GridEntry entry) {
        Point cellPt = new Point(xval, yval);
        this.installModifiedGridContents(cellPt, entry);
    }

    private void writeBackModifiedGridContents(Point pt, GridContents gc) {
        if (this.bounds_ != null && !this.bounds_.contains(pt)) {
            return;
        }
        if (gc == null || this.dropGroupEntries(gc)) {
            this.patternx_.remove(pt);
        } else {
            this.patternx_.put(pt, gc);
        }
    }

    private void writeBackModifiedGridContents(int xval, int yval, GridContents gc) {
        Point cellPt = new Point(xval, yval);
        this.writeBackModifiedGridContents(cellPt, gc);
    }

    public static Vector2D getVector(int direction) {
        switch (direction) {
            case 1: {
                return new Vector2D(0.0, -1.0);
            }
            case 2: {
                return new Vector2D(1.0, 0.0);
            }
            case 4: {
                return new Vector2D(0.0, 1.0);
            }
            case 8: {
                return new Vector2D(-1.0, 0.0);
            }
        }
        throw new IllegalStateException();
    }

    public static int getReverse(int forward) {
        switch (forward) {
            case 1: {
                return 4;
            }
            case 4: {
                return 1;
            }
            case 2: {
                return 8;
            }
            case 8: {
                return 2;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int getDirection(Vector2D vector) {
        int vecX = (int)vector.getX();
        int vecY = (int)vector.getY();
        if (vecX == -1 && vecY == 0) {
            return 8;
        }
        if (vecX == 0 && vecY == 1) {
            return 4;
        }
        if (vecX == 1 && vecY == 0) {
            return 2;
        }
        if (vecX == 0 && vecY == -1) {
            return 1;
        }
        System.err.println("Not canonical: " + vector);
        throw new IllegalArgumentException();
    }

    public static int getDirectionFromPoints(Point start, Point end) {
        int vecX = end.x - start.x;
        int vecY = end.y - start.y;
        if (vecX == -1 && vecY == 0) {
            return 8;
        }
        if (vecX == 0 && vecY == 1) {
            return 4;
        }
        if (vecX == 1 && vecY == 0) {
            return 2;
        }
        if (vecX == 0 && vecY == -1) {
            return 1;
        }
        throw new IllegalArgumentException();
    }

    public static boolean isOrthogonal(Point2D start, Point2D end) {
        double vecX = end.getX() - start.getX();
        double vecY = end.getY() - start.getY();
        if (vecX == 0.0 && vecY == 0.0) {
            return false;
        }
        return vecX == 0.0 || vecY == 0.0;
    }

    public static boolean isOrthogonal(Vector2D vec) {
        double vecX = vec.getX();
        double vecY = vec.getY();
        if (vecX == 0.0 && vecY == 0.0) {
            return false;
        }
        return vecX == 0.0 || vecY == 0.0;
    }

    public static int getDirectionFromCoords(double startX, double startY, double endX, double endY) {
        double vecX = endX - startX;
        double vecY = endY - startY;
        if (vecX == 0.0 && vecY == 0.0) {
            return 0;
        }
        if (vecX < 0.0 && vecY == 0.0) {
            return 8;
        }
        if (vecX == 0.0 && vecY > 0.0) {
            return 4;
        }
        if (vecX > 0.0 && vecY == 0.0) {
            return 2;
        }
        if (vecX == 0.0 && vecY < 0.0) {
            return 1;
        }
        return 16;
    }

    public static int oppositeTurn(int leftRight) {
        switch (leftRight) {
            case 1: {
                return 0;
            }
            case 0: {
                return 1;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Vector2D getTurn(Vector2D straight, int leftRight) {
        if (leftRight != 1 && leftRight != 0) {
            throw new IllegalArgumentException();
        }
        int vecX = (int)straight.getX();
        int vecY = (int)straight.getY();
        if (vecX == -1 && vecY == 0) {
            return leftRight == 1 ? new Vector2D(0.0, -1.0) : new Vector2D(0.0, 1.0);
        }
        if (vecX == 0 && vecY == 1) {
            return leftRight == 1 ? new Vector2D(-1.0, 0.0) : new Vector2D(1.0, 0.0);
        }
        if (vecX == 1 && vecY == 0) {
            return leftRight == 1 ? new Vector2D(0.0, 1.0) : new Vector2D(0.0, -1.0);
        }
        if (vecX == 0 && vecY == -1) {
            return leftRight == 1 ? new Vector2D(1.0, 0.0) : new Vector2D(-1.0, 0.0);
        }
        System.err.println(straight);
        throw new IllegalArgumentException();
    }

    private Integer getVectorBin(Vector2D vector) {
        if (vector.isZero()) {
            return new Integer(0);
        }
        Vector2D normVec = vector.normalized();
        double vecX = normVec.getX();
        double vecY = normVec.getY();
        int retval = vecX < 0.0 ? (vecY < -this.sqrt2o2_ ? 1 : (vecY > this.sqrt2o2_ ? 4 : 8)) : (vecY < -this.sqrt2o2_ ? 1 : (vecY > this.sqrt2o2_ ? 4 : 2));
        return new Integer(retval);
    }

    private Vector2D getSecondClosestCanonical(Vector2D vector) {
        if (vector.isZero()) {
            return null;
        }
        Vector2D normVec = vector.normalized();
        int retval = 0;
        double vecX = normVec.getX();
        double vecY = normVec.getY();
        if (vecX < 0.0) {
            retval = vecY < -this.sqrt2o2_ || vecY > this.sqrt2o2_ ? 8 : (vecY < 0.0 ? 1 : (vecY > 0.0 ? 4 : 0));
        } else if (vecX > 0.0) {
            retval = vecY < -this.sqrt2o2_ || vecY > this.sqrt2o2_ ? 2 : (vecY < 0.0 ? 1 : (vecY > 0.0 ? 4 : 0));
        }
        if (retval == 0) {
            return this.getClosestCanonical(vector);
        }
        return LinkPlacementGrid.getVector(retval);
    }

    private Vector2D getClosestCanonical(Vector2D vector) {
        Integer bin = this.getVectorBin(vector);
        if (bin.equals(new Integer(0))) {
            return null;
        }
        return LinkPlacementGrid.getVector(bin);
    }

    public SortedSet getAddedCornerRows(LinkPlacementGrid otherGrid, BTProgressMonitor monitor) throws AsynchExitRequestException {
        MinMax myRowRange = this.getMinMaxYForRange(null, monitor);
        MinMax otherRowRange = otherGrid.getMinMaxYForRange(null, monitor);
        MinMax combinedRowRange = myRowRange.union(otherRowRange);
        MinMax myColRange = this.getMinMaxXForRange(null, monitor);
        MinMax otherColRange = otherGrid.getMinMaxXForRange(null, monitor);
        MinMax combinedColRange = myColRange.union(otherColRange);
        TreeSet<Integer> retval = new TreeSet<Integer>();
        for (int i = combinedRowRange.min; i <= combinedRowRange.max; ++i) {
            if (!this.cornerAddedToRow(i, otherGrid, combinedColRange)) continue;
            retval.add(new Integer(i));
        }
        return retval;
    }

    public SortedSet getAddedCornerCols(LinkPlacementGrid otherGrid, BTProgressMonitor monitor) throws AsynchExitRequestException {
        MinMax myRowRange = this.getMinMaxYForRange(null, monitor);
        MinMax otherRowRange = otherGrid.getMinMaxYForRange(null, monitor);
        MinMax combinedRowRange = myRowRange.union(otherRowRange);
        MinMax myColRange = this.getMinMaxXForRange(null, monitor);
        MinMax otherColRange = otherGrid.getMinMaxXForRange(null, monitor);
        MinMax combinedColRange = myColRange.union(otherColRange);
        TreeSet<Integer> retval = new TreeSet<Integer>();
        for (int i = combinedColRange.min; i <= combinedColRange.max; ++i) {
            if (!this.cornerAddedToCol(i, otherGrid, combinedRowRange)) continue;
            retval.add(new Integer(i));
        }
        return retval;
    }

    public SortedSet getEmptyRows(MinMax xBounds, boolean makeRegionsOpaque, BTProgressMonitor monitor) throws AsynchExitRequestException {
        return this.getEmptyRows(xBounds, makeRegionsOpaque, monitor, null, null);
    }

    public SortedSet getEmptyRowsWithYBounds(MinMax xBounds, MinMax rowRange, boolean makeRegionsOpaque, BTProgressMonitor monitor) throws AsynchExitRequestException {
        int minGrid = xBounds.min / 10;
        int maxGrid = xBounds.max / 10;
        xBounds = new MinMax(minGrid, maxGrid);
        minGrid = rowRange.min / 10;
        maxGrid = rowRange.max / 10;
        rowRange = new MinMax(minGrid, maxGrid);
        TreeSet retval = new TreeSet(Collections.reverseOrder());
        for (int i = rowRange.min; i <= rowRange.max; ++i) {
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            if (!this.rowIsEmpty(i, xBounds, makeRegionsOpaque, null)) continue;
            retval.add(new Integer(i));
        }
        return retval;
    }

    public SortedSet getEmptyRows(MinMax xBounds, boolean makeRegionsOpaque, BTProgressMonitor monitor, Set ignoreNodes, MinMax testedRange) throws AsynchExitRequestException {
        if (xBounds != null) {
            int minGrid = xBounds.min / 10;
            int maxGrid = xBounds.max / 10;
            xBounds = new MinMax(minGrid, maxGrid);
        }
        TreeSet retval = new TreeSet(Collections.reverseOrder());
        MinMax rowRange = this.getMinMaxYForRange(xBounds, monitor);
        if (rowRange == null) {
            return retval;
        }
        if (testedRange != null) {
            testedRange.min = rowRange.min;
            testedRange.max = rowRange.max;
        }
        for (int i = rowRange.min; i <= rowRange.max; ++i) {
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            if (!this.rowIsEmpty(i, xBounds, makeRegionsOpaque, ignoreNodes)) continue;
            retval.add(new Integer(i));
        }
        return retval;
    }

    public SortedSet getExpandableRows(MinMax xBounds, boolean reversable, BTProgressMonitor monitor) throws AsynchExitRequestException {
        if (xBounds != null) {
            int minGrid = xBounds.min / 10;
            int maxGrid = xBounds.max / 10;
            xBounds = new MinMax(minGrid, maxGrid);
        }
        TreeSet retval = new TreeSet(Collections.reverseOrder());
        MinMax rowRange = this.getMinMaxYForRange(xBounds, monitor);
        MinMax colRange = this.getMinMaxXForRange(null, monitor);
        if (rowRange == null || colRange == null) {
            return retval;
        }
        for (int i = rowRange.min; i <= rowRange.max; ++i) {
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            if (!this.rowCanExpand(i, reversable, colRange)) continue;
            retval.add(new Integer(i));
        }
        return retval;
    }

    public SortedSet getEmptyColumns(MinMax yBounds, boolean makeRegionsOpaque, BTProgressMonitor monitor) throws AsynchExitRequestException {
        return this.getEmptyColumns(yBounds, makeRegionsOpaque, monitor, null, null);
    }

    public SortedSet getEmptyColumnsWithXBounds(MinMax yBounds, MinMax colRange, boolean makeRegionsOpaque, BTProgressMonitor monitor) throws AsynchExitRequestException {
        int minGrid = yBounds.min / 10;
        int maxGrid = yBounds.max / 10;
        yBounds = new MinMax(minGrid, maxGrid);
        minGrid = colRange.min / 10;
        maxGrid = colRange.max / 10;
        colRange = new MinMax(minGrid, maxGrid);
        TreeSet retval = new TreeSet(Collections.reverseOrder());
        for (int i = colRange.min; i <= colRange.max; ++i) {
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            if (!this.columnIsEmpty(i, yBounds, makeRegionsOpaque)) continue;
            retval.add(new Integer(i));
        }
        return retval;
    }

    public SortedSet getEmptyColumns(MinMax yBounds, boolean makeRegionsOpaque, BTProgressMonitor monitor, Set ignoreNodes, MinMax testedRange) throws AsynchExitRequestException {
        if (yBounds != null) {
            int minGrid = yBounds.min / 10;
            int maxGrid = yBounds.max / 10;
            yBounds = new MinMax(minGrid, maxGrid);
        }
        TreeSet retval = new TreeSet(Collections.reverseOrder());
        MinMax colRange = this.getMinMaxXForRange(yBounds, monitor);
        if (colRange == null) {
            return retval;
        }
        if (testedRange != null) {
            testedRange.min = colRange.min;
            testedRange.max = colRange.max;
        }
        for (int i = colRange.min; i <= colRange.max; ++i) {
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            if (!this.columnIsEmpty(i, yBounds, makeRegionsOpaque)) continue;
            retval.add(new Integer(i));
        }
        return retval;
    }

    public SortedSet getExpandableColumns(MinMax yBounds, boolean reversable, BTProgressMonitor monitor) throws AsynchExitRequestException {
        if (yBounds != null) {
            int minGrid = yBounds.min / 10;
            int maxGrid = yBounds.max / 10;
            yBounds = new MinMax(minGrid, maxGrid);
        }
        TreeSet retval = new TreeSet(Collections.reverseOrder());
        MinMax rowRange = this.getMinMaxYForRange(null, monitor);
        MinMax colRange = this.getMinMaxXForRange(yBounds, monitor);
        if (rowRange == null || colRange == null) {
            return retval;
        }
        for (int i = colRange.min; i <= colRange.max; ++i) {
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            if (!this.columnCanExpand(i, reversable, rowRange)) continue;
            retval.add(new Integer(i));
        }
        return retval;
    }

    public MinMax getMinMaxYForRange(MinMax xRange, BTProgressMonitor monitor) throws AsynchExitRequestException {
        int minValue = Integer.MAX_VALUE;
        int maxValue = Integer.MIN_VALUE;
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        PatternIterator kit = new PatternIterator(true, false);
        while (kit.hasNext()) {
            Point pt = (Point)kit.next();
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            GridContents gval = this.getGridContents(pt);
            if (gval == null || xRange != null && (pt.x < xRange.min || pt.x > xRange.max)) continue;
            if (pt.y < minValue) {
                minValue = pt.y;
            }
            if (pt.y <= maxValue) continue;
            maxValue = pt.y;
        }
        if (minValue == Integer.MAX_VALUE || maxValue == Integer.MIN_VALUE) {
            return null;
        }
        return new MinMax(minValue, maxValue);
    }

    public MinMax getMinMaxXForRange(MinMax yRange, BTProgressMonitor monitor) throws AsynchExitRequestException {
        int minValue = Integer.MAX_VALUE;
        int maxValue = Integer.MIN_VALUE;
        PatternIterator kit = new PatternIterator(true, false);
        while (kit.hasNext()) {
            Point pt = (Point)kit.next();
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            GridContents gval = this.getGridContents(pt);
            if (gval == null || yRange != null && (pt.y < yRange.min || pt.y > yRange.max)) continue;
            if (pt.x < minValue) {
                minValue = pt.x;
            }
            if (pt.x <= maxValue) continue;
            maxValue = pt.x;
        }
        if (minValue == Integer.MAX_VALUE || maxValue == Integer.MIN_VALUE) {
            return null;
        }
        return new MinMax(minValue, maxValue);
    }

    private boolean cornerAddedToRow(int y, LinkPlacementGrid otherGrid, MinMax colRange) {
        Point pt = new Point(colRange.min, y);
        int i = colRange.min;
        while (i <= colRange.max) {
            GridContents otherGval;
            pt.x = i++;
            GridContents myGval = this.getGridContents(pt);
            if (!this.cornerAddedToContents(myGval, otherGval = otherGrid.getGridContents(pt))) continue;
            return true;
        }
        return false;
    }

    private boolean cornerAddedToCol(int x, LinkPlacementGrid otherGrid, MinMax rowRange) {
        Point pt = new Point(x, rowRange.min);
        int i = rowRange.min;
        while (i <= rowRange.max) {
            GridContents otherGval;
            pt.y = i++;
            GridContents myGval = this.getGridContents(pt);
            if (!this.cornerAddedToContents(myGval, otherGval = otherGrid.getGridContents(pt))) continue;
            return true;
        }
        return false;
    }

    private boolean cornerAddedToContents(GridContents myGval, GridContents otherGval) {
        int otherType;
        if (myGval == null) {
            return false;
        }
        int myType = this.cornerType(myGval);
        return otherGval == null ? myType != 0 : (otherType = this.cornerType(otherGval)) == 0 && myType != 0;
    }

    private boolean dropLinkReference(GridContents gc, String srcID, Point pt, List deadList) {
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            if (gc.entry.id.equals(srcID) && gc.entry.type != 1 && gc.entry.type != 2) {
                deadList.add(pt);
                return true;
            }
            return false;
        }
        int size = gc.extra.size();
        for (int i = size - 1; i >= 0; --i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (!currEntry.id.equals(srcID) || currEntry.type == 1 || currEntry.type == 2) continue;
            gc.extra.remove(i);
        }
        size = gc.extra.size();
        if (size == 0) {
            deadList.add(pt);
            return true;
        }
        if (size == 1) {
            gc.entry = (GridEntry)gc.extra.get(0);
            gc.extra = null;
        }
        return false;
    }

    private void clearTemps() {
        List myTemps = this.findTemps();
        int numTemps = myTemps.size();
        for (int i = 0; i < numTemps; ++i) {
            Point pt = (Point)myTemps.get(i);
            this.removeTemp(pt, false);
        }
    }

    private void checkForTemps() {
        PatternIterator kit = new PatternIterator(false, false);
        while (kit.hasNext()) {
            Point pt = (Point)kit.next();
            this.checkForTemp(pt);
        }
    }

    private List findTemps() {
        ArrayList<Point> list = new ArrayList<Point>();
        PatternIterator kit = new PatternIterator(false, false);
        while (kit.hasNext()) {
            Point pt = (Point)kit.next();
            if (!this.hasATemp(pt)) continue;
            list.add(pt);
        }
        return list;
    }

    private void commitTemps(String linkID) {
        List myTemps = this.findTemps();
        int numTemps = myTemps.size();
        for (int i = 0; i < numTemps; ++i) {
            Point pt = (Point)myTemps.get(i);
            GridContents gc = this.getGridContents(pt);
            this.commitForContents(gc);
            this.writeBackModifiedGridContents(pt, gc);
        }
        this.drawnLinks_.add(linkID);
    }

    private void commitForContents(GridContents gc) {
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            gc.entry.commitTemp();
            return;
        }
        int size = gc.extra.size();
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            currEntry.commitTemp();
        }
    }

    private boolean hasATemp(Point2D pt) {
        int x = (int)pt.getX();
        int y = (int)pt.getY();
        GridContents gc = this.getGridContents(x, y);
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            return gc.entry.isTemp();
        }
        int size = gc.extra.size();
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (!currEntry.isTemp()) continue;
            return true;
        }
        return false;
    }

    private void checkForTemp(Point2D pt) {
        int x = (int)pt.getX();
        int y = (int)pt.getY();
        GridContents gc = this.getGridContents(x, y);
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            if (gc.entry.isTemp()) {
                System.out.println("Temp at " + pt);
            }
            return;
        }
        int size = gc.extra.size();
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (!currEntry.isTemp()) continue;
            System.out.println("Temp at " + pt);
        }
    }

    private boolean checkForTempFlag(Point2D pt) {
        int y;
        int x = (int)pt.getX();
        GridContents gc = this.getGridContents(x, y = (int)pt.getY());
        if (gc == null) {
            return false;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            return gc.entry.isTemp();
        }
        int size = gc.extra.size();
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (!currEntry.isTemp()) continue;
            return true;
        }
        return false;
    }

    private void removeTemp(Point2D pt, boolean checkCorrect) {
        int x = (int)pt.getX();
        int y = (int)pt.getY();
        GridContents gc = this.getGridContents(x, y);
        if (checkCorrect && gc == null) {
            return;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            if (gc.entry.isTemp()) {
                if (gc.entry.needsPostTempRestore()) {
                    gc.entry.clearTemp();
                } else {
                    gc = null;
                }
            } else if (checkCorrect) {
                // empty if block
            }
            this.writeBackModifiedGridContents(x, y, gc);
            return;
        }
        int size = gc.extra.size();
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (!currEntry.isTemp()) continue;
            if (currEntry.needsPostTempRestore()) {
                currEntry.clearTemp();
                break;
            }
            gc.extra.remove(i);
            break;
        }
        if ((size = gc.extra.size()) == 0) {
            throw new IllegalStateException();
        }
        if (size == 1) {
            gc.entry = (GridEntry)gc.extra.get(0);
            gc.extra = null;
        }
        this.writeBackModifiedGridContents(x, y, gc);
    }

    private void addTempEntryForRun(Point2D pt, String src, int direction) {
        if (direction == 16) {
            return;
        }
        int ptx = (int)pt.getX();
        int pty = (int)pt.getY();
        GridEntry entry = new GridEntry(src, 5, LinkPlacementGrid.getReverse(direction), direction, true);
        this.installModifiedGridContents(ptx, pty, entry);
    }

    private void addTempEntryForCorner(Point2D pt, String src, int entryDir, int exit) {
        GridEntry entry = new GridEntry(src, 3, LinkPlacementGrid.getReverse(entryDir), exit, true);
        int ptx = (int)pt.getX();
        int pty = (int)pt.getY();
        this.installModifiedGridContents(ptx, pty, entry);
    }

    private void addTempEntryForDiagonalCorner(Point2D pt, String src) {
        GridEntry entry = new GridEntry(src, 3, 0, 16, true);
        int ptx = (int)pt.getX();
        int pty = (int)pt.getY();
        this.installModifiedGridContents(ptx, pty, entry);
    }

    private void addTempEntryForFinalCorner(Point2D pt, String src, int exit) throws NonConvergenceException {
        int pty;
        int ptx = (int)pt.getX();
        GridContents gc = this.getGridContents(ptx, pty = (int)pt.getY());
        if (gc == null) {
            System.err.println("no grid contents at " + pt + " for src " + src);
            throw new NonConvergenceException();
        }
        gc.mergeContentsForFinalCorner(src, exit);
        this.writeBackModifiedGridContents(ptx, pty, gc);
    }

    private boolean canTravel(String src, String trg, String linkID, Set okGroups, Point2D start, Point2D end, boolean directDepart) {
        Vector2D travel = new Vector2D(start, end);
        WalkValues walk = this.getWalkValues(travel.normalized(), start, end, 1);
        for (int x = walk.startX; x != walk.endX; x += walk.incX) {
            for (int y = walk.startY; y != walk.endY; y += walk.incY) {
                GridContents gc = this.getGridContents(x, y);
                if (this.checkForTravel(gc, src, trg, linkID, okGroups, walk, null, null, directDepart)) continue;
                return false;
            }
        }
        return true;
    }

    private int generateDeparture(GridContents gc, String id, Set okGroups, WalkValues walk) {
        if (gc == null) {
            return 1;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            return this.resolveDepartureCell(gc.entry, id, okGroups, walk);
        }
        int size = gc.extra.size();
        boolean allOK = true;
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            int racVal = this.resolveDepartureCell(currEntry, id, okGroups, walk);
            if (racVal == 0) {
                return 0;
            }
            if (racVal == 1) continue;
            allOK = false;
        }
        return allOK ? 1 : 2;
    }

    private int generateArrival(GridContents gc, String srcID, String targID, String linkID, Set okGroups, WalkValues walk) {
        if (gc == null) {
            return 1;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            return this.resolveArrivalCell(gc.entry, srcID, targID, linkID, okGroups, walk.entryDirection);
        }
        int size = gc.extra.size();
        boolean allOK = true;
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            int racVal = this.resolveArrivalCell(currEntry, srcID, targID, linkID, okGroups, walk.entryDirection);
            if (racVal == 0) {
                return 0;
            }
            if (racVal == 1) continue;
            allOK = false;
        }
        return allOK ? 1 : 2;
    }

    private boolean canGenerateEmergencyArrival(GridContents gc, String srcID, String targID, String linkID, Set okGroups, int entryDirection) {
        if (gc == null) {
            return true;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            return this.resolveArrivalCell(gc.entry, srcID, targID, linkID, okGroups, entryDirection) == 1;
        }
        int size = gc.extra.size();
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            int racVal = this.resolveArrivalCell(currEntry, srcID, targID, linkID, okGroups, entryDirection);
            if (racVal == 1) continue;
            return false;
        }
        return true;
    }

    private int resolveDepartureCell(GridEntry entry, String id, Set okGroups, WalkValues walk) {
        if (entry.type == 1) {
            if (entry.id.equals(id)) {
                return 1;
            }
            return 0;
        }
        if (!entry.canPassThrough(id, null, null, okGroups, walk.exitDirection, null, null, true, false)) {
            return 0;
        }
        if (entry.type == 9) {
            return 1;
        }
        return 2;
    }

    private int resolveArrivalCell(GridEntry entry, String srcID, String targID, String linkID, Set okGroups, int entryDirection) {
        if (entry.type == 1) {
            if (entry.id.equals(targID)) {
                return 2;
            }
            return 0;
        }
        if (!entry.canPassThrough(srcID, targID, linkID, okGroups, entryDirection, null, null, false, false)) {
            return 0;
        }
        if (entry.type == 2) {
            return 1;
        }
        if (entry.type == 9) {
            return 1;
        }
        return 2;
    }

    private boolean checkForTravel(GridContents gc, String id, String trg, String linkID, Set okGroups, WalkValues walk, Set groupBlockers, Set recoveryExemptions, boolean directDepart) {
        if (gc == null) {
            return true;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            return this.resolveTravelCell(gc.entry, id, trg, linkID, okGroups, walk, groupBlockers, recoveryExemptions, directDepart, false);
        }
        int size = gc.extra.size();
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (this.resolveTravelCell(currEntry, id, trg, linkID, okGroups, walk, groupBlockers, recoveryExemptions, directDepart, false)) continue;
            return false;
        }
        return true;
    }

    private int checkForTravelCountCrossings(GridContents gc, String id, String trg, String linkID, Set okGroups, WalkValues walk, Set groupBlockers, Set recoveryExemptions, boolean directDepart, boolean ignoreMyTemps) {
        if (gc == null) {
            return 0;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            return this.resolveTravelCellCountCrossings(gc.entry, id, trg, linkID, okGroups, walk, groupBlockers, recoveryExemptions, directDepart, ignoreMyTemps);
        }
        int size = gc.extra.size();
        int crossingCount = 0;
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            int nextCrossing = this.resolveTravelCellCountCrossings(currEntry, id, trg, linkID, okGroups, walk, groupBlockers, recoveryExemptions, directDepart, ignoreMyTemps);
            if (nextCrossing < 0) {
                return nextCrossing;
            }
            crossingCount += nextCrossing;
        }
        return crossingCount;
    }

    private boolean okForTurns(GridContents gc, String src, String trg, String linkID, Set okGroups) {
        if (gc == null) {
            return true;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            return gc.entry.entryOKForCorner(src, trg, linkID, okGroups);
        }
        int size = gc.extra.size();
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (currEntry.entryOKForCorner(src, trg, linkID, okGroups)) continue;
            return false;
        }
        return true;
    }

    private boolean isSingleRunForSource(GridContents gc, String src) {
        if (gc == null) {
            return false;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            return gc.entry.type == 5 && gc.entry.id.equals(src);
        }
        boolean gottaRun = false;
        int size = gc.extra.size();
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (currEntry.type != 5 || !currEntry.id.equals(src)) continue;
            if (gottaRun) {
                return false;
            }
            gottaRun = true;
        }
        return gottaRun;
    }

    private Set getCellGroupContents(GridContents gc) {
        HashSet<String> retval = new HashSet<String>();
        if (gc == null) {
            return retval;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            if (gc.entry.type == 9) {
                retval.add(gc.entry.id);
            }
            return retval;
        }
        int size = gc.extra.size();
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (currEntry.type != 9) continue;
            retval.add(currEntry.id);
        }
        return retval;
    }

    private boolean resolveTravelCell(GridEntry entry, String id, String trg, String linkID, Set okGroups, WalkValues walk, Set groupBlockers, Set recoveryExemptions, boolean directDepart, boolean ignoreMyTemps) {
        if (entry.type == 1) {
            return entry.id.equals(id) && directDepart || recoveryExemptions != null && recoveryExemptions.contains(entry.id);
        }
        return entry.canPassThrough(id, trg, linkID, okGroups, walk.exitDirection, groupBlockers, recoveryExemptions, directDepart, ignoreMyTemps);
    }

    private int resolveTravelCellCountCrossings(GridEntry entry, String id, String trg, String linkID, Set okGroups, WalkValues walk, Set groupBlockers, Set recoveryExemptions, boolean directDepart, boolean ignoreMyTemps) {
        if (entry.type == 1) {
            if (recoveryExemptions != null && recoveryExemptions.contains(entry.id)) {
                return 0;
            }
            if (!entry.id.equals(id) || !directDepart) {
                if (trg != null && entry.id.equals(trg)) {
                    return -2;
                }
                return -1;
            }
        }
        return entry.canPassThroughCountCrossings(id, trg, linkID, okGroups, walk.exitDirection, groupBlockers, recoveryExemptions, directDepart, ignoreMyTemps);
    }

    private void fillForLink(String linkSrc, double x1, double y1, double x2, double y2, CornerOracle corc, DecoInfo pointData) {
        FillData fd = this.buildFillData(linkSrc, x1, y1, x2, y2, corc);
        for (int x = fd.startX; x != fd.endX; x += fd.incX) {
            for (int y = fd.startY; y != fd.endY; y += fd.incY) {
                GridEntry entry = x == fd.startX && y == fd.startY ? fd.startEntry : (x == fd.endX - fd.incX && y == fd.endY - fd.incY ? fd.endEntry : fd.runEntry);
                if (entry == null) continue;
                Point cellPt = new Point(x, y);
                this.installModifiedGridContents(cellPt, new GridEntry(entry));
                if (pointData == null) continue;
                this.addUserData(cellPt, pointData, linkSrc);
            }
        }
    }

    private void addUserData(Point cellPt, DecoInfo pointData, String dataID) {
        if (pointData == null) {
            return;
        }
        HashMap<String, DecoInfo> udm = (HashMap<String, DecoInfo>)this.userData_.get(cellPt);
        if (udm == null) {
            udm = new HashMap<String, DecoInfo>();
            this.userData_.put(cellPt, udm);
        }
        udm.put(dataID, pointData);
    }

    private DecoInfo getUserData(Point cellPt, String dataID) {
        HashMap udm = (HashMap)this.userData_.get(cellPt);
        if (udm == null) {
            return null;
        }
        return (DecoInfo)udm.get(dataID);
    }

    private FillData buildFillData(String linkSrc, double x1, double y1, double x2, double y2, CornerOracle corc) {
        int endType;
        if (x1 == Double.MAX_VALUE || y1 == Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        FillData fd = new FillData();
        double deltaX = x2 - x1;
        double deltaY = y2 - y1;
        fd.startX = (int)x1 / 10;
        fd.incX = 1;
        fd.endX = (int)x2 / 10;
        fd.startY = (int)y1 / 10;
        fd.incY = 1;
        fd.endY = (int)y2 / 10;
        fd.startEntry = null;
        fd.runEntry = null;
        fd.endEntry = null;
        boolean startIsPad = !corc.isCornerPoint(new Point2D.Double(x1, y1));
        boolean endIsPad = !corc.isCornerPoint(new Point2D.Double(x2, y2));
        int startType = startIsPad ? 4 : 3;
        int n = endType = endIsPad ? 4 : 3;
        if (deltaX < 0.0 && deltaY < 0.0) {
            fd.startEntry = new GridEntry(linkSrc, startType, 0, 16, false);
            fd.endEntry = new GridEntry(linkSrc, endType, 16, 0, false);
            fd.incX = -1;
            fd.incY = -1;
        } else if (deltaX < 0.0 && deltaY == 0.0) {
            fd.startEntry = new GridEntry(linkSrc, startType, 0, 8, false);
            fd.runEntry = new GridEntry(linkSrc, 5, 2, 8, false);
            fd.endEntry = new GridEntry(linkSrc, endType, 2, 0, false);
            fd.incX = -1;
        } else if (deltaX < 0.0 && deltaY > 0.0) {
            fd.startEntry = new GridEntry(linkSrc, startType, 0, 16, false);
            fd.endEntry = new GridEntry(linkSrc, endType, 16, 0, false);
            fd.incX = -1;
            fd.incY = 1;
        } else if (deltaX == 0.0 && deltaY < 0.0) {
            fd.startEntry = new GridEntry(linkSrc, startType, 0, 1, false);
            fd.runEntry = new GridEntry(linkSrc, 5, 4, 1, false);
            fd.endEntry = new GridEntry(linkSrc, endType, 4, 0, false);
            fd.incY = -1;
        } else if (deltaX == 0.0 && deltaY == 0.0) {
            fd.startEntry = new GridEntry(linkSrc, 6, 0, 0, false);
        } else if (deltaX == 0.0 && deltaY > 0.0) {
            fd.startEntry = new GridEntry(linkSrc, startType, 0, 4, false);
            fd.runEntry = new GridEntry(linkSrc, 5, 1, 4, false);
            fd.endEntry = new GridEntry(linkSrc, endType, 1, 0, false);
            fd.incY = 1;
        } else if (deltaX > 0.0 && deltaY < 0.0) {
            fd.startEntry = new GridEntry(linkSrc, startType, 0, 16, false);
            fd.endEntry = new GridEntry(linkSrc, endType, 16, 0, false);
            fd.incX = 1;
            fd.incY = -1;
        } else if (deltaX > 0.0 && deltaY == 0.0) {
            fd.startEntry = new GridEntry(linkSrc, startType, 0, 2, false);
            fd.runEntry = new GridEntry(linkSrc, 5, 8, 2, false);
            fd.endEntry = new GridEntry(linkSrc, endType, 8, 0, false);
            fd.incX = 1;
        } else if (deltaX > 0.0 && deltaY > 0.0) {
            fd.startEntry = new GridEntry(linkSrc, startType, 0, 16, false);
            fd.endEntry = new GridEntry(linkSrc, endType, 16, 0, false);
            fd.incX = 1;
            fd.incY = 1;
        }
        fd.endX += fd.incX;
        fd.endY += fd.incY;
        return fd;
    }

    private boolean canFillForLink(String linkSrc, double x1, double y1, double x2, double y2, LinkProperties props, Map linkMap, Map targMap, Map tupMap) {
        FillData fd = this.buildFillData(linkSrc, x1, y1, x2, y2, props);
        PointPair pair = new PointPair(new Point2D.Double(x1, y1), new Point2D.Double(x2, y2));
        List links = (List)linkMap.get(pair);
        ArrayList targs = new ArrayList();
        ArrayList<GenomeInstance.GroupTuple> tups = new ArrayList<GenomeInstance.GroupTuple>();
        int lnum = links.size();
        for (int i = 0; i < lnum; ++i) {
            String linkID = (String)links.get(i);
            targs.add(targMap.get(linkID));
            GenomeInstance.GroupTuple tup = (GenomeInstance.GroupTuple)tupMap.get(linkID);
            if (tup == null || tups.contains(tup)) continue;
            tups.add(tup);
        }
        for (int x = fd.startX; x != fd.endX; x += fd.incX) {
            for (int y = fd.startY; y != fd.endY; y += fd.incY) {
                GridContents gc;
                GridEntry entry = x == fd.startX && y == fd.startY ? fd.startEntry : (x == fd.endX - fd.incX && y == fd.endY - fd.incY ? fd.endEntry : fd.runEntry);
                if (entry == null || this.canMergeContents(gc = this.getGridContents(x, y), entry, links, targs, tups)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean canMergeContents(GridContents gc, GridEntry entry, List links, List targs, List tups) {
        if (gc == null) {
            return true;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            return gc.entry.canMergeEntries(entry, links, targs, tups);
        }
        int size = gc.extra.size();
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (currEntry.canMergeEntries(entry, links, targs, tups)) continue;
            return false;
        }
        return true;
    }

    private boolean rowIsEmpty(int y, MinMax xBounds, boolean makeRegionsOpaque) {
        return this.rowIsEmpty(y, xBounds, makeRegionsOpaque, null);
    }

    private boolean rowIsEmpty(int y, MinMax xBounds, boolean makeRegionsOpaque, Set ignoreNodes) {
        if (xBounds != null) {
            Point pt = new Point(xBounds.min, y);
            for (int i = xBounds.min; i <= xBounds.max; ++i) {
                pt.x = i;
                GridContents gval = this.getGridContents(pt, makeRegionsOpaque);
                if (gval == null || this.cellNotRequired(gval, makeRegionsOpaque, ignoreNodes)) continue;
                return false;
            }
            return true;
        }
        PatternIterator kit = new PatternIterator(makeRegionsOpaque, false);
        while (kit.hasNext()) {
            GridContents gval;
            Point pt = (Point)kit.next();
            if (pt.y != y || xBounds != null && (pt.x < xBounds.min || pt.x > xBounds.max) || (gval = this.getGridContents(pt, makeRegionsOpaque)) == null || this.cellNotRequired(gval, makeRegionsOpaque, ignoreNodes)) continue;
            return false;
        }
        return true;
    }

    private boolean rowCanExpand(int y, boolean reversable, MinMax xBounds) {
        if (!reversable) {
            return true;
        }
        ArrayList nodeList = new ArrayList();
        ArrayList neighborList = new ArrayList();
        Point pt = new Point(xBounds.min, y);
        Point pt2 = new Point(xBounds.min, y - 1);
        for (int i = xBounds.min; i <= xBounds.max; ++i) {
            boolean neighborIsNode;
            pt.x = i;
            pt2.x = i;
            GridContents gval = this.getGridContents(pt, false);
            GridContents gval2 = this.getGridContents(pt2, false);
            nodeList.clear();
            neighborList.clear();
            boolean iAmNode = gval != null && this.cellHasNode(gval, nodeList);
            boolean bl = neighborIsNode = gval2 != null && this.cellHasNode(gval2, neighborList);
            if (!iAmNode) continue;
            if (iAmNode) {
                if (!neighborIsNode) continue;
                nodeList.retainAll(neighborList);
                if (nodeList.isEmpty()) continue;
            }
            return false;
        }
        return true;
    }

    private boolean columnIsEmpty(int x, MinMax yBounds, boolean makeRegionsOpaque) {
        return this.columnIsEmpty(x, yBounds, makeRegionsOpaque, null);
    }

    private boolean columnIsEmpty(int x, MinMax yBounds, boolean makeRegionsOpaque, Set ignoreNodes) {
        if (yBounds != null) {
            Point pt = new Point(x, yBounds.min);
            for (int i = yBounds.min; i <= yBounds.max; ++i) {
                pt.y = i;
                GridContents gval = this.getGridContents(pt, makeRegionsOpaque);
                if (gval == null || this.cellNotRequired(gval, makeRegionsOpaque, ignoreNodes)) continue;
                return false;
            }
            return true;
        }
        PatternIterator kit = new PatternIterator(makeRegionsOpaque, false);
        while (kit.hasNext()) {
            GridContents gval;
            Point pt = (Point)kit.next();
            if (pt.x != x || yBounds != null && (pt.y < yBounds.min || pt.y > yBounds.max) || (gval = this.getGridContents(pt, makeRegionsOpaque)) == null || this.cellNotRequired(gval, makeRegionsOpaque, ignoreNodes)) continue;
            return false;
        }
        return true;
    }

    private boolean columnCanExpand(int x, boolean reversable, MinMax yBounds) {
        if (!reversable) {
            return true;
        }
        ArrayList nodeList = new ArrayList();
        ArrayList neighborList = new ArrayList();
        Point pt = new Point(x, yBounds.min);
        Point pt2 = new Point(x - 1, yBounds.min);
        for (int i = yBounds.min; i <= yBounds.max; ++i) {
            boolean neighborIsNode;
            pt.y = i;
            pt2.y = i;
            GridContents gval = this.getGridContents(pt, false);
            GridContents gval2 = this.getGridContents(pt2, false);
            nodeList.clear();
            neighborList.clear();
            boolean iAmNode = gval != null && this.cellHasNode(gval, nodeList);
            boolean bl = neighborIsNode = gval2 != null && this.cellHasNode(gval2, neighborList);
            if (!iAmNode || !neighborIsNode) continue;
            nodeList.retainAll(neighborList);
            if (nodeList.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private boolean cellNotRequired(GridContents gc, boolean makeRegionsOpaque) {
        return this.cellNotRequired(gc, makeRegionsOpaque, null);
    }

    private boolean cellNotRequired(GridContents gc, boolean makeRegionsOpaque, Set ignoreNodes) {
        ArrayList nodeList;
        boolean canIgnoreNodes = false;
        if (ignoreNodes != null && this.cellHasNode(gc, nodeList = new ArrayList())) {
            HashSet hasSet = new HashSet(nodeList);
            hasSet.removeAll(ignoreNodes);
            canIgnoreNodes = hasSet.isEmpty();
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            if (canIgnoreNodes && (gc.entry.type == 1 || gc.entry.type == 2)) {
                return true;
            }
            return gc.entry.type == 5 || !makeRegionsOpaque && gc.entry.type == 9;
        }
        int size = gc.extra.size();
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (canIgnoreNodes && (currEntry.type == 1 || currEntry.type == 2) || currEntry.type == 5 || !makeRegionsOpaque && currEntry.type == 9) continue;
            return false;
        }
        return true;
    }

    private boolean cellIsGroupOnly(GridContents gc) {
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            return gc.entry.type == 9;
        }
        int size = gc.extra.size();
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (currEntry.type == 9) continue;
            return false;
        }
        return true;
    }

    private boolean cellHasNode(GridContents gc, List ids) {
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            if (gc.entry.type == 1 || gc.entry.type == 2) {
                ids.add(gc.entry.id);
                return true;
            }
            return false;
        }
        boolean hasNode = false;
        int size = gc.extra.size();
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (currEntry.type != 1 && currEntry.type != 2) continue;
            ids.add(currEntry.id);
            hasNode = true;
        }
        return hasNode;
    }

    private boolean cellIsPad(GridContents gc) {
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            return gc.entry.type == 4;
        }
        int size = gc.extra.size();
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (currEntry.type != 4) continue;
            return true;
        }
        return false;
    }

    private int lookForLaunchCell(String srcID, GridContents gc, Set okGroups, Set linksFromSource) {
        if (gc == null) {
            return 0;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            return this.lookForLaunchEntry(srcID, gc.entry);
        }
        int size = gc.extra.size();
        int retval = 0;
        boolean needEntry = true;
        boolean gotGroup = false;
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (currEntry.type == 9) {
                if (okGroups == null || !okGroups.contains(currEntry.id)) continue;
                gotGroup = true;
                continue;
            }
            if (currEntry.type == 2 || !currEntry.id.equals(srcID) && currEntry.type == 8 && linksFromSource.contains(currEntry.id) || currEntry.id.equals(srcID) && currEntry.type == 10 || currEntry.id.equals(srcID) && currEntry.type == 1 || !needEntry) continue;
            retval = this.lookForLaunchEntry(srcID, currEntry);
            needEntry = false;
        }
        if (okGroups != null && !gotGroup) {
            return 0;
        }
        return retval;
    }

    private int lookForLaunchEntry(String srcID, GridEntry entry) {
        if (entry == null) {
            return 0;
        }
        if (!entry.id.equals(srcID)) {
            return 0;
        }
        if (entry.isTemp()) {
            return 0;
        }
        if (entry.type == 5) {
            return 5;
        }
        if (entry.type != 3) {
            return 0;
        }
        if (entry.entryCount != 1) {
            return 0;
        }
        return 3;
    }

    private boolean lookForSource(String srcID, GridContents gc) {
        if (gc == null) {
            return false;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            return gc.entry.id.equals(srcID) && gc.entry.type != 1 && gc.entry.type != 2;
        }
        int size = gc.extra.size();
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (!currEntry.id.equals(srcID) || currEntry.type == 1 || currEntry.type == 2) continue;
            return true;
        }
        return false;
    }

    private int otherLinkCount(String srcID, GridContents gc) {
        if (gc == null) {
            return 0;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            if (!gc.entry.id.equals(srcID) && gc.entry.type != 1 && gc.entry.type != 2 && gc.entry.type != 9) {
                return 1;
            }
            return 0;
        }
        int size = gc.extra.size();
        int count = 0;
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (currEntry.id.equals(srcID) || currEntry.type == 1 || currEntry.type == 2 || currEntry.type == 9) continue;
            ++count;
        }
        return count;
    }

    private boolean isOKForTerminal(GridContents gc) {
        if (gc == null) {
            return true;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            return gc.entry.type == 1 || gc.entry.type == 2 || gc.entry.type == 9;
        }
        int size = gc.extra.size();
        boolean count = false;
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (currEntry.type == 1 || currEntry.type == 2 || currEntry.type == 9) continue;
            return false;
        }
        return true;
    }

    private boolean checkWalkValues(WalkValues walk) {
        int diffX = walk.endX - walk.startX;
        if (diffX == 0 || diffX / Math.abs(diffX) != walk.incX) {
            return false;
        }
        int diffY = walk.endY - walk.startY;
        return diffY != 0 && diffY / Math.abs(diffY) == walk.incY;
    }

    private WalkValues getWalkValues(Vector2D vec, Point2D start, Point2D end, int sign) {
        int maxVal;
        if (sign != 1 && sign != -1) {
            throw new IllegalArgumentException();
        }
        WalkValues retval = new WalkValues();
        int vecX = (int)vec.getX();
        int vecY = (int)vec.getY();
        retval.startX = (int)start.getX();
        retval.startY = (int)start.getY();
        int minVal = sign > 0 ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        int n = maxVal = sign > 0 ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        if (vecX == -1 && vecY == 0) {
            retval.incY = 1;
            retval.incX = -1 * sign;
            retval.endX = end == null ? minVal : (int)end.getX() + retval.incX;
            retval.endY = retval.startY + retval.incY;
            retval.entryDirection = sign > 0 ? 2 : 8;
            retval.exitDirection = sign > 0 ? 8 : 2;
        } else if (vecX == 0 && vecY == 1) {
            retval.incY = 1 * sign;
            retval.incX = 1;
            retval.endX = retval.startX + retval.incX;
            retval.endY = end == null ? maxVal : (int)end.getY() + retval.incY;
            retval.entryDirection = sign > 0 ? 1 : 4;
            retval.exitDirection = sign > 0 ? 4 : 1;
        } else if (vecX == 1 && vecY == 0) {
            retval.incY = 1;
            retval.incX = 1 * sign;
            retval.endX = end == null ? maxVal : (int)end.getX() + retval.incX;
            retval.endY = retval.startY + retval.incY;
            retval.entryDirection = sign > 0 ? 8 : 2;
            retval.exitDirection = sign > 0 ? 2 : 8;
        } else if (vecX == 0 && vecY == -1) {
            retval.incY = -1 * sign;
            retval.incX = 1;
            retval.endX = retval.startX + retval.incX;
            retval.endY = end == null ? minVal : (int)end.getY() + retval.incY;
            retval.entryDirection = sign > 0 ? 4 : 1;
            retval.exitDirection = sign > 0 ? 1 : 4;
        } else {
            System.err.println("bad vector: " + vec);
            throw new IllegalArgumentException();
        }
        return retval;
    }

    private TravelResult analyzeTravel(String src, Point2D start, Vector2D direction, String trg, Point2D end, String linkID, Set okGroups, Set groupBlockers, boolean isStart) {
        HashSet myGroupBlocker = okGroups != null ? new HashSet() : null;
        Vector2D travel = new Vector2D(start, end);
        double fullDist = travel.dot(direction);
        if (fullDist < 0.0) {
            System.err.println(start + " " + end + " " + travel + " " + direction + " " + fullDist);
            throw new IllegalArgumentException();
        }
        if (fullDist == 0.0) {
            return new TravelResult(false, (Point2D)end.clone(), 1.0, 0, 0.0, 0.0, null, false);
        }
        WalkValues walk = this.getWalkValues(direction, start, end, 1);
        int crossings = 0;
        double fraction = 0.0;
        double currDist = 0.0;
        Point2D farthestPt = (Point2D)start.clone();
        for (int x = walk.startX; x != walk.endX; x += walk.incX) {
            for (int y = walk.startY; y != walk.endY; y += walk.incY) {
                GridContents gc = this.getGridContents(x, y);
                int currentCrossings = this.checkForTravelCountCrossings(gc, src, trg, linkID, okGroups, walk, myGroupBlocker, null, isStart, false);
                if (currentCrossings < 0) {
                    if (groupBlockers != null && myGroupBlocker != null) {
                        groupBlockers.addAll(myGroupBlocker);
                    }
                    return new TravelResult(true, farthestPt, fraction, crossings, 0.0, currDist, myGroupBlocker, currentCrossings == -2);
                }
                crossings += currentCrossings;
                farthestPt = new Point2D.Double(x, y);
                Vector2D travelVec = new Vector2D(start, farthestPt);
                currDist = travelVec.length();
                fraction = currDist / fullDist;
            }
        }
        return new TravelResult(true, farthestPt, fraction, crossings, 0.0, currDist, myGroupBlocker, false);
    }

    private TravelResult analyzeDetourTravel(String src, Point2D start, Vector2D detourDirection, Vector2D desiredDirection, String trg, Point2D end, String linkID, Set okGroups, Set groupBlockers, boolean isStart) {
        WalkValues walk = this.getWalkValues(detourDirection, start, null, 1);
        for (int x = walk.startX; x != walk.endX; x += walk.incX) {
            for (int y = walk.startY; y != walk.endY; y += walk.incY) {
                GridContents gc = this.getGridContents(x, y);
                int currentCrossings = this.checkForTravelCountCrossings(gc, src, trg, linkID, okGroups, walk, groupBlockers, null, isStart, false);
                if (currentCrossings < 0) {
                    return null;
                }
                Point2D.Double detourTurn = new Point2D.Double(x, y);
                TravelResult result = this.analyzeTravel(src, detourTurn, desiredDirection, trg, end, linkID, okGroups, groupBlockers, isStart);
                if (!(result.fraction > 0.0)) continue;
                Vector2D detour = new Vector2D(start, detourTurn);
                result.detourDistance = detour.length();
                return result;
            }
        }
        throw new IllegalStateException();
    }

    private List pickStartIndex(TerminalRegion departure, TerminalRegion arrival) {
        int bestStart;
        int i;
        ArrayList<StartIndex> retval = new ArrayList<StartIndex>();
        int numDep = departure.getNumPoints();
        Point end = arrival.getPoint(0);
        Vector2D departDir = departure.getTerminalVector();
        int leftDir = LinkPlacementGrid.getDirection(LinkPlacementGrid.getTurn(departDir, 0));
        int rightDir = LinkPlacementGrid.getDirection(LinkPlacementGrid.getTurn(departDir, 1));
        int foundMatch = -1;
        for (int i2 = 0; i2 < numDep; ++i2) {
            Point start = departure.getPoint(i2);
            int direct = LinkPlacementGrid.getDirectionFromCoords(start.getX(), start.getY(), end.getX(), end.getY());
            if (direct == 16 || direct == 0) continue;
            Vector2D travel = LinkPlacementGrid.getVector(direct);
            if (direct != leftDir && direct != rightDir) continue;
            retval.add(new StartIndex(i2, travel));
            foundMatch = i2;
            break;
        }
        for (i = bestStart = numDep < 3 ? numDep - 1 : 2; i >= 0; --i) {
            if (i == foundMatch) continue;
            retval.add(new StartIndex(i, departDir));
        }
        for (i = numDep - 1; i > bestStart; --i) {
            if (i == foundMatch) continue;
            retval.add(new StartIndex(i, departDir));
        }
        return retval;
    }

    private TravelTurn buildInitTurn(String src, Point2D start, Vector2D direction, String trg, Point2D end, String linkID, Set okGroups) {
        HashSet groupBlockers = okGroups != null ? new HashSet() : null;
        Vector2D travel = new Vector2D(start, end);
        double fullDist = travel.dot(direction);
        TravelTurn retval = new TravelTurn();
        retval.start = (Point2D)start.clone();
        retval.runDirection = new Vector2D(direction);
        if (fullDist < 0.0) {
            retval.runTerminus = null;
        } else if (fullDist == 0.0) {
            retval.runTerminus = null;
        } else {
            TravelResult res = this.analyzeTravel(src, start, direction, trg, end, linkID, okGroups, groupBlockers, true);
            retval.runTerminus = (Point2D)res.farthestPt.clone();
        }
        this.fillOrthogonalVectors(retval, start, end);
        return retval;
    }

    TravelTurn buildInitRecoveryTurn(Vector2D direction, List threePts) {
        Point2D startPt = (Point2D)threePts.get(0);
        TravelTurn retval = new TravelTurn();
        retval.start = (Point2D)startPt.clone();
        if (threePts.size() == 1) {
            return retval;
        }
        Point2D endPt = (Point2D)threePts.get(1);
        Point2D turnTarget = (Point2D)threePts.get(threePts.size() - 1);
        if (LinkPlacementGrid.isOrthogonal(direction)) {
            retval.runDirection = new Vector2D(direction);
            retval.runTerminus = (Point2D)endPt.clone();
            this.fillOrthogonalVectors(retval, startPt, turnTarget);
        }
        return retval;
    }

    private TravelTurn buildTryTurn(List threePts, boolean force, Point2D turnTarget) {
        Point2D startPt = (Point2D)threePts.get(0);
        Point2D endPt = (Point2D)threePts.get(1);
        turnTarget.setLocation((Point2D)threePts.get(threePts.size() - 1));
        TravelTurn retval = new TravelTurn();
        retval.start = (Point2D)startPt.clone();
        retval.runDirection = new Vector2D(startPt, endPt).normalized();
        if (force) {
            retval.runDirection.scale(-1.0);
        }
        if (!LinkPlacementGrid.isOrthogonal(retval.runDirection)) {
            retval.runDirection = this.getClosestCanonical(retval.runDirection);
            Vector2D toPt = new Vector2D(startPt, endPt);
            double runDot = retval.runDirection.dot(toPt);
            Vector2D delta = retval.runDirection.scaled(runDot);
            endPt = delta.add(startPt);
        }
        retval.runTerminus = force ? null : (Point2D)endPt.clone();
        this.fillOrthogonalVectors(retval, startPt, turnTarget);
        return retval;
    }

    private TravelTurn buildTryTurnToo(List threePts, boolean force, Point2D turnTarget, List prevJumpDetour) {
        Point2D prePt;
        boolean noDetour;
        boolean bl = noDetour = prevJumpDetour == null || prevJumpDetour.isEmpty();
        if (noDetour) {
            prePt = (Point2D)threePts.get(0);
        } else {
            Point2D detPt = (Point2D)prevJumpDetour.get(prevJumpDetour.size() - 2);
            Point dummyPt = new Point();
            prePt = new Point2D.Double();
            LinkPlacementGrid.pointConversion(detPt, prePt, dummyPt);
        }
        Point2D startPt = (Point2D)threePts.get(1);
        Point2D endPt = (Point2D)threePts.get(2);
        turnTarget.setLocation(endPt);
        TravelTurn retval = new TravelTurn();
        retval.start = (Point2D)startPt.clone();
        Vector2D preRunDirection = new Vector2D(prePt, startPt).normalized();
        Vector2D toPt = new Vector2D(startPt, endPt);
        Vector2D toPtNorm = toPt.normalized();
        Vector2D primary = null;
        boolean wentSecondBest = false;
        if (!LinkPlacementGrid.isOrthogonal(toPtNorm)) {
            Vector2D secondBest;
            primary = this.getClosestCanonical(toPtNorm);
            if (primary.equals(secondBest = this.getSecondClosestCanonical(toPtNorm))) {
                retval.runDirection = primary;
            } else if (secondBest.equals(preRunDirection)) {
                retval.runDirection = secondBest;
                wentSecondBest = true;
            } else {
                retval.runDirection = primary;
            }
        } else {
            retval.runDirection = toPtNorm;
        }
        double runDot = retval.runDirection.dot(toPt);
        Vector2D delta = retval.runDirection.scaled(runDot);
        Point2D closestOrtho = delta.add(startPt);
        if (!wentSecondBest && retval.runDirection.scaled(-1.0).equals(preRunDirection)) {
            retval.runDirection = new Vector2D(closestOrtho, endPt).normalized();
            if (retval.runDirection.isZero()) {
                return null;
            }
            runDot = retval.runDirection.dot(toPt);
            delta = retval.runDirection.scaled(runDot);
            closestOrtho = delta.add(startPt);
        }
        boolean nullTerm = false;
        if (force) {
            if (!wentSecondBest) {
                retval.runDirection = LinkPlacementGrid.getVector(LinkPlacementGrid.getReverse(LinkPlacementGrid.getDirection(retval.runDirection)));
                nullTerm = true;
            } else {
                retval.runDirection = primary;
                runDot = retval.runDirection.dot(toPt);
                delta = retval.runDirection.scaled(runDot);
                closestOrtho = delta.add(startPt);
                nullTerm = false;
            }
        }
        retval.runTerminus = nullTerm ? null : (Point2D)closestOrtho.clone();
        this.fillOrthogonalVectors(retval, startPt, turnTarget);
        return retval;
    }

    private void fillOrthogonalVectors(TravelTurn turn, Point2D start, Point2D end) {
        Vector2D travel = new Vector2D(start, end);
        Vector2D leftTurn = LinkPlacementGrid.getTurn(turn.runDirection, 0);
        Vector2D rightTurn = LinkPlacementGrid.getTurn(turn.runDirection, 1);
        double leftDot = leftTurn.dot(travel);
        double rightDot = rightTurn.dot(travel);
        if (leftDot > 0.0) {
            turn.primaryTurnDirection = leftTurn;
            turn.secondaryTurnDirection = rightTurn;
            turn.isDirect = false;
        } else if (rightDot > 0.0) {
            turn.primaryTurnDirection = rightTurn;
            turn.secondaryTurnDirection = leftTurn;
            turn.isDirect = false;
        } else if (leftDot == 0.0 && rightDot == 0.0) {
            turn.primaryTurnDirection = leftTurn;
            turn.secondaryTurnDirection = rightTurn;
            turn.isDirect = travel.length() != 0.0 ? LinkPlacementGrid.getReverse(LinkPlacementGrid.getDirection(turn.runDirection)) != LinkPlacementGrid.getDirection(travel.normalized()) : true;
        } else {
            throw new IllegalStateException();
        }
    }

    private TravelOptions analyzeTravelsForRun(TravelTurn turn, String src, String trg, String linkID, Set okGroups, Point2D end, boolean isStart) {
        if (turn.isDirect) {
            return this.analyzeTravelsForDirectRun(turn, src, trg, linkID, okGroups, end, isStart);
        }
        return this.analyzeTravelsForOffsetRun(turn, src, trg, linkID, okGroups, end, isStart);
    }

    private TravelOptions analyzeTravelsForOffsetRun(TravelTurn turn, String src, String trg, String linkID, Set okGroups, Point2D end, boolean directDepart) {
        TravelOptions retval = new TravelOptions();
        retval.travels = new ArrayList();
        retval.turn = turn;
        retval.groupBlockers = okGroups != null ? new HashSet() : null;
        WalkValues walk = this.getWalkValues(retval.turn.runDirection, retval.turn.start, null, 1);
        double runDist = 0.0;
        if (retval.turn.runTerminus != null) {
            Vector2D runVector = new Vector2D(retval.turn.start, retval.turn.runTerminus);
            runDist = runVector.length();
        }
        Vector2D postDetour = new Vector2D(retval.turn.runDirection);
        for (int x = walk.startX; x != walk.endX; x += walk.incX) {
            for (int y = walk.startY; y != walk.endY; y += walk.incY) {
                if (x == walk.startX && y == walk.startY) {
                    retval.travels.add(new TravelResultPair(null, null));
                    continue;
                }
                GridContents gc = this.getGridContents(x, y);
                if (!this.checkForTravel(gc, src, trg, linkID, okGroups, walk, null, null, directDepart)) {
                    return retval;
                }
                if (!this.okForTurns(gc, src, trg, linkID, okGroups)) {
                    retval.travels.add(new TravelResultPair(null, null));
                    continue;
                }
                Point2D.Double currPt = new Point2D.Double(x, y);
                TravelResult result = this.analyzeTravel(src, currPt, retval.turn.primaryTurnDirection, trg, end, linkID, okGroups, retval.groupBlockers, directDepart);
                Point2D detEnd = postDetour.scaled(100.0).add(currPt);
                TravelResult resultS = this.analyzeDetourTravel(src, currPt, retval.turn.secondaryTurnDirection, postDetour, trg, detEnd, linkID, okGroups, retval.groupBlockers, directDepart);
                retval.travels.add(new TravelResultPair(result, resultS));
                Vector2D haveCovered = new Vector2D(retval.turn.start, currPt);
                if (!(haveCovered.length() > runDist) || result.needATurn && (result.fraction != 1.0 || result.crossings != 0)) continue;
                return retval;
            }
        }
        throw new IllegalStateException();
    }

    private TravelOptions analyzeTravelsForDirectRun(TravelTurn turn, String src, String trg, String linkID, Set okGroups, Point2D end, boolean directDepart) {
        TravelOptions retval = new TravelOptions();
        retval.travels = new ArrayList();
        retval.turn = turn;
        WalkValues walk = this.getWalkValues(retval.turn.runDirection, retval.turn.start, null, 1);
        double runDist = 0.0;
        Vector2D postDetour = new Vector2D(retval.turn.runDirection);
        postDetour.scale(-1.0);
        if (retval.turn.runTerminus != null) {
            Vector2D runVector = new Vector2D(retval.turn.start, retval.turn.runTerminus);
            runDist = runVector.length();
            postDetour = retval.turn.runDirection;
        }
        HashSet groupBlockers = okGroups != null ? new HashSet() : null;
        for (int x = walk.startX; x != walk.endX; x += walk.incX) {
            for (int y = walk.startY; y != walk.endY; y += walk.incY) {
                Point2D.Double currPt = new Point2D.Double(x, y);
                Vector2D haveCovered = new Vector2D(retval.turn.start, currPt);
                if (x == walk.startX && y == walk.startY) {
                    retval.travels.add(new TravelResultPair(null, null));
                    continue;
                }
                GridContents gc = this.getGridContents(x, y);
                if (!this.checkForTravel(gc, src, trg, linkID, okGroups, walk, groupBlockers, null, directDepart)) {
                    return retval;
                }
                if (!this.okForTurns(gc, src, trg, linkID, okGroups)) {
                    retval.travels.add(new TravelResultPair(null, null));
                    if (!(runDist > 0.0) || !(haveCovered.length() >= runDist)) continue;
                    return retval;
                }
                TravelResult resultP = this.analyzeDetourTravel(src, currPt, retval.turn.primaryTurnDirection, postDetour, trg, end, linkID, okGroups, groupBlockers, directDepart);
                TravelResult resultS = this.analyzeDetourTravel(src, currPt, retval.turn.secondaryTurnDirection, postDetour, trg, end, linkID, okGroups, groupBlockers, directDepart);
                retval.travels.add(new TravelResultPair(resultP, resultS));
                if (!(runDist > 0.0 && haveCovered.length() >= runDist) && (runDist != 0.0 || resultP == null && resultS == null)) continue;
                return retval;
            }
        }
        throw new IllegalStateException();
    }

    private TravelOptions analyzeTravelsForRecoverRun(TravelTurn turn, String src, String trg, String linkID, Set okGroups, List threePoints, Set exemptions, boolean directDepart) {
        TravelOptions retval = new TravelOptions();
        retval.travels = new ArrayList();
        retval.turn = turn;
        Point2D endPt = (Point2D)threePoints.get(1);
        Point2D turnTarget = threePoints.size() == 3 ? (Point2D)threePoints.get(2) : null;
        retval.groupBlockers = okGroups != null ? new HashSet() : null;
        WalkValues walk = this.getWalkValues(turn.runDirection, turn.start, turn.runTerminus, 1);
        if (!this.checkWalkValues(walk)) {
            return retval;
        }
        for (int x = walk.startX; x != walk.endX; x += walk.incX) {
            for (int y = walk.startY; y != walk.endY; y += walk.incY) {
                Point2D.Double currPt = new Point2D.Double(x, y);
                if (x == walk.startX && y == walk.startY) {
                    retval.travels.add(new TravelResultPair(null, null));
                    continue;
                }
                GridContents gc = this.getGridContents(x, y);
                if (!this.checkForTravel(gc, src, trg, linkID, okGroups, walk, null, exemptions, directDepart)) {
                    return retval;
                }
                if (currPt.equals(endPt)) {
                    TravelResult result;
                    if (turnTarget == null) {
                        result = new TravelResult(false, (Point2D)endPt.clone(), 1.0, 0, 0.0, 0.0, null, false);
                    } else {
                        Vector2D turnVec = new Vector2D(endPt, turnTarget);
                        result = new TravelResult(true, (Point2D)turnTarget.clone(), 1.0, 0, 0.0, turnVec.length(), null, false);
                    }
                    retval.travels.add(new TravelResultPair(result, null));
                    return retval;
                }
                retval.travels.add(new TravelResultPair(null, null));
            }
        }
        return retval;
    }

    private int chopLoops(List points, Point2D start, List retList) {
        int i;
        int numPoints = points.size();
        if (numPoints < 3) {
            return 0;
        }
        int chopi = -1;
        int chopj = -1;
        Point2D chopPoint = null;
        Point2D lastOuterPoint = start;
        for (i = 0; i < numPoints - 2; ++i) {
            Point2D nextOuterPoint = (Point2D)points.get(i);
            double lopX = lastOuterPoint.getX();
            double lopY = lastOuterPoint.getY();
            double nopX = nextOuterPoint.getX();
            double nopY = nextOuterPoint.getY();
            Point2D lastInnerPoint = (Point2D)points.get(i + 1);
            for (int j = i + 2; j < numPoints; ++j) {
                Point2D nextInnerPoint = (Point2D)points.get(j);
                double lipX = lastInnerPoint.getX();
                double lipY = lastInnerPoint.getY();
                double nipX = nextInnerPoint.getX();
                double nipY = nextInnerPoint.getY();
                Point2D inter = this.lineIntersection(lastOuterPoint, nextOuterPoint, lastInnerPoint, nextInnerPoint);
                if (inter != null) {
                    chopi = i;
                    chopj = j;
                    chopPoint = inter;
                    break;
                }
                lastInnerPoint = nextInnerPoint;
            }
            lastOuterPoint = nextOuterPoint;
        }
        if (chopPoint != null) {
            retList.clear();
            for (i = 0; i < chopi; ++i) {
                retList.add(points.get(i));
            }
            retList.add(chopPoint);
            for (int j = chopj; j < numPoints; ++j) {
                retList.add(points.get(j));
            }
            return 1;
        }
        return 0;
    }

    private List chopToShorterBackward(List points, Point2D start, String src, String trg, Set okGroups) {
        int numPoints = points.size();
        if (numPoints < 3) {
            return null;
        }
        int chopi = -1;
        int chopj = -1;
        Point2D chopPoint = null;
        Point2D lastOuterPoint = (Point2D)points.get(numPoints - 1);
        for (int i = numPoints - 2; i > 0 && chopPoint == null; --i) {
            Point2D nextOuterPoint = (Point2D)points.get(i);
            if (nextOuterPoint.equals(lastOuterPoint) || !LinkPlacementGrid.isOrthogonal(nextOuterPoint, lastOuterPoint)) {
                lastOuterPoint = nextOuterPoint;
                continue;
            }
            Vector2D segt = new Vector2D(lastOuterPoint, nextOuterPoint);
            double segtLen = segt.length();
            Vector2D segta = segt.normalized();
            segta.scale(segtLen + 300.0);
            Point2D nextScaledOuterPoint = segta.add(lastOuterPoint);
            Point2D lastInnerPoint = start;
            for (int j = 0; j < i && chopPoint == null; ++j) {
                Point2D nextInnerPoint = (Point2D)points.get(j);
                if (nextInnerPoint.equals(lastInnerPoint) || !LinkPlacementGrid.isOrthogonal(nextInnerPoint, lastInnerPoint)) {
                    lastInnerPoint = nextInnerPoint;
                    continue;
                }
                Point2D inter = this.lineIntersection(lastOuterPoint, nextScaledOuterPoint, lastInnerPoint, nextInnerPoint);
                if (inter != null && this.haveChopWillTravel(nextOuterPoint, lastOuterPoint, inter, src, trg, okGroups, i == 0)) {
                    chopi = i;
                    chopj = j;
                    chopPoint = inter;
                    break;
                }
                lastInnerPoint = nextInnerPoint;
            }
            lastOuterPoint = nextOuterPoint;
        }
        if (chopPoint != null) {
            List retval = new ArrayList();
            for (int j = 0; j < chopj; ++j) {
                retval.add(points.get(j));
            }
            if (retval.size() == 0 || !chopPoint.equals(retval.get(retval.size() - 1))) {
                retval.add(chopPoint);
            }
            for (int i = chopi; i < numPoints; ++i) {
                retval.add(points.get(i));
            }
            if (((Object)(retval = this.dropCollinearPoints(retval))).equals(points)) {
                return null;
            }
            return retval;
        }
        return null;
    }

    private List chopToShorterForward(List points, Point2D start, String src, String trg, Set okGroups) {
        int starti;
        int numPoints = points.size();
        if (numPoints < 3) {
            return null;
        }
        int chopi = -1;
        int chopj = -1;
        Point2D chopPoint = null;
        Point2D lastOuterPoint = start;
        for (int i = starti = this.collinearStart(points, start) ? 1 : 0; i < numPoints - 2 && chopPoint == null; ++i) {
            Point2D nextOuterPoint = (Point2D)points.get(i);
            if (nextOuterPoint.equals(lastOuterPoint) || !LinkPlacementGrid.isOrthogonal(nextOuterPoint, lastOuterPoint)) {
                lastOuterPoint = nextOuterPoint;
                continue;
            }
            Vector2D segt = new Vector2D(lastOuterPoint, nextOuterPoint);
            double segtLen = segt.length();
            Vector2D segta = segt.normalized();
            segta.scale(segtLen + 300.0);
            Point2D nextScaledOuterPoint = segta.add(lastOuterPoint);
            Point2D lastInnerPoint = (Point2D)points.get(numPoints - 1);
            for (int j = numPoints - 2; j > i && chopPoint == null; --j) {
                Point2D nextInnerPoint = (Point2D)points.get(j);
                if (nextInnerPoint.equals(lastInnerPoint) || !LinkPlacementGrid.isOrthogonal(nextInnerPoint, lastInnerPoint)) {
                    lastInnerPoint = nextInnerPoint;
                    continue;
                }
                Point2D inter = this.lineIntersection(lastOuterPoint, nextScaledOuterPoint, lastInnerPoint, nextInnerPoint);
                if (inter != null && this.haveChopWillTravel(nextOuterPoint, lastOuterPoint, inter, src, trg, okGroups, i == 0)) {
                    chopi = i;
                    chopj = j;
                    chopPoint = inter;
                    break;
                }
                lastInnerPoint = nextInnerPoint;
            }
            lastOuterPoint = nextOuterPoint;
        }
        if (chopPoint != null) {
            List retval = new ArrayList();
            for (int i = 0; i <= chopi; ++i) {
                retval.add(points.get(i));
            }
            if (!chopPoint.equals(retval.get(retval.size() - 1))) {
                retval.add(chopPoint);
            }
            for (int j = chopj + 1; j < numPoints; ++j) {
                retval.add(points.get(j));
            }
            if (((Object)(retval = this.dropCollinearPoints(retval))).equals(points)) {
                return null;
            }
            return retval;
        }
        return null;
    }

    private boolean collinearStart(List points, Point2D start) {
        if (points.size() < 2) {
            return false;
        }
        Point2D pt1 = (Point2D)points.get(0);
        Point2D pt2 = (Point2D)points.get(1);
        return this.collinearPoints(start, pt1, pt2);
    }

    private boolean collinearPoints(Point2D start, Point2D pt1, Point2D pt2) {
        double x0 = start.getX();
        double x1 = pt1.getX();
        double x2 = pt2.getX();
        double y0 = start.getY();
        double y1 = pt1.getY();
        double y2 = pt2.getY();
        return x0 == x1 && x0 == x2 || y0 == y1 && y0 == y2;
    }

    private List dropCollinearPoints(List points) {
        int numPoints = points.size();
        if (numPoints < 3) {
            return points;
        }
        ArrayList retval = new ArrayList();
        retval.add(points.get(0));
        for (int i = 0; i < numPoints - 2; ++i) {
            Point2D pt2;
            Point2D pt1;
            Point2D pt0 = (Point2D)points.get(i);
            if (this.collinearPoints(pt0, pt1 = (Point2D)points.get(i + 1), pt2 = (Point2D)points.get(i + 2))) continue;
            retval.add(pt1);
        }
        retval.add(points.get(numPoints - 1));
        return retval;
    }

    private List lookForAlternateLaunch(List points, Point2D start, String src, String trg, Set okGroups, NewCorner changedStart, Set linksFromSource) {
        int numPoints = points.size();
        if (numPoints < 3) {
            return null;
        }
        ArrayList<Point2D> allPoints = new ArrayList<Point2D>(points);
        allPoints.add(0, start);
        int chopi = -1;
        Point2D chopPoint = null;
        Point2D.Double checkPt = new Point2D.Double();
        Point2D lastOuterPoint = (Point2D)allPoints.get(++numPoints - 1);
        for (int i = numPoints - 2; i >= 0 && chopPoint == null; --i) {
            double nopY;
            double nopX;
            double lopY;
            Point2D nextOuterPoint = (Point2D)allPoints.get(i);
            double lopX = lastOuterPoint.getX();
            int direct = LinkPlacementGrid.getDirectionFromCoords(lopX, lopY = lastOuterPoint.getY(), nopX = nextOuterPoint.getX(), nopY = nextOuterPoint.getY());
            if (direct == 0 || direct == 16) {
                lastOuterPoint = nextOuterPoint;
                continue;
            }
            Vector2D runVec = new Vector2D(lastOuterPoint, nextOuterPoint).normalized();
            Vector2D goRight = LinkPlacementGrid.getTurn(runVec, 1);
            Vector2D goLeft = LinkPlacementGrid.getTurn(runVec, 0);
            Point startPt = new Point();
            Point2D.Double startPtD = new Point2D.Double();
            LinkPlacementGrid.pointConversion(lastOuterPoint, startPtD, startPt);
            Point endPt = new Point();
            Point2D.Double endPtD = new Point2D.Double();
            LinkPlacementGrid.pointConversion(nextOuterPoint, endPtD, endPt);
            WalkValues walk = this.getWalkValues(runVec, startPt, endPt, 1);
            for (int xc = walk.startX; xc != walk.endX && chopPoint == null; xc += walk.incX) {
                block2: for (int yc = walk.startY; yc != walk.endY && chopPoint == null; yc += walk.incY) {
                    ((Point2D)checkPt).setLocation(xc, yc);
                    if (checkPt.equals(startPt) || checkPt.equals(endPt)) continue;
                    Point2D.Double ugCheckPoint = new Point2D.Double(((Point2D)checkPt).getX() * 10.0, ((Point2D)checkPt).getY() * 10.0);
                    for (int j = 1; j < 4; ++j) {
                        Vector2D newDistVec;
                        double newDist;
                        Point2D.Double ugRightPoint;
                        Vector2D newDistVec2;
                        double newDist2;
                        Point2D.Double ugLeftPoint;
                        Vector2D scaledGoLeft = goLeft.scaled(j);
                        Point2D leftPoint = scaledGoLeft.add(checkPt);
                        GridContents gcl = this.getGridContents((int)leftPoint.getX(), (int)leftPoint.getY());
                        int cellType = this.lookForLaunchCell(src, gcl, okGroups, linksFromSource);
                        if (cellType != 0 && this.haveChopWillTravel(ugLeftPoint = new Point2D.Double(leftPoint.getX() * 10.0, leftPoint.getY() * 10.0), ugCheckPoint, ugLeftPoint, src, trg, okGroups, false) && (newDist2 = (newDistVec2 = new Vector2D(ugLeftPoint, ugCheckPoint)).length()) < this.traceLength(start, ugCheckPoint, points, i)) {
                            changedStart.type = cellType;
                            changedStart.point = leftPoint;
                            changedStart.dir = LinkPlacementGrid.getReverse(LinkPlacementGrid.getDirection(goLeft));
                            chopPoint = (Point2D)ugCheckPoint.clone();
                            chopi = i;
                            continue block2;
                        }
                        Vector2D scaledGoRight = goRight.scaled(j);
                        Point2D rightPoint = scaledGoRight.add(checkPt);
                        GridContents gcr = this.getGridContents((int)rightPoint.getX(), (int)rightPoint.getY());
                        cellType = this.lookForLaunchCell(src, gcr, okGroups, linksFromSource);
                        if (cellType == 0 || !this.haveChopWillTravel(ugRightPoint = new Point2D.Double(leftPoint.getX() * 10.0, leftPoint.getY() * 10.0), ugCheckPoint, ugRightPoint, src, trg, okGroups, false) || !((newDist = (newDistVec = new Vector2D(ugRightPoint, ugCheckPoint)).length()) < this.traceLength(start, ugCheckPoint, points, i))) continue;
                        changedStart.type = cellType;
                        changedStart.point = rightPoint;
                        changedStart.dir = LinkPlacementGrid.getReverse(LinkPlacementGrid.getDirection(goLeft));
                        chopPoint = (Point2D)ugCheckPoint.clone();
                        chopi = i;
                        continue block2;
                    }
                }
            }
            lastOuterPoint = nextOuterPoint;
        }
        numPoints = points.size();
        if (chopPoint != null) {
            ArrayList<Point2D> retval = new ArrayList<Point2D>();
            retval.add(chopPoint);
            for (int j = chopi; j < numPoints; ++j) {
                retval.add((Point2D)points.get(j));
            }
            if (((Object)retval).equals(points)) {
                return null;
            }
            return retval;
        }
        return null;
    }

    private double traceLength(Point2D start, Point2D chop, List pointList, int lastIndex) {
        int numPoints = pointList.size();
        if (lastIndex < 0 || numPoints == 0) {
            return new Vector2D(start, chop).length();
        }
        Point2D lastPoint = (Point2D)pointList.get(0);
        double retval = new Vector2D(start, lastPoint).length();
        for (int i = 1; i <= lastIndex; ++i) {
            Point2D nextPoint = (Point2D)pointList.get(i);
            retval += new Vector2D(lastPoint, nextPoint).length();
            lastPoint = nextPoint;
        }
        return retval += new Vector2D(lastPoint, chop).length();
    }

    private Point2D lineIntersection(Point2D lastOuterPoint, Point2D nextScaledOuterPoint, Point2D lastInnerPoint, Point2D nextInnerPoint) {
        return UiUtil.lineIntersection(lastOuterPoint, nextScaledOuterPoint, lastInnerPoint, nextInnerPoint);
    }

    private boolean haveChopWillTravel(Point2D runPt, Point2D firstPt, Point2D lastPt, String src, String trg, Set okGroups, boolean isStart) {
        Vector2D seg1 = new Vector2D(firstPt, runPt);
        Vector2D runVec = new Vector2D(seg1).normalized();
        Point startPt = new Point();
        Point2D.Double startPtD = new Point2D.Double();
        LinkPlacementGrid.pointConversion(firstPt, startPtD, startPt);
        Point endPt = new Point();
        Point2D.Double endPtD = new Point2D.Double();
        LinkPlacementGrid.pointConversion(lastPt, endPtD, endPt);
        Point chkPt = new Point();
        WalkValues walk = this.getWalkValues(runVec, startPtD, endPtD, 1);
        for (int xc = walk.startX; xc != walk.endX; xc += walk.incX) {
            for (int yc = walk.startY; yc != walk.endY; yc += walk.incY) {
                GridContents gc;
                int currentCrossings;
                chkPt.setLocation(xc, yc);
                if (chkPt.equals(startPt) || chkPt.equals(endPt) || (currentCrossings = this.checkForTravelCountCrossings(gc = this.getGridContents(xc, yc), src, trg, null, okGroups, walk, null, null, isStart, true)) >= 0) continue;
                return false;
            }
        }
        return true;
    }

    private boolean needOrthoRecovery(RecoveryDataForLink recoverForLink, int index) {
        int pc = recoverForLink.getPointCount();
        if (index >= pc) {
            if (pc == 0) {
                return false;
            }
            return recoverForLink.getInboundOrtho(pc - 1);
        }
        return recoverForLink.getInboundOrtho(index);
    }

    LinkProperties.CornerDoF getCornerDoF(RecoveryDataForLink recoverForLink, int index) {
        if (index >= recoverForLink.getPointCount()) {
            return null;
        }
        return recoverForLink.getCornerDoF(index);
    }

    List buildRecoverPointList(Point2D start, Point2D end, RecoveryDataForLink recoverForLink, int index) {
        Point2D.Double firstPoint;
        Point2D secondPoint = null;
        Point2D thirdPoint = null;
        Point dummyPt = new Point();
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        int epSize = recoverForLink.getPointCount();
        if (epSize == 0) {
            if (index > 0) {
                firstPoint = new Point2D.Double(end.getX(), end.getY());
            } else {
                firstPoint = new Point2D.Double(start.getX(), start.getY());
                secondPoint = new Point2D.Double(end.getX(), end.getY());
            }
        } else if (index == 0) {
            firstPoint = new Point2D.Double(start.getX(), start.getY());
            secondPoint = new Point2D.Double();
            LinkPlacementGrid.pointConversion(recoverForLink.getPoint(0), secondPoint, dummyPt);
            if (epSize == 1) {
                thirdPoint = new Point2D.Double(end.getX(), end.getY());
            } else {
                thirdPoint = new Point2D.Double();
                LinkPlacementGrid.pointConversion(recoverForLink.getPoint(1), thirdPoint, dummyPt);
            }
        } else if (index == epSize) {
            firstPoint = new Point2D.Double();
            LinkPlacementGrid.pointConversion(recoverForLink.getPoint(index - 1), firstPoint, dummyPt);
            secondPoint = end;
        } else {
            if (index > epSize) {
                return null;
            }
            firstPoint = new Point2D.Double();
            LinkPlacementGrid.pointConversion(recoverForLink.getPoint(index - 1), firstPoint, dummyPt);
            secondPoint = new Point2D.Double();
            LinkPlacementGrid.pointConversion(recoverForLink.getPoint(index), secondPoint, dummyPt);
            if (index == epSize - 1) {
                thirdPoint = new Point2D.Double(end.getX(), end.getY());
            } else {
                thirdPoint = new Point2D.Double();
                LinkPlacementGrid.pointConversion(recoverForLink.getPoint(index + 1), thirdPoint, dummyPt);
            }
        }
        ArrayList<Object> retval = new ArrayList<Object>();
        retval.add(firstPoint.clone());
        if (secondPoint != null) {
            retval.add(secondPoint.clone());
        }
        if (thirdPoint != null) {
            retval.add(thirdPoint.clone());
        }
        return retval;
    }

    private List buildRecoverKeyList(RecoveryDataForLink recoverForLink, int index) {
        LinkSegmentID secondPoint;
        LinkSegmentID firstPoint;
        LinkSegmentID thirdPoint = null;
        int epSize = recoverForLink.getPointCount();
        if (epSize == 0) {
            if (index > 0) {
                throw new IllegalArgumentException();
            }
            firstPoint = null;
            secondPoint = null;
        } else if (index == 0) {
            firstPoint = null;
            secondPoint = recoverForLink.getPointKey(0);
            thirdPoint = epSize == 1 ? null : recoverForLink.getPointKey(1);
        } else if (index == epSize) {
            firstPoint = recoverForLink.getPointKey(index - 1);
            secondPoint = null;
        } else {
            if (index > epSize) {
                return null;
            }
            firstPoint = recoverForLink.getPointKey(index - 1);
            secondPoint = recoverForLink.getPointKey(index);
            thirdPoint = index == epSize - 1 ? null : recoverForLink.getPointKey(index + 1);
        }
        ArrayList<LinkSegmentID> retval = new ArrayList<LinkSegmentID>();
        retval.add(firstPoint);
        retval.add(secondPoint);
        retval.add(thirdPoint);
        return retval;
    }

    boolean recoverPointListIsOrtho(List threePoints) {
        Point2D thirdPoint;
        Point2D firstPoint = (Point2D)threePoints.get(0);
        Point2D secondPoint = (Point2D)threePoints.get(1);
        Point2D point2D = thirdPoint = threePoints.size() == 3 ? (Point2D)threePoints.get(2) : null;
        if (!LinkPlacementGrid.isOrthogonal(firstPoint, secondPoint)) {
            return false;
        }
        return thirdPoint == null || secondPoint.equals(thirdPoint) || LinkPlacementGrid.isOrthogonal(secondPoint, thirdPoint);
    }

    boolean recoverPointListStartsOrtho(List threePoints) {
        Point2D firstPoint = (Point2D)threePoints.get(0);
        Point2D secondPoint = (Point2D)threePoints.get(1);
        return LinkPlacementGrid.isOrthogonal(firstPoint, secondPoint);
    }

    private int recoverStep(String src, String trg, String linkID, Point2D targ, Vector2D startDir, Vector2D finalDir, TravelTurn turn, List points, int maxDepth, int currDepth, GoodnessParams params, IterationChecker checker, boolean isStart, boolean force, Set okGroups, int entryPref, RecoveryDataForLink recoverForLink, Set recoveryExemptions, List prevJumpDetour, boolean strictOKGroups) throws NonConvergenceException {
        if (turn.start.equals(targ)) {
            if (currDepth == 0) {
                this.addTempEntryForCorner(turn.start, src, LinkPlacementGrid.getDirection(startDir), LinkPlacementGrid.getDirection(finalDir));
            } else {
                this.addTempEntryForFinalCorner(turn.start, src, LinkPlacementGrid.getDirection(finalDir));
            }
            return 4;
        }
        if (currDepth == maxDepth) {
            throw new NonConvergenceException();
        }
        checker.bump();
        isStart = isStart && currDepth == 0;
        boolean gottaBeOrtho = this.needOrthoRecovery(recoverForLink, currDepth);
        boolean cornerGottaBeOrtho = this.needOrthoRecovery(recoverForLink, currDepth + 1);
        RecoveryDOFAnalyzer dofa = new RecoveryDOFAnalyzer(this, gottaBeOrtho, cornerGottaBeOrtho, recoverForLink, currDepth, targ, turn, src, trg, linkID, okGroups, recoveryExemptions, isStart);
        List dofOptions = dofa.generateDOFOptions();
        int numOptions = dofOptions.size();
        int lastRetval = -1;
        for (int i = 0; i <= numOptions; ++i) {
            boolean goDirectDiagonal;
            boolean fallbackToJump;
            boolean trySimpleRecovery;
            RecoveryDOFAnalyzer.DOFOptionPair optionPair = i != numOptions ? (RecoveryDOFAnalyzer.DOFOptionPair)dofOptions.get(i) : null;
            DOFState state = this.installDOFOption(optionPair, recoverForLink, currDepth, targ, turn);
            boolean haveOrthoPoints = state.haveOrthoPoints;
            boolean haveOrthoCorner = state.haveOrthoCorner;
            List threePts = state.threePts;
            turn = state.turn;
            if (gottaBeOrtho || haveOrthoPoints) {
                trySimpleRecovery = haveOrthoPoints;
                fallbackToJump = true;
                goDirectDiagonal = false;
            } else {
                trySimpleRecovery = false;
                fallbackToJump = false;
                goDirectDiagonal = true;
            }
            try {
                lastRetval = this.recoverStepPhaseTwo(threePts, trySimpleRecovery, fallbackToJump, goDirectDiagonal, src, trg, linkID, targ, startDir, finalDir, turn, points, maxDepth, currDepth, params, checker, isStart, force, okGroups, entryPref, recoverForLink, recoveryExemptions, prevJumpDetour, strictOKGroups);
                if (lastRetval == 4) {
                    return 4;
                }
            }
            catch (NonConvergenceException ncex) {
                this.dropDOFOption(optionPair, recoverForLink);
                throw ncex;
            }
            this.dropDOFOption(optionPair, recoverForLink);
        }
        return lastRetval;
    }

    private int recoverStepPhaseTwo(List threePts, boolean trySimpleRecovery, boolean fallbackToJump, boolean goDirectDiagonal, String src, String trg, String linkID, Point2D targ, Vector2D startDir, Vector2D finalDir, TravelTurn turn, List points, int maxDepth, int currDepth, GoodnessParams params, IterationChecker checker, boolean isStart, boolean force, Set okGroups, int entryPref, RecoveryDataForLink recoverForLink, Set exemptions, List prevJumpDetour, boolean strictOKGroups) throws NonConvergenceException {
        int retval;
        SimpleRecoveryResult simpleResult = null;
        if (trySimpleRecovery) {
            simpleResult = this.trySimpleRecovery(src, trg, linkID, targ, startDir, finalDir, turn, points, maxDepth, currDepth, params, checker, isStart, force, okGroups, entryPref, recoverForLink, threePts, strictOKGroups);
            if (simpleResult.exitWithCode) {
                return simpleResult.exitCode;
            }
            if (simpleResult.recovResult == 2) {
                ++currDepth;
                fallbackToJump = false;
            }
        }
        RecoveryJumpResult jumpResult = null;
        if (fallbackToJump) {
            JumpPreparations jumpPrep = this.prepareForJump(simpleResult, turn, targ, recoverForLink, threePts, currDepth, src, prevJumpDetour, isStart, startDir, okGroups, linkID, trg);
            if (jumpPrep.exitWithCode) {
                return jumpPrep.exitCode;
            }
            currDepth = jumpPrep.currDepth;
            try {
                jumpResult = this.handleRecoveryJump(src, trg, linkID, targ, jumpPrep.jumpTarg, startDir, finalDir, turn, jumpPrep.tryTurn, maxDepth, currDepth, params, checker, simpleResult == null ? -1 : simpleResult.recovResult, threePts, isStart, force, okGroups, entryPref, recoverForLink, prevJumpDetour, strictOKGroups);
            }
            catch (NonConvergenceException ncex) {
                if (simpleResult != null && simpleResult.noTurnPlan != null) {
                    this.removeTempForPlan(simpleResult.noTurnPlan);
                }
                throw ncex;
            }
            if (jumpResult.exitWithCode) {
                if (jumpResult.exitCode == 4) {
                    this.installSuccessfulPaths(src, jumpResult, simpleResult, null, recoverForLink, points);
                } else {
                    this.backOutTempPlans(jumpResult, simpleResult, null);
                }
                return jumpResult.exitCode;
            }
            currDepth = jumpResult.currDepth;
            threePts = jumpResult.threePts;
        }
        ArrayList jumpDetour = jumpResult == null ? null : jumpResult.jumpDetour;
        DiagonalResult diagResult = null;
        if (goDirectDiagonal) {
            diagResult = this.handleDiagonalStepJump(src, targ, turn, currDepth, points, threePts, recoverForLink);
            if (diagResult.exitWithCode) {
                return diagResult.exitCode;
            }
            currDepth = diagResult.currDepth;
            threePts = diagResult.threePts;
        }
        Point2D startPt = (Point2D)threePts.get(0);
        Vector2D departDir = null;
        if (threePts.size() > 1) {
            Point2D endPt = (Point2D)threePts.get(1);
            departDir = new Vector2D(startPt, endPt).normalized();
        }
        TravelTurn pickupTurn = this.buildInitRecoveryTurn(departDir, threePts);
        try {
            retval = this.recoverStep(src, trg, linkID, targ, startDir, finalDir, pickupTurn, points, maxDepth, currDepth, params, checker, isStart, force, okGroups, entryPref, recoverForLink, exemptions, jumpDetour, strictOKGroups);
            if (retval == 4) {
                this.installSuccessfulPaths(src, jumpResult, simpleResult, diagResult, recoverForLink, points);
                return 4;
            }
        }
        catch (NonConvergenceException ncex) {
            this.backOutTempPlans(jumpResult, simpleResult, diagResult);
            throw ncex;
        }
        this.backOutTempPlans(jumpResult, simpleResult, diagResult);
        return retval;
    }

    private void dropDOFOption(RecoveryDOFAnalyzer.DOFOptionPair optionPair, RecoveryDataForLink recoverForLink) {
        if (optionPair == null) {
            return;
        }
        if (optionPair.firstPoint != null) {
            recoverForLink.popRevisedPoint(optionPair.firstPoint.lsid);
        }
        if (optionPair.cornerPoint != null) {
            recoverForLink.popRevisedPoint(optionPair.cornerPoint.lsid);
        }
    }

    boolean haveDOFWillTravel(List threePts, boolean checkCorner, String src, String trg, String linkID, Set okGroups, Set recoveryExemptions, boolean isStart) {
        if (checkCorner && threePts.size() != 3) {
            return false;
        }
        Point2D startPtD = (Point2D)(checkCorner ? threePts.get(1) : threePts.get(0));
        Point2D endPtD = (Point2D)(checkCorner ? threePts.get(2) : threePts.get(1));
        Point2D.Double chkPtD = new Point2D.Double();
        Vector2D runVec = new Vector2D(startPtD, endPtD).normalized();
        if (runVec.isZero()) {
            return false;
        }
        WalkValues walk = this.getWalkValues(runVec, startPtD, endPtD, 1);
        for (int xc = walk.startX; xc != walk.endX; xc += walk.incX) {
            for (int yc = walk.startY; yc != walk.endY; yc += walk.incY) {
                GridContents gc;
                int currentCrossings;
                ((Point2D)chkPtD).setLocation(xc, yc);
                if (chkPtD.equals(startPtD) || chkPtD.equals(endPtD) || (currentCrossings = this.checkForTravelCountCrossings(gc = this.getGridContents(xc, yc), src, trg, linkID, okGroups, walk, null, null, isStart, false)) >= 0) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isReachable(Point2D chkPtD, String src, String trg, String linkID, Set okGroups, Set recoveryExemptions, boolean isStart) {
        if (this.linkIsPresentAtPoint(src, new Point((int)chkPtD.getX(), (int)chkPtD.getY()))) {
            return true;
        }
        Vector2D downVec = LinkPlacementGrid.getVector(4);
        Vector2D upVec = LinkPlacementGrid.getVector(1);
        Vector2D leftVec = LinkPlacementGrid.getVector(8);
        Vector2D rightVec = LinkPlacementGrid.getVector(2);
        Point2D startAbove = upVec.add(chkPtD);
        Point2D startBelow = downVec.add(chkPtD);
        Point2D startLeft = leftVec.add(chkPtD);
        Point2D startRight = rightVec.add(chkPtD);
        WalkValues walkDown = this.getWalkValues(downVec, startAbove, chkPtD, 1);
        WalkValues walkUp = this.getWalkValues(upVec, startBelow, chkPtD, 1);
        WalkValues walkLeft = this.getWalkValues(leftVec, startRight, chkPtD, 1);
        WalkValues walkRight = this.getWalkValues(rightVec, startLeft, chkPtD, 1);
        int xc = (int)chkPtD.getX();
        int yc = (int)chkPtD.getY();
        GridContents gc = this.getGridContents(xc - 1, yc - 1);
        gc = this.getGridContents(xc, yc - 1);
        boolean ad = this.checkForTravelCountCrossings(gc, src, trg, linkID, okGroups, walkDown, null, recoveryExemptions, isStart, false) >= 0;
        gc = this.getGridContents(xc + 1, yc - 1);
        gc = this.getGridContents(xc - 1, yc);
        boolean lr = this.checkForTravelCountCrossings(gc, src, trg, linkID, okGroups, walkRight, null, recoveryExemptions, isStart, false) >= 0;
        gc = this.getGridContents(xc + 1, yc);
        boolean rl = this.checkForTravelCountCrossings(gc, src, trg, linkID, okGroups, walkLeft, null, recoveryExemptions, isStart, false) >= 0;
        gc = this.getGridContents(xc - 1, yc + 1);
        gc = this.getGridContents(xc, yc + 1);
        boolean bu = this.checkForTravelCountCrossings(gc, src, trg, linkID, okGroups, walkUp, null, recoveryExemptions, isStart, false) >= 0;
        gc = this.getGridContents(xc + 1, yc + 1);
        int count = ad ? 1 : 0;
        count = lr ? count + 1 : count;
        count = rl ? count + 1 : count;
        count = bu ? count + 1 : count;
        return count >= 2;
    }

    private DOFState installDOFOption(RecoveryDOFAnalyzer.DOFOptionPair optionPair, RecoveryDataForLink recoverForLink, int currDepth, Point2D targ, TravelTurn turn) {
        DOFState retval = new DOFState();
        retval.threePts = this.buildRecoverPointList(turn.start, targ, recoverForLink, currDepth);
        retval.haveOrthoPoints = retval.threePts == null ? false : this.recoverPointListStartsOrtho(retval.threePts);
        retval.haveOrthoCorner = retval.haveOrthoPoints && this.recoverPointListIsOrtho(retval.threePts);
        retval.turn = turn;
        if (optionPair != null && optionPair.firstPoint != null) {
            recoverForLink.pushRevisedPoint(optionPair.firstPoint.lsid, optionPair.firstPoint.newPt);
            retval.threePts = this.buildRecoverPointList(turn.start, targ, recoverForLink, currDepth);
            Point2D startPt = (Point2D)retval.threePts.get(0);
            Point2D endPt = (Point2D)retval.threePts.get(1);
            Vector2D departDir = new Vector2D(startPt, endPt).normalized();
            retval.turn = this.buildInitRecoveryTurn(departDir, retval.threePts);
            retval.haveOrthoPoints = retval.threePts == null ? false : this.recoverPointListStartsOrtho(retval.threePts);
            boolean bl = retval.haveOrthoCorner = retval.haveOrthoPoints && this.recoverPointListIsOrtho(retval.threePts);
        }
        if (optionPair != null && optionPair.cornerPoint != null) {
            recoverForLink.pushRevisedPoint(optionPair.cornerPoint.lsid, optionPair.cornerPoint.newPt);
            retval.threePts = this.buildRecoverPointList(turn.start, targ, recoverForLink, currDepth);
            retval.haveOrthoCorner = retval.haveOrthoPoints && this.recoverPointListIsOrtho(retval.threePts);
        }
        return retval;
    }

    private void installSuccessfulPaths(String src, RecoveryJumpResult jumpResult, SimpleRecoveryResult simpleResult, DiagonalResult diagResult, RecoveryDataForLink recoverForLink, List points) {
        if (jumpResult != null) {
            int numDetour = jumpResult.jumpDetour.size();
            for (int i = numDetour - 1; i >= 0; --i) {
                Point2D nextPoint = (Point2D)jumpResult.jumpDetour.get(i);
                if (!points.isEmpty() && nextPoint.equals(points.get(0))) continue;
                points.add(0, nextPoint);
            }
            RecoveryDataForSource rds = recoverForLink.getEnclosingSource();
            if (rds.isOriginalPoint(jumpResult.detourStart)) {
                rds.addJumpFromPoint(jumpResult.detourStart, (Point2D)jumpResult.jumpDetour.get(0));
            }
            if (rds.isOriginalPoint(jumpResult.detourEnd) && numDetour > 1) {
                rds.addJumpIntoPoint(jumpResult.detourEnd, (Point2D)jumpResult.jumpDetour.get(numDetour - 2));
            }
        }
        if (diagResult != null) {
            Point2D.Double nextPoint = new Point2D.Double(diagResult.endPt.getX() * 10.0, diagResult.endPt.getY() * 10.0);
            if (points.isEmpty() || !nextPoint.equals(points.get(0))) {
                points.add(0, nextPoint);
            }
        }
        if (simpleResult != null && simpleResult.noTurnPlan != null) {
            Point2D.Double nextPoint = new Point2D.Double(simpleResult.noTurnPlan.corner.getX() * 10.0, simpleResult.noTurnPlan.corner.getY() * 10.0);
            if (points.isEmpty() || !nextPoint.equals(points.get(0))) {
                points.add(0, nextPoint);
            }
        }
    }

    private void backOutTempPlans(RecoveryJumpResult jumpResult, SimpleRecoveryResult simpleResult, DiagonalResult diagResult) {
        if (jumpResult != null) {
            for (int i = jumpResult.tempedPlans.size() - 1; i >= 0; --i) {
                this.removeTempForPlan((TravelPlan)jumpResult.tempedPlans.get(i));
            }
        }
        if (diagResult != null) {
            this.removeTemp(diagResult.startPt, true);
        }
        if (simpleResult != null && simpleResult.noTurnPlan != null) {
            this.removeTempForPlan(simpleResult.noTurnPlan);
        }
    }

    private SimpleRecoveryResult trySimpleRecovery(String src, String trg, String linkID, Point2D targ, Vector2D startDir, Vector2D finalDir, TravelTurn turn, List points, int maxDepth, int currDepth, GoodnessParams params, IterationChecker checker, boolean isStart, boolean force, Set okGroups, int entryPref, RecoveryDataForLink recoverForLink, List threePts, boolean strictOKGroups) throws NonConvergenceException {
        SimpleRecoveryResult retval = new SimpleRecoveryResult();
        retval.noTurnPlan = null;
        retval.recovResult = 0;
        Set modOkGroups = strictOKGroups ? okGroups : null;
        TaggedPlan rscResult = this.recoverStepCore(src, trg, linkID, targ, startDir, finalDir, turn, points, maxDepth, currDepth + 1, params, checker, isStart, force, modOkGroups, entryPref, recoverForLink, threePts, strictOKGroups);
        retval.recovResult = rscResult.returnCode;
        retval.noTurnPlan = rscResult.partialPlan;
        if (retval.recovResult == 4) {
            retval.exitCode = 4;
            retval.exitWithCode = true;
            return retval;
        }
        if (retval.recovResult == 1) {
            int numPts = threePts.size();
            Point2D secondPt = (Point2D)threePts.get(1);
            Point2D lastPt = (Point2D)threePts.get(numPts - 1);
            if (numPts == 3 && secondPt.equals(lastPt) && lastPt.equals(targ)) {
                this.addTempForPlan(retval.noTurnPlan, src, isStart, startDir);
                this.addTempEntryForFinalCorner(turn.start, src, LinkPlacementGrid.getDirection(finalDir));
                points.add(0, new Point2D.Double(retval.noTurnPlan.corner.getX() * 10.0, retval.noTurnPlan.corner.getY() * 10.0));
                retval.exitWithCode = true;
                retval.exitCode = 4;
                return retval;
            }
            if (!this.needOrthoRecovery(recoverForLink, currDepth + 1)) {
                retval.recovResult = 2;
                this.addTempForPlan(retval.noTurnPlan, src, isStart, startDir);
                return retval;
            }
        }
        retval.exitWithCode = false;
        retval.exitCode = -1;
        return retval;
    }

    private JumpPreparations prepareForJump(SimpleRecoveryResult simpleResult, TravelTurn turn, Point2D targ, RecoveryDataForLink recoverForLink, List threePts, int currDepth, String src, List prevJumpDetour, boolean isStart, Vector2D startDir, Set okGroups, String linkID, String trg) {
        JumpPreparations retval = new JumpPreparations();
        retval.currDepth = currDepth;
        retval.jumpTarg = new Point2D.Double();
        retval.exitWithCode = false;
        retval.exitCode = -1;
        if (simpleResult == null || simpleResult.recovResult == 0) {
            if (retval.currDepth > 0) {
                List turnPts = this.buildRecoverPointList(turn.start, targ, recoverForLink, retval.currDepth - 1);
                retval.tryTurn = this.buildTryTurnToo(turnPts, false, retval.jumpTarg, prevJumpDetour);
                if (retval.tryTurn == null) {
                    retval.exitWithCode = true;
                    retval.exitCode = 3;
                }
            } else if (startDir.isZero()) {
                retval.exitWithCode = true;
                retval.exitCode = 3;
            } else {
                retval.jumpTarg.setLocation((Point2D)threePts.get(1));
                Vector2D canStart = startDir.isCanonical() ? startDir : startDir.canonical().normalized();
                retval.tryTurn = this.buildInitTurn(src, turn.start, canStart, trg, (Point2D)threePts.get(1), linkID, okGroups);
            }
        } else if (simpleResult.recovResult == 1) {
            this.addTempForPlan(simpleResult.noTurnPlan, src, isStart, startDir);
            List turnPts = this.buildRecoverPointList(turn.start, targ, recoverForLink, retval.currDepth);
            retval.tryTurn = this.buildTryTurnToo(turnPts, false, retval.jumpTarg, null);
            if (retval.tryTurn == null) {
                retval.exitWithCode = true;
                retval.exitCode = 3;
            } else {
                ++retval.currDepth;
            }
        } else {
            if (simpleResult.recovResult == 3) {
                retval.exitWithCode = true;
                retval.exitCode = 3;
                return retval;
            }
            throw new IllegalStateException();
        }
        return retval;
    }

    private RecoveryJumpResult handleRecoveryJump(String src, String trg, String linkID, Point2D finalTarg, Point2D jumpTarg, Vector2D startDir, Vector2D finalDir, TravelTurn turn, TravelTurn tryTurn, int maxDepth, int currDepth, GoodnessParams params, IterationChecker checker, int prevRecoveryState, List threePts, boolean isStart, boolean force, Set okGroups, int entryPref, RecoveryDataForLink recoverForLink, List prevJumpDetour, boolean strictOkGroups) throws NonConvergenceException {
        boolean jscOK;
        RecoveryJumpResult retval = new RecoveryJumpResult();
        retval.tempedPlans = new ArrayList();
        retval.jumpDetour = new ArrayList();
        retval.threePts = threePts;
        retval.detourStart = (Point2D)tryTurn.start.clone();
        retval.detourEnd = (Point2D)jumpTarg.clone();
        int currSkip = currDepth;
        List skipPts = this.buildRecoverPointList(turn.start, finalTarg, recoverForLink, currSkip++);
        ArrayList<TravelPlan> skipPlans = new ArrayList<TravelPlan>();
        while (skipPts != null && skipPts.size() >= 2) {
            TravelPlan skipPlan = null;
            if (skipPts != null && skipPts.size() >= 2 && this.recoverPointListStartsOrtho(skipPts)) {
                Point2D skip2;
                Vector2D turnVector = null;
                Point2D skip0 = (Point2D)skipPts.get(0);
                Point2D skip1 = (Point2D)skipPts.get(1);
                if (this.recoverPointListIsOrtho(skipPts) && skipPts.size() == 3 && !skip1.equals(skip2 = (Point2D)skipPts.get(2))) {
                    turnVector = new Vector2D(skip1, skip2).normalized();
                }
                skipPlan = new TravelPlan(skip0, skip1, null, new Vector2D(skip0, skip1).normalized(), turnVector);
                this.addTempForPlan(skipPlan, src, false, null);
                skipPlans.add(skipPlan);
            }
            skipPts = this.buildRecoverPointList(turn.start, finalTarg, recoverForLink, currSkip++);
        }
        try {
            Vector2D canStart = startDir.isCanonical() ? startDir : startDir.canonical().normalized();
            Set modOkGroups = strictOkGroups ? okGroups : null;
            jscOK = this.jumpStepCore(src, trg, linkID, jumpTarg, canStart, finalDir, tryTurn, retval.jumpDetour, maxDepth, currDepth, params, checker, isStart, false, modOkGroups, entryPref, retval.tempedPlans);
            if (!jscOK && force) {
                List turnPts;
                if (prevRecoveryState == 0 || prevRecoveryState == -1) {
                    if (retval.currDepth > 0) {
                        turnPts = this.buildRecoverPointList(turn.start, finalTarg, recoverForLink, currDepth - 1);
                        tryTurn = this.buildTryTurnToo(turnPts, force, jumpTarg, prevJumpDetour);
                        if (tryTurn == null) {
                            retval.exitCode = 3;
                            retval.exitWithCode = true;
                            retval.currDepth = currDepth;
                            return retval;
                        }
                    } else {
                        jumpTarg.setLocation((Point2D)threePts.get(1));
                        tryTurn = this.buildInitTurn(src, turn.start, canStart, trg, (Point2D)threePts.get(1), linkID, okGroups);
                    }
                } else {
                    turnPts = this.buildRecoverPointList(turn.start, finalTarg, recoverForLink, currDepth - 1);
                    tryTurn = this.buildTryTurnToo(turnPts, force, jumpTarg, null);
                    if (tryTurn == null) {
                        retval.exitCode = 3;
                        retval.exitWithCode = true;
                        retval.currDepth = currDepth;
                        return retval;
                    }
                }
                jscOK = this.jumpStepCore(src, trg, linkID, jumpTarg, canStart, finalDir, tryTurn, retval.jumpDetour, maxDepth, currDepth, params, checker, isStart, false, modOkGroups, entryPref, retval.tempedPlans);
            }
        }
        catch (NonConvergenceException ncex) {
            int numSkips = skipPlans.size();
            for (int i = numSkips - 1; i >= 0; --i) {
                this.removeTempForPlan((TravelPlan)skipPlans.get(i));
            }
            throw ncex;
        }
        int numSkips = skipPlans.size();
        for (int i = numSkips - 1; i >= 0; --i) {
            this.removeTempForPlan((TravelPlan)skipPlans.get(i));
        }
        if (!jscOK) {
            retval.exitCode = 3;
            retval.exitWithCode = true;
            retval.currDepth = currDepth;
            return retval;
        }
        retval.threePts = this.buildRecoverPointList(turn.start, finalTarg, recoverForLink, ++currDepth);
        if (retval.threePts == null) {
            this.addTempEntryForFinalCorner(turn.start, src, LinkPlacementGrid.getDirection(finalDir));
            retval.exitCode = 4;
            retval.exitWithCode = true;
            retval.currDepth = currDepth;
            return retval;
        }
        retval.exitCode = -1;
        retval.exitWithCode = false;
        retval.currDepth = currDepth;
        return retval;
    }

    private DiagonalResult handleDiagonalStepJump(String src, Point2D targ, TravelTurn turn, int currDepth, List points, List threePts, RecoveryDataForLink recoverForLink) throws NonConvergenceException {
        DiagonalResult retval = new DiagonalResult();
        if (threePts == null) {
            retval.exitCode = 4;
            retval.exitWithCode = false;
            return retval;
        }
        retval.threePts = threePts;
        retval.startPt = (Point2D)threePts.get(0);
        retval.endPt = (Point2D)threePts.get(1);
        this.addTempEntryForDiagonalCorner(retval.startPt, src);
        retval.threePts = this.buildRecoverPointList(turn.start, targ, recoverForLink, ++currDepth);
        if (retval.threePts == null) {
            this.addTempEntryForFinalCorner(retval.endPt, src, 0);
            Point2D.Double nextPoint = new Point2D.Double(retval.endPt.getX() * 10.0, retval.endPt.getY() * 10.0);
            if (points.isEmpty() || !nextPoint.equals(points.get(0))) {
                points.add(0, nextPoint);
            }
            retval.exitCode = 4;
            retval.exitWithCode = true;
            retval.currDepth = currDepth;
            return retval;
        }
        retval.exitCode = -1;
        retval.exitWithCode = false;
        retval.currDepth = currDepth;
        return retval;
    }

    private TaggedPlan recoverStepCore(String src, String trg, String linkID, Point2D targ, Vector2D startDir, Vector2D finalDir, TravelTurn turn, List points, int maxDepth, int currDepth, GoodnessParams params, IterationChecker checker, boolean isStart, boolean force, Set okGroups, int entryPref, RecoveryDataForLink recoverForLink, List threePts, boolean strictOKGroups) throws NonConvergenceException {
        Set exemptions = recoverForLink.getEnclosingSource().getExemptions();
        TravelOptions options = this.analyzeTravelsForRecoverRun(turn, src, trg, linkID, okGroups, threePts, exemptions, isStart);
        TravelPlan newPlan;
        while ((newPlan = this.chooseRecoveryPlan(options)) != null) {
            Point2D endPt;
            Point2D startPt;
            if (threePts.size() == 3 && !LinkPlacementGrid.isOrthogonal(startPt = (Point2D)threePts.get(1), endPt = (Point2D)threePts.get(2))) {
                return new TaggedPlan(1, newPlan);
            }
            this.addTempForPlan(newPlan, src, isStart, startDir);
            threePts = this.buildRecoverPointList(turn.start, targ, recoverForLink, currDepth);
            TravelTurn newTurn = this.planToNewRecoverTurn(newPlan, threePts);
            try {
                Set modOkGroups = strictOKGroups ? okGroups : null;
                int retval = this.recoverStep(src, trg, linkID, targ, startDir, finalDir, newTurn, points, maxDepth, currDepth, params, checker, false, force, modOkGroups, entryPref, recoverForLink, exemptions, null, strictOKGroups);
                if (retval == 4) {
                    points.add(0, new Point2D.Double(newPlan.corner.getX() * 10.0, newPlan.corner.getY() * 10.0));
                    return new TaggedPlan(4, null);
                }
                if (retval == 3) {
                    this.removeTempForPlan(newPlan);
                    return new TaggedPlan(3, null);
                }
            }
            catch (NonConvergenceException ncex) {
                this.removeTempForPlan(newPlan);
                throw ncex;
            }
            this.removeTempForPlan(newPlan);
        }
        return new TaggedPlan(0, null);
    }

    private boolean jumpStep(String src, String trg, String linkID, Point2D targ, Vector2D startDir, Vector2D finalDir, TravelTurn turn, List points, int maxDepth, int currDepth, GoodnessParams params, IterationChecker checker, boolean isStart, boolean force, Set okGroups, int entryPref, List tempedPlans) throws NonConvergenceException {
        if (++currDepth == maxDepth) {
            throw new NonConvergenceException();
        }
        checker.bump();
        if (turn.start.equals(targ)) {
            if (currDepth == 1) {
                this.addTempEntryForCorner(turn.start, src, LinkPlacementGrid.getDirection(startDir), LinkPlacementGrid.getDirection(finalDir));
            } else {
                this.addTempEntryForFinalCorner(turn.start, src, LinkPlacementGrid.getDirection(finalDir));
            }
            return true;
        }
        return this.jumpStepCore(src, trg, linkID, targ, startDir, finalDir, turn, points, maxDepth, currDepth, params, checker, isStart, force, okGroups, entryPref, tempedPlans);
    }

    private boolean jumpStepCore(String src, String trg, String linkID, Point2D targ, Vector2D startDir, Vector2D finalDir, TravelTurn turn, List points, int maxDepth, int currDepth, GoodnessParams params, IterationChecker checker, boolean isStart, boolean force, Set okGroups, int entryPref, List tempedPlans) throws NonConvergenceException {
        TravelOptions options = this.analyzeTravelsForRun(turn, src, trg, linkID, okGroups, targ, isStart);
        TravelPlan newPlan;
        while ((newPlan = this.chooseAPlan(options, params, targ, isStart || force, entryPref)) != null) {
            this.addTempForPlan(newPlan, src, isStart, startDir);
            if (tempedPlans != null) {
                tempedPlans.add(newPlan);
            }
            TravelTurn newTurn = this.planToNewTurn(newPlan, targ);
            try {
                if (this.jumpStep(src, trg, linkID, targ, startDir, finalDir, newTurn, points, maxDepth, currDepth, params, checker, false, force, okGroups, entryPref, tempedPlans)) {
                    points.add(0, new Point2D.Double(newPlan.corner.getX() * 10.0, newPlan.corner.getY() * 10.0));
                    return true;
                }
            }
            catch (NonConvergenceException ncex) {
                this.removeTempForPlan(newPlan);
                if (tempedPlans != null) {
                    tempedPlans.remove(tempedPlans.size() - 1);
                }
                throw ncex;
            }
            this.removeTempForPlan(newPlan);
            if (tempedPlans == null) continue;
            tempedPlans.remove(tempedPlans.size() - 1);
        }
        return false;
    }

    private void addTempForPlan(TravelPlan plan, String src, boolean doStart, Vector2D turnEntry) {
        if (plan.corner.equals(new Point2D.Double(-13.0, 147.0)) && src.equals("wnt9zzzr:0")) {
            plan.turnDirection = new Vector2D(0.0, 1.0);
        }
        WalkValues walk = this.getWalkValues(plan.runDirection, plan.start, plan.corner, 1);
        int dirVal = LinkPlacementGrid.getDirection(plan.runDirection);
        for (int x = walk.startX; x != walk.endX; x += walk.incX) {
            for (int y = walk.startY; y != walk.endY; y += walk.incY) {
                if (x == walk.startX && y == walk.startY) {
                    if (!doStart) continue;
                    int sDirVal = LinkPlacementGrid.getDirection(turnEntry);
                    this.addTempEntryForCorner(new Point2D.Double(x, y), src, sDirVal, LinkPlacementGrid.getDirection(plan.runDirection));
                    continue;
                }
                if (x == walk.endX - walk.incX && y == walk.endY - walk.incY) {
                    int turnDir = plan.turnDirection != null ? LinkPlacementGrid.getDirection(plan.turnDirection) : 16;
                    this.addTempEntryForCorner(new Point2D.Double(x, y), src, dirVal, turnDir);
                    continue;
                }
                this.addTempEntryForRun(new Point2D.Double(x, y), src, dirVal);
            }
        }
    }

    private void removeTempForPlan(TravelPlan plan) {
        WalkValues walk = this.getWalkValues(plan.runDirection, plan.start, plan.corner, 1);
        int dirVal = LinkPlacementGrid.getDirection(plan.runDirection);
        for (int x = walk.startX; x != walk.endX; x += walk.incX) {
            for (int y = walk.startY; y != walk.endY; y += walk.incY) {
                if (x == walk.startX && y == walk.startY) continue;
                Point2D.Double pointForPlan = new Point2D.Double(x, y);
                this.removeTemp(pointForPlan, true);
                if (!this.checkForTempFlag(pointForPlan)) continue;
                this.removeTemp(pointForPlan, true);
            }
        }
    }

    private TravelPlan chooseAPlan(TravelOptions options, GoodnessParams params, Point2D targ, boolean force, int entryPref) {
        if (options.turn.isDirect) {
            return this.chooseDirectPlan(options, targ);
        }
        return this.chooseOffsetPlan(options, params, targ, force, entryPref);
    }

    private TravelPlan chooseOffsetPlan(TravelOptions options, GoodnessParams params, Point2D targ, boolean force, int entryPref) {
        Vector2D turnDir;
        TravelResult result;
        int preferredPos;
        if (options.groupBlockers != null && !options.groupBlockers.isEmpty()) {
            double blockFraction = Double.NEGATIVE_INFINITY;
            int osize = options.travels.size();
            for (int i = 0; i < osize; ++i) {
                TravelResultPair pair = (TravelResultPair)options.travels.get(i);
                TravelResult prim = pair.primary;
                if (prim == null || prim.groupBlocker == null || prim.groupBlocker.isEmpty()) continue;
                if (blockFraction == Double.NEGATIVE_INFINITY) {
                    blockFraction = prim.fraction;
                    continue;
                }
                pair.primary = null;
            }
            options.groupBlockers = null;
        }
        if (options.turn.runTerminus == null) {
            preferredPos = 1;
        } else {
            Vector2D run = new Vector2D(options.turn.start, options.turn.runTerminus);
            double distance = run.length();
            preferredPos = (int)distance;
        }
        if (options.travels.size() <= preferredPos) {
            preferredPos = options.travels.size() - 1;
        }
        int bestResult = this.findBestDirectionViaGoodness(params, options, preferredPos, targ, entryPref);
        boolean goToBackup = false;
        if (bestResult == -1) {
            if (force) {
                bestResult = this.findALastDitchDetour(options);
                if (bestResult == -1) {
                    return null;
                }
                goToBackup = true;
            } else {
                return null;
            }
        }
        TravelResultPair pair = (TravelResultPair)options.travels.get(bestResult);
        if (goToBackup) {
            result = pair.secondary;
            pair.secondary = null;
            turnDir = options.turn.secondaryTurnDirection;
        } else {
            result = pair.primary;
            pair.primary = null;
            turnDir = options.turn.primaryTurnDirection;
        }
        Vector2D toCorner = new Vector2D(options.turn.runDirection);
        toCorner.scale(bestResult);
        Point2D corner = toCorner.add(options.turn.start);
        return new TravelPlan(options.turn.start, corner, result.farthestPt, options.turn.runDirection, turnDir);
    }

    private TravelPlan chooseRecoveryPlan(TravelOptions options) {
        TravelResult prim = null;
        int osize = options.travels.size();
        int matchIndex = -1;
        for (int i = 0; i < osize; ++i) {
            TravelResultPair pair = (TravelResultPair)options.travels.get(i);
            TravelResult chk = pair.primary;
            if (chk == null) continue;
            prim = chk;
            pair.primary = null;
            matchIndex = i;
            break;
        }
        if (prim == null) {
            return null;
        }
        Vector2D turnDir = options.turn.isDirect ? options.turn.runDirection : options.turn.primaryTurnDirection;
        Vector2D toCorner = new Vector2D(options.turn.runDirection);
        toCorner.scale(matchIndex);
        Point2D corner = toCorner.add(options.turn.start);
        return new TravelPlan(options.turn.start, corner, prim.farthestPt, options.turn.runDirection, turnDir);
    }

    private TravelPlan chooseDirectPlan(TravelOptions options, Point2D targ) {
        Vector2D turnDir;
        TravelResult result;
        BestDetour bestResult;
        int preferredPos;
        if (options.turn.runTerminus == null) {
            preferredPos = 1;
        } else {
            Vector2D run = new Vector2D(options.turn.start, options.turn.runTerminus);
            double distance = run.length();
            preferredPos = (int)distance;
        }
        if (options.travels.size() <= preferredPos) {
            preferredPos = options.travels.size() - 1;
        }
        if ((bestResult = this.findBestDetour(options, preferredPos)) == null || bestResult.index == -1) {
            return null;
        }
        TravelResultPair pair = (TravelResultPair)options.travels.get(bestResult.index);
        if (bestResult.usePrimary) {
            result = pair.primary;
            turnDir = options.turn.primaryTurnDirection;
            pair.primary = null;
        } else {
            result = pair.secondary;
            pair.secondary = null;
            turnDir = options.turn.secondaryTurnDirection;
        }
        Vector2D toCorner = new Vector2D(options.turn.runDirection);
        toCorner.scale(bestResult.index);
        Point2D corner = toCorner.add(options.turn.start);
        return new TravelPlan(options.turn.start, corner, result.farthestPt, options.turn.runDirection, turnDir);
    }

    private int findNearestMax(TravelOptions options, int preferredIndex, int step) {
        if (step != 1 && step != -1) {
            throw new IllegalArgumentException();
        }
        int end = step == 1 ? options.travels.size() : 0;
        double currentMaxTravel = Double.NEGATIVE_INFINITY;
        int currentMaxIndex = -1;
        int currentCrossing = Integer.MAX_VALUE;
        for (int i = preferredIndex; i != end; i += step) {
            TravelResultPair pair = (TravelResultPair)options.travels.get(i);
            if (pair.primary == null || !(pair.primary.fraction > currentMaxTravel) && (pair.primary.fraction != currentMaxTravel || pair.primary.crossings >= currentCrossing)) continue;
            currentMaxTravel = pair.primary.fraction;
            currentCrossing = pair.primary.crossings;
            currentMaxIndex = i;
        }
        return currentMaxIndex;
    }

    private int findBestDirectionViaGoodness(GoodnessParams params, TravelOptions options, int preferredPos, Point2D targ, int entryPref) {
        double bestAboveGoodness;
        double bestBelowGoodness;
        int bestBelow;
        TravelResultPair prefPair = (TravelResultPair)options.travels.get(preferredPos);
        boolean toTarg = false;
        if (prefPair != null && prefPair.primary != null && prefPair.primary.stoppedByTarget) {
            toTarg = true;
        }
        if ((bestBelow = this.findBestGoodness(params, options, preferredPos, -1, targ)) == -1) {
            bestBelowGoodness = 0.0;
        } else {
            TravelResultPair pair = (TravelResultPair)options.travels.get(bestBelow);
            bestBelowGoodness = this.goodness(params, pair.primary.fraction, preferredPos - bestBelow, pair.primary.crossings);
        }
        int bestAbove = this.findBestGoodness(params, options, preferredPos, 1, targ);
        if (bestAbove == -1) {
            bestAboveGoodness = 0.0;
        } else {
            TravelResultPair pair = (TravelResultPair)options.travels.get(bestAbove);
            bestAboveGoodness = this.goodness(params, pair.primary.fraction, preferredPos - bestAbove, pair.primary.crossings);
        }
        if (bestBelowGoodness == 0.0 && bestAboveGoodness == 0.0) {
            return -1;
        }
        if (toTarg && entryPref != 0) {
            boolean useBelow;
            int runDir = LinkPlacementGrid.getDirection(options.turn.runDirection);
            switch (runDir) {
                case 2: {
                    useBelow = (entryPref & 8) != 0;
                    break;
                }
                case 8: {
                    useBelow = (entryPref & 2) != 0;
                    break;
                }
                case 1: {
                    useBelow = (entryPref & 4) != 0;
                    break;
                }
                case 4: {
                    useBelow = (entryPref & 1) != 0;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (useBelow) {
                return bestBelowGoodness != 0.0 ? bestBelow : bestAbove;
            }
            return bestAboveGoodness != 0.0 ? bestAbove : bestBelow;
        }
        if (bestAboveGoodness > bestBelowGoodness) {
            return bestAbove;
        }
        return bestBelow;
    }

    private int findBestGoodness(GoodnessParams params, TravelOptions options, int preferredIndex, int step, Point2D targ) {
        if (step != 1 && step != -1) {
            throw new IllegalArgumentException();
        }
        int end = step == 1 ? options.travels.size() : 0;
        double bestGoodness = 0.0;
        int currentMaxIndex = -1;
        HashMap goodMap = new HashMap();
        for (int i = preferredIndex; i != end; i += step) {
            TravelResultPair pair = (TravelResultPair)options.travels.get(i);
            if (pair.primary == null || pair.primary.fraction == 0.0) continue;
            Vector2D trav = new Vector2D(options.turn.runDirection);
            trav.scale(i);
            Point2D pos = trav.add(options.turn.start);
            Vector2D remains = new Vector2D(pos, targ);
            boolean isTerminal = remains.length() < params.terminal;
            int useCrossings = isTerminal ? 0 : pair.primary.crossings;
            double currGoodness = this.goodness(params, pair.primary.fraction, preferredIndex - i, useCrossings);
            if (!(currGoodness > bestGoodness)) continue;
            bestGoodness = currGoodness;
            currentMaxIndex = i;
        }
        return currentMaxIndex;
    }

    private int findALastDitchDetour(TravelOptions options) {
        int retval = -1;
        int end = options.travels.size();
        for (int i = 0; i < end; ++i) {
            TravelResultPair pair = (TravelResultPair)options.travels.get(i);
            if (pair.secondary != null && retval == -1) {
                retval = i;
            }
            pair.primary = null;
        }
        return retval;
    }

    private double goodness(GoodnessParams params, double targetPercent, int travelDiff, int crossings) {
        double term1 = targetPercent * params.normalize;
        double term2 = params.differenceCoeff * this.gaussian(travelDiff, params.differenceSigma);
        double term3 = params.crossingCoeff * (1.0 / (params.crossingMultiplier * (double)crossings + 1.0));
        return term1 + (term2 *= params.differenceNormalize * params.normalize) + (term3 *= params.normalize);
    }

    private double gaussian(double x, double sigma) {
        Double lookupArg = new Double(x);
        Double result = (Double)this.gauss_.get(lookupArg);
        if (result == null) {
            double coeff = 1.0 / (Math.sqrt(Math.PI * 2) * sigma);
            double exp = -(x * x / (2.0 * sigma * sigma));
            double retval = coeff * Math.exp(exp);
            this.gauss_.put(lookupArg, new Double(retval));
            return retval;
        }
        return result;
    }

    private BestDetour findBestDetour(TravelOptions options, int preferredPos) {
        double currentMinDetour = Double.POSITIVE_INFINITY;
        int currentBestIndex = -1;
        boolean usePrimary = false;
        for (int i = preferredPos; i != 0; --i) {
            TravelResultPair pair = (TravelResultPair)options.travels.get(i);
            if (pair.primary == null && pair.secondary == null) continue;
            if (pair.primary != null && pair.primary.detourDistance < currentMinDetour) {
                currentMinDetour = pair.primary.detourDistance;
                usePrimary = true;
                currentBestIndex = i;
            }
            if (pair.secondary == null || !(pair.secondary.detourDistance < currentMinDetour)) continue;
            currentMinDetour = pair.secondary.detourDistance;
            usePrimary = false;
            currentBestIndex = i;
        }
        return new BestDetour(currentBestIndex, usePrimary);
    }

    private TravelTurn planToNewTurn(TravelPlan oldPlan, Point2D finalPt) {
        TravelTurn retval = new TravelTurn();
        retval.runDirection = oldPlan.turnDirection;
        retval.runTerminus = oldPlan.farthestPt;
        retval.start = (Point2D)oldPlan.corner.clone();
        this.fillOrthogonalVectors(retval, oldPlan.corner, finalPt);
        return retval;
    }

    private TravelTurn planToNewRecoverTurn(TravelPlan oldPlan, List threePoints) {
        TravelTurn retval = new TravelTurn();
        retval.runDirection = oldPlan.turnDirection;
        retval.runTerminus = oldPlan.farthestPt;
        retval.start = (Point2D)oldPlan.corner.clone();
        if (threePoints != null && threePoints.size() == 3) {
            Point2D turnTarget = (Point2D)threePoints.get(2);
            this.fillOrthogonalVectors(retval, oldPlan.corner, turnTarget);
        } else {
            retval.primaryTurnDirection = LinkPlacementGrid.getTurn(retval.runDirection, 0);
            retval.secondaryTurnDirection = LinkPlacementGrid.getTurn(retval.runDirection, 1);
            retval.isDirect = true;
        }
        return retval;
    }

    private void convertTerminalRegion(TerminalRegion region) {
        boolean isRun = false;
        int numPt = region.getNumTravelPoints();
        for (int i = 0; i < numPt; ++i) {
            GridEntry entry;
            Point pt = region.getTravelPoint(i);
            GridContents gc = this.getGridContents(pt);
            if (!this.dropReservation(gc, pt, region.type)) {
                this.writeBackModifiedGridContents(pt, gc);
            } else {
                this.dropFromPattern(pt);
            }
            if (i == 0) {
                entry = this.convertTerminalPoint(pt, region, 4);
                if (entry != null) {
                    this.installModifiedGridContents(pt, entry);
                }
                isRun = true;
                continue;
            }
            if (this.cornerType(gc) != 0) {
                isRun = false;
                continue;
            }
            if (!isRun || (entry = this.convertTerminalPoint(pt, region, 5)) == null) continue;
            this.installModifiedGridContents(pt, entry);
        }
    }

    private void dropTerminalRegion(TerminalRegion region) {
        int numPt = region.getNumTravelPoints();
        for (int i = 0; i < numPt; ++i) {
            Point pt = region.getTravelPoint(i);
            GridContents gc = this.getGridContents(pt);
            if (!this.dropReservation(gc, pt, region.type)) {
                this.writeBackModifiedGridContents(pt, gc);
                continue;
            }
            this.dropFromPattern(pt);
        }
    }

    private boolean dropReservation(GridContents gc, Point pt, int type) {
        if (gc == null) {
            return false;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            if (gc.entry.type == 8 && type == 0) {
                return true;
            }
            if (gc.entry.type == 10 && type == 0) {
                return true;
            }
            return gc.entry.type == 7 && type == 1;
        }
        int size = gc.extra.size();
        for (int i = size - 1; i >= 0; --i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (currEntry.type == 8 && type == 0) {
                gc.extra.remove(i);
                continue;
            }
            if (currEntry.type == 10 && type == 0) {
                gc.extra.remove(i);
                continue;
            }
            if (currEntry.type != 7 || type != 1) continue;
            gc.extra.remove(i);
        }
        size = gc.extra.size();
        if (size == 0) {
            return true;
        }
        if (size == 1) {
            gc.entry = (GridEntry)gc.extra.get(0);
            gc.extra = null;
        }
        return false;
    }

    private int cornerType(GridContents gc) {
        if (gc == null) {
            return 0;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            if (gc.entry.type == 3) {
                return gc.entry.cornerType();
            }
            return 0;
        }
        int size = gc.extra.size();
        boolean allOK = true;
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (currEntry.type != 3) continue;
            return currEntry.cornerType();
        }
        return 0;
    }

    private GridEntry convertTerminalPoint(Point pt, TerminalRegion region, int type) {
        GridEntry retval = null;
        int direction = LinkPlacementGrid.getDirection(region.getTerminalVector());
        if (type == 5) {
            this.addTempEntryForRun(pt, region.id, direction);
        } else if (type == 4) {
            retval = new GridEntry(region.id, 4, LinkPlacementGrid.getReverse(direction), 0, true);
        }
        return retval;
    }

    public Set getAllCrossings() {
        HashSet crossings = new HashSet();
        PatternIterator kit = new PatternIterator(false, false);
        while (kit.hasNext()) {
            Point pt = (Point)kit.next();
            GridContents gval = this.getGridContents(pt);
            if (gval == null) continue;
            this.getCrossings(gval, crossings);
        }
        return crossings;
    }

    public GraphColorer buildCrossingGraph() {
        HashSet nodes = new HashSet();
        HashSet links = new HashSet();
        PatternIterator kit = new PatternIterator(false, false);
        while (kit.hasNext()) {
            Point pt = (Point)kit.next();
            GridContents gval = this.getGridContents(pt);
            if (gval == null) continue;
            this.getNodeIDs(gval, nodes);
            this.getCrossings(gval, links);
        }
        return new GraphColorer(nodes, links);
    }

    private void getNodeIDs(GridContents gc, Set nodeIDs) {
        if (gc == null) {
            return;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            if (gc.entry.type == 1) {
                nodeIDs.add(gc.entry.id);
            }
            return;
        }
        int size = gc.extra.size();
        boolean allOK = true;
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (currEntry.type != 1) continue;
            nodeIDs.add(currEntry.id);
        }
    }

    private void getCrossings(GridContents gc, Set crossings) {
        if (gc == null) {
            return;
        }
        if (gc.entry != null) {
            if (gc.extra != null) {
                throw new IllegalStateException();
            }
            return;
        }
        int size = gc.extra.size();
        HashSet<String> runsPresent = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            GridEntry currEntry = (GridEntry)gc.extra.get(i);
            if (currEntry.type != 3 && currEntry.type != 4 && currEntry.type != 5 || runsPresent.contains(currEntry.id)) continue;
            Iterator rpit = runsPresent.iterator();
            while (rpit.hasNext()) {
                String present = (String)rpit.next();
                crossings.add(new Link(present, currEntry.id));
                crossings.add(new Link(currEntry.id, present));
            }
            runsPresent.add(currEntry.id);
        }
    }

    private void drawnLinkAccounting(Genome genome, String linkKey, String overlayKey) {
        if (overlayKey != null) {
            throw new IllegalArgumentException();
        }
        Set allLinks = genome.getOutboundLinks(linkKey);
        this.drawnLinks_.removeAll(allLinks);
    }

    private HashSet drawnLinksForID(Genome genome, String linkKey, String overlayKey) {
        if (overlayKey != null) {
            throw new IllegalArgumentException();
        }
        Set allLinks = genome.getOutboundLinks(linkKey);
        HashSet drawnForSource = new HashSet();
        DataUtil.intersection(allLinks, this.drawnLinks_, drawnForSource);
        return drawnForSource;
    }

    public static class DecoInfo {
        public static final String MODULE_KEY = "__WJRL_DECO_BOGUS_KEY__";
        public String treeID;
        public String srcID;
        public LinkSegmentID segID;
        public Point2D firstPt;
        public int normCanon;
        public Point offsetForSrc;
        public MinMax traceRange;
        public boolean isModule;

        public DecoInfo(String treeID, LinkSegmentID segID, String srcID, Point2D firstPt, int normCanon, Point offsetForSrc, MinMax traceRange) {
            this.treeID = treeID;
            this.segID = segID;
            this.srcID = srcID;
            this.firstPt = firstPt;
            this.normCanon = normCanon;
            this.offsetForSrc = offsetForSrc;
            this.traceRange = traceRange;
            this.isModule = false;
        }

        public DecoInfo(boolean isModule) {
            this.treeID = null;
            this.segID = null;
            this.srcID = null;
            this.firstPt = null;
            this.normCanon = -1;
            this.offsetForSrc = null;
            this.traceRange = null;
            this.isModule = isModule;
        }

        public DecoInfoKey getDIK() {
            return new DecoInfoKey(this.treeID, this.segID);
        }

        public String toString() {
            return "DecoInfo: " + this.treeID + " " + this.segID + " " + this.srcID + " " + this.firstPt + " " + this.normCanon + " " + this.offsetForSrc + " " + this.traceRange + " " + this.isModule;
        }
    }

    public static class DecoInfoKey {
        public String treeID;
        public LinkSegmentID segID;

        public DecoInfoKey(String treeID, LinkSegmentID segID) {
            this.treeID = treeID;
            this.segID = segID;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof DecoInfoKey)) {
                return false;
            }
            DecoInfoKey otherDIK = (DecoInfoKey)other;
            if (!this.treeID.equals(otherDIK.treeID)) {
                return false;
            }
            return this.segID.equals(otherDIK.segID);
        }

        public int hashCode() {
            return this.treeID.hashCode() + this.segID.hashCode();
        }
    }

    public static class DecoratedPath {
        private GeneralPath thePath_ = new GeneralPath();
        private HashMap theData_ = new HashMap();

        public GeneralPath getPath() {
            return this.thePath_;
        }

        public Map getData() {
            return this.theData_;
        }

        public void decorate(Point2D theStart, Object theData) {
            this.theData_.put(theStart, theData);
        }
    }

    private static class DOFState {
        boolean haveOrthoPoints;
        boolean haveOrthoCorner;
        List threePts;
        TravelTurn turn;

        private DOFState() {
        }
    }

    private static class PointAlternativeForRecovery {
        PointAlternative pa;
        List threePts;
        Point end;
        RecoveryDataForLink truncatedRFL;

        PointAlternativeForRecovery(PointAlternative pa, List threePts, Point end, RecoveryDataForLink truncatedRFL) {
            this.pa = pa;
            this.threePts = threePts;
            this.end = end;
            this.truncatedRFL = truncatedRFL;
        }
    }

    private static class PlanOrPoint {
        TravelPlan plan;
        Point2D point;

        PlanOrPoint(TravelPlan plan, Point2D point) {
            this.plan = plan;
            this.point = point;
        }
    }

    private static class DiagonalResult {
        Point2D startPt;
        Point2D endPt;
        List threePts;
        boolean exitWithCode;
        int currDepth;
        int exitCode;

        private DiagonalResult() {
        }
    }

    private static class JumpPreparations {
        TravelTurn tryTurn;
        Point2D jumpTarg;
        boolean exitWithCode;
        int exitCode;
        int currDepth;

        private JumpPreparations() {
        }
    }

    private static class SimpleRecoveryResult {
        int recovResult;
        TravelPlan noTurnPlan;
        boolean exitWithCode;
        int exitCode;

        private SimpleRecoveryResult() {
        }
    }

    private static class RecoveryJumpResult {
        ArrayList jumpDetour;
        ArrayList tempedPlans;
        List threePts;
        Point2D detourStart;
        Point2D detourEnd;
        boolean exitWithCode;
        int currDepth;
        int exitCode;

        private RecoveryJumpResult() {
        }
    }

    private static class TaggedPlan {
        TravelPlan partialPlan;
        int returnCode;

        TaggedPlan(int returnCode, TravelPlan partialPlan) {
            this.returnCode = returnCode;
            this.partialPlan = partialPlan;
        }
    }

    private static class LaunchAnalysis {
        HashMap binnedResults = new HashMap();
        ArrayList bestOrder = new ArrayList();
        private int currBinIndex = 0;

        LaunchAnalysis() {
        }

        void addAlternative(PointAlternative pa, Integer binKey, Double dist) {
            ArrayList<PointAlternative> ptsForDist;
            TreeMap<Double, ArrayList<PointAlternative>> distForBin = (TreeMap<Double, ArrayList<PointAlternative>>)this.binnedResults.get(binKey);
            if (distForBin == null) {
                distForBin = new TreeMap<Double, ArrayList<PointAlternative>>();
                this.binnedResults.put(binKey, distForBin);
            }
            if ((ptsForDist = (ArrayList<PointAlternative>)distForBin.get(dist)) == null) {
                ptsForDist = new ArrayList<PointAlternative>();
                distForBin.put(dist, ptsForDist);
            }
            ptsForDist.add(pa);
        }

        void rankAlternatives() {
            TreeMap<Double, Integer> buildOrder = new TreeMap<Double, Integer>();
            Iterator brkit = this.binnedResults.keySet().iterator();
            while (brkit.hasNext()) {
                Integer binKey = (Integer)brkit.next();
                TreeMap distForBin = (TreeMap)this.binnedResults.get(binKey);
                Double minDist = (Double)distForBin.firstKey();
                buildOrder.put(minDist, binKey);
            }
            this.bestOrder.addAll(buildOrder.values());
        }

        PointAlternative extractNextAlternative() {
            Integer nextBestBin;
            TreeMap distForBin;
            if (this.bestOrder.size() == 0) {
                return null;
            }
            int startIndex = this.currBinIndex;
            boolean wrapped = false;
            do {
                if (this.currBinIndex == startIndex && wrapped) {
                    return null;
                }
                nextBestBin = (Integer)this.bestOrder.get(this.currBinIndex++);
                if (this.currBinIndex < this.bestOrder.size()) continue;
                this.currBinIndex = 0;
                wrapped = true;
            } while ((distForBin = (TreeMap)this.binnedResults.get(nextBestBin)).isEmpty());
            Object firstKey = distForBin.firstKey();
            ArrayList ptsForDist = (ArrayList)distForBin.get(firstKey);
            PointAlternative retval = (PointAlternative)ptsForDist.remove(0);
            if (ptsForDist.isEmpty()) {
                distForBin.remove(firstKey);
            }
            return retval;
        }
    }

    public static class PointAlternative
    implements Cloneable {
        Point point;
        int type;
        int dir;

        PointAlternative(Point point, int type, int dir) {
            this.point = point;
            this.type = type;
            this.dir = dir;
        }

        public Object clone() {
            try {
                PointAlternative retval = (PointAlternative)super.clone();
                retval.point = (Point)this.point.clone();
                return retval;
            }
            catch (CloneNotSupportedException cnse) {
                throw new IllegalStateException();
            }
        }

        public String toString() {
            return "PointAlternative: " + this.point + " " + this.type + " " + this.dir;
        }

        public int hashCode() {
            return this.point.hashCode() + this.type + this.dir;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof PointAlternative)) {
                return false;
            }
            PointAlternative otherAlt = (PointAlternative)other;
            return this.point.equals(otherAlt.point) && this.type == otherAlt.type && this.dir == otherAlt.dir;
        }
    }

    private static class MyCornerOracle
    implements CornerOracle {
        private Point2D start_;
        private Point2D end_;

        MyCornerOracle(Point2D start, Point2D end) {
            this.start_ = start;
            this.end_ = end;
        }

        public boolean isCornerPoint(Point2D pt) {
            if (this.start_ != null && this.start_.equals(pt)) {
                return false;
            }
            return this.end_ == null || !this.end_.equals(pt);
        }
    }

    private static class TravelPlan {
        Point2D start;
        Point2D corner;
        Point2D farthestPt;
        Vector2D runDirection;
        Vector2D turnDirection;

        TravelPlan(Point2D start, Point2D corner, Point2D farthestPt, Vector2D runDirection, Vector2D turnDirection) {
            this.start = start;
            this.corner = corner;
            this.farthestPt = farthestPt;
            this.runDirection = runDirection;
            this.turnDirection = turnDirection;
        }

        public String toString() {
            return "TravelPlan: st=" + this.start + " co=" + this.corner + " fp=" + this.farthestPt + " rd=" + this.runDirection + " td=" + this.turnDirection;
        }
    }

    private static class BestDetour {
        int index;
        boolean usePrimary;

        BestDetour(int index, boolean usePrimary) {
            this.index = index;
            this.usePrimary = usePrimary;
        }

        public String toString() {
            return "BestDetour: " + this.index + " " + this.usePrimary;
        }
    }

    private static class StartIndex {
        int index;
        Vector2D direction;

        StartIndex(int index, Vector2D direction) {
            this.index = index;
            this.direction = direction;
        }

        public String toString() {
            return "StartIndex: " + this.index + " " + this.direction;
        }
    }

    private static class IterationChecker {
        int max;
        int count;

        IterationChecker(int max) {
            this.max = max;
            this.count = 0;
        }

        void bump() throws NonConvergenceException {
            ++this.count;
            if (this.count >= this.max) {
                throw new NonConvergenceException();
            }
        }

        boolean limitExceeded() {
            return this.count >= this.max;
        }
    }

    private static class TravelOptions {
        List travels;
        TravelTurn turn;
        Set groupBlockers;

        TravelOptions() {
        }
    }

    private static class TravelResultPair {
        TravelResult primary;
        TravelResult secondary;

        TravelResultPair(TravelResult primary, TravelResult secondary) {
            this.primary = primary;
            this.secondary = secondary;
        }

        public String toString() {
            return "TravelResultPair: prim=" + this.primary + " sec=" + this.secondary;
        }
    }

    static class TravelTurn {
        Point2D start;
        Point2D runTerminus;
        Vector2D runDirection;
        Vector2D primaryTurnDirection;
        Vector2D secondaryTurnDirection;
        boolean isDirect;

        TravelTurn() {
        }

        public String toString() {
            return "TravelTurn: st=" + this.start + " rt=" + this.runTerminus + " rd=" + this.runDirection + " ptd=" + this.primaryTurnDirection + " std=" + this.secondaryTurnDirection + " id=" + this.isDirect;
        }
    }

    private static class TravelResult {
        boolean needATurn;
        Point2D farthestPt;
        double fraction;
        double travelDistance;
        int crossings;
        double detourDistance;
        boolean stoppedByTarget;
        Set groupBlocker;

        TravelResult(boolean needATurn, Point2D farthestPt, double fraction, int crossings, double detourDistance, double travelDistance, Set groupBlocker, boolean stoppedByTarget) {
            this.needATurn = needATurn;
            this.farthestPt = farthestPt;
            this.fraction = fraction;
            this.travelDistance = travelDistance;
            this.crossings = crossings;
            this.detourDistance = detourDistance;
            this.groupBlocker = groupBlocker;
            this.stoppedByTarget = stoppedByTarget;
        }

        public String toString() {
            return "TravelResult: needATurn" + this.needATurn + " farthestPt=" + this.farthestPt + " fraction=" + this.fraction + " crossings=" + this.crossings + " detourDistance=" + this.detourDistance + " groupBlocker=" + this.groupBlocker;
        }
    }

    private static class WalkValues {
        int startX;
        int incX;
        int endX;
        int startY;
        int incY;
        int endY;
        int entryDirection;
        int exitDirection;

        private WalkValues() {
        }

        public String toString() {
            return this.startX + " " + this.incX + " " + this.endX + " " + this.startY + " " + this.incY + " " + this.endY + " " + this.entryDirection + " " + this.exitDirection;
        }
    }

    public static class GridContents
    implements Cloneable {
        GridEntry entry;
        ArrayList extra;

        GridContents(GridEntry entry) {
            this.entry = entry;
        }

        public String toString() {
            return "GridContents: " + this.entry + " " + this.extra;
        }

        public Object clone() {
            try {
                GridContents retval = (GridContents)super.clone();
                if (this.entry != null) {
                    retval.entry = (GridEntry)this.entry.clone();
                }
                if (this.extra != null) {
                    retval.extra = new ArrayList();
                    int numExt = this.extra.size();
                    for (int i = 0; i < numExt; ++i) {
                        GridEntry nextra = (GridEntry)this.extra.get(i);
                        retval.extra.add(nextra.clone());
                    }
                }
                return retval;
            }
            catch (CloneNotSupportedException cnse) {
                throw new IllegalStateException();
            }
        }

        void mergeContents(GridEntry newEntry) {
            if (this.entry != null) {
                if (this.extra != null) {
                    throw new IllegalStateException();
                }
                if (this.entry.id.equals(newEntry.id) && this.resolveSameSource(this.entry, newEntry)) {
                    return;
                }
                this.extra = new ArrayList();
                this.extra.add(this.entry);
                this.entry = null;
                this.extra.add(newEntry);
                return;
            }
            int size = this.extra.size();
            for (int i = 0; i < size; ++i) {
                GridEntry currEntry = (GridEntry)this.extra.get(i);
                if (!currEntry.id.equals(newEntry.id) || !this.resolveSameSource(currEntry, newEntry)) continue;
                return;
            }
            this.extra.add(newEntry);
        }

        void mergeContentsForFinalCorner(String src, int exitDir) {
            if (this.entry != null) {
                if (this.extra != null) {
                    throw new IllegalStateException();
                }
                if (this.entry.id.equals(src) && this.resolveSameSourceForFinalCorner(this.entry, src, exitDir)) {
                    return;
                }
                return;
            }
            int size = this.extra.size();
            for (int i = 0; i < size; ++i) {
                GridEntry currEntry = (GridEntry)this.extra.get(i);
                if (!currEntry.id.equals(src) || !this.resolveSameSourceForFinalCorner(currEntry, src, exitDir)) continue;
                return;
            }
        }

        private boolean resolveSameSource(GridEntry existing, GridEntry newEntry) {
            if (!existing.id.equals(newEntry.id)) {
                throw new IllegalArgumentException();
            }
            if (existing.type != 3 || newEntry.type != 3) {
                return false;
            }
            if (existing.isTemp() && newEntry.isTemp()) {
                return true;
            }
            if (newEntry.isTemp()) {
                existing.setToTemp();
            }
            existing.entries |= newEntry.entries;
            existing.exits |= newEntry.exits;
            existing.entryCount += newEntry.entryCount;
            return true;
        }

        private boolean resolveSameSourceForFinalCorner(GridEntry existing, String src, int exitDir) {
            if (!existing.id.equals(src)) {
                throw new IllegalArgumentException();
            }
            if (existing.type != 3) {
                return false;
            }
            existing.exits = exitDir;
            return true;
        }
    }

    private static class GridEntry
    implements Cloneable {
        String id;
        int type;
        int entries;
        int entryCount;
        int exits;
        private boolean isTemp_;
        GridEntry preTemp;

        GridEntry(GridEntry other) {
            this.id = other.id;
            this.type = other.type;
            this.entries = other.entries;
            this.entryCount = other.entryCount;
            this.exits = other.exits;
            this.isTemp_ = other.isTemp_;
            if (other.preTemp != null) {
                this.preTemp = new GridEntry(other.preTemp);
            }
        }

        GridEntry(String id, int type, int entries, int exits, boolean isTemp) {
            this.id = id;
            this.type = type;
            this.entries = entries;
            this.entryCount = entries != 0 ? 1 : 0;
            this.exits = exits;
            this.isTemp_ = isTemp;
            this.preTemp = null;
        }

        public Object clone() {
            try {
                GridEntry retval = (GridEntry)super.clone();
                if (this.preTemp != null) {
                    retval.preTemp = (GridEntry)this.preTemp.clone();
                }
                return retval;
            }
            catch (CloneNotSupportedException cnse) {
                throw new IllegalStateException();
            }
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof GridEntry)) {
                return false;
            }
            GridEntry otherEnt = (GridEntry)other;
            if (!this.id.equals(otherEnt.id) || this.type != otherEnt.type || this.entries != otherEnt.entries || this.entryCount != otherEnt.entryCount || this.exits != otherEnt.exits || this.isTemp_ != otherEnt.isTemp_) {
                return false;
            }
            if (this.preTemp == null) {
                return otherEnt.preTemp == null;
            }
            return this.preTemp.equals(otherEnt.preTemp);
        }

        void commitTemp() {
            this.isTemp_ = false;
            this.preTemp = null;
        }

        void clearTemp() {
            if (this.preTemp != null) {
                this.id = this.preTemp.id;
                this.type = this.preTemp.type;
                this.entries = this.preTemp.entries;
                this.entryCount = this.preTemp.entryCount;
                this.exits = this.preTemp.exits;
            }
            this.isTemp_ = false;
            this.preTemp = null;
        }

        void setToTemp() {
            GridEntry myTemp;
            this.preTemp = myTemp = new GridEntry(this);
            this.isTemp_ = true;
        }

        boolean needsPostTempRestore() {
            return this.preTemp != null;
        }

        boolean isTemp() {
            return this.isTemp_;
        }

        public String toString() {
            return this.id + " typ=" + this.type + " ent=" + this.entries + " entCount=" + this.entryCount + " exits=" + this.exits + " tmp=" + this.isTemp_ + " pretemp=" + this.preTemp;
        }

        boolean canPassThrough(String id, String trg, String linkID, Set okGroups, int direction, Set groupBlockers, Set exemptions, boolean isDirectDepart, boolean ignoreMyTemps) {
            return this.canPassThroughCountCrossings(id, trg, linkID, okGroups, direction, groupBlockers, exemptions, isDirectDepart, ignoreMyTemps) >= 0;
        }

        int canPassThroughCountCrossings(String id, String trg, String linkID, Set okGroups, int direction, Set groupBlockers, Set exemptions, boolean isDirectDepart, boolean ignoreMyTemps) {
            if (this.type == 9) {
                if (okGroups != null) {
                    if (okGroups.contains(this.id)) {
                        return 0;
                    }
                    if (groupBlockers != null) {
                        groupBlockers.add(this.id);
                    }
                    return -1;
                }
                return 0;
            }
            if (trg != null && this.id.equals(trg) && this.type == 2) {
                return 0;
            }
            if (id != null && this.id.equals(id) && (this.type == 7 || isDirectDepart)) {
                return 0;
            }
            if (id != null && this.id.equals(id) && this.type == 10) {
                return 0;
            }
            if (linkID != null && this.id.equals(linkID) && this.type == 8) {
                return 0;
            }
            if (exemptions != null && this.type == 2 && exemptions.contains(this.id)) {
                return 0;
            }
            if (id.equals(this.id)) {
                if (this.isTemp_ && ignoreMyTemps) {
                    return 0;
                }
                return -1;
            }
            if (this.type != 5) {
                return -1;
            }
            boolean canCross = false;
            switch (direction) {
                case 1: 
                case 4: {
                    canCross = (this.entries & 1) == 0 && (this.exits & 4) == 0 && (this.entries & 4) == 0 && (this.exits & 1) == 0;
                    break;
                }
                case 2: 
                case 8: {
                    canCross = (this.entries & 2) == 0 && (this.exits & 8) == 0 && (this.entries & 8) == 0 && (this.exits & 2) == 0;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return canCross ? 1 : -1;
        }

        boolean canMergeEntries(GridEntry other, List links, List targs, List tups) {
            if (targs.contains(this.id) && this.type == 2 && (other.type == 5 || other.type == 3)) {
                return true;
            }
            if (targs.contains(other.id) && other.type == 2 && (this.type == 5 || this.type == 3)) {
                return true;
            }
            if (tups != null && !tups.isEmpty() && this.type == 9) {
                int numTup = tups.size();
                for (int i = 0; i < numTup; ++i) {
                    GenomeInstance.GroupTuple tup = (GenomeInstance.GroupTuple)tups.get(i);
                    if (!this.id.equals(tup.getSourceGroup()) && !this.id.equals(tup.getTargetGroup())) continue;
                    return true;
                }
                return false;
            }
            if (targs.contains(this.id) && this.type == 1) {
                return true;
            }
            if (targs.contains(other.id) && other.type == 1) {
                return true;
            }
            if (this.id.equals(other.id) && this.type == 7) {
                return true;
            }
            if (this.id.equals(other.id) && this.type == 10) {
                return true;
            }
            if (this.id.equals(other.id) && this.type == 1 && (other.type == 5 || other.type == 4 || other.type == 3)) {
                return true;
            }
            if (this.id.equals(other.id) && other.type == 1 && (this.type == 5 || this.type == 4 || this.type == 3)) {
                return true;
            }
            if (links.contains(this.id) && this.type == 8) {
                return true;
            }
            if (this.mergableRuns(other)) {
                return true;
            }
            if (this.mergableCorners(other)) {
                return true;
            }
            return this.mergableRunToCorner(other);
        }

        boolean hasNodeCollision(GridEntry other) {
            if (this.type == 9 || other.type == 9) {
                return false;
            }
            if (this.type != 1 && this.type != 2 && other.type != 1 && other.type != 2) {
                return false;
            }
            return this.type == 1 || other.type == 1;
        }

        boolean mergableRuns(GridEntry other) {
            if (other.id.equals(this.id) || this.type != 5 || other.type != 5) {
                return false;
            }
            boolean thisIsEW = (this.entries & 1) == 0 && (this.exits & 4) == 0 && (this.entries & 4) == 0 && (this.exits & 1) == 0;
            boolean thisIsNS = (this.entries & 2) == 0 && (this.exits & 8) == 0 && (this.entries & 8) == 0 && (this.exits & 2) == 0;
            boolean otherIsEW = (other.entries & 1) == 0 && (other.exits & 4) == 0 && (other.entries & 4) == 0 && (other.exits & 1) == 0;
            boolean otherIsNS = (other.entries & 2) == 0 && (other.exits & 8) == 0 && (other.entries & 8) == 0 && (other.exits & 2) == 0;
            return thisIsEW && otherIsNS || thisIsNS && otherIsEW;
        }

        boolean mergableCorners(GridEntry other) {
            if (!other.id.equals(this.id) || this.type != 3 || other.type != 3) {
                return false;
            }
            return (this.entries & other.entries & this.exits & other.exits) == 0;
        }

        boolean mergableRunToCorner(GridEntry other) {
            if (!other.id.equals(this.id) || this.type != 5 || other.type != 3) {
                return false;
            }
            return (this.entries & other.entries & this.exits & other.exits) == 0;
        }

        static int getCardinalOppositeDirection(int direction) {
            switch (direction) {
                case 1: {
                    return 4;
                }
                case 4: {
                    return 1;
                }
                case 8: {
                    return 2;
                }
                case 2: {
                    return 8;
                }
            }
            return 0;
        }

        int cornerType() {
            if (this.type != 3) {
                return 0;
            }
            if (this.entryCount > 1) {
                return 4;
            }
            int opposite = GridEntry.getCardinalOppositeDirection(this.exits);
            if (opposite == 0) {
                return 3;
            }
            return this.entries == opposite ? 1 : 2;
        }

        int runDirection() {
            if (this.type != 5) {
                return 0;
            }
            if ((this.entries & 1) != 0 && (this.exits & 4) != 0 || (this.entries & 4) != 0 && (this.exits & 1) != 0) {
                return 1;
            }
            if ((this.entries & 8) != 0 && (this.exits & 2) != 0 || (this.entries & 2) != 0 && (this.exits & 8) != 0) {
                return 2;
            }
            return 3;
        }

        boolean entryOKForCorner(String src, String trg, String linkID, Set okGroups) {
            switch (this.type) {
                case 2: {
                    return trg != null && this.id.equals(trg);
                }
                case 8: {
                    return linkID != null && this.id.equals(linkID);
                }
                case 10: {
                    return src != null && this.id.equals(src);
                }
                case 7: {
                    return src != null && this.id.equals(src);
                }
                case 9: {
                    return okGroups == null || okGroups.contains(this.id);
                }
            }
            return false;
        }

        List availableExits() {
            ArrayList<Vector2D> retval = new ArrayList<Vector2D>();
            if ((this.entries & 1) == 0 && (this.exits & 1) == 0) {
                retval.add(LinkPlacementGrid.getVector(1));
            }
            if ((this.entries & 4) == 0 && (this.exits & 4) == 0) {
                retval.add(LinkPlacementGrid.getVector(4));
            }
            if ((this.entries & 2) == 0 && (this.exits & 2) == 0) {
                retval.add(LinkPlacementGrid.getVector(2));
            }
            if ((this.entries & 8) == 0 && (this.exits & 8) == 0) {
                retval.add(LinkPlacementGrid.getVector(8));
            }
            return retval;
        }
    }

    private static class FillData {
        int startX;
        int incX;
        int endX;
        int startY;
        int incY;
        int endY;
        GridEntry startEntry;
        GridEntry runEntry;
        GridEntry endEntry;

        private FillData() {
        }
    }

    private class PatternValueIterator
    implements Iterator {
        private PatternIterator iterator_;
        private boolean doGroups_;

        PatternValueIterator(boolean doGroups) {
            this.doGroups_ = doGroups;
            this.iterator_ = new PatternIterator(doGroups, false);
        }

        public boolean hasNext() {
            return this.iterator_.hasNext();
        }

        public Object next() {
            Point pt = (Point)this.iterator_.next();
            return LinkPlacementGrid.this.getGridContents(pt, this.doGroups_);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class PatternIterator
    implements Iterator {
        private Set keySet_;
        private Iterator gridIterator_;
        private Iterator groupIterator_;
        private ArrayList currentGroupList_;

        PatternIterator(boolean doGroups, boolean allowDeletes) {
            this.keySet_ = allowDeletes ? new HashSet(LinkPlacementGrid.this.patternx_.keySet()) : LinkPlacementGrid.this.patternx_.keySet();
            this.gridIterator_ = this.keySet_.iterator();
            if (doGroups) {
                this.groupIterator_ = LinkPlacementGrid.this.groups_.keySet().iterator();
            }
            this.currentGroupList_ = new ArrayList();
        }

        public boolean hasNext() {
            if (this.gridIterator_.hasNext()) {
                return true;
            }
            if (this.groupIterator_ == null) {
                return false;
            }
            if (this.currentGroupList_.isEmpty()) {
                this.stockGroupList();
            }
            return this.currentGroupList_.size() > 0;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.gridIterator_.hasNext()) {
                return this.gridIterator_.next();
            }
            if (this.currentGroupList_.isEmpty()) {
                String nextGroup = (String)this.groupIterator_.next();
                Rectangle rect = (Rectangle)LinkPlacementGrid.this.groups_.get(nextGroup);
                int grpX = rect.x / 10;
                int grpY = rect.y / 10;
                int grpW = rect.width / 10;
                int grpH = rect.height / 10;
                for (int x = 0; x < grpW; ++x) {
                    for (int y = 0; y < grpH; ++y) {
                        int xval = grpX + x;
                        int yval = grpY + y;
                        Point nextPt = new Point(xval, yval);
                        this.currentGroupList_.add(nextPt);
                    }
                }
            }
            int cslSize = this.currentGroupList_.size();
            return this.currentGroupList_.remove(cslSize - 1);
        }

        private void stockGroupList() {
            while (this.groupIterator_.hasNext()) {
                String nextGroup = (String)this.groupIterator_.next();
                Rectangle rect = (Rectangle)LinkPlacementGrid.this.groups_.get(nextGroup);
                int grpX = rect.x / 10;
                int grpY = rect.y / 10;
                int grpW = rect.width / 10;
                int grpH = rect.height / 10;
                for (int x = 0; x < grpW; ++x) {
                    for (int y = 0; y < grpH; ++y) {
                        int xval = grpX + x;
                        int yval = grpY + y;
                        Point nextPt = new Point(xval, yval);
                        if (this.keySet_.contains(nextPt)) continue;
                        this.currentGroupList_.add(nextPt);
                    }
                }
                if (this.currentGroupList_.isEmpty()) continue;
                return;
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class RecoveryPointData
    implements Cloneable {
        public Point2D point;
        public boolean inboundOrtho;
        public Vector2D inboundRun;
        public LinkProperties.CornerDoF dof;
        private boolean committed_;
        private boolean unreachable_;

        public RecoveryPointData(Point2D point, boolean inboundOrtho, Vector2D inboundRun, LinkProperties.CornerDoF cornerDoF) {
            this.point = point;
            this.inboundOrtho = inboundOrtho;
            this.inboundRun = inboundRun;
            this.dof = cornerDoF;
            this.committed_ = false;
            this.unreachable_ = false;
        }

        public Object clone() {
            try {
                RecoveryPointData retval = (RecoveryPointData)super.clone();
                retval.point = this.point == null ? null : (Point2D)this.point.clone();
                retval.inboundRun = this.inboundRun == null ? null : (Vector2D)this.inboundRun.clone();
                retval.dof = this.dof == null ? null : (LinkProperties.CornerDoF)this.dof.clone();
                return retval;
            }
            catch (CloneNotSupportedException cnse) {
                throw new IllegalStateException();
            }
        }

        public void commit() {
            this.committed_ = true;
        }

        public boolean isCommitted() {
            return this.committed_;
        }

        public void tagAsUnreachable() {
            this.unreachable_ = true;
        }

        public boolean isUnreachable() {
            return this.unreachable_;
        }
    }

    public static class RecoveryDataForSource {
        private HashMap segListPerLink = new HashMap();
        private HashMap pointDataPerSegID = new HashMap();
        private HashMap pushedPointDataPerSegID = new HashMap();
        private HashMap jumpsFromPoints = new HashMap();
        private HashMap jumpsIntoPoints = new HashMap();
        private HashMap boundPointPerLink = new HashMap();
        private Map segmentToKidsMap;
        private LinkSegmentID rootSeg;
        private String directLinkID;
        private Set exemptions;
        private HashMap arrivalRegionChops = new HashMap();
        private HashMap departureRegionChops = new HashMap();

        public void setArrivalRegionChops(Map arrivalRegionChops) {
            this.arrivalRegionChops = arrivalRegionChops == null ? null : new HashMap(arrivalRegionChops);
        }

        public void setDepartureRegionChops(Map departureRegionChops) {
            this.departureRegionChops = departureRegionChops == null ? null : new HashMap(departureRegionChops);
        }

        public Map getArrivalRegionChops() {
            return this.arrivalRegionChops;
        }

        public Map getDepartureRegionChops() {
            return this.departureRegionChops;
        }

        public void setTreeTopology(Map segmentToKidsMap, LinkSegmentID rootSeg, String directLinkID) {
            this.segmentToKidsMap = segmentToKidsMap;
            this.rootSeg = rootSeg;
            this.directLinkID = directLinkID;
        }

        public void setExemptions(Set exemptions) {
            this.exemptions = exemptions;
        }

        public Set getExemptions() {
            return this.exemptions;
        }

        public String getDirectLinkID() {
            return this.directLinkID;
        }

        public LinkSegmentID getRootSeg() {
            return this.rootSeg;
        }

        public Map getSegmentToKidsMap() {
            return this.segmentToKidsMap;
        }

        public Set getLinks() {
            return this.segListPerLink.keySet();
        }

        public void setSegListPerLink(String linkID, List segList) {
            this.segListPerLink.put(linkID, new ArrayList(segList));
        }

        public void setBoundPointPerLink(String linkID, LinkSegmentID bpSeg) {
            this.boundPointPerLink.put(linkID, bpSeg);
        }

        public LinkSegmentID getBoundPointPerLink(String linkID) {
            return (LinkSegmentID)this.boundPointPerLink.get(linkID);
        }

        public boolean revisedPointCanBePushed(LinkSegmentID lsid) {
            RecoveryPointData rpd = (RecoveryPointData)this.pointDataPerSegID.get(lsid);
            if (rpd.isCommitted()) {
                return false;
            }
            if (rpd.isUnreachable()) {
                return false;
            }
            RecoveryPointData pushedRpd = (RecoveryPointData)this.pushedPointDataPerSegID.get(lsid);
            return pushedRpd == null;
        }

        public void pushRevisedPoint(LinkSegmentID lsid, Point2D point) {
            RecoveryPointData rpd = (RecoveryPointData)this.pointDataPerSegID.get(lsid);
            if (rpd.isCommitted()) {
                throw new IllegalStateException();
            }
            if (rpd.isUnreachable()) {
                throw new IllegalStateException();
            }
            RecoveryPointData pushedRpd = (RecoveryPointData)this.pushedPointDataPerSegID.get(lsid);
            if (pushedRpd != null) {
                throw new IllegalStateException();
            }
            RecoveryPointData copy = (RecoveryPointData)rpd.clone();
            copy.point = (Point2D)point.clone();
            this.pushedPointDataPerSegID.put(lsid, copy);
        }

        public void popAllRevisedPoints() {
            this.pushedPointDataPerSegID.clear();
        }

        public void popRevisedPoint(LinkSegmentID lsid) {
            this.pushedPointDataPerSegID.remove(lsid);
        }

        public void addJumpFromPoint(Point2D oldPoint, Point2D jumped) {
            Point dummyPt = new Point();
            Point2D.Double jumped2D = new Point2D.Double();
            LinkPlacementGrid.pointConversion(jumped, jumped2D, dummyPt);
            ArrayList<Point2D.Double> ptList = (ArrayList<Point2D.Double>)this.jumpsFromPoints.get(oldPoint);
            if (ptList == null) {
                ptList = new ArrayList<Point2D.Double>();
                this.jumpsFromPoints.put(oldPoint, ptList);
            }
            ptList.add(jumped2D);
        }

        public void addJumpIntoPoint(Point2D oldPoint, Point2D jumped) {
            Point dummyPt = new Point();
            Point2D.Double jumped2D = new Point2D.Double();
            LinkPlacementGrid.pointConversion(jumped, jumped2D, dummyPt);
            this.jumpsIntoPoints.put(oldPoint, jumped2D);
        }

        public List getJumpFromPoints(Point2D oldPoint) {
            return (List)this.jumpsFromPoints.get(oldPoint);
        }

        public Point2D getJumpIntoPoint(Point2D oldPoint) {
            return (Point2D)this.jumpsIntoPoints.get(oldPoint);
        }

        public void commitAllRevisedPoints() {
            Iterator pkit = this.pushedPointDataPerSegID.keySet().iterator();
            while (pkit.hasNext()) {
                LinkSegmentID lsid = (LinkSegmentID)pkit.next();
                RecoveryPointData pushedRpd = (RecoveryPointData)this.pushedPointDataPerSegID.get(lsid);
                this.pointDataPerSegID.put(lsid, pushedRpd);
                pushedRpd.commit();
            }
            this.pushedPointDataPerSegID.clear();
        }

        public RecoveryPointData getRpd(LinkSegmentID lsid) {
            RecoveryPointData rpd = (RecoveryPointData)this.pushedPointDataPerSegID.get(lsid);
            if (rpd == null) {
                rpd = (RecoveryPointData)this.pointDataPerSegID.get(lsid);
            }
            if (rpd == null || rpd.isUnreachable()) {
                return null;
            }
            return rpd;
        }

        public Point2D getPoint(LinkSegmentID lsid) {
            RecoveryPointData rpd = (RecoveryPointData)this.pushedPointDataPerSegID.get(lsid);
            if (rpd == null) {
                rpd = (RecoveryPointData)this.pointDataPerSegID.get(lsid);
            }
            if (rpd == null || rpd.isUnreachable()) {
                return null;
            }
            return rpd.point;
        }

        public boolean getInboundOrtho(LinkSegmentID lsid) {
            RecoveryPointData rpd = (RecoveryPointData)this.pushedPointDataPerSegID.get(lsid);
            if (rpd == null) {
                rpd = (RecoveryPointData)this.pointDataPerSegID.get(lsid);
            }
            if (rpd == null || rpd.isUnreachable()) {
                return false;
            }
            return rpd.inboundOrtho;
        }

        public void putPointData(LinkSegmentID lsid, RecoveryPointData rpd) {
            this.pointDataPerSegID.put(lsid, rpd);
        }

        public void cleanup() {
            Iterator slit = this.segListPerLink.keySet().iterator();
            while (slit.hasNext()) {
                String linkID = (String)slit.next();
                ArrayList linkList = (ArrayList)this.segListPerLink.get(linkID);
                int numpt = linkList.size();
                ArrayList<LinkSegmentID> cleanedPtsForLink = new ArrayList<LinkSegmentID>();
                RecoveryPointData lastPt = null;
                for (int i = 0; i < numpt; ++i) {
                    LinkSegmentID segID = (LinkSegmentID)linkList.get(i);
                    RecoveryPointData nextPt = (RecoveryPointData)this.pointDataPerSegID.get(segID);
                    if (nextPt == null || nextPt.point == null || lastPt != null && nextPt.point.equals(lastPt.point)) continue;
                    cleanedPtsForLink.add(segID);
                    lastPt = nextPt;
                }
                linkList.clear();
                linkList.addAll(cleanedPtsForLink);
            }
        }

        public LinkSegmentID getPointKey(String linkID, int index, int offset) {
            ArrayList segList = (ArrayList)this.segListPerLink.get(linkID);
            int reachablePreOff = 0;
            int reachablePostOff = 0;
            int segSize = segList.size();
            for (int i = 0; i < segSize; ++i) {
                LinkSegmentID segID = (LinkSegmentID)segList.get(i);
                RecoveryPointData rpd = (RecoveryPointData)this.pushedPointDataPerSegID.get(segID);
                if (rpd == null) {
                    rpd = (RecoveryPointData)this.pointDataPerSegID.get(segID);
                }
                if (rpd.isUnreachable()) continue;
                if (reachablePreOff == offset && index == reachablePostOff) {
                    return segID;
                }
                if (reachablePreOff < offset) {
                    ++reachablePreOff;
                    continue;
                }
                if (reachablePreOff == offset) {
                    ++reachablePostOff;
                    continue;
                }
                throw new IllegalStateException();
            }
            return null;
        }

        public RecoveryPointData getRpd(String linkID, int index, int offset) {
            ArrayList segList = (ArrayList)this.segListPerLink.get(linkID);
            int reachablePreOff = 0;
            int reachablePostOff = 0;
            int segSize = segList.size();
            for (int i = 0; i < segSize; ++i) {
                LinkSegmentID segID = (LinkSegmentID)segList.get(i);
                RecoveryPointData rpd = (RecoveryPointData)this.pushedPointDataPerSegID.get(segID);
                if (rpd == null) {
                    rpd = (RecoveryPointData)this.pointDataPerSegID.get(segID);
                }
                if (rpd.isUnreachable()) continue;
                if (reachablePreOff == offset && index == reachablePostOff) {
                    return rpd;
                }
                if (reachablePreOff < offset) {
                    ++reachablePreOff;
                    continue;
                }
                if (reachablePreOff == offset) {
                    ++reachablePostOff;
                    continue;
                }
                throw new IllegalStateException();
            }
            return null;
        }

        public int getPointCount(String linkID, int offset) {
            ArrayList segList = (ArrayList)this.segListPerLink.get(linkID);
            int segSize = segList == null ? 0 : segList.size();
            int reachablePreOff = 0;
            int reachablePostOff = 0;
            for (int i = 0; i < segSize; ++i) {
                LinkSegmentID segID = (LinkSegmentID)segList.get(i);
                RecoveryPointData rpd = (RecoveryPointData)this.pushedPointDataPerSegID.get(segID);
                if (rpd == null) {
                    rpd = (RecoveryPointData)this.pointDataPerSegID.get(segID);
                }
                if (rpd.isUnreachable()) continue;
                if (reachablePreOff < offset) {
                    ++reachablePreOff;
                    continue;
                }
                if (reachablePreOff == offset) {
                    ++reachablePostOff;
                    continue;
                }
                throw new IllegalStateException();
            }
            return reachablePostOff;
        }

        public Point2D getPoint(String linkID, int index, int offset) {
            RecoveryPointData rpd = this.getRpd(linkID, index, offset);
            return rpd.point;
        }

        public Vector2D getInboundRun(String linkID, int index, int offset) {
            RecoveryPointData rpd = this.getRpd(linkID, index, offset);
            return rpd.inboundRun;
        }

        public boolean getInboundOrtho(String linkID, int index, int offset) {
            RecoveryPointData rpd = this.getRpd(linkID, index, offset);
            return rpd.inboundOrtho;
        }

        public LinkProperties.CornerDoF getCornerDoF(String linkID, int index, int offset) {
            RecoveryPointData rpd = this.getRpd(linkID, index, offset);
            return rpd.dof;
        }

        public boolean isOriginalPoint(Point2D pt) {
            Point2D.Double testPt = new Point2D.Double(pt.getX() * 10.0, pt.getY() * 10.0);
            Iterator pvdit = this.pointDataPerSegID.values().iterator();
            while (pvdit.hasNext()) {
                RecoveryPointData rpd = (RecoveryPointData)pvdit.next();
                if (rpd.point == null || !rpd.point.equals(testPt)) continue;
                return true;
            }
            return false;
        }
    }

    public static class RecoveryDataForLink {
        private RecoveryDataForSource rdfs_;
        private String linkID_;
        private int offset_;
        private Point2D shiftedStart_;

        public RecoveryDataForLink(RecoveryDataForSource rdfs, String linkID) {
            this.rdfs_ = rdfs;
            this.linkID_ = linkID;
            this.shiftedStart_ = null;
            this.offset_ = 0;
        }

        public RecoveryDataForLink(RecoveryDataForLink other, int offset) {
            this.rdfs_ = other.rdfs_;
            this.linkID_ = other.linkID_;
            if (offset < 0) {
                throw new IllegalArgumentException();
            }
            this.offset_ = offset;
            this.shiftedStart_ = null;
        }

        public RecoveryDataForLink(RecoveryDataForLink other, int offset, Point2D shiftedStart) {
            this.rdfs_ = other.rdfs_;
            this.linkID_ = other.linkID_;
            if (offset < 0) {
                throw new IllegalArgumentException();
            }
            this.offset_ = offset;
            this.shiftedStart_ = shiftedStart;
        }

        public String dumpPath() {
            StringBuffer buf = new StringBuffer();
            int count = this.getPointCount();
            for (int i = 0; i < count; ++i) {
                buf.append("[");
                buf.append(this.getPoint(i).toString());
                buf.append(" @ ");
                buf.append(this.getInboundRun(i).toString());
                buf.append("] ");
            }
            return buf.toString();
        }

        public RecoveryDataForSource getEnclosingSource() {
            return this.rdfs_;
        }

        public LinkSegmentID getSourceBoundPoint() {
            return this.rdfs_.getBoundPointPerLink(this.linkID_);
        }

        public int getSourceBoundIndex() {
            LinkSegmentID id = this.rdfs_.getBoundPointPerLink(this.linkID_);
            int ptCount = this.getPointCount();
            for (int i = 0; i < ptCount; ++i) {
                LinkSegmentID pkfi = this.getPointKey(i);
                if (!pkfi.equals(id)) continue;
                return i;
            }
            return -1;
        }

        public RecoveryPointData getRpd(int index) {
            return this.rdfs_.getRpd(this.linkID_, index, this.offset_);
        }

        public int getPointCount() {
            return this.rdfs_.getPointCount(this.linkID_, this.offset_);
        }

        public Point2D getPoint(int index) {
            if (index == 0 && this.shiftedStart_ != null) {
                return this.shiftedStart_;
            }
            return this.rdfs_.getPoint(this.linkID_, index, this.offset_);
        }

        public Vector2D getInboundRun(int index) {
            return this.rdfs_.getInboundRun(this.linkID_, index, this.offset_);
        }

        public Point2D getPoint(LinkSegmentID lsid) {
            return this.rdfs_.getPoint(lsid);
        }

        public boolean getInboundOrtho(int index) {
            return this.rdfs_.getInboundOrtho(this.linkID_, index, this.offset_);
        }

        public LinkProperties.CornerDoF getCornerDoF(int index) {
            return this.rdfs_.getCornerDoF(this.linkID_, index, this.offset_);
        }

        public boolean revisedPointCanBePushed(LinkSegmentID lsid) {
            return this.rdfs_.revisedPointCanBePushed(lsid);
        }

        public void pushRevisedPoint(LinkSegmentID lsid, Point2D point) {
            this.rdfs_.pushRevisedPoint(lsid, point);
        }

        public void popRevisedPoint(LinkSegmentID lsid) {
            this.rdfs_.popRevisedPoint(lsid);
        }

        public void commitAllRevisedPoints() {
            this.rdfs_.commitAllRevisedPoints();
        }

        public void popAllRevisedPoints() {
            this.rdfs_.popAllRevisedPoints();
        }

        public LinkSegmentID getPointKey(int index) {
            return this.rdfs_.getPointKey(this.linkID_, index, this.offset_);
        }
    }

    public static class PointPair {
        public Point2D start;
        public Point2D end;

        public PointPair() {
        }

        public PointPair(Point2D start, Point2D end) {
            this.start = (Point2D)start.clone();
            this.end = end == null ? null : (Point2D)end.clone();
        }

        public void shift(Vector2D shift) {
            this.start = shift.add(this.start);
            this.end = this.end == null ? null : shift.add(this.end);
        }

        public int hashCode() {
            return this.start.hashCode() + (this.end == null ? 0 : this.end.hashCode());
        }

        public String toString() {
            return "start = " + this.start + " end = " + this.end;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof PointPair)) {
                return false;
            }
            PointPair otherPair = (PointPair)other;
            if (!this.start.equals(otherPair.start)) {
                return false;
            }
            if (this.end == null) {
                return otherPair.end == null;
            }
            return this.end.equals(otherPair.end);
        }
    }

    public static class InkValues {
        public int ink;
        public int simpleCorners;
        public int complexCorners;

        public InkValues(int ink, int simpleCorners, int complexCorners) {
            this.ink = ink;
            this.simpleCorners = simpleCorners;
            this.complexCorners = complexCorners;
        }

        public InkValues() {
        }

        public InkValues(InkValues other) {
            this.copy(other);
        }

        public static InkValues merge(InkValues origFull, InkValues origSub, InkValues modSub) {
            InkValues retval = new InkValues();
            retval.ink = origFull.ink - origSub.ink + modSub.ink;
            retval.simpleCorners = origFull.simpleCorners - origSub.simpleCorners + modSub.simpleCorners;
            retval.complexCorners = origFull.complexCorners - origSub.complexCorners + modSub.complexCorners;
            return retval;
        }

        public void copy(InkValues other) {
            this.ink = other.ink;
            this.simpleCorners = other.simpleCorners;
            this.complexCorners = other.complexCorners;
        }

        public String toString() {
            return "InkValues: ink = " + this.ink + " simpleCorners: " + this.simpleCorners + " complexCorners: " + this.complexCorners;
        }
    }

    public static class GoodnessParams {
        public double differenceSigma;
        public double differenceCoeff;
        double differenceNormalize;
        public double crossingMultiplier;
        public double crossingCoeff;
        double normalize;
        double terminal;

        public GoodnessParams() {
            this.crossingCoeff = 0.0;
            this.crossingMultiplier = 0.0;
            this.differenceCoeff = 0.5;
            this.differenceSigma = 15.0;
            this.terminal = 10.0;
        }

        public GoodnessParams(GoodnessParams other) {
            this.crossingCoeff = other.crossingCoeff;
            this.crossingMultiplier = other.crossingMultiplier;
            this.differenceCoeff = other.differenceCoeff;
            this.differenceSigma = other.differenceSigma;
            this.terminal = other.terminal;
            this.differenceNormalize = other.differenceNormalize;
            this.normalize = other.normalize;
        }
    }

    public static class NewCorner {
        public int type;
        public Point2D point;
        public int dir;

        NewCorner(int type, Point2D point, int dir) {
            this.type = type;
            this.point = point;
            this.dir = dir;
        }

        public String toString() {
            return "NewCorner: type = " + this.type + " point = " + this.point + " dir = " + this.dir;
        }
    }

    public static class TerminalRegion {
        public static final int ARRIVAL = 0;
        public static final int DEPARTURE = 1;
        String id;
        Point start;
        boolean[] slots;
        int direction;
        int type;

        TerminalRegion(String id, Point start, boolean[] slots, int direction, int type) {
            this.id = id;
            this.start = start;
            this.slots = slots;
            this.direction = direction;
            this.type = type;
        }

        public int hashCode() {
            int slotCode = 0;
            int factor = 1;
            for (int i = 0; i < this.slots.length; ++i) {
                int slotVal = this.slots[i] ? 1 : 0;
                slotCode += factor * slotVal;
                factor *= 2;
            }
            return this.id.hashCode() + this.start.hashCode() + this.direction + this.type + slotCode;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof TerminalRegion)) {
                return false;
            }
            TerminalRegion otherTR = (TerminalRegion)other;
            if (!this.id.equals(otherTR.id)) {
                return false;
            }
            if (!this.start.equals(otherTR.start)) {
                return false;
            }
            if (this.direction != otherTR.direction) {
                return false;
            }
            if (this.type != otherTR.type) {
                return false;
            }
            if (this.slots.length != otherTR.slots.length) {
                return false;
            }
            for (int i = 0; i < this.slots.length; ++i) {
                if (this.slots[i] == otherTR.slots[i]) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuffer slotBuf = new StringBuffer();
            for (int i = 0; i < this.slots.length; ++i) {
                slotBuf.append(this.slots[i]);
                slotBuf.append(' ');
            }
            return "Terminal Region: id = " + this.id + " start = " + this.start + " slots = " + slotBuf + " direction = " + this.direction + " type = " + this.type;
        }

        int getNumPoints() {
            int retval = 0;
            for (int i = 0; i < this.slots.length; ++i) {
                if (!this.slots[i]) continue;
                ++retval;
            }
            return retval;
        }

        Point getPoint(int n) {
            int count = 0;
            for (int i = 0; i < this.slots.length; ++i) {
                if (!this.slots[i]) continue;
                if (count == n) {
                    Vector2D addon = this.getTerminalVector();
                    addon.scale(this.type == 0 ? (double)(-i) : (double)i);
                    Point2D retval = addon.add(this.start);
                    return new Point((int)retval.getX(), (int)retval.getY());
                }
                ++count;
            }
            throw new IllegalArgumentException();
        }

        int getNumTravelPoints() {
            return this.slots.length;
        }

        Point getTravelPoint(int n) {
            Vector2D addon = this.getTerminalVector();
            addon.scale(this.type == 0 ? (double)(-n) : (double)n);
            Point2D retval = addon.add(this.start);
            return new Point((int)retval.getX(), (int)retval.getY());
        }

        Vector2D getTerminalVector() {
            return LinkPlacementGrid.getVector(this.direction);
        }
    }
}

