/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.ListWidgetClient;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;

public class ListWidget
extends JPanel
implements ListSelectionListener {
    public static final int ADD_ONLY = 0;
    public static final int DELETE_ONLY = 1;
    public static final int FULL_MODE = 2;
    public static final int DELETE_COMBINE = 3;
    public static final int DELETE_EDIT = 4;
    public static final int ADD_ONLY_HOLD_SELECT = 5;
    private JButton buttonA_;
    private JButton buttonD_;
    private JButton buttonE_;
    private JButton buttonC_;
    private JButton buttonExtra_;
    private JList list_;
    private int[] selectedRows_;
    private ListWidgetClient client_;
    private int mode_;

    public ListWidget(List contents, ListWidgetClient client) {
        this(contents, client, false);
    }

    public ListWidget(List contents, ListWidgetClient client, boolean addOnly) {
        this(contents, client, addOnly ? 0 : 2, null);
    }

    public ListWidget(List contents, ListWidgetClient client, int mode) {
        this(contents, client, mode, null);
    }

    public ListWidget(List contents, ListWidgetClient client, int mode, JButton buttonExtra) {
        ResourceManager rMan = ResourceManager.getManager();
        GridBagConstraints gbc = new GridBagConstraints();
        this.client_ = client;
        this.mode_ = mode;
        this.selectedRows_ = new int[0];
        this.buttonExtra_ = buttonExtra;
        this.setLayout(new GridBagLayout());
        this.list_ = new JList<Object>(contents.toArray());
        this.list_.addListSelectionListener(this);
        if (mode == 0 || mode == 5 || mode == 2) {
            this.buttonA_ = new JButton(rMan.getString("dialogs.add"));
            this.buttonA_.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    try {
                        if (ListWidget.this.addRow()) {
                            ListWidget.this.list_.revalidate();
                        }
                    }
                    catch (Exception ex) {
                        ExceptionHandler.getHandler().displayException(ex);
                    }
                }
            });
        }
        if (mode == 1 || mode == 3 || mode == 4 || mode == 2) {
            this.buttonD_ = new JButton(rMan.getString("dialogs.delete"));
            this.buttonD_.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    try {
                        if (ListWidget.this.deleteRows(ListWidget.this.selectedRows_)) {
                            ListWidget.this.list_.revalidate();
                        }
                    }
                    catch (Exception ex) {
                        ExceptionHandler.getHandler().displayException(ex);
                    }
                }
            });
            this.buttonD_.setEnabled(false);
        }
        if (mode == 2 || mode == 4) {
            this.buttonE_ = new JButton(rMan.getString("dialogs.edit"));
            this.buttonE_.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    try {
                        if (ListWidget.this.editRow(ListWidget.this.selectedRows_)) {
                            ListWidget.this.list_.revalidate();
                        }
                    }
                    catch (Exception ex) {
                        ExceptionHandler.getHandler().displayException(ex);
                    }
                }
            });
            this.buttonE_.setEnabled(false);
        }
        if (mode == 3) {
            this.buttonC_ = new JButton(rMan.getString("dialogs.combine"));
            this.buttonC_.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    try {
                        if (ListWidget.this.combineRows(ListWidget.this.selectedRows_)) {
                            ListWidget.this.list_.revalidate();
                        }
                    }
                    catch (Exception ex) {
                        ExceptionHandler.getHandler().displayException(ex);
                    }
                }
            });
            this.buttonC_.setEnabled(false);
        }
        UiUtil.gbcSet(gbc, 0, 0, 2, 5, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        JScrollPane jsp = new JScrollPane(this.list_);
        this.add((Component)jsp, gbc);
        int rowNum = 0;
        if (mode == 0 || mode == 5 || mode == 2) {
            UiUtil.gbcSet(gbc, 2, rowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 11, 0.0, 0.0);
            this.add((Component)this.buttonA_, gbc);
        }
        if (mode == 1 || mode == 3 || mode == 4 || mode == 2) {
            UiUtil.gbcSet(gbc, 2, rowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 11, 0.0, 0.0);
            this.add((Component)this.buttonD_, gbc);
        }
        if (mode == 2 || mode == 4) {
            UiUtil.gbcSet(gbc, 2, rowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 11, 0.0, 0.0);
            this.add((Component)this.buttonE_, gbc);
        }
        if (mode == 3) {
            UiUtil.gbcSet(gbc, 2, rowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 11, 0.0, 0.0);
            this.add((Component)this.buttonC_, gbc);
        }
        if (this.buttonExtra_ != null) {
            UiUtil.gbcSet(gbc, 2, rowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 11, 0.0, 0.0);
            this.add((Component)this.buttonExtra_, gbc);
            this.buttonExtra_.setEnabled(false);
        }
    }

    public void setSelectedIndices(int[] indices) {
        this.list_.setSelectedIndices(indices);
        if (indices.length > 0) {
            this.list_.ensureIndexIsVisible(indices[0]);
        }
    }

    public Object getElementAt(int index) {
        return this.list_.getModel().getElementAt(index);
    }

    public int getElementCount() {
        return this.list_.getModel().getSize();
    }

    public Object[] getSelectedObjects() {
        return this.list_.getSelectedValues();
    }

    public int[] getSelections() {
        return this.list_.getSelectedIndices();
    }

    public void update(List entries) {
        this.list_.clearSelection();
        this.list_.setListData(entries.toArray());
    }

    public boolean addRow() {
        List entries = this.client_.addRow(this);
        if (entries == null) {
            return false;
        }
        int[] holdRows = null;
        if (this.mode_ == 5) {
            holdRows = this.list_.getSelectedIndices();
        }
        this.list_.clearSelection();
        this.list_.setListData(entries.toArray());
        if (this.mode_ == 5) {
            this.setSelectedIndices(holdRows);
        }
        return true;
    }

    public boolean deleteRows(int[] selectedRows) {
        List entries = this.client_.deleteRows(this, selectedRows);
        if (entries == null) {
            return false;
        }
        this.list_.clearSelection();
        this.list_.setListData(entries.toArray());
        return true;
    }

    public boolean editRow(int[] selectedRows) {
        List entries = this.client_.editRow(this, selectedRows);
        if (entries == null) {
            return false;
        }
        this.list_.clearSelection();
        this.list_.setListData(entries.toArray());
        return true;
    }

    public boolean combineRows(int[] selectedRows) {
        List entries = this.client_.combineRows(this, selectedRows);
        if (entries == null) {
            return false;
        }
        this.list_.clearSelection();
        this.list_.setListData(entries.toArray());
        return true;
    }

    public void valueChanged(ListSelectionEvent lse) {
        try {
            if (lse.getValueIsAdjusting()) {
                return;
            }
            this.selectedRows_ = this.list_.getSelectedIndices();
            this.handleButtons(this.isEnabled());
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.buttonA_.setEnabled(enabled);
        this.handleButtons(enabled);
        this.list_.setEnabled(enabled);
    }

    private void handleButtons(boolean amEnabled) {
        boolean haveManyRows;
        boolean haveRows = this.selectedRows_.length > 0;
        boolean haveARow = this.selectedRows_.length == 1;
        boolean bl = haveManyRows = this.selectedRows_.length >= 2;
        if (this.buttonD_ != null) {
            this.buttonD_.setEnabled(haveRows && amEnabled);
            this.buttonD_.revalidate();
        }
        if (this.buttonE_ != null) {
            this.buttonE_.setEnabled(haveARow && amEnabled);
            this.buttonE_.revalidate();
        }
        if (this.buttonC_ != null) {
            this.buttonC_.setEnabled(haveManyRows && amEnabled);
            this.buttonC_.revalidate();
        }
        if (this.buttonExtra_ != null) {
            this.buttonExtra_.setEnabled(haveARow && amEnabled);
            this.buttonExtra_.revalidate();
        }
    }
}

