/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

public class MapIOSupport {
    private String mapTag_;
    private String keyTag_;
    private String keyAttrib_;
    private String elemTag_;
    private String elemAttrib_;

    public MapIOSupport(String mapTag, String keyTag, String keyAttrib, String elemTag, String elemAttrib) {
        this.mapTag_ = mapTag;
        this.keyTag_ = keyTag;
        this.elemTag_ = elemTag;
        this.keyAttrib_ = keyAttrib;
        this.elemAttrib_ = elemAttrib;
    }

    public void dumpMapToXML(PrintWriter out, Indenter ind, Map map) {
        if (!map.isEmpty()) {
            ind.indent();
            out.print("<");
            out.print(this.mapTag_);
            out.println(">");
            ind.up();
            TreeSet sorted = new TreeSet(map.keySet());
            Iterator dpkit = sorted.iterator();
            while (dpkit.hasNext()) {
                String dpkey = (String)dpkit.next();
                ArrayList notes = (ArrayList)map.get(dpkey);
                ind.indent();
                out.print("<");
                out.print(this.keyTag_);
                out.print(" ");
                out.print(this.keyAttrib_);
                out.print("=\"");
                out.print(dpkey);
                out.println("\">");
                ind.up();
                int numN = notes.size();
                for (int i = 0; i < numN; ++i) {
                    String noteID = (String)notes.get(i);
                    ind.indent();
                    out.print("<");
                    out.print(this.elemTag_);
                    out.print(" ");
                    out.print(this.elemAttrib_);
                    out.print("=\"");
                    out.print(noteID);
                    out.println("\"/>");
                }
                ind.down().indent();
                out.print("</");
                out.print(this.keyTag_);
                out.println(">");
            }
            ind.down().indent();
            out.print("</");
            out.print(this.mapTag_);
            out.println(">");
        }
    }

    public class MapElemWorker
    extends AbstractFactoryClient {
        public MapElemWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add(MapIOSupport.this.elemTag_);
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            String retval = null;
            if (elemName.equals(MapIOSupport.this.elemTag_)) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.currentMapTarget = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private String buildFromXML(String elemName, Attributes attrs) throws IOException {
            String name = AttributeExtractor.extractAttribute(elemName, attrs, MapIOSupport.this.elemTag_, MapIOSupport.this.elemAttrib_, true);
            return name;
        }
    }

    public static class MyElemGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            Map cMap = board.currentMap;
            ArrayList targList = (ArrayList)cMap.get(board.currentMapKey);
            targList.add(board.currentMapTarget);
            return null;
        }
    }

    public class MapKeyWorker
    extends AbstractFactoryClient {
        public MapKeyWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add(MapIOSupport.this.keyTag_);
            this.installWorker(new MapElemWorker(whiteboard), new MyElemGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            String retval = null;
            if (elemName.equals(MapIOSupport.this.keyTag_)) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.currentMapKey = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private String buildFromXML(String elemName, Attributes attrs) throws IOException {
            String key = AttributeExtractor.extractAttribute(elemName, attrs, MapIOSupport.this.keyTag_, MapIOSupport.this.keyAttrib_, true);
            return key;
        }
    }

    public static class MyKeyGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            Map cMap = board.currentMap;
            ArrayList targList = new ArrayList();
            cMap.put(board.currentMapKey, targList);
            return null;
        }
    }

    public class MapWorker
    extends AbstractFactoryClient {
        public MapWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add(MapIOSupport.this.mapTag_);
            this.installWorker(new MapKeyWorker(whiteboard), new MyKeyGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            Map retval = null;
            if (elemName.equals(MapIOSupport.this.mapTag_)) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.currentMap = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private Map buildFromXML(String elemName, Attributes attrs) throws IOException {
            HashMap retval = new HashMap();
            return retval;
        }
    }
}

