/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.systemsbiology.biotapestry.util.ExceptionHandler;

public class MultiChoiceEditor
extends JPanel
implements TableCellEditor {
    private ArrayList listeners_;
    private JCheckBox[] boxes_;
    protected ChoiceEntrySet templateValue_;
    protected ChoiceEntrySet origValue_;
    private int currRow_;
    private int currColumn_;

    public MultiChoiceEditor(Object valueObject) {
        this.valueFill(valueObject);
        this.listeners_ = new ArrayList();
        this.currRow_ = -1;
        this.currColumn_ = -1;
    }

    public void replaceValues(ChoiceEntrySet ces) {
        this.removeAll();
        this.valueFill(ces);
    }

    private void valueFill(Object valueObject) {
        ChoiceEntrySet ces = (ChoiceEntrySet)valueObject;
        int size = ces.values.length;
        this.boxes_ = new JCheckBox[size];
        this.setLayout(new GridLayout(1, size));
        for (int i = 0; i < size; ++i) {
            ChoiceEntry ce = ces.values[i];
            this.boxes_[i] = new JCheckBox(ce.display, ce.selected);
            this.add(this.boxes_[i]);
        }
        this.templateValue_ = new ChoiceEntrySet(ces);
    }

    private void toBoxes(ChoiceEntrySet ces) {
        int size = ces.values.length;
        for (int i = 0; i < size; ++i) {
            ChoiceEntry ce = ces.values[i];
            this.boxes_[i].setSelected(ce.selected);
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        try {
            if (value == null) {
                return this;
            }
            this.currRow_ = row;
            this.currColumn_ = column;
            ChoiceEntrySet ces = (ChoiceEntrySet)value;
            this.toBoxes(ces);
            table.setRowSelectionInterval(row, row);
            table.setColumnSelectionInterval(column, column);
            this.origValue_ = new ChoiceEntrySet(ces);
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
        return this;
    }

    public int getCurrRow() {
        return this.currRow_;
    }

    public int getCurrColumn() {
        return this.currColumn_;
    }

    public boolean entryIsValid() {
        return this.currRow_ != -1 && this.currColumn_ != -1;
    }

    public void addCellEditorListener(CellEditorListener l) {
        try {
            this.listeners_.add(l);
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public void cancelCellEditing() {
        try {
            this.editingCanceled();
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public ChoiceEntrySet fromBoxes() {
        ChoiceEntrySet ces = new ChoiceEntrySet(this.templateValue_);
        int size = ces.values.length;
        for (int i = 0; i < size; ++i) {
            ChoiceEntry ce = ces.values[i];
            ce.selected = this.boxes_[i].isSelected();
        }
        return ces;
    }

    public Object getCellEditorValue() {
        ChoiceEntrySet retval = null;
        try {
            retval = this.fromBoxes();
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
        return retval;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public void removeCellEditorListener(CellEditorListener l) {
        try {
            this.listeners_.remove(l);
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean stopCellEditing() {
        try {
            this.editingStopped();
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
        return true;
    }

    public void addItemListener(ItemListener l) {
        int size = this.boxes_.length;
        for (int i = 0; i < size; ++i) {
            this.boxes_[i].addItemListener(l);
        }
    }

    public void removeItemListener(ItemListener l) {
        int size = this.boxes_.length;
        for (int i = 0; i < size; ++i) {
            this.boxes_[i].removeItemListener(l);
        }
    }

    private void editingCanceled() {
        this.currRow_ = -1;
        this.currColumn_ = -1;
        if (this.origValue_ != null) {
            this.toBoxes(this.origValue_);
        }
        ChangeEvent cev = new ChangeEvent(this);
        ArrayList lCopy = new ArrayList(this.listeners_);
        Iterator lit = lCopy.iterator();
        while (lit.hasNext()) {
            CellEditorListener cel = (CellEditorListener)lit.next();
            cel.editingCanceled(cev);
        }
    }

    private void editingStopped() {
        this.currRow_ = -1;
        this.currColumn_ = -1;
        ChangeEvent cev = new ChangeEvent(this);
        ArrayList lCopy = new ArrayList(this.listeners_);
        Iterator lit = lCopy.iterator();
        while (lit.hasNext()) {
            CellEditorListener cel = (CellEditorListener)lit.next();
            cel.editingStopped(cev);
        }
    }

    public static class ChoiceEntrySet {
        public ChoiceEntry[] values;

        public ChoiceEntrySet() {
            this.values = new ChoiceEntry[0];
        }

        public ChoiceEntrySet(ChoiceEntry[] values) {
            int size = values.length;
            this.values = new ChoiceEntry[size];
            for (int i = 0; i < size; ++i) {
                this.values[i] = new ChoiceEntry(values[i]);
            }
        }

        public ChoiceEntrySet(ChoiceEntrySet other) {
            this(other.values);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof ChoiceEntrySet)) {
                return false;
            }
            ChoiceEntrySet otherCES = (ChoiceEntrySet)other;
            if (otherCES.values.length != this.values.length) {
                return false;
            }
            int size = this.values.length;
            for (int i = 0; i < size; ++i) {
                if (this.values[i].equals(otherCES.values[i])) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            int size = this.values.length;
            for (int i = 0; i < size; ++i) {
                buf.append(this.values[i]);
                buf.append("\n");
            }
            return buf.toString();
        }
    }

    public static class ChoiceEntry {
        public boolean selected;
        public String display;
        public String internal;

        public ChoiceEntry(String display, String internal, boolean selected) {
            this.display = display;
            this.internal = internal;
            this.selected = selected;
        }

        public ChoiceEntry(ChoiceEntry other) {
            this.display = other.display;
            this.internal = other.internal;
            this.selected = other.selected;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof ChoiceEntry)) {
                return false;
            }
            ChoiceEntry otherCE = (ChoiceEntry)other;
            return otherCE.selected == this.selected && otherCE.display.equals(this.display) && otherCE.internal.equals(this.internal);
        }

        public String toString() {
            return this.display + " (" + this.internal + ") : " + this.selected;
        }
    }
}

