/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.systemsbiology.biotapestry.ui.FontManager;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.ResourceManager;

public class MultiLineRenderSupport {
    public static final int LEFT_JUST = 0;
    public static final int CENTER_JUST = 1;
    public static final int RIGHT_JUST = 2;
    private static final int NUM_JUST_ = 3;
    public static final int DEFAULT_JUST = 1;
    private static final String LEFT_JUST_STR_ = "left";
    private static final String CENTER_JUST_STR_ = "center";
    private static final String RIGHT_JUST_STR_ = "right";
    private static final int OLD_LABEL_BREAK_LIMIT_ = 12;
    private static final int OLD_GENE_MAX_CHAR_ = 12;

    private MultiLineRenderSupport() {
    }

    public static Dimension firstLineBounds(FontRenderContext frc, String text, boolean hideName, Font mFont, String breakDef) {
        if (hideName || text.indexOf(94) != -1 || breakDef == null) {
            return MultiLineRenderSupport.getSimpleTextDims(frc, text, hideName, mFont, breakDef);
        }
        List frags = MultiLineRenderSupport.applyLineBreaksForFragments(text, breakDef);
        String frag = (String)frags.get(0);
        Rectangle2D bounds = mFont.getStringBounds(frag, frc);
        return new Dimension((int)bounds.getWidth(), (int)bounds.getHeight());
    }

    public static Point2D renderText(Graphics2D g2, float x, float y, String text, boolean hideName, Font mFont, String breakDef) {
        FontRenderContext frc = g2.getFontRenderContext();
        if (hideName) {
            Rectangle2D bounds = mFont.getStringBounds(":", frc);
            return new Point2D.Double((double)x + bounds.getWidth(), (double)y - bounds.getHeight() / 3.0);
        }
        Font sFont = FontManager.getMgr().getFont(0);
        int superIndex = text.indexOf(94);
        if (superIndex != -1) {
            String regular = text.substring(0, superIndex);
            String superscript = text.substring(superIndex + 1);
            Rectangle2D bounds = mFont.getStringBounds(regular, frc);
            g2.setFont(mFont);
            g2.drawString(regular, x, y);
            g2.setFont(sFont);
            g2.drawString(superscript, x + (float)bounds.getWidth(), y - (float)bounds.getHeight() / 2.0f);
            Rectangle2D fullBounds = mFont.getStringBounds(text, frc);
            return new Point2D.Double((double)x + fullBounds.getWidth(), (double)y - fullBounds.getHeight() / 3.0);
        }
        if (breakDef == null) {
            if (text.length() > 0) {
                g2.setFont(mFont);
                g2.drawString(text, x, y);
            }
            Rectangle2D fullBounds = mFont.getStringBounds(text, frc);
            return new Point2D.Double((double)x + fullBounds.getWidth(), (double)y - fullBounds.getHeight() / 3.0);
        }
        List frags = MultiLineRenderSupport.applyLineBreaksForFragments(text, breakDef);
        int numFrags = frags.size();
        RectangularShape bounds = null;
        float currY = y;
        for (int i = 0; i < numFrags; ++i) {
            String frag = (String)frags.get(i);
            if (bounds == null) {
                bounds = mFont.getStringBounds(frag, frc);
            }
            if (frag.length() == 0) {
                frag = " ";
            }
            TextLayout tl = new TextLayout(frag, mFont, frc);
            tl.draw(g2, x, currY);
            currY += tl.getAscent() + tl.getDescent() + tl.getLeading();
        }
        return new Point2D.Double((double)x + bounds.getWidth(), (double)y - bounds.getHeight() / 3.0);
    }

    public static Rectangle2D getTextBounds(FontRenderContext frc, float x, float y, String text, boolean hideName, Font mFont, String breakDef) {
        if (hideName || text.indexOf(94) != -1 || breakDef == null) {
            return MultiLineRenderSupport.getSimpleTextBounds(frc, x, y, text, hideName, mFont, breakDef);
        }
        List frags = MultiLineRenderSupport.applyLineBreaksForFragments(text, breakDef);
        String[] toks = frags.toArray(new String[frags.size()]);
        Point2D.Double center = new Point2D.Double();
        Rectangle2D rect2D = MultiLineRenderSupport.multiLineGuts(frc, toks, mFont, center, null, null, null, null);
        Rectangle2D bounds1 = mFont.getStringBounds((String)frags.get(0), frc);
        double mly = (double)y - bounds1.getHeight() * 0.8;
        return new Rectangle2D.Double(x, mly, rect2D.getWidth(), rect2D.getHeight());
    }

    public static Dimension getSimpleTextDims(FontRenderContext frc, String text, boolean hideName, Font mFont, String breakDef) {
        if (hideName) {
            Rectangle2D bounds = mFont.getStringBounds(":", frc);
            return new Dimension((int)bounds.getWidth(), (int)bounds.getHeight());
        }
        Font sFont = FontManager.getMgr().getFont(0);
        int superIndex = text.indexOf(94);
        if (superIndex != -1) {
            double height2;
            String regular = text.substring(0, superIndex);
            String superscript = text.substring(superIndex + 1);
            Rectangle2D bounds = mFont.getStringBounds(regular, frc);
            Rectangle2D superBounds = sFont.getStringBounds(superscript, frc);
            double height1 = bounds.getHeight() / 2.0 + superBounds.getHeight();
            double retHeight = height1 > (height2 = bounds.getHeight()) ? height1 : height2;
            return new Dimension((int)(bounds.getWidth() + superBounds.getWidth()), (int)retHeight);
        }
        if (breakDef == null) {
            Rectangle2D bounds = mFont.getStringBounds(text, frc);
            return new Dimension((int)bounds.getWidth(), (int)bounds.getHeight());
        }
        return null;
    }

    private static Rectangle2D getSimpleTextBounds(FontRenderContext frc, float x, float y, String text, boolean hideName, Font mFont, String breakDef) {
        Dimension dim = MultiLineRenderSupport.getSimpleTextDims(frc, text, hideName, mFont, breakDef);
        return new Rectangle2D.Double(x, (double)y - dim.getHeight() * 0.8, dim.getWidth(), dim.getHeight());
    }

    public static boolean isTextCandidate(FontRenderContext frc, int fontType, FontManager.FontOverride fo, String text, double xPad, double dx, double distSq, String breakDef, boolean canBeLeft, boolean nameHidden) {
        double sizeSq;
        if (!canBeLeft && dx > 0.0) {
            return false;
        }
        if (nameHidden) {
            return false;
        }
        Rectangle2D rect = FontManager.getMgr().getCharSize(fontType, fo, frc);
        int textLength = text.length();
        int superIndex = text.indexOf(94);
        if (superIndex != -1) {
            int length = textLength;
            double radius = rect.getWidth() * (double)length + xPad;
            sizeSq = radius * radius;
        } else {
            Dimension estRect = MultiLineRenderSupport.textRect(breakDef, text, rect);
            sizeSq = estRect.getWidth() * estRect.getWidth() + estRect.getHeight() * estRect.getHeight() + xPad * xPad;
        }
        return distSq < sizeSq;
    }

    public static boolean isSingleLineText(String text, boolean hideName, String breakDef) {
        if (hideName) {
            return true;
        }
        int superIndex = text.indexOf(94);
        if (superIndex != -1) {
            return false;
        }
        return breakDef == null;
    }

    public static boolean intersectTextLabel(FontRenderContext frc, float x, float y, String text, Point2D intPt, boolean hideName, int fontType, FontManager.FontOverride fo, String breakDef) {
        if (hideName) {
            return false;
        }
        Font mFont = FontManager.getMgr().getFont(fontType);
        Font sFont = FontManager.getMgr().getFont(0);
        int superIndex = text.indexOf(94);
        if (superIndex != -1) {
            String regular = text.substring(0, superIndex);
            String superscript = text.substring(superIndex + 1);
            Rectangle2D bounds = mFont.getStringBounds(regular, frc);
            bounds.setRect(x, (double)y - bounds.getHeight(), bounds.getWidth(), bounds.getHeight());
            if (bounds.contains(intPt)) {
                return true;
            }
            Rectangle2D supBounds = mFont.getStringBounds(superscript, frc);
            supBounds.setRect(x + (float)bounds.getWidth(), (double)(y - (float)bounds.getHeight() / 2.0f) - supBounds.getHeight(), supBounds.getWidth(), supBounds.getHeight());
            return supBounds.contains(intPt);
        }
        if (breakDef == null) {
            Rectangle2D bounds = mFont.getStringBounds(text, frc);
            bounds.setRect(x, (double)y - bounds.getHeight(), bounds.getWidth(), bounds.getHeight());
            return bounds.contains(intPt);
        }
        List frags = MultiLineRenderSupport.applyLineBreaksForFragments(text, breakDef);
        int numFrags = frags.size();
        Rectangle2D bounds = null;
        float currY = y;
        for (int i = 0; i < numFrags; ++i) {
            String frag = (String)frags.get(i);
            if (bounds == null) {
                bounds = mFont.getStringBounds(frag, frc);
            }
            if (frag.length() == 0) {
                frag = " ";
            }
            TextLayout tl = new TextLayout(frag, mFont, frc);
            bounds = tl.getBounds();
            bounds.setRect(x, (double)currY - bounds.getHeight(), bounds.getWidth(), bounds.getHeight());
            if (bounds.contains(intPt)) {
                return true;
            }
            currY += tl.getAscent() + tl.getDescent() + tl.getLeading();
        }
        return false;
    }

    public static String legacyLineBreaks(boolean hideLabel, int nodeType, FontRenderContext frc, String text) {
        if (hideLabel) {
            return null;
        }
        Font mFont = FontManager.getMgr().getFont(1);
        if (nodeType == 1 || nodeType == 2) {
            return null;
        }
        int limit = nodeType != 4 ? 12 : 12;
        int superIndex = text.indexOf(94);
        if (superIndex != -1) {
            return null;
        }
        if (text.length() <= limit || text.indexOf(32) == -1) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        AttributedString as = new AttributedString(text);
        as.addAttribute(TextAttribute.FONT, mFont);
        AttributedCharacterIterator aci = as.getIterator();
        LineBreakMeasurer lbm = new LineBreakMeasurer(aci, frc);
        Rectangle2D bounds = mFont.getStringBounds(text.substring(0, limit), frc);
        float wrap = (float)bounds.getWidth();
        int lastPos = 0;
        while (lbm.getPosition() < aci.getEndIndex()) {
            if (lastPos != 0) {
                buf.append("\n");
            }
            int nextPos = lbm.nextOffset(wrap);
            lbm.nextLayout(wrap);
            buf.append(text.substring(lastPos, nextPos));
            lastPos = nextPos;
        }
        return MultiLineRenderSupport.genBreaks(buf.toString());
    }

    public static String applyLineBreaks(String name, String breakDef) {
        List breaks = MultiLineRenderSupport.parseBreaks(breakDef);
        if (breaks == null || breaks.isEmpty()) {
            return name;
        }
        StringBuffer buf = new StringBuffer();
        int nameLen = name.length();
        int lastBreak = 0;
        int size = breaks.size();
        for (int i = 0; i < size; ++i) {
            int nextBreak = (Integer)breaks.get(i);
            if (nextBreak >= nameLen) {
                buf.append(name.substring(lastBreak, nameLen));
                return buf.toString();
            }
            buf.append(name.substring(lastBreak, nextBreak));
            buf.append("\n");
            lastBreak = nextBreak;
        }
        buf.append(name.substring(lastBreak, name.length()));
        return buf.toString();
    }

    public static List applyLineBreaksForFragments(String name, String breakDef) {
        ArrayList<String> retval = new ArrayList<String>();
        List breaks = MultiLineRenderSupport.parseBreaks(breakDef);
        if (breaks == null || breaks.isEmpty()) {
            retval.add(name);
            return retval;
        }
        int nameLen = name.length();
        int lastBreak = 0;
        int size = breaks.size();
        for (int i = 0; i < size; ++i) {
            int nextBreak = (Integer)breaks.get(i);
            if (nextBreak >= nameLen) {
                retval.add(name.substring(lastBreak, nameLen));
                return retval;
            }
            retval.add(name.substring(lastBreak, nextBreak));
            lastBreak = nextBreak;
        }
        retval.add(name.substring(lastBreak, name.length()));
        return retval;
    }

    public static List parseBreaks(String breakDef) {
        if (breakDef == null) {
            return null;
        }
        String[] toks = breakDef.split(":");
        ArrayList<Integer> retval = new ArrayList<Integer>();
        for (int i = 0; i < toks.length; ++i) {
            Integer val;
            try {
                val = Integer.valueOf(toks[i]);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException();
            }
            retval.add(val);
        }
        return retval;
    }

    public static Dimension textRect(String breakDef, String text, Rectangle2D charRect) {
        List breaks = MultiLineRenderSupport.parseBreaks(breakDef);
        int textLen = text.length();
        if (breaks == null) {
            Dimension dim = new Dimension((int)charRect.getWidth() * textLen, (int)charRect.getHeight());
            return dim;
        }
        int numBr = breaks.size();
        int lastBr = 0;
        int maxDiff = Integer.MIN_VALUE;
        for (int i = 0; i < numBr; ++i) {
            Integer brk = (Integer)breaks.get(i);
            int brkVal = brk;
            int diff = brkVal - lastBr;
            if (diff > maxDiff) {
                maxDiff = diff;
            }
            lastBr = brkVal;
        }
        int lastDiff = textLen - lastBr - 1;
        if (lastDiff > maxDiff) {
            maxDiff = lastDiff;
        }
        Dimension dim = new Dimension((int)charRect.getWidth() * maxDiff, (int)charRect.getHeight() * (numBr + 1));
        return dim;
    }

    public static Rectangle2D multiLineGuts(FontRenderContext frc, String[] toks, Font mFont, Point2D origin, TextLayout[] tls, float[] ylocs, float[] widths, Point2D startPt) {
        if (toks.length == 0) {
            return null;
        }
        float currY = 0.0f;
        float maxWidth = Float.NEGATIVE_INFINITY;
        float midY = 0.0f;
        boolean isOdd = toks.length % 2 == 1;
        int midi = isOdd ? toks.length / 2 - 1 : toks.length / 2;
        float firstY = 0.0f;
        for (int i = 0; i < toks.length; ++i) {
            float nextY;
            float width;
            String frag = toks[i];
            if (frag.length() == 0) {
                frag = " ";
            }
            TextLayout tl = new TextLayout(frag, mFont, frc);
            try {
                width = tl.getAdvance();
                nextY = tl.getAscent() + tl.getDescent() + tl.getLeading();
            }
            catch (Exception ex) {
                Rectangle2D bounds = mFont.getStringBounds(frag, frc);
                width = (float)bounds.getWidth();
                nextY = (float)bounds.getHeight();
            }
            if (width > maxWidth) {
                maxWidth = width;
            }
            if (i == midi) {
                midY = isOdd ? currY + nextY / 2.0f : currY + nextY / 3.0f;
            }
            currY += nextY;
            if (i == 0) {
                firstY = currY;
            }
            if (tls != null) {
                tls[i] = tl;
            }
            if (widths != null) {
                widths[i] = width;
            }
            if (ylocs == null) continue;
            ylocs[i] = currY;
        }
        float ox = (float)origin.getX();
        float oy = (float)origin.getY();
        float rx = ox - maxWidth / 2.0f;
        float ul = oy - midY;
        if (startPt != null) {
            startPt.setLocation(rx, ul);
        }
        Rectangle2D.Float rect = new Rectangle2D.Float(rx, ul + firstY / 3.0f, maxWidth, currY);
        return rect;
    }

    public static Rectangle2D multiLineRender(Graphics2D g2, FontRenderContext frc, String[] toks, Font mFont, Point2D origin, boolean selected, int justification, Color col) {
        float currY = 0.0f;
        TextLayout[] tls = new TextLayout[toks.length];
        float[] ylocs = new float[toks.length];
        float[] widths = new float[toks.length];
        Point2D.Double startPt = new Point2D.Double();
        Rectangle2D rect = MultiLineRenderSupport.multiLineGuts(frc, toks, mFont, origin, tls, ylocs, widths, startPt);
        if (selected) {
            g2.setPaint(Color.orange);
            g2.fill(rect);
        }
        float ox = (float)origin.getX();
        float oy = (float)origin.getY();
        float maxWidth = (float)rect.getWidth();
        float ul = (float)((Point2D)startPt).getY();
        g2.setPaint(col);
        g2.setFont(mFont);
        for (int i = 0; i < toks.length; ++i) {
            float drawX;
            String frag = toks[i];
            switch (justification) {
                case 1: {
                    drawX = ox - widths[i] / 2.0f;
                    break;
                }
                case 2: {
                    drawX = ox + maxWidth / 2.0f - widths[i];
                    break;
                }
                case 0: {
                    drawX = ox - maxWidth / 2.0f;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            tls[i].draw(g2, drawX, ul + ylocs[i]);
        }
        return rect;
    }

    public static String buildBreaks(List breakVals) {
        if (breakVals.isEmpty()) {
            return null;
        }
        int num = breakVals.size();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < num; ++i) {
            Integer bVal = (Integer)breakVals.get(i);
            buf.append(bVal);
            if (i == num - 1) continue;
            buf.append(":");
        }
        return buf.toString();
    }

    public static String stripBreaks(String brokenName) {
        return brokenName.replaceAll("\n", "");
    }

    public static String breaksToWhitespace(String brokenName) {
        return brokenName.replaceAll("\n", " ");
    }

    public static String genBreaks(String brokenName) {
        StringBuffer buf = new StringBuffer();
        String[] toks = brokenName.split("\n");
        int count = 0;
        for (int i = 0; i < toks.length - 1; ++i) {
            buf.append(count += toks[i].length());
            if (i == toks.length - 2) continue;
            buf.append(":");
        }
        if (buf.length() == 0) {
            return null;
        }
        return buf.toString();
    }

    public static Vector getJustifyTypes() {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        for (int i = 0; i < 3; ++i) {
            retval.add(MultiLineRenderSupport.justForCombo(i));
        }
        return retval;
    }

    public static ChoiceContent justForCombo(int type) {
        return new ChoiceContent(MultiLineRenderSupport.mapJustToDisplay(type), type);
    }

    public static String mapJustToDisplay(int just) {
        String justTag = MultiLineRenderSupport.mapToJustTag(just);
        return ResourceManager.getManager().getString("ntProp." + justTag);
    }

    public static String mapToJustTag(int val) {
        switch (val) {
            case 0: {
                return LEFT_JUST_STR_;
            }
            case 1: {
                return CENTER_JUST_STR_;
            }
            case 2: {
                return RIGHT_JUST_STR_;
            }
        }
        throw new IllegalStateException();
    }

    public static int mapFromJustTag(String tag) {
        if (tag.equals(LEFT_JUST_STR_)) {
            return 0;
        }
        if (tag.equals(CENTER_JUST_STR_)) {
            return 1;
        }
        if (tag.equals(RIGHT_JUST_STR_)) {
            return 2;
        }
        throw new IllegalArgumentException();
    }
}

