/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.io.IOException;
import java.io.PrintWriter;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

public class NameValuePair
implements Cloneable {
    private String name_;
    private String value_;

    public NameValuePair(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException();
        }
        this.name_ = name;
        this.value_ = value;
    }

    NameValuePair(String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.name_ = name;
    }

    void setValue(String value) throws IOException {
        this.value_ = value;
    }

    public Object clone() {
        try {
            NameValuePair newPair = (NameValuePair)super.clone();
            return newPair;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public int hashCode() {
        return this.name_.hashCode() + this.value_.hashCode();
    }

    public String getName() {
        return this.name_;
    }

    public String getValue() {
        return this.value_;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof NameValuePair)) {
            return false;
        }
        NameValuePair otherNVP = (NameValuePair)other;
        return this.name_.equals(otherNVP.name_) && this.value_.equals(otherNVP.value_);
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<nameValPair name=\"");
        out.print(CharacterEntityMapper.mapEntities(this.name_, false));
        out.print("\" >");
        out.print(CharacterEntityMapper.mapEntities(this.value_, false));
        out.println("</nameValPair>");
    }

    public String toString() {
        return "name: " + this.name_ + " value: " + this.value_;
    }

    public static class NameValPairWorker
    extends AbstractFactoryClient {
        private StringBuffer charBuf_;

        public NameValPairWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("nameValPair");
            this.charBuf_ = new StringBuffer();
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            NameValuePair retval = null;
            if (elemName.equals("nameValPair")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.nvPair = this.buildFromXML(elemName, attrs);
                this.charBuf_.setLength(0);
            }
            return retval;
        }

        protected void localFinishElement(String elemName) throws IOException {
            if (elemName.equals("nameValPair")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                board.nvPair.setValue(CharacterEntityMapper.unmapEntities(this.charBuf_.toString(), false));
            }
        }

        protected void localProcessCharacters(char[] chars, int start, int length) {
            String nextString = new String(chars, start, length);
            this.charBuf_.append(nextString);
        }

        private NameValuePair buildFromXML(String elemName, Attributes attrs) throws IOException {
            String name = AttributeExtractor.extractAttribute(elemName, attrs, "nameValPair", "name", true);
            name = CharacterEntityMapper.unmapEntities(name, false);
            return new NameValuePair(name);
        }
    }
}

