/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.util.HashSet;
import java.util.Set;
import org.systemsbiology.biotapestry.util.MinMax;

public class Pattern {
    private String[][] pattern_;
    private int height_;
    private int width_;
    private String val_;

    public Pattern(int w, int h) {
        if (w <= 0 || h <= 0) {
            throw new IllegalArgumentException();
        }
        this.pattern_ = new String[w][h];
    }

    public Pattern(int w, int h, String val) {
        if (w <= 0 || h <= 0 || val == null) {
            throw new IllegalArgumentException();
        }
        this.height_ = h;
        this.width_ = w;
        this.val_ = val;
    }

    public boolean isFilledBox() {
        if (this.pattern_ == null) {
            return true;
        }
        int height = this.getHeight();
        int width = this.getWidth();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (this.pattern_[x][y] != null) continue;
                return false;
            }
        }
        return this.getValues().size() <= 1;
    }

    public int getHeight() {
        return this.pattern_ != null ? this.pattern_[0].length : this.height_;
    }

    public int getWidth() {
        return this.pattern_ != null ? this.pattern_.length : this.width_;
    }

    public MinMax getHeightRange() {
        int height = this.getHeight();
        if (this.pattern_ == null) {
            return new MinMax(0, height - 1);
        }
        int width = this.getWidth();
        int minValue = Integer.MAX_VALUE;
        int maxValue = Integer.MIN_VALUE;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (this.pattern_[x][y] == null) continue;
                if (y < minValue) {
                    minValue = y;
                }
                if (y <= maxValue) continue;
                maxValue = y;
            }
        }
        if (minValue == Integer.MAX_VALUE || maxValue == Integer.MIN_VALUE) {
            return null;
        }
        return new MinMax(minValue, maxValue);
    }

    public MinMax getWidthRange() {
        int width = this.getWidth();
        if (this.pattern_ == null) {
            return new MinMax(0, width - 1);
        }
        int minValue = Integer.MAX_VALUE;
        int maxValue = Integer.MIN_VALUE;
        int height = this.getHeight();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (this.pattern_[x][y] == null) continue;
                if (x < minValue) {
                    minValue = x;
                }
                if (x <= maxValue) continue;
                maxValue = x;
            }
        }
        if (minValue == Integer.MAX_VALUE || maxValue == Integer.MIN_VALUE) {
            return null;
        }
        return new MinMax(minValue, maxValue);
    }

    public void fill(int x, int y, String val) {
        if (this.pattern_ == null) {
            throw new IllegalStateException();
        }
        this.pattern_[x][y] = val;
    }

    public void fillAll(String val) {
        if (this.pattern_ == null) {
            if (val == null) {
                throw new IllegalArgumentException();
            }
            this.val_ = val;
            return;
        }
        int height = this.getHeight();
        int width = this.getWidth();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                this.pattern_[x][y] = val;
            }
        }
    }

    public String getValue(int x, int y) {
        if (this.pattern_ == null) {
            if (x < 0 || y < 0 || x >= this.width_ || y >= this.height_) {
                throw new IllegalArgumentException();
            }
            return this.val_;
        }
        return this.pattern_[x][y];
    }

    public Set getValues() {
        HashSet<String> retval = new HashSet<String>();
        if (this.pattern_ == null) {
            if (this.val_ == null) {
                throw new IllegalStateException();
            }
            retval.add(this.val_);
        }
        int height = this.getHeight();
        int width = this.getWidth();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                String val = this.pattern_[x][y];
                if (val == null) continue;
                retval.add(val);
            }
        }
        return retval;
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        int height = this.getHeight();
        int width = this.getWidth();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                String val = this.pattern_ == null ? this.val_ : this.pattern_[x][y];
                retval.append(val == null ? (char)' ' : val.charAt(val.length() - 1));
            }
            retval.append("\n");
        }
        return retval.toString();
    }
}

