/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.Pattern;

public class PatternGrid {
    private HashMap pattern_ = new HashMap();
    private ArrayList rects_;

    public PatternGrid() {
        this.rects_ = new ArrayList();
    }

    public PatternGrid(PatternGrid other) {
        Iterator kit = other.pattern_.keySet().iterator();
        while (kit.hasNext()) {
            Point pt = (Point)kit.next();
            String gval = (String)other.pattern_.get(pt);
            this.pattern_.put(new Point(pt), gval);
        }
        this.rects_ = new ArrayList();
        int numRect = other.rects_.size();
        for (int i = 0; i < numRect; ++i) {
            RectWithID rect = (RectWithID)other.rects_.get(i);
            this.rects_.add(new RectWithID(rect));
        }
    }

    public void fill(int x, int y, String val) {
        if (val == null) {
            throw new IllegalArgumentException();
        }
        Point pt = new Point(x, y);
        this.pattern_.put(pt, val);
    }

    public String getValue(int x, int y) {
        Point pt = new Point(x, y);
        String retval = (String)this.pattern_.get(pt);
        if (retval != null) {
            return retval;
        }
        int numRect = this.rects_.size();
        for (int i = 0; i < numRect; ++i) {
            RectWithID rectwid = (RectWithID)this.rects_.get(i);
            Rectangle rect = rectwid.rect;
            if (x < rect.x || y < rect.y || x >= rect.x + rect.width || y >= rect.y + rect.height) continue;
            return rectwid.id;
        }
        return null;
    }

    public Point getLocation(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Iterator kit = this.pattern_.keySet().iterator();
        while (kit.hasNext()) {
            Point pt = (Point)kit.next();
            String gval = (String)this.pattern_.get(pt);
            if (!value.equals(gval)) continue;
            return pt;
        }
        int numRect = this.rects_.size();
        for (int i = 0; i < numRect; ++i) {
            RectWithID rect = (RectWithID)this.rects_.get(i);
            if (!value.equals(rect.id)) continue;
            return new Point(rect.rect.x, rect.rect.y);
        }
        return null;
    }

    public void conditionalFill(int x, int y, String val) {
        if (val == null) {
            return;
        }
        this.fill(x, y, val);
    }

    public void place(Pattern pat, int px, int py) {
        int maxX = pat.getWidth();
        int maxY = pat.getHeight();
        if (pat.isFilledBox()) {
            String val;
            if (maxX > 0 && maxY > 0 && (val = pat.getValue(0, 0)) != null) {
                Rectangle rect = new Rectangle(px, py, maxX, maxY);
                RectWithID rwid = new RectWithID(val, rect);
                this.rects_.add(0, rwid);
            }
            Point pt = new Point(0, 0);
            for (int x = 0; x < maxX; ++x) {
                for (int y = 0; y < maxY; ++y) {
                    pt.setLocation(px + x, py + y);
                    if (!this.pattern_.containsKey(pt)) continue;
                    this.pattern_.remove(pt);
                }
            }
            return;
        }
        for (int x = 0; x < maxX; ++x) {
            for (int y = 0; y < maxY; ++y) {
                this.conditionalFill(px + x, py + y, pat.getValue(x, y));
            }
        }
    }

    public PatternGrid nondestructivePlace(Pattern pat, int px, int py) {
        PatternGrid retval = new PatternGrid(this);
        retval.place(pat, px, py);
        return retval;
    }

    public boolean emptyIntersection(Pattern pat, int px, int py) {
        int maxX = pat.getWidth();
        int maxY = pat.getHeight();
        if (pat.isFilledBox() && this.pattern_.isEmpty()) {
            Rectangle pRect = new Rectangle(px, py, maxX, maxY);
            int numRect = this.rects_.size();
            for (int i = 0; i < numRect; ++i) {
                RectWithID rect = (RectWithID)this.rects_.get(i);
                if (!rect.rect.intersects(pRect)) continue;
                return false;
            }
            return true;
        }
        for (int x = 0; x < maxX; ++x) {
            for (int y = 0; y < maxY; ++y) {
                String patValue = pat.getValue(x, y);
                String myValue = this.getValue(px + x, py + y);
                if (patValue == null || myValue == null) continue;
                return false;
            }
        }
        return true;
    }

    public MinMax getMinMaxYForRange(MinMax xRange) {
        int minValue = Integer.MAX_VALUE;
        int maxValue = Integer.MIN_VALUE;
        Iterator kit = this.pattern_.keySet().iterator();
        while (kit.hasNext()) {
            Point pt = (Point)kit.next();
            String gval = (String)this.pattern_.get(pt);
            if (gval == null || xRange != null && (pt.x < xRange.min || pt.x > xRange.max)) continue;
            if (pt.y < minValue) {
                minValue = pt.y;
            }
            if (pt.y <= maxValue) continue;
            maxValue = pt.y;
        }
        int numRect = this.rects_.size();
        for (int i = 0; i < numRect; ++i) {
            int hiVal;
            RectWithID rectwid = (RectWithID)this.rects_.get(i);
            Rectangle rect = rectwid.rect;
            if (rect.y < minValue) {
                minValue = rect.y;
            }
            if ((hiVal = rect.y + rect.height - 1) <= maxValue) continue;
            maxValue = hiVal;
        }
        if (minValue == Integer.MAX_VALUE || maxValue == Integer.MIN_VALUE) {
            return null;
        }
        return new MinMax(minValue, maxValue);
    }

    public MinMax getMinMaxXForRange(MinMax yRange) {
        int minValue = Integer.MAX_VALUE;
        int maxValue = Integer.MIN_VALUE;
        Iterator kit = this.pattern_.keySet().iterator();
        while (kit.hasNext()) {
            Point pt = (Point)kit.next();
            String gval = (String)this.pattern_.get(pt);
            if (gval == null || yRange != null && (pt.y < yRange.min || pt.y > yRange.max)) continue;
            if (pt.x < minValue) {
                minValue = pt.x;
            }
            if (pt.x <= maxValue) continue;
            maxValue = pt.x;
        }
        int numRect = this.rects_.size();
        for (int i = 0; i < numRect; ++i) {
            int hiVal;
            RectWithID rectwid = (RectWithID)this.rects_.get(i);
            Rectangle rect = rectwid.rect;
            if (rect.x < minValue) {
                minValue = rect.x;
            }
            if ((hiVal = rect.x + rect.width - 1) <= maxValue) continue;
            maxValue = hiVal;
        }
        if (minValue == Integer.MAX_VALUE || maxValue == Integer.MIN_VALUE) {
            return null;
        }
        return new MinMax(minValue, maxValue);
    }

    public Pattern generatePattern() {
        MinMax yRange = this.getMinMaxYForRange(null);
        MinMax xRange = this.getMinMaxXForRange(null);
        if (yRange == null || xRange == null) {
            return null;
        }
        Pattern retval = new Pattern(xRange.max - xRange.min + 1, yRange.max - yRange.min + 1);
        int yVal = 0;
        for (int i = yRange.min; i <= yRange.max; ++i) {
            int xVal = 0;
            for (int j = xRange.min; j <= xRange.max; ++j) {
                String val = this.getValue(j, i);
                if (val != null) {
                    retval.fill(xVal, yVal, val);
                }
                ++xVal;
            }
            ++yVal;
        }
        return retval;
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        MinMax mmY = this.getMinMaxYForRange(null);
        MinMax mmX = this.getMinMaxXForRange(null);
        retval.append("X range = ");
        retval.append(mmX != null ? mmX.min : 0);
        retval.append(" ");
        retval.append(mmX != null ? mmX.max : 0);
        retval.append(" Y range = ");
        retval.append(mmY != null ? mmY.min : 0);
        retval.append(" ");
        retval.append(mmY != null ? mmY.max : 0);
        retval.append("\n");
        if (mmY == null || mmX == null) {
            return retval.toString();
        }
        for (int i = mmY.min; i <= mmY.max; ++i) {
            for (int j = mmX.min; j <= mmX.max; ++j) {
                String val = this.getValue(j, i);
                retval.append(val == null ? (char)' ' : val.charAt(val.length() - 1));
            }
            retval.append("\n");
        }
        return retval.toString();
    }

    private static class RectWithID {
        String id;
        Rectangle rect;

        RectWithID(String id, Rectangle rect) {
            this.id = id;
            this.rect = (Rectangle)rect.clone();
        }

        RectWithID(RectWithID other) {
            this.id = other.id;
            this.rect = (Rectangle)other.rect.clone();
        }
    }
}

