/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class PatternPaint
implements Paint {
    public static final int FORWARD_DIAGONAL_LINES = 0;
    public static final int BACKWARD_DENSE_DIAGONAL_LINES = 1;
    public static final int DOTS = 2;
    private int patternType_;
    private Color patternColor_;

    public PatternPaint(int patternType, Color patternColor) {
        this.patternType_ = patternType;
        this.patternColor_ = patternColor;
    }

    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        return new PatternPaintContext(this.patternType_, this.patternColor_);
    }

    public int getTransparency() {
        return 1;
    }

    public static class PatternPaintContext
    implements PaintContext {
        private int patternType_;
        private Color patternColor_;

        public PatternPaintContext(int patternType, Color patternColor) {
            this.patternType_ = patternType;
            this.patternColor_ = patternColor;
        }

        public void dispose() {
        }

        public ColorModel getColorModel() {
            return new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
        }

        public Raster getRaster(int x, int y, int w, int h) {
            int pcRed = this.patternColor_.getRed();
            int pcGreen = this.patternColor_.getGreen();
            int pcBlue = this.patternColor_.getBlue();
            Color white = Color.white;
            int bgRed = white.getRed();
            int bgGreen = white.getGreen();
            int bgBlue = white.getBlue();
            WritableRaster wr = this.getColorModel().createCompatibleWritableRaster(w, h);
            int[] data = new int[4];
            switch (this.patternType_) {
                case 0: {
                    for (int j = 0; j < h; ++j) {
                        for (int i = 0; i < w; ++i) {
                            int patPos = (x + y + i + j) % 8;
                            boolean isPat = patPos >= 0 && patPos <= 1;
                            int base = 0;
                            data[base] = isPat ? pcRed : bgRed;
                            data[base + 1] = isPat ? pcGreen : bgGreen;
                            data[base + 2] = isPat ? pcBlue : bgBlue;
                            data[base + 3] = 255;
                            wr.setPixel(i, j, data);
                        }
                    }
                    break;
                }
                case 1: {
                    for (int j = 0; j < h; ++j) {
                        for (int i = 0; i < w; ++i) {
                            int patPos = (3 - (x + i) % 4 + y + j) % 4;
                            boolean isPat = patPos >= 2 && patPos <= 3;
                            int base = 0;
                            data[base] = isPat ? pcRed : bgRed;
                            data[base + 1] = isPat ? pcGreen : bgGreen;
                            data[base + 2] = isPat ? pcBlue : bgBlue;
                            data[base + 3] = 255;
                            wr.setPixel(i, j, data);
                        }
                    }
                    break;
                }
                case 2: {
                    for (int j = 0; j < h; ++j) {
                        for (int i = 0; i < w; ++i) {
                            int patPos = (3 - (x + i) % 4 + y + j) % 4;
                            int patLine = (y + j) % 2;
                            boolean isPat = patPos >= 2 && patPos <= 3 && patLine == 0;
                            int base = 0;
                            data[base] = isPat ? pcRed : bgRed;
                            data[base + 1] = isPat ? pcGreen : bgGreen;
                            data[base + 2] = isPat ? pcBlue : bgBlue;
                            data[base + 3] = 255;
                            wr.setPixel(i, j, data);
                        }
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return wr;
        }
    }
}

