/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.Point;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.Pattern;
import org.systemsbiology.biotapestry.util.PatternGrid;

public class PatternPlacerMinimizeHeight {
    private PatternGrid grid_;
    private Pattern pattern_;
    private int leftColumn_;
    private int stepSize_;

    public PatternPlacerMinimizeHeight(PatternGrid grid, Pattern pattern, int leftColumn) {
        this(grid, pattern, leftColumn, 1);
    }

    public PatternPlacerMinimizeHeight(PatternGrid grid, Pattern pattern, int leftColumn, int stepSize) {
        this.grid_ = grid;
        this.pattern_ = pattern;
        this.leftColumn_ = leftColumn;
        this.stepSize_ = stepSize;
    }

    public Point placePattern() {
        MinMax minMax = this.grid_.getMinMaxYForRange(null);
        if (minMax == null) {
            this.grid_.place(this.pattern_, this.leftColumn_, 0);
            return new Point(this.leftColumn_, 0);
        }
        MinMax patColRange = this.pattern_.getWidthRange();
        if (patColRange == null) {
            throw new IllegalStateException();
        }
        int minCol = this.leftColumn_ + patColRange.min;
        int maxCol = this.leftColumn_ + patColRange.max;
        MinMax minMaxForCols = this.grid_.getMinMaxYForRange(new MinMax(minCol, maxCol));
        MinMax patRowRange = this.pattern_.getHeightRange();
        if (patRowRange == null) {
            throw new IllegalStateException();
        }
        if (minMaxForCols == null) {
            int placeRow = minMax.min - patRowRange.min;
            this.grid_.place(this.pattern_, this.leftColumn_, placeRow);
            return new Point(this.leftColumn_, placeRow);
        }
        int currY = minMaxForCols.min - this.pattern_.getHeight() + patRowRange.min;
        while (true) {
            if (this.grid_.emptyIntersection(this.pattern_, this.leftColumn_, currY)) {
                PatternGrid testGrid = this.grid_.nondestructivePlace(this.pattern_, this.leftColumn_, currY);
                MinMax testMinMax = testGrid.getMinMaxYForRange(null);
                if (testMinMax == null) {
                    throw new IllegalStateException();
                }
                if (testMinMax.min >= minMax.min) {
                    this.grid_.place(this.pattern_, this.leftColumn_, currY);
                    return new Point(this.leftColumn_, currY);
                }
            }
            currY += this.stepSize_;
        }
    }
}

