/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.Point;
import org.systemsbiology.biotapestry.util.Pattern;
import org.systemsbiology.biotapestry.util.PatternGrid;

public class PatternPlacerSpiral {
    public static final int CW = 0;
    public static final int RIGHT_ONLY = 1;
    public static final int UP = 10;
    private PatternGrid grid_;
    private Pattern pattern_;
    private Point initialPoint_;
    private int padding_;
    private int leftColumn_;
    private int mode_;
    private int direction_;

    public PatternPlacerSpiral(PatternGrid grid, Pattern pattern, Point initialPoint, int mode, int direction) {
        this.grid_ = grid;
        this.pattern_ = pattern;
        this.initialPoint_ = (Point)initialPoint.clone();
        this.mode_ = mode;
        this.direction_ = direction;
        if (this.direction_ != 10) {
            throw new IllegalArgumentException();
        }
        if (this.mode_ != 0 && this.mode_ != 1) {
            throw new IllegalArgumentException();
        }
    }

    public Point placePattern() {
        Point retval = this.locatePattern();
        this.grid_.place(this.pattern_, retval.x, retval.y);
        return retval;
    }

    public void sinkPattern(Point leftCorner) {
        this.grid_.place(this.pattern_, leftCorner.x, leftCorner.y);
    }

    public Point locatePattern() {
        SpiralState ss = this.mode_ == 0 ? new CircleState(this.initialPoint_) : new SweepState(this.initialPoint_);
        if (this.grid_.emptyIntersection(this.pattern_, this.initialPoint_.x, this.initialPoint_.y)) {
            return new Point(this.initialPoint_);
        }
        Point fillPoint = new Point();
        do {
            ss.next(fillPoint);
        } while (!this.grid_.emptyIntersection(this.pattern_, fillPoint.x, fillPoint.y));
        return new Point(fillPoint);
    }

    public static void main(String[] argv) {
        int i;
        SpiralState ss = new CircleState(new Point(0, 0));
        Point fillPoint = new Point();
        for (i = 0; i < 50; ++i) {
            System.out.println(ss.next(fillPoint));
        }
        System.out.println("-------------------------------------");
        ss = new SweepState(new Point(0, 0));
        fillPoint = new Point();
        for (i = 0; i < 50; ++i) {
            System.out.println(ss.next(fillPoint));
        }
    }

    private static class SweepState
    extends SpiralState {
        private int phase;
        private int sign;
        private int radius;
        private int remaining;

        SweepState(Point origin) {
            this.currPt_ = (Point)origin.clone();
            this.phase = 0;
            this.sign = -1;
            this.radius = 1;
            this.remaining = 0;
        }

        Point next(Point toFill) {
            int[] delta = new int[2];
            int pad = this.sign == -1 ? 0 : 1;
            switch (this.phase) {
                case 0: {
                    delta[0] = 0;
                    delta[1] = 1 * this.sign;
                    this.phase = 1;
                    this.remaining = this.radius + pad;
                    break;
                }
                case 1: {
                    delta[0] = 1;
                    delta[1] = 0;
                    if (--this.remaining != 0) break;
                    this.phase = 2;
                    this.remaining = 2 * (this.radius + pad);
                    break;
                }
                case 2: {
                    delta[0] = 0;
                    delta[1] = -1 * this.sign;
                    if (--this.remaining != 0) break;
                    this.phase = 3;
                    this.remaining = this.radius + pad;
                    break;
                }
                case 3: {
                    delta[0] = -1;
                    delta[1] = 0;
                    if (--this.remaining != 0) break;
                    this.phase = 0;
                    if (this.sign == 1) {
                        this.radius += 2;
                    }
                    this.sign *= -1;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.currPt_.x += delta[0];
            this.currPt_.y += delta[1];
            toFill.x = this.currPt_.x;
            toFill.y = this.currPt_.y;
            return toFill;
        }
    }

    private static class CircleState
    extends SpiralState {
        private int runLen_;
        private int runRemains_;
        private int runPhase_;
        private int runIndex_;
        private int[] patternX_;
        private int[] patternY_;

        CircleState(Point origin) {
            this.currPt_ = (Point)origin.clone();
            this.patternX_ = new int[]{0, 1, 0, -1};
            this.patternY_ = new int[]{-1, 0, 1, 0};
            this.runLen_ = 1;
            this.runRemains_ = 1;
            this.runIndex_ = 0;
            this.runPhase_ = 0;
        }

        Point next(Point toFill) {
            if (this.runRemains_ == 0) {
                this.runIndex_ = (this.runIndex_ + 1) % 4;
                if (this.runPhase_ == 1) {
                    ++this.runLen_;
                    this.runPhase_ = 0;
                } else {
                    this.runPhase_ = 1;
                }
                this.runRemains_ = this.runLen_ - 1;
            } else {
                --this.runRemains_;
            }
            this.currPt_.x += this.patternX_[this.runIndex_];
            this.currPt_.y += this.patternY_[this.runIndex_];
            toFill.x = this.currPt_.x;
            toFill.y = this.currPt_.y;
            return toFill;
        }
    }

    private static abstract class SpiralState {
        protected Point currPt_;

        private SpiralState() {
        }

        abstract Point next(Point var1);
    }
}

