/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.Point;
import org.systemsbiology.biotapestry.util.Pattern;
import org.systemsbiology.biotapestry.util.PatternGrid;

public class PatternPlacerVerticalFit {
    private PatternGrid grid_;
    private Pattern pattern_;
    private int targetRow_;
    private int leftColumn_;

    public PatternPlacerVerticalFit(PatternGrid grid, Pattern pattern, int targetRow, int leftColumn) {
        this.grid_ = grid;
        this.pattern_ = pattern;
        this.targetRow_ = targetRow;
        this.leftColumn_ = leftColumn;
    }

    public Point placePattern() {
        int bestBelow = Integer.MAX_VALUE;
        int currY = this.targetRow_;
        while (true) {
            if (this.grid_.emptyIntersection(this.pattern_, this.leftColumn_, currY)) break;
            --currY;
        }
        bestBelow = currY;
        if (bestBelow == Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        if (bestBelow == this.targetRow_) {
            this.grid_.place(this.pattern_, this.leftColumn_, this.targetRow_);
            return new Point(this.leftColumn_, this.targetRow_);
        }
        int maxY = this.targetRow_ + (this.targetRow_ - bestBelow);
        int bestHigh = Integer.MIN_VALUE;
        for (currY = this.targetRow_; currY < maxY; ++currY) {
            if (!this.grid_.emptyIntersection(this.pattern_, this.leftColumn_, currY)) continue;
            bestHigh = currY;
            break;
        }
        int bestRow = bestHigh == Integer.MIN_VALUE ? bestBelow : bestHigh;
        this.grid_.place(this.pattern_, this.leftColumn_, bestRow);
        return new Point(this.leftColumn_, bestRow);
    }
}

