/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.Point;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.Pattern;
import org.systemsbiology.biotapestry.util.PatternGrid;

public class PatternPlacerVerticalNesting {
    private PatternGrid grid_;
    private Pattern pattern_;
    private boolean onTop_;
    private int padding_;
    private int leftColumn_;

    public PatternPlacerVerticalNesting(PatternGrid grid, Pattern pattern, int leftColumn, int padding, boolean onTop) {
        this.grid_ = grid;
        this.pattern_ = pattern;
        this.onTop_ = onTop;
        this.padding_ = padding;
        this.leftColumn_ = leftColumn;
    }

    public Point placePattern() {
        Point retval = this.locatePattern();
        this.grid_.place(this.pattern_, this.leftColumn_, retval.y);
        return retval;
    }

    public void sinkPattern(Point leftCorner) {
        this.grid_.place(this.pattern_, this.leftColumn_, leftCorner.y);
    }

    public Point locatePattern() {
        int end;
        int sign;
        int currY;
        MinMax yRange = this.grid_.getMinMaxYForRange(null);
        int topY = yRange.min - this.pattern_.getHeight() - 5;
        int botY = yRange.max + 5;
        int midY = (yRange.max + yRange.min) / 2 - this.pattern_.getHeight() / 2;
        if (this.onTop_) {
            currY = topY;
            sign = 1;
            end = botY;
        } else {
            currY = botY;
            sign = -1;
            end = topY;
        }
        while (true) {
            if (!this.grid_.emptyIntersection(this.pattern_, this.leftColumn_, currY)) {
                int placeRow = currY - sign * this.padding_;
                return new Point(this.leftColumn_, placeRow);
            }
            if (currY == end) {
                return null;
            }
            currY += sign;
        }
    }
}

