/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.systemsbiology.biotapestry.ui.LinkProperties;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.util.LinkPlacementGrid;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;

public class RecoveryDOFAnalyzer {
    private boolean haveOrthoPoints_;
    private boolean haveOrthoCorner_;
    private boolean gottaBeOrtho_;
    private boolean cornerGottaBeOrtho_;
    private List threePts_;
    private DOFOption firstPointOption_;
    private boolean returnFirstPoint_;
    private DOFOption secondPointOption_;
    private boolean returnSecondPoint_;
    private LinkPlacementGrid.RecoveryDataForLink recoverForLink_;
    private int currDepth_;
    private Point2D targ_;
    private LinkPlacementGrid.TravelTurn turn_;
    private String src_;
    private String trg_;
    private String linkID_;
    private HashSet okGroups_;
    private Set recoveryExemptions_;
    private boolean isStart_;
    private LinkPlacementGrid grid_;
    private List dualPtList_;
    private Point2D newPt_;
    private boolean modifyFirst_;
    private boolean pointIsFirst_;
    private int cornerDepth_;
    private ArrayList answerList_;

    public RecoveryDOFAnalyzer(LinkPlacementGrid grid, boolean gottaBeOrtho, boolean cornerGottaBeOrtho, LinkPlacementGrid.RecoveryDataForLink recoverForLink, int currDepth, Point2D targ, LinkPlacementGrid.TravelTurn turn, String src, String trg, String linkID, Set okGroups, Set recoveryExemptions, boolean isStart) {
        this.grid_ = grid;
        this.targ_ = targ;
        this.turn_ = turn;
        this.gottaBeOrtho_ = gottaBeOrtho;
        this.cornerGottaBeOrtho_ = cornerGottaBeOrtho;
        this.recoverForLink_ = recoverForLink;
        this.currDepth_ = currDepth;
        this.src_ = src;
        this.trg_ = trg;
        this.linkID_ = linkID;
        this.okGroups_ = okGroups == null ? null : new HashSet(okGroups);
        this.recoveryExemptions_ = recoveryExemptions;
        this.isStart_ = isStart;
        this.threePts_ = this.grid_.buildRecoverPointList(turn.start, targ, this.recoverForLink_, this.currDepth_);
        this.haveOrthoPoints_ = this.threePts_ == null ? false : this.grid_.recoverPointListStartsOrtho(this.threePts_);
        this.haveOrthoCorner_ = this.haveOrthoPoints_ && this.grid_.recoverPointListIsOrtho(this.threePts_);
        this.firstPointOption_ = null;
        this.returnFirstPoint_ = false;
        this.secondPointOption_ = null;
        this.returnSecondPoint_ = false;
        this.dualPtList_ = null;
        this.newPt_ = null;
        this.modifyFirst_ = false;
        this.pointIsFirst_ = false;
        this.cornerDepth_ = 0;
        this.answerList_ = new ArrayList();
    }

    public List generateDOFOptions() {
        ArrayList retval = new ArrayList();
        if (!this.analyzeFirstPoint(retval)) {
            return retval;
        }
        if (!this.needCornerPointAnalysis()) {
            this.cleanUpForReturn(retval);
            return retval;
        }
        if (!this.prepareCornerAnalysis()) {
            this.cleanUpForReturn(retval);
            return retval;
        }
        if (!this.doCornerAnalysis()) {
            this.cleanUpForReturn(retval);
            return retval;
        }
        this.cleanUpForReturn(retval);
        return retval;
    }

    private boolean analyzeFirstPoint(ArrayList dofResults) {
        LinkSegmentID lsid;
        Point2D newPt;
        LinkProperties.CornerDoF dof;
        if (this.gottaBeOrtho_ && !this.haveOrthoPoints_ && (dof = this.grid_.getCornerDoF(this.recoverForLink_, this.currDepth_)) != null && (newPt = this.generateDownstreamOrthoCandidate(dof, this.currDepth_)) != null && (lsid = this.recoverForLink_.getPointKey(this.currDepth_)) != null && this.recoverForLink_.revisedPointCanBePushed(lsid)) {
            boolean nowHaveOrthoPoints;
            this.recoverForLink_.pushRevisedPoint(lsid, newPt);
            this.firstPointOption_ = new DOFOption(lsid, newPt);
            this.threePts_ = this.grid_.buildRecoverPointList(this.turn_.start, this.targ_, this.recoverForLink_, this.currDepth_);
            boolean bl = nowHaveOrthoPoints = this.threePts_ == null ? false : this.grid_.recoverPointListStartsOrtho(this.threePts_);
            if (nowHaveOrthoPoints && this.grid_.haveDOFWillTravel(this.threePts_, false, this.src_, this.trg_, this.linkID_, this.okGroups_, this.recoveryExemptions_, this.isStart_ && this.currDepth_ == 0)) {
                this.returnFirstPoint_ = true;
                this.haveOrthoPoints_ = nowHaveOrthoPoints;
                this.haveOrthoCorner_ = this.haveOrthoPoints_ && this.grid_.recoverPointListIsOrtho(this.threePts_);
                Point2D startPt = (Point2D)this.threePts_.get(0);
                Point2D endPt = (Point2D)this.threePts_.get(1);
                Vector2D departDir = new Vector2D(startPt, endPt).normalized();
                this.turn_ = this.grid_.buildInitRecoveryTurn(departDir, this.threePts_);
            } else {
                this.recoverForLink_.popRevisedPoint(this.firstPointOption_.lsid);
                return false;
            }
        }
        return true;
    }

    private void cleanUpForReturn(List retval) {
        if (this.firstPointOption_ != null) {
            this.recoverForLink_.popRevisedPoint(this.firstPointOption_.lsid);
        }
        if (this.secondPointOption_ != null) {
            this.recoverForLink_.popRevisedPoint(this.secondPointOption_.lsid);
        }
        if (this.returnFirstPoint_ || this.returnSecondPoint_) {
            DOFOption firstRet = this.returnFirstPoint_ ? this.firstPointOption_ : null;
            DOFOption secondRet = this.returnSecondPoint_ ? this.secondPointOption_ : null;
            DOFOptionPair dop = new DOFOptionPair(firstRet, secondRet);
            retval.add(dop);
        } else {
            retval.addAll(this.answerList_);
        }
    }

    private boolean needCornerPointAnalysis() {
        return this.cornerGottaBeOrtho_ && !this.haveOrthoCorner_;
    }

    private boolean prepareCornerAnalysis() {
        LinkProperties.CornerDoF dof1 = this.grid_.getCornerDoF(this.recoverForLink_, this.currDepth_);
        LinkProperties.CornerDoF dof2 = this.grid_.getCornerDoF(this.recoverForLink_, this.currDepth_ + 1);
        if (dof1 != null && dof2 != null) {
            this.dualPtList_ = this.generateDualOrthoCandidates(dof1, dof2, this.currDepth_);
        } else if (dof1 != null) {
            this.newPt_ = this.generateUpstreamOrthoCandidate(dof1, this.currDepth_);
            this.cornerDepth_ = this.currDepth_;
            this.modifyFirst_ = this.firstPointOption_ != null;
            this.pointIsFirst_ = true;
        } else if (dof2 != null) {
            this.newPt_ = this.generateDownstreamOrthoCandidate(dof2, this.currDepth_ + 1);
            this.cornerDepth_ = this.currDepth_ + 1;
        }
        return this.dualPtList_ != null || this.newPt_ != null;
    }

    private boolean doCornerAnalysis() {
        if (this.newPt_ != null) {
            return this.doOnePointCornerAnalysis();
        }
        if (this.dualPtList_ != null) {
            return this.doTwoPointCornerAnalysis();
        }
        throw new IllegalStateException();
    }

    private boolean doOnePointCornerAnalysis() {
        DOFOption stashedOption = null;
        LinkSegmentID lsid = this.recoverForLink_.getPointKey(this.cornerDepth_);
        if (lsid != null && (this.modifyFirst_ || this.recoverForLink_.revisedPointCanBePushed(lsid))) {
            boolean nowHaveOrthoCorner;
            if (this.modifyFirst_) {
                this.recoverForLink_.popRevisedPoint(this.firstPointOption_.lsid);
                stashedOption = this.firstPointOption_;
            }
            this.recoverForLink_.pushRevisedPoint(lsid, this.newPt_);
            DOFOption pointOption = new DOFOption(lsid, this.newPt_);
            if (this.pointIsFirst_) {
                this.firstPointOption_ = pointOption;
            } else {
                this.secondPointOption_ = pointOption;
            }
            this.threePts_ = this.grid_.buildRecoverPointList(this.turn_.start, this.targ_, this.recoverForLink_, this.currDepth_);
            boolean bl = nowHaveOrthoCorner = this.threePts_ == null ? false : this.grid_.recoverPointListIsOrtho(this.threePts_);
            if (nowHaveOrthoCorner && this.grid_.haveDOFWillTravel(this.threePts_, true, this.src_, this.trg_, this.linkID_, this.okGroups_, this.recoveryExemptions_, false)) {
                DOFOption retOpt = new DOFOption(lsid, this.newPt_);
                if (this.pointIsFirst_) {
                    this.returnFirstPoint_ = true;
                } else {
                    this.returnSecondPoint_ = true;
                }
            } else {
                if (this.modifyFirst_) {
                    this.recoverForLink_.popRevisedPoint(this.firstPointOption_.lsid);
                    this.recoverForLink_.pushRevisedPoint(stashedOption.lsid, stashedOption.newPt);
                    this.firstPointOption_ = stashedOption;
                }
                return false;
            }
        }
        return true;
    }

    private boolean doTwoPointCornerAnalysis() {
        int numDC = this.dualPtList_.size();
        this.modifyFirst_ = this.firstPointOption_ != null;
        DOFOption stashedOption = null;
        for (int i = 0; i < numDC; ++i) {
            boolean nowHaveOrthoCorner;
            LinkSegmentID lsid;
            DualCandidate dc = (DualCandidate)this.dualPtList_.get(i);
            DOFOption startOption = null;
            DOFOption endOption = null;
            if (dc.startCandidate != null && (lsid = this.recoverForLink_.getPointKey(this.currDepth_)) != null && (this.modifyFirst_ || this.recoverForLink_.revisedPointCanBePushed(lsid))) {
                if (this.modifyFirst_) {
                    this.recoverForLink_.popRevisedPoint(this.firstPointOption_.lsid);
                    stashedOption = this.firstPointOption_;
                }
                this.recoverForLink_.pushRevisedPoint(lsid, dc.startCandidate);
                startOption = new DOFOption(lsid, dc.startCandidate);
            }
            if (dc.endCandidate != null && (lsid = this.recoverForLink_.getPointKey(this.currDepth_ + 1)) != null && this.recoverForLink_.revisedPointCanBePushed(lsid)) {
                this.recoverForLink_.pushRevisedPoint(lsid, dc.endCandidate);
                endOption = new DOFOption(lsid, dc.endCandidate);
            }
            this.threePts_ = this.grid_.buildRecoverPointList(this.turn_.start, this.targ_, this.recoverForLink_, this.currDepth_);
            boolean bl = nowHaveOrthoCorner = this.threePts_ == null ? false : this.grid_.recoverPointListIsOrtho(this.threePts_);
            if (nowHaveOrthoCorner && this.grid_.haveDOFWillTravel(this.threePts_, true, this.src_, this.trg_, this.linkID_, this.okGroups_, this.recoveryExemptions_, false)) {
                DOFOptionPair dop = new DOFOptionPair(startOption, endOption);
                this.answerList_.add(dop);
            }
            if (startOption != null) {
                this.recoverForLink_.popRevisedPoint(startOption.lsid);
                if (this.modifyFirst_) {
                    this.recoverForLink_.pushRevisedPoint(stashedOption.lsid, stashedOption.newPt);
                    stashedOption = null;
                }
            }
            if (endOption == null) continue;
            this.recoverForLink_.popRevisedPoint(endOption.lsid);
        }
        return this.answerList_.size() > 0;
    }

    private Point2D generateDownstreamOrthoCandidate(LinkProperties.CornerDoF dof, int useDepth) {
        List threePts = this.grid_.buildRecoverPointList(this.turn_.start, this.targ_, this.recoverForLink_, useDepth);
        if (threePts == null) {
            return null;
        }
        if (!dof.inboundIsCanonical) {
            return null;
        }
        Point2D startPt = (Point2D)threePts.get(0);
        startPt = new Point2D.Double(startPt.getX() * 10.0, startPt.getY() * 10.0);
        Point2D nonOrthPt = (Point2D)threePts.get(1);
        nonOrthPt = new Point2D.Double(nonOrthPt.getX() * 10.0, nonOrthPt.getY() * 10.0);
        Vector2D toNonOrth = new Vector2D(startPt, nonOrthPt);
        double dotVal = dof.runVector.dot(toNonOrth);
        Vector2D toOrth = dof.runVector.scaled(dotVal);
        Point2D candidate = toOrth.add(startPt);
        UiUtil.forceToGrid(candidate, 10.0);
        Point2D replacement = this.withinDOFBounds(dof, nonOrthPt, candidate, dof.runVector);
        return replacement;
    }

    private Point2D generateUpstreamOrthoCandidate(LinkProperties.CornerDoF dof, int useDepth) {
        List threePts = this.grid_.buildRecoverPointList(this.turn_.start, this.targ_, this.recoverForLink_, useDepth);
        if (threePts == null) {
            return null;
        }
        Point2D startPt = (Point2D)threePts.get(0);
        startPt = new Point2D.Double(startPt.getX() * 10.0, startPt.getY() * 10.0);
        Point2D cornerPt = (Point2D)threePts.get(1);
        cornerPt = new Point2D.Double(cornerPt.getX() * 10.0, cornerPt.getY() * 10.0);
        Point2D endPt = (Point2D)threePts.get(2);
        endPt = new Point2D.Double(endPt.getX() * 10.0, endPt.getY() * 10.0);
        Vector2D toEnd = new Vector2D(cornerPt, endPt);
        double dotVal = dof.runVector.dot(toEnd);
        Vector2D toOrth = dof.runVector.scaled(dotVal);
        Point2D candidate = toOrth.add(cornerPt);
        UiUtil.forceToGrid(candidate, 10.0);
        Vector2D orthToCand = new Vector2D(cornerPt, candidate);
        Point2D replacement = this.withinDOFBounds(dof, cornerPt, candidate, dof.runVector);
        return replacement;
    }

    private boolean isPinned(LinkProperties.CornerDoF dof, Vector2D normShiftVec, Vector2D desiredCanonicalVec) {
        if (normShiftVec.equals(dof.antiNormVector) || normShiftVec.equals(dof.normVector)) {
            if (dof.runPoint != null) {
                return true;
            }
            if (!dof.inboundIsCanonical && dof.backupPoint != null) {
                return true;
            }
        } else if (normShiftVec.equals(dof.backupVector) || normShiftVec.equals(dof.runVector)) {
            if (desiredCanonicalVec.equals(dof.antiNormVector) && dof.normPoint != null) {
                return true;
            }
            if (desiredCanonicalVec.equals(dof.normVector) && dof.antiNormPoint != null) {
                return true;
            }
        }
        return false;
    }

    private Point2D withinDOFBounds(LinkProperties.CornerDoF dof, Point2D orig, Point2D candidate, Vector2D desiredCanonicalVec) {
        Vector2D origToCand = new Vector2D(orig, candidate);
        Vector2D normOrigToCand = origToCand.normalized();
        if (this.isPinned(dof, normOrigToCand, desiredCanonicalVec)) {
            return null;
        }
        Point2D modified = this.dotCompare(dof.backupPoint, dof.backupVector, origToCand, normOrigToCand, orig, candidate);
        if (modified == null) {
            return null;
        }
        if (normOrigToCand.equals(dof.backupVector) && dof.inboundIsCanonical && dof.backupPoint == null) {
            return null;
        }
        if ((modified = this.dotCompare(dof.runPoint, dof.runVector, origToCand, normOrigToCand, orig, modified)) == null) {
            return null;
        }
        if ((modified = this.dotCompare(dof.normPoint, dof.normVector, origToCand, normOrigToCand, orig, modified)) == null) {
            return null;
        }
        modified = this.dotCompare(dof.antiNormPoint, dof.antiNormVector, origToCand, normOrigToCand, orig, modified);
        return modified;
    }

    private Point2D dotCompare(LinkSegmentID dofPoint, Vector2D dofVector, Vector2D origToCand, Vector2D normOrigToCand, Point2D orig, Point2D candidate) {
        if (dofPoint != null) {
            Vector2D origToCurr;
            double origToCurrDot;
            double runDot = dofVector.dot(origToCand);
            if (runDot <= 0.0) {
                return candidate;
            }
            Point2D currRunPoint = this.recoverForLink_.getPoint(dofPoint);
            if (currRunPoint != null && (origToCurrDot = dofVector.dot(origToCurr = new Vector2D(orig, currRunPoint))) <= runDot) {
                if ((origToCurrDot -= 20.0) <= 0.0) {
                    return null;
                }
                Vector2D toReplace = dofVector.scaled(origToCurrDot);
                Point2D replacement = toReplace.add(orig);
                UiUtil.forceToGrid(replacement, 10.0);
                return replacement;
            }
        }
        return candidate;
    }

    private List generateDualOrthoCandidates(LinkProperties.CornerDoF dofStart, LinkProperties.CornerDoF dofEnd, int useDepth) {
        ArrayList<DualCandidate> retval = new ArrayList<DualCandidate>();
        List threePts = this.grid_.buildRecoverPointList(this.turn_.start, this.targ_, this.recoverForLink_, useDepth);
        if (threePts == null || threePts.size() < 3) {
            return null;
        }
        if (!dofEnd.inboundIsCanonical) {
            return null;
        }
        Point2D startPt = (Point2D)threePts.get(1);
        startPt = new Point2D.Double(startPt.getX() * 10.0, startPt.getY() * 10.0);
        Point2D endPoint = (Point2D)threePts.get(2);
        endPoint = new Point2D.Double(endPoint.getX() * 10.0, endPoint.getY() * 10.0);
        Point2D startCand = this.generateUpstreamOrthoCandidate(dofStart, useDepth);
        Point2D endCand = this.generateDownstreamOrthoCandidate(dofEnd, useDepth + 1);
        if (startCand == null && endCand == null) {
            return null;
        }
        if (startCand == null) {
            DualCandidate dc = new DualCandidate();
            dc.startCandidate = null;
            dc.endCandidate = endCand;
            retval.add(dc);
            return retval;
        }
        if (endCand == null) {
            DualCandidate dc = new DualCandidate();
            dc.startCandidate = startCand;
            dc.endCandidate = null;
            retval.add(dc);
            return retval;
        }
        Vector2D startDelta = new Vector2D(startPt, startCand);
        Vector2D endDelta = new Vector2D(endPoint, endCand);
        int startInc = (int)(startDelta.length() / 10.0);
        int endInc = (int)(endDelta.length() / 10.0);
        Vector2D normStartDelta = startDelta.normalized();
        Vector2D normEndDelta = endDelta.normalized();
        DualCandidate dc = new DualCandidate();
        dc.startCandidate = startCand;
        dc.endCandidate = null;
        retval.add(dc);
        dc = new DualCandidate();
        dc.startCandidate = null;
        dc.endCandidate = endCand;
        retval.add(dc);
        return retval;
    }

    private static class DualCandidate {
        Point2D startCandidate;
        Point2D endCandidate;

        private DualCandidate() {
        }

        public String toString() {
            return "DualCandidate: startCandidate = " + this.startCandidate + " endCandidate = " + this.endCandidate;
        }
    }

    public static class DOFOptionPair {
        DOFOption firstPoint;
        DOFOption cornerPoint;

        DOFOptionPair(DOFOption firstPoint, DOFOption cornerPoint) {
            this.firstPoint = firstPoint;
            this.cornerPoint = cornerPoint;
        }

        public String toString() {
            return "DOFOptionPair: first = " + this.firstPoint + " corner = " + this.cornerPoint;
        }
    }

    public static class DOFOption {
        LinkSegmentID lsid;
        Point2D newPt;

        DOFOption(LinkSegmentID lsid, Point2D newPt) {
            this.lsid = lsid;
            this.newPt = newPt;
        }

        public String toString() {
            return "DOFOption: lsid = " + this.lsid + " pt = " + this.newPt;
        }
    }
}

