/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RectDefinedByRects {
    private Rectangle2D myOrig_;
    private HashMap myDef_;
    private double deltaMinX_;
    private double deltaMinY_;
    private double deltaMaxX_;
    private double deltaMaxY_;

    public RectDefinedByRects(Rectangle2D myRect, Set otherRects) {
        ArrayList fixedOrder = new ArrayList(otherRects);
        Collections.sort(fixedOrder, new RectOrdering());
        this.myDef_ = new HashMap();
        this.myOrig_ = (Rectangle2D)myRect.clone();
        Iterator orit = fixedOrder.iterator();
        RectangularShape interUnion = null;
        while (orit.hasNext()) {
            TaggedRect otherRect = (TaggedRect)orit.next();
            Rectangle2D interRect = myRect.createIntersection(otherRect.rect);
            if (!(interRect.getHeight() >= 0.0) || !(interRect.getWidth() >= 0.0)) continue;
            this.myDef_.put(otherRect.clone(), interRect);
            if (interUnion == null) {
                interUnion = interRect;
                continue;
            }
            interUnion = ((Rectangle2D)interUnion).createUnion(interRect);
        }
        if (interUnion != null) {
            this.deltaMinX_ = interUnion.getMinX() - this.myOrig_.getMinX();
            this.deltaMinY_ = interUnion.getMinY() - this.myOrig_.getMinY();
            this.deltaMaxX_ = this.myOrig_.getMaxX() - interUnion.getMaxX();
            this.deltaMaxY_ = this.myOrig_.getMaxY() - interUnion.getMaxY();
        }
    }

    public boolean isDefined() {
        return !this.myDef_.isEmpty();
    }

    public Set definedByKeys() {
        return this.myDef_.keySet();
    }

    public Rectangle2D generateNewRect(Map oldToNew) {
        Point2D.Double interPt = new Point2D.Double();
        RectangularShape interUnion = null;
        ArrayList fixedOrder = new ArrayList(this.myDef_.keySet());
        Collections.sort(fixedOrder, new RectOrdering());
        Iterator mdkit = fixedOrder.iterator();
        while (mdkit.hasNext()) {
            TaggedRect defTagRect = (TaggedRect)mdkit.next();
            Rectangle2D defRect = defTagRect.rect;
            Rectangle2D interRect = (Rectangle2D)this.myDef_.get(defTagRect);
            Rectangle2D transDefRect = (Rectangle2D)oldToNew.get(defTagRect);
            Point2D.Double ulp = new Point2D.Double(interRect.getX(), interRect.getY());
            this.convertPtToRectFrame(defRect, ulp, interPt);
            Point2D.Double transUlp = new Point2D.Double();
            this.convertNormPtToPt(transDefRect, interPt, transUlp);
            Point2D.Double lrp = new Point2D.Double(interRect.getMaxX(), interRect.getMaxY());
            this.convertPtToRectFrame(defRect, lrp, interPt);
            Point2D.Double transLrp = new Point2D.Double();
            this.convertNormPtToPt(transDefRect, interPt, transLrp);
            Rectangle2D.Double transInterRect = new Rectangle2D.Double(((Point2D)transUlp).getX(), ((Point2D)transUlp).getY(), ((Point2D)transLrp).getX() - ((Point2D)transUlp).getX(), ((Point2D)transLrp).getY() - ((Point2D)transUlp).getY());
            if (interUnion == null) {
                interUnion = transInterRect;
                continue;
            }
            interUnion = ((Rectangle2D)interUnion).createUnion(transInterRect);
        }
        double retX = interUnion.getMinX() - this.deltaMinX_;
        double retY = interUnion.getMinY() - this.deltaMinY_;
        double retMaxX = this.deltaMaxX_ + interUnion.getMaxX();
        double retMaxY = this.deltaMaxY_ + interUnion.getMaxY();
        return new Rectangle2D.Double(retX, retY, retMaxX - retX, retMaxY - retY);
    }

    private void convertPtToRectFrame(Rectangle2D rect, Point2D pt, Point2D result) {
        double delX = pt.getX() - rect.getX();
        double delY = pt.getY() - rect.getY();
        double rW = rect.getWidth();
        double rH = rect.getHeight();
        double rcx = rW == 0.0 ? 0.0 : delX / rW;
        double rcy = rH == 0.0 ? 0.0 : delY / rH;
        result.setLocation(rcx, rcy);
    }

    private void convertNormPtToPt(Rectangle2D rect, Point2D normPt, Point2D result) {
        double delX = normPt.getX() * rect.getWidth();
        double delY = normPt.getY() * rect.getHeight();
        double rcx = rect.getX() + delX;
        double rcy = rect.getY() + delY;
        result.setLocation(rcx, rcy);
    }

    public static void main(String[] argv) {
        try {
            Rectangle2D.Double testRect = new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0);
            Rectangle2D.Double baseRect0 = new Rectangle2D.Double(-10.0, -10.0, 5.0, 5.0);
            Rectangle2D.Double baseRect1 = new Rectangle2D.Double(-10.0, -10.0, 20.0, 20.0);
            Rectangle2D.Double baseRect2 = new Rectangle2D.Double(-10.0, 90.0, 20.0, 20.0);
            TaggedRect tr0 = new TaggedRect(baseRect0, "0");
            TaggedRect tr1 = new TaggedRect(baseRect1, "1");
            TaggedRect tr2 = new TaggedRect(baseRect2, "2");
            HashSet<TaggedRect> baseSet = new HashSet<TaggedRect>();
            baseSet.add(tr0);
            baseSet.add(tr1);
            baseSet.add(tr2);
            RectDefinedByRects rdr = new RectDefinedByRects(testRect, baseSet);
            Rectangle2D.Double transRect0 = new Rectangle2D.Double(-10.0, -10.0, 5.0, 5.0);
            Rectangle2D.Double transRect1 = new Rectangle2D.Double(-10.0, -50.0, 20.0, 40.0);
            Rectangle2D.Double transRect2 = new Rectangle2D.Double(-10.0, 200.0, 30.0, 10.0);
            HashMap<TaggedRect, Rectangle2D.Double> o2n = new HashMap<TaggedRect, Rectangle2D.Double>();
            o2n.put(tr0, transRect0);
            o2n.put(tr1, transRect1);
            o2n.put(tr2, transRect2);
            Rectangle2D transRdr = rdr.generateNewRect(o2n);
            System.out.println(transRdr);
        }
        catch (Exception ioex) {
            System.err.println(ioex);
            ioex.printStackTrace();
        }
    }

    public static class RectOrdering
    implements Comparator {
        public int compare(Object firstRect, Object secondRect) {
            TaggedRect first = (TaggedRect)firstRect;
            TaggedRect second = (TaggedRect)secondRect;
            int xDiff = (int)(first.rect.getX() - second.rect.getX());
            int yDiff = (int)(first.rect.getY() - second.rect.getY());
            int xMaxDiff = (int)(first.rect.getMaxX() - second.rect.getMaxX());
            int yMaxDiff = (int)(first.rect.getMaxY() - second.rect.getMaxY());
            if (xDiff != 0) {
                return xDiff;
            }
            if (yDiff != 0) {
                return yDiff;
            }
            if (xMaxDiff != 0) {
                return xMaxDiff;
            }
            return yMaxDiff;
        }
    }

    public static class TaggedRect
    implements Cloneable {
        public Rectangle2D rect;
        public Object tag;

        public TaggedRect(Rectangle2D rect, Object tag) {
            this.rect = rect;
            this.tag = tag;
        }

        public Object clone() {
            try {
                TaggedRect newVal = (TaggedRect)super.clone();
                newVal.rect = (Rectangle2D)this.rect.clone();
                return newVal;
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }

        public int hashCode() {
            return this.rect.hashCode() + this.tag.hashCode();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof TaggedRect)) {
                return false;
            }
            TaggedRect otherTR = (TaggedRect)other;
            if (!this.tag.equals(otherTR.tag)) {
                return false;
            }
            if (!this.rect.equals(otherTR.rect)) {
                throw new IllegalStateException();
            }
            return true;
        }
    }
}

