/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceManager {
    private static ResourceManager singleton_;
    private ResourceBundle bundle_;

    public String getString(String key) {
        String retval;
        try {
            retval = this.bundle_.getString(key);
        }
        catch (MissingResourceException mre) {
            retval = key;
        }
        return retval;
    }

    public char getChar(String key) {
        String str;
        try {
            str = this.bundle_.getString(key);
        }
        catch (MissingResourceException mre) {
            str = "!";
        }
        if (str.length() == 0) {
            str = "!";
        }
        return str.charAt(0);
    }

    public static synchronized ResourceManager initManager(String bundleName) {
        if (singleton_ != null) {
            throw new IllegalStateException();
        }
        singleton_ = new ResourceManager(bundleName);
        return singleton_;
    }

    public static synchronized ResourceManager getManager() {
        if (singleton_ == null) {
            singleton_ = new ResourceManager();
        }
        return singleton_;
    }

    private ResourceManager() {
        this.bundle_ = ResourceBundle.getBundle("org.systemsbiology.biotapestry.util.BioTapestry");
    }

    private ResourceManager(String bundleName) {
        this.bundle_ = ResourceBundle.getBundle(bundleName);
    }

    public static void main(String[] argv) {
        ResourceManager rm = ResourceManager.getManager();
        String test = rm.getString("testKey");
        System.out.println("Test key returns: " + test);
    }
}

