/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.util.SlicedRectangle;

public class SliceAndDicer {
    public static final int OWNED_BY_GROUP = 0;
    public static final int UNCLAIMED = 1;
    public static final int MULTI_CLAIMED = 2;
    public static final int BOUNDING_A_GROUP = 3;
    private static final int NO_INTERSECTION_ = 0;
    private static final int CHUNKS_CONTAINED_IN_SHAPE_ = 1;
    private static final int SHAPE_CONTAINED_IN_CHUNKS_ = 2;
    private static final int CHUNK_AND_SHAPE_SLICE_ = 3;
    private static final int NUM_SLICE_RESULTS_ = 4;

    public List sliceARectByAllBounds(Map boundsForGroups, Map groupZOrder, Rectangle2D oldShape, boolean isName) {
        Map chunkedBounds = this.sliceBFG(boundsForGroups, groupZOrder);
        PreSliceResult psr = this.doEverythingButSlice(chunkedBounds, oldShape, isName);
        if (psr.osr != null) {
            ArrayList<OneSliceResult> retval = new ArrayList<OneSliceResult>();
            if (psr.osr.status == 3) {
                retval.addAll(this.sliceOffBoundaries(chunkedBounds, oldShape, psr, isName));
            } else {
                retval.add(psr.osr);
            }
            return retval;
        }
        return this.sliceTheShape(chunkedBounds, oldShape, psr, isName);
    }

    private PreSliceResult doEverythingButSlice(Map chunkedBounds, Rectangle2D oldShape, boolean isName) {
        HashSet[] chunksPerRes = new HashSet[4];
        for (int i = 0; i < 4; ++i) {
            chunksPerRes[i] = new HashSet();
        }
        HashMap interRects = new HashMap();
        PreSliceResult retval = new PreSliceResult(chunksPerRes, interRects);
        if (chunkedBounds.isEmpty()) {
            return retval.setOsr(new OneSliceResult(oldShape, isName));
        }
        this.buildIntersectionInfo(chunkedBounds, oldShape, chunksPerRes, interRects);
        int numChunks = chunkedBounds.size();
        retval.unclaimed = chunksPerRes[0].size() == numChunks;
        retval.chunksFullyInShape = chunksPerRes[1].size();
        retval.shapeFullyInChunks = chunksPerRes[2].size();
        retval.numToSlice = chunksPerRes[3].size();
        if (retval.unclaimed) {
            return retval.setOsr(new OneSliceResult(oldShape, isName));
        }
        if (retval.numToSlice == 0) {
            if (retval.shapeFullyInChunks == 1) {
                if (retval.chunksFullyInShape != 0) {
                    throw new IllegalStateException();
                }
                GroupAndChunk gac = (GroupAndChunk)chunksPerRes[2].iterator().next();
                return retval.setOsr(new OneSliceResult(gac.grp, oldShape, false, isName));
            }
            if (retval.shapeFullyInChunks > 1) {
                throw new IllegalStateException();
            }
            if (retval.chunksFullyInShape == 1) {
                GroupAndChunk gac = (GroupAndChunk)chunksPerRes[1].iterator().next();
                return retval.setOsr(new OneSliceResult(gac.grp, oldShape, true, isName));
            }
            if (retval.chunksFullyInShape > 1) {
                return retval;
            }
            throw new IllegalStateException();
        }
        return retval;
    }

    private Map sliceBFG(Map boundsForGroups, Map groupZOrder) {
        ChunkTracker ct = new ChunkTracker();
        Map chunked = this.basicSliceBFG(boundsForGroups, ct);
        int lastChunked = -1;
        int chunkedSize = chunked.size();
        while (lastChunked != chunkedSize) {
            Iterator cit1 = chunked.keySet().iterator();
            boolean broken = false;
            block1: while (cit1.hasNext() && !broken) {
                GroupAndChunk gac1 = (GroupAndChunk)cit1.next();
                Rectangle2D rect1 = (Rectangle2D)chunked.get(gac1);
                Iterator cit2 = chunked.keySet().iterator();
                while (cit2.hasNext()) {
                    Rectangle2D rect2;
                    Rectangle2D interRect;
                    GroupAndChunk gac2 = (GroupAndChunk)cit2.next();
                    if (gac2.equals(gac1) || !((interRect = (rect2 = (Rectangle2D)chunked.get(gac2)).createIntersection(rect1)).getHeight() > 0.0) || !(interRect.getWidth() > 0.0)) continue;
                    this.breakToChunks(chunked, gac1, gac2, interRect, groupZOrder, ct);
                    broken = true;
                    continue block1;
                }
            }
            lastChunked = chunkedSize;
            chunkedSize = chunked.size();
        }
        return chunked;
    }

    private Map basicSliceBFG(Map boundsForGroups, ChunkTracker ct) {
        HashMap<GroupAndChunk, Rectangle> retval = new HashMap<GroupAndChunk, Rectangle>();
        Iterator bfgit = boundsForGroups.keySet().iterator();
        while (bfgit.hasNext()) {
            String grpID = (String)bfgit.next();
            Rectangle rect = (Rectangle)boundsForGroups.get(grpID);
            int next = ct.getNextChunkNum(grpID);
            GroupAndChunk gac = new GroupAndChunk(grpID, next);
            retval.put(gac, rect);
        }
        return retval;
    }

    private void fragment(Map chunked, GroupAndChunk gac, Rectangle2D fragRect, Rectangle2D interRect, ChunkTracker ct) {
        SlicedRectangle sl = new SlicedRectangle(fragRect, interRect);
        List sliceOpts = sl.getFirstSliceOptions();
        if (sliceOpts.size() == 0) {
            return;
        }
        Integer opt = (Integer)sliceOpts.get(0);
        SlicedRectangle.SlicedRectangleSplit srs = sl.slice(opt);
        chunked.put(gac, srs.first);
        int next = ct.getNextChunkNum(gac.grp);
        GroupAndChunk gac2 = new GroupAndChunk(gac.grp, next);
        chunked.put(gac2, srs.second);
    }

    private void breakToChunks(Map chunked, GroupAndChunk gac1, GroupAndChunk gac2, Rectangle2D interRect, Map groupZOrder, ChunkTracker ct) {
        int z2;
        boolean z1InFront;
        Rectangle2D rect1 = (Rectangle2D)chunked.get(gac1);
        Rectangle2D rect2 = (Rectangle2D)chunked.get(gac2);
        int z1 = (Integer)groupZOrder.get(gac1.grp);
        boolean bl = z1InFront = z1 > (z2 = ((Integer)groupZOrder.get(gac2.grp)).intValue());
        if (interRect.equals(rect1)) {
            if (z1InFront) {
                if (interRect.equals(rect2)) {
                    chunked.remove(gac2);
                } else {
                    this.fragment(chunked, gac2, rect2, interRect, ct);
                }
            } else {
                chunked.remove(gac1);
            }
        } else if (interRect.equals(rect2)) {
            if (z1InFront) {
                this.fragment(chunked, gac2, rect2, interRect, ct);
            } else {
                chunked.remove(gac1);
            }
        } else if (z1InFront) {
            this.fragment(chunked, gac2, rect2, interRect, ct);
        } else {
            this.fragment(chunked, gac1, rect1, interRect, ct);
        }
    }

    private List sliceTheShape(Map chunkedBounds, Rectangle2D oldShape, PreSliceResult psr, boolean isName) {
        int i;
        ArrayList<SliceChoice> choices = new ArrayList<SliceChoice>();
        Iterator git = psr.chunksPerRes[3].isEmpty() ? psr.chunksPerRes[1].iterator() : psr.chunksPerRes[3].iterator();
        while (git.hasNext()) {
            GroupAndChunk gac = (GroupAndChunk)git.next();
            Rectangle2D interRect = (Rectangle2D)psr.interRects.get(gac);
            SlicedRectangle sl = new SlicedRectangle(oldShape, interRect);
            List sliceOpts = sl.getFirstSliceOptions();
            int numOpts = sliceOpts.size();
            for (i = 0; i < numOpts; ++i) {
                Integer opt = (Integer)sliceOpts.get(i);
                SlicedRectangle.SlicedRectangleSplit srs = sl.slice(opt);
                PreSliceResult psr1 = this.doEverythingButSlice(chunkedBounds, srs.first, isName);
                PreSliceResult psr2 = this.doEverythingButSlice(chunkedBounds, srs.second, isName);
                choices.add(new SliceChoice(opt, psr1, psr2, srs.first, srs.second));
            }
        }
        int numChoices = choices.size();
        SliceChoice choice = null;
        SliceChoice lastDitch = null;
        SliceChoice finalSlice = null;
        int minSlices = Integer.MAX_VALUE;
        for (i = 0; i < numChoices; ++i) {
            SliceChoice nextChoice = (SliceChoice)choices.get(i);
            int val = nextChoice.psr1.numToSlice + nextChoice.psr2.numToSlice;
            if (val > psr.numToSlice) continue;
            if (nextChoice.psr1.numToSlice == psr.numToSlice && nextChoice.psr2.numToSlice == 0 || nextChoice.psr2.numToSlice == psr.numToSlice && nextChoice.psr1.numToSlice == 0) {
                if (nextChoice.psr1.chunksFullyInShape < psr.chunksFullyInShape && nextChoice.psr2.chunksFullyInShape < psr.chunksFullyInShape) {
                    lastDitch = nextChoice;
                }
                if ((nextChoice.psr1.numToSlice != 1 || nextChoice.psr2.numToSlice != 0) && (nextChoice.psr2.numToSlice != 1 || nextChoice.psr1.numToSlice != 0)) continue;
                finalSlice = nextChoice;
                continue;
            }
            if (val >= minSlices) continue;
            minSlices = val;
            choice = nextChoice;
        }
        if (choice == null) {
            choice = lastDitch;
        }
        if (choice == null) {
            choice = finalSlice;
        }
        if (choice == null) {
            choice = (SliceChoice)choices.get(0);
        }
        ArrayList<OneSliceResult> retval = new ArrayList<OneSliceResult>();
        if (choice.psr1.osr == null) {
            retval.addAll(this.sliceTheShape(chunkedBounds, choice.shape1, choice.psr1, isName));
        } else if (choice.psr1.osr.status == 3) {
            retval.addAll(this.sliceOffBoundaries(chunkedBounds, choice.shape1, choice.psr1, isName));
        } else {
            retval.add(choice.psr1.osr);
        }
        if (choice.psr2.osr == null) {
            retval.addAll(this.sliceTheShape(chunkedBounds, choice.shape2, choice.psr2, isName));
        } else if (choice.psr2.osr.status == 3) {
            retval.addAll(this.sliceOffBoundaries(chunkedBounds, choice.shape2, choice.psr2, isName));
        } else {
            retval.add(choice.psr2.osr);
        }
        return retval;
    }

    private List sliceOffBoundaries(Map chunkedBounds, Rectangle2D oldShape, PreSliceResult psr, boolean isName) {
        ArrayList<OneSliceResult> retval = new ArrayList<OneSliceResult>();
        GroupAndChunk gac = (GroupAndChunk)psr.chunksPerRes[1].iterator().next();
        Rectangle2D interRect = (Rectangle2D)psr.interRects.get(gac);
        SlicedRectangle sl = new SlicedRectangle(oldShape, interRect);
        List options = sl.getFirstSliceOptions();
        if (options.isEmpty()) {
            retval.add(new OneSliceResult(gac.grp, oldShape, false, isName));
            return retval;
        }
        Integer opt = (Integer)sl.getFirstSliceOptions().get(0);
        SlicedRectangle.SlicedRectangleSplit srs = sl.slice(opt);
        PreSliceResult psr1 = this.doEverythingButSlice(chunkedBounds, srs.first, isName);
        PreSliceResult psr2 = this.doEverythingButSlice(chunkedBounds, srs.second, isName);
        if (psr1.osr == null) {
            retval.addAll(this.sliceTheShape(chunkedBounds, srs.first, psr1, isName));
        } else if (psr1.osr.status == 3) {
            retval.addAll(this.sliceOffBoundaries(chunkedBounds, srs.first, psr1, isName));
        } else {
            retval.add(psr1.osr);
        }
        if (psr2.osr == null) {
            retval.addAll(this.sliceTheShape(chunkedBounds, srs.second, psr2, isName));
        } else if (psr2.osr.status == 3) {
            retval.addAll(this.sliceOffBoundaries(chunkedBounds, srs.second, psr2, isName));
        } else {
            retval.add(psr2.osr);
        }
        return retval;
    }

    private void buildIntersectionInfo(Map chunkedBounds, Rectangle2D oldShape, HashSet[] chunksPerRes, HashMap interRects) {
        Iterator bfgkit = chunkedBounds.keySet().iterator();
        while (bfgkit.hasNext()) {
            GroupAndChunk gac = (GroupAndChunk)bfgkit.next();
            Rectangle2D regBounds = (Rectangle2D)chunkedBounds.get(gac);
            IBResult result = this.intersectBounds(regBounds, oldShape);
            chunksPerRes[result.result].add(gac);
            if (result.interRect == null) continue;
            interRects.put(gac, result.interRect);
        }
    }

    private IBResult intersectBounds(Rectangle2D groupBounds, Rectangle2D shape) {
        Rectangle2D interRect = groupBounds.createIntersection(shape);
        if (interRect.getHeight() > 0.0 && interRect.getWidth() > 0.0) {
            if (interRect.equals(groupBounds)) {
                return new IBResult(1, interRect);
            }
            if (interRect.equals(shape)) {
                return new IBResult(2, interRect);
            }
            return new IBResult(3, interRect);
        }
        return new IBResult(0, null);
    }

    public static class GroupAndChunk
    implements Cloneable {
        public String grp;
        public int chunkNum;

        public GroupAndChunk(String groupID, int chunkNum) {
            this.grp = groupID;
            this.chunkNum = chunkNum;
        }

        public Object clone() {
            try {
                GroupAndChunk newVal = (GroupAndChunk)super.clone();
                return newVal;
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }

        public int hashCode() {
            return this.grp.hashCode() + this.chunkNum;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof GroupAndChunk)) {
                return false;
            }
            GroupAndChunk otherTR = (GroupAndChunk)other;
            if (!this.grp.equals(otherTR.grp)) {
                return false;
            }
            return this.chunkNum == otherTR.chunkNum;
        }
    }

    public static class ChunkTracker {
        private HashMap currMaxChunk_ = new HashMap();

        ChunkTracker() {
        }

        int getNextChunkNum(String grp) {
            Integer cmc = (Integer)this.currMaxChunk_.get(grp);
            int retval = cmc == null ? 0 : cmc + 1;
            cmc = new Integer(retval);
            this.currMaxChunk_.put(grp, cmc);
            return retval;
        }
    }

    private static class PreSliceResult {
        OneSliceResult osr;
        boolean unclaimed = true;
        int chunksFullyInShape;
        int shapeFullyInChunks;
        int numToSlice;
        HashSet[] chunksPerRes;
        HashMap interRects;

        PreSliceResult(HashSet[] chunksPerRes, HashMap interRects) {
            this.chunksPerRes = chunksPerRes;
            this.interRects = interRects;
        }

        PreSliceResult setOsr(OneSliceResult osr) {
            this.osr = osr;
            return this;
        }

        int rateIt() {
            return this.numToSlice;
        }
    }

    private static class IBResult {
        int result;
        Rectangle2D interRect;

        IBResult(int result, Rectangle2D interRect) {
            this.result = result;
            this.interRect = interRect;
        }
    }

    private static class SliceChoice {
        Integer opt;
        PreSliceResult psr1;
        PreSliceResult psr2;
        Rectangle2D shape1;
        Rectangle2D shape2;

        SliceChoice(Integer opt, PreSliceResult psr1, PreSliceResult psr2, Rectangle2D shape1, Rectangle2D shape2) {
            this.opt = opt;
            this.psr1 = psr1;
            this.psr2 = psr2;
            this.shape1 = shape1;
            this.shape2 = shape2;
        }
    }

    public static class OneSliceResult {
        public int status;
        public HashSet groups;
        public Rectangle2D shape;
        public boolean isName;

        OneSliceResult(Rectangle2D oldShape, boolean isName) {
            this.status = 1;
            this.shape = (Rectangle2D)oldShape.clone();
            this.isName = isName;
        }

        OneSliceResult(String grpID, Rectangle2D oldShape, boolean withBounds, boolean isName) {
            this.status = withBounds ? 3 : 0;
            this.groups = new HashSet();
            this.groups.add(grpID);
            this.shape = (Rectangle2D)oldShape.clone();
            this.isName = isName;
        }

        OneSliceResult(Set groups, Rectangle2D oldShape, boolean isName) {
            this.status = 2;
            this.groups = new HashSet(groups);
            this.shape = (Rectangle2D)oldShape.clone();
            this.isName = isName;
        }
    }
}

