/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.systemsbiology.biotapestry.util.MinMax;

public class SlicedRectangle {
    public static final int MIN_X = 0;
    public static final int MIN_Y = 1;
    public static final int MAX_X = 2;
    public static final int MAX_Y = 3;
    private int minX;
    private int minY;
    private int maxX;
    private int maxY;
    private int[] xCuts;
    private int[] yCuts;

    public SlicedRectangle(Rectangle2D toSlice, Rectangle2D interRect) {
        MinMax targX = new MinMax((int)toSlice.getMinX(), (int)toSlice.getMaxX());
        MinMax interX = new MinMax((int)interRect.getMinX(), (int)interRect.getMaxX());
        List sliceX = SlicedRectangle.sliceDim(targX, interX);
        MinMax targY = new MinMax((int)toSlice.getMinY(), (int)toSlice.getMaxY());
        MinMax interY = new MinMax((int)interRect.getMinY(), (int)interRect.getMaxY());
        List sliceY = SlicedRectangle.sliceDim(targY, interY);
        int numX = sliceX.size();
        int numY = sliceY.size();
        this.xCuts = new int[numX + 1];
        this.yCuts = new int[numY + 1];
        for (int x = 0; x < numX; ++x) {
            MinMax xCut = (MinMax)sliceX.get(x);
            this.xCuts[x] = xCut.min;
            if (x != numX - 1) continue;
            this.xCuts[numX] = xCut.max;
        }
        for (int y = 0; y < numY; ++y) {
            MinMax yCut = (MinMax)sliceY.get(y);
            this.yCuts[y] = yCut.min;
            if (y != numY - 1) continue;
            this.yCuts[numY] = yCut.max;
        }
        this.minX = interX.min;
        this.minY = interY.min;
        this.maxX = interX.max;
        this.maxY = interY.max;
    }

    public List getFirstSliceOptions() {
        ArrayList<Integer> options = new ArrayList<Integer>();
        if (this.xCuts.length > 2) {
            if (this.minX != this.xCuts[0]) {
                options.add(new Integer(0));
            }
            if (this.maxX != this.xCuts[this.xCuts.length - 1]) {
                options.add(new Integer(2));
            }
        }
        if (this.yCuts.length > 2) {
            if (this.minY != this.yCuts[0]) {
                options.add(new Integer(1));
            }
            if (this.maxY != this.yCuts[this.yCuts.length - 1]) {
                options.add(new Integer(3));
            }
        }
        return options;
    }

    public List getFullSlicePlans() {
        List options = this.getFirstSliceOptions();
        Collections.sort(options);
        ArrayList<SlicePlanTuple> retval = new ArrayList<SlicePlanTuple>();
        ArrayList perms = SlicedRectangle.permute(options);
        int numPerm = perms.size();
        for (int i = 0; i < numPerm; ++i) {
            retval.add(new SlicePlanTuple((List)perms.get(i)));
        }
        return retval;
    }

    public List toList() {
        ArrayList<Rectangle2D.Double> retval = new ArrayList<Rectangle2D.Double>();
        int numX = this.xCuts.length - 1;
        for (int x = 0; x < numX; ++x) {
            int numY = this.yCuts.length - 1;
            for (int y = 0; y < numY; ++y) {
                int minx4r = this.xCuts[x];
                int miny4r = this.yCuts[y];
                Rectangle2D.Double nextRect = new Rectangle2D.Double(minx4r, miny4r, this.xCuts[x + 1] - minx4r, this.yCuts[y + 1] - miny4r);
                retval.add(nextRect);
            }
        }
        return retval;
    }

    public SlicedRectangleSplit slice(Integer which) {
        Rectangle2D.Double second;
        Rectangle2D.Double first;
        switch (which) {
            case 0: {
                first = new Rectangle2D.Double(this.xCuts[0], this.yCuts[0], this.minX - this.xCuts[0], this.yCuts[this.yCuts.length - 1] - this.yCuts[0]);
                second = new Rectangle2D.Double(this.minX, this.yCuts[0], this.xCuts[this.xCuts.length - 1] - this.minX, this.yCuts[this.yCuts.length - 1] - this.yCuts[0]);
                break;
            }
            case 1: {
                first = new Rectangle2D.Double(this.xCuts[0], this.yCuts[0], this.xCuts[this.xCuts.length - 1] - this.xCuts[0], this.minY - this.yCuts[0]);
                second = new Rectangle2D.Double(this.xCuts[0], this.minY, this.xCuts[this.xCuts.length - 1] - this.xCuts[0], this.yCuts[this.yCuts.length - 1] - this.minY);
                break;
            }
            case 2: {
                first = new Rectangle2D.Double(this.xCuts[0], this.yCuts[0], this.maxX - this.xCuts[0], this.yCuts[this.yCuts.length - 1] - this.yCuts[0]);
                second = new Rectangle2D.Double(this.maxX, this.yCuts[0], this.xCuts[this.xCuts.length - 1] - this.maxX, this.yCuts[this.yCuts.length - 1] - this.yCuts[0]);
                break;
            }
            case 3: {
                first = new Rectangle2D.Double(this.xCuts[0], this.yCuts[0], this.xCuts[this.xCuts.length - 1] - this.xCuts[0], this.maxY - this.yCuts[0]);
                second = new Rectangle2D.Double(this.xCuts[0], this.maxY, this.xCuts[this.xCuts.length - 1] - this.xCuts[0], this.yCuts[this.yCuts.length - 1] - this.maxY);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return new SlicedRectangleSplit(first, second);
    }

    private static ArrayList permute(List remainingVals) {
        ArrayList<List> retval = new ArrayList<List>();
        int numVals = remainingVals.size();
        if (numVals == 1) {
            retval.add(remainingVals);
            return retval;
        }
        for (int i = 0; i < numVals; ++i) {
            ArrayList minusOne = new ArrayList(remainingVals);
            Integer takeOut = (Integer)minusOne.remove(i);
            ArrayList theRest = SlicedRectangle.permute(minusOne);
            int numRest = theRest.size();
            for (int j = 0; j < numRest; ++j) {
                ArrayList nextRest = (ArrayList)theRest.get(j);
                nextRest.add(0, takeOut);
                retval.add(nextRest);
            }
        }
        return retval;
    }

    private static List sliceDim(MinMax sliceBounds, MinMax interBounds) {
        ArrayList<Object> retval = new ArrayList<Object>();
        int sliceEval = sliceBounds.evaluate(interBounds);
        switch (sliceEval) {
            case 0: 
            case 1: 
            case 3: {
                retval.add(sliceBounds.clone());
                return retval;
            }
            case 2: {
                boolean equalMax;
                boolean equalMin = interBounds.min == sliceBounds.min;
                boolean bl = equalMax = interBounds.max == sliceBounds.max;
                if (equalMin && equalMax) {
                    throw new IllegalStateException();
                }
                if (equalMin) {
                    retval.add(new MinMax(interBounds.min, interBounds.max));
                    retval.add(new MinMax(interBounds.max, sliceBounds.max));
                } else if (equalMax) {
                    retval.add(new MinMax(sliceBounds.min, interBounds.min));
                    retval.add(new MinMax(interBounds.min, interBounds.max));
                } else {
                    retval.add(new MinMax(sliceBounds.min, interBounds.min));
                    retval.add(new MinMax(interBounds.min, interBounds.max));
                    retval.add(new MinMax(interBounds.max, sliceBounds.max));
                }
                return retval;
            }
            case 4: {
                boolean interLower;
                boolean bl = interLower = interBounds.min < sliceBounds.min;
                if (interLower) {
                    retval.add(new MinMax(interBounds.min, sliceBounds.min));
                    retval.add(new MinMax(sliceBounds.min, interBounds.max));
                    retval.add(new MinMax(interBounds.max, sliceBounds.max));
                } else {
                    retval.add(new MinMax(sliceBounds.min, interBounds.min));
                    retval.add(new MinMax(interBounds.min, sliceBounds.max));
                    retval.add(new MinMax(sliceBounds.max, interBounds.max));
                }
                return retval;
            }
        }
        throw new IllegalStateException();
    }

    public static void main(String[] argv) {
        Rectangle2D.Double toSlice = new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0);
        Rectangle2D.Double interRect = new Rectangle2D.Double(60.0, 40.0, 30.0, 20.0);
        SlicedRectangle sr = new SlicedRectangle(toSlice, interRect);
        List options = sr.getFirstSliceOptions();
        int numOpt = options.size();
        for (int i = 0; i < numOpt; ++i) {
            Integer opt = (Integer)options.get(i);
            SlicedRectangleSplit srs = sr.slice(opt);
            System.out.println("first " + srs.first);
            System.out.println("second " + srs.second);
        }
    }

    public static class SlicedRectangleSplit {
        public Rectangle2D first;
        public Rectangle2D second;

        SlicedRectangleSplit(Rectangle2D first, Rectangle2D second) {
            this.first = first;
            this.second = second;
        }
    }

    public static class SlicePlanTuple {
        List plan_;

        SlicePlanTuple(List plan) {
            this.plan_ = plan;
        }

        public Iterator getPlan() {
            return this.plan_.iterator();
        }
    }
}

