/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.FactoryUtilWhiteboard;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

public class TaggedSet
implements Cloneable {
    public static final int UNTAGGED = -1;
    public int tag;
    public HashSet set;

    public TaggedSet() {
        this.tag = -1;
        this.set = new HashSet();
    }

    public TaggedSet(int tag, Set set) {
        this.tag = tag;
        this.set = new HashSet(set);
    }

    public TaggedSet(String tag) throws IOException {
        try {
            this.tag = Integer.parseInt(tag);
        }
        catch (NumberFormatException nfe) {
            throw new IOException();
        }
        this.set = new HashSet();
    }

    public TaggedSet(TaggedSet other) {
        this.tag = other.tag;
        this.set = new HashSet(other.set);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof TaggedSet)) {
            return false;
        }
        TaggedSet otherTS = (TaggedSet)other;
        if (this.tag != otherTS.tag) {
            return false;
        }
        return this.set.equals(otherTS.set);
    }

    public int hashCode() {
        return this.set.hashCode() + this.tag;
    }

    public Object clone() {
        try {
            TaggedSet retval = (TaggedSet)super.clone();
            retval.set = (HashSet)this.set.clone();
            return retval;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public String toString() {
        return "TaggedSet: tag = " + this.tag + " set = " + this.set;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<taggedSet");
        if (this.tag != -1) {
            out.print(" tag=\"");
            out.print(this.tag);
            out.print("\" ");
        }
        if (this.set.isEmpty()) {
            out.println("/>");
            return;
        }
        out.println(">");
        ind.up().indent();
        out.println("<setMembers>");
        Iterator si = this.set.iterator();
        ind.up();
        while (si.hasNext()) {
            String mod = (String)si.next();
            ind.indent();
            out.print("<setMember id=\"");
            out.print(mod);
            out.println("\" />");
        }
        ind.down().indent();
        out.println("</setMembers>");
        ind.down().indent();
        out.println("</taggedSet>");
    }

    public static class TaggedSetMemberWorker
    extends AbstractFactoryClient {
        public TaggedSetMemberWorker(FactoryUtilWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("setMember");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            String retval = null;
            if (elemName.equals("setMember")) {
                FactoryUtilWhiteboard board = (FactoryUtilWhiteboard)this.sharedWhiteboard_;
                retval = board.currentTaggedSetMember = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private String buildFromXML(String elemName, Attributes attrs) throws IOException {
            String id = AttributeExtractor.extractAttribute(elemName, attrs, "setMember", "id", true);
            return id;
        }
    }

    public static class MyGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryUtilWhiteboard board = (FactoryUtilWhiteboard)optionalArgs;
            TaggedSet tagSet = board.currentTaggedSet;
            String tagSetMember = board.currentTaggedSetMember;
            tagSet.set.add(tagSetMember);
            return null;
        }
    }

    public static class TaggedSetWorker
    extends AbstractFactoryClient {
        public TaggedSetWorker(FactoryUtilWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("taggedSet");
            this.installWorker(new TaggedSetMemberWorker(whiteboard), new MyGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            TaggedSet retval = null;
            if (elemName.equals("taggedSet")) {
                FactoryUtilWhiteboard board = (FactoryUtilWhiteboard)this.sharedWhiteboard_;
                retval = board.currentTaggedSet = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private TaggedSet buildFromXML(String elemName, Attributes attrs) throws IOException {
            String tag = AttributeExtractor.extractAttribute(elemName, attrs, "taggedSet", "tag", false);
            return tag == null ? new TaggedSet() : new TaggedSet(tag);
        }
    }
}

