/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.Component;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.systemsbiology.biotapestry.util.ExceptionHandler;

public class TextEditor
extends JTextField
implements TableCellEditor {
    private ArrayList listeners_ = new ArrayList();
    private Object origValue_;
    private int currRow_ = -1;
    private int currColumn_ = -1;

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        try {
            this.currRow_ = row;
            this.currColumn_ = column;
            this.setText((String)value);
            table.setRowSelectionInterval(row, row);
            table.setColumnSelectionInterval(column, column);
            this.origValue_ = value;
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
        return this;
    }

    public int getCurrRow() {
        return this.currRow_;
    }

    public Object getOrigValue() {
        return this.origValue_;
    }

    public void resetValue() {
        this.setText((String)this.origValue_);
    }

    public int getCurrColumn() {
        return this.currColumn_;
    }

    public boolean entryIsValid() {
        return this.currRow_ != -1 && this.currColumn_ != -1;
    }

    public void addCellEditorListener(CellEditorListener l) {
        try {
            this.listeners_.add(l);
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public void cancelCellEditing() {
        try {
            this.editingCanceled();
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public Object getCellEditorValue() {
        String retval = null;
        try {
            retval = this.getText();
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
        return retval;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public void removeCellEditorListener(CellEditorListener l) {
        try {
            this.listeners_.remove(l);
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean stopCellEditing() {
        try {
            this.editingStopped();
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
        return true;
    }

    private void editingCanceled() {
        this.setText((String)this.origValue_);
        ChangeEvent cev = new ChangeEvent(this);
        ArrayList lCopy = new ArrayList(this.listeners_);
        Iterator lit = lCopy.iterator();
        while (lit.hasNext()) {
            CellEditorListener cel = (CellEditorListener)lit.next();
            cel.editingCanceled(cev);
        }
        this.currRow_ = -1;
        this.currColumn_ = -1;
    }

    private void editingStopped() {
        ChangeEvent cev = new ChangeEvent(this);
        ArrayList lCopy = new ArrayList(this.listeners_);
        Iterator lit = lCopy.iterator();
        while (lit.hasNext()) {
            CellEditorListener cel = (CellEditorListener)lit.next();
            cel.editingStopped(cev);
        }
        this.currRow_ = -1;
        this.currColumn_ = -1;
    }
}

