/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.TextEditor;
import org.systemsbiology.biotapestry.util.TextFinishedTracker;

public class TextEditorTracker
implements CaretListener,
CellEditorListener {
    private TextEditor textEdit_;
    private AbstractTableModel table_;
    private TextFinishedTracker finished_;

    public TextEditorTracker(TextEditor textEdit, AbstractTableModel table) {
        this(textEdit, table, null);
    }

    public TextEditorTracker(TextEditor textEdit, AbstractTableModel table, TextFinishedTracker track) {
        this.textEdit_ = textEdit;
        this.table_ = table;
        this.finished_ = track;
        this.textEdit_.addCaretListener(this);
        this.textEdit_.addCellEditorListener(this);
    }

    public void caretUpdate(CaretEvent e) {
        try {
            if (this.textEdit_.entryIsValid()) {
                int cc = this.textEdit_.getCurrColumn();
                int cr = this.textEdit_.getCurrRow();
                this.table_.setValueAt(this.textEdit_.getText(), cr, cc);
            }
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public void editingCanceled(ChangeEvent e) {
        try {
            if (this.textEdit_.entryIsValid()) {
                int cc = this.textEdit_.getCurrColumn();
                int cr = this.textEdit_.getCurrRow();
                this.table_.setValueAt(this.textEdit_.getText(), cr, cc);
            }
            return;
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
            return;
        }
    }

    public void editingStopped(ChangeEvent e) {
        try {
            int cr;
            int cc;
            if (this.finished_ != null && this.textEdit_.entryIsValid() && !this.finished_.textEditingDone(cc = this.textEdit_.getCurrColumn(), cr = this.textEdit_.getCurrRow(), this.textEdit_.getText())) {
                this.textEdit_.resetValue();
            }
            return;
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
            return;
        }
    }
}

