/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.util.List;
import org.systemsbiology.biotapestry.util.EnumCell;

public abstract class TrackingUnit {
    public abstract boolean isEnabled(int var1);

    public static class JustAValue
    extends TrackingUnit {
        private boolean overVal_;

        public JustAValue(boolean overVal) {
            this.overVal_ = overVal;
        }

        public void setOverride(boolean overVal) {
            this.overVal_ = overVal;
        }

        public boolean isEnabled(int row) {
            return this.overVal_;
        }
    }

    public static class ListTrackingUnitWithOverride
    extends ListTrackingUnit {
        private boolean overVal_;

        public ListTrackingUnitWithOverride(List aCol, int myDisableVal, boolean overVal) {
            super(aCol, myDisableVal);
            this.overVal_ = overVal;
        }

        public void setOverride(boolean overVal) {
            this.overVal_ = overVal;
        }

        public boolean isEnabled(int row) {
            if (!this.overVal_) {
                return false;
            }
            return super.isEnabled(row);
        }
    }

    public static class ListTrackingMultiValUnit
    extends TrackingUnit {
        private List myTrackedColumn_;
        private int[] myEnableVals_;

        public ListTrackingMultiValUnit(List aCol, int[] myEnableVals) {
            this.myTrackedColumn_ = aCol;
            this.myEnableVals_ = myEnableVals;
        }

        public boolean isEnabled(int row) {
            int newTrackedVal = ((EnumCell)this.myTrackedColumn_.get((int)row)).value;
            for (int i = 0; i < this.myEnableVals_.length; ++i) {
                if (newTrackedVal != this.myEnableVals_[i]) continue;
                return true;
            }
            return false;
        }
    }

    public static class ListTrackingUnit
    extends TrackingUnit {
        private List myActivityColumn_;
        private int myEnableVal_;

        public ListTrackingUnit(List aCol, int myEnableVal) {
            this.myActivityColumn_ = aCol;
            this.myEnableVal_ = myEnableVal;
        }

        public boolean isEnabled(int row) {
            int newActivity = ((EnumCell)this.myActivityColumn_.get((int)row)).value;
            return newActivity == this.myEnableVal_;
        }
    }
}

