/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.util.ArrayList;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.cmd.BTUndoCmd;
import org.systemsbiology.biotapestry.cmd.CompoundPostEventCmd2;
import org.systemsbiology.biotapestry.cmd.CompoundPreEventCmd;
import org.systemsbiology.biotapestry.event.ChangeEvent;
import org.systemsbiology.biotapestry.util.ResourceManager;

public class UndoSupport {
    private static int changeCount_ = 0;
    private ArrayList shadowEdits_;
    private CompoundEdit edit_ = new CompoundEdit();
    private CompoundPreEventCmd pre_ = new CompoundPreEventCmd();
    private CompoundPostEventCmd2 post_;
    private ArrayList preList_;
    private ArrayList postList_;
    private UndoManager undo_;

    public UndoSupport(UndoManager undo, String presentation) {
        this.post_ = new CompoundPostEventCmd2(ResourceManager.getManager().getString(presentation));
        this.preList_ = new ArrayList();
        this.postList_ = new ArrayList();
        this.shadowEdits_ = new ArrayList();
        this.edit_.addEdit(this.pre_);
        this.undo_ = undo;
    }

    public void rollback() {
        this.edit_.end();
        this.edit_.undo();
    }

    public void addEdit(BTUndoCmd edit) {
        if (edit.changesModel()) {
            ++changeCount_;
        }
        this.edit_.addEdit(edit);
    }

    public void addEdits(BTUndoCmd[] edits) {
        for (int i = 0; i < edits.length; ++i) {
            this.addEdit(edits[i]);
        }
    }

    public void addEvent(ChangeEvent event) {
        if (!this.preList_.contains(event)) {
            this.preList_.add(event);
        }
        if (!this.postList_.contains(event)) {
            this.postList_.add(event);
        }
    }

    public void addPreEvent(ChangeEvent event) {
        if (!this.preList_.contains(event)) {
            this.preList_.add(event);
        }
    }

    public void addPostEvent(ChangeEvent event) {
        if (!this.postList_.contains(event)) {
            this.postList_.add(event);
        }
    }

    public void finish() {
        this.edit_.addEdit(this.post_);
        this.pre_.addChangeEvents(this.preList_);
        this.post_.addChangeEvents(this.postList_);
        this.post_.execute();
        this.edit_.end();
        this.undo_.addEdit(this.edit_);
    }

    public static void clearTracking() {
        changeCount_ = 0;
    }

    public static boolean hasAChange() {
        return changeCount_ > 0;
    }
}

