/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;

public class UniqueLabeller
implements Cloneable {
    private TreeSet existing_;
    private HashSet legacy_;
    private boolean isNumeric_;
    private String fixedPrefix_;

    public UniqueLabeller() {
        this.existing_ = new TreeSet(new KeyComparator());
        this.legacy_ = new HashSet();
        this.isNumeric_ = true;
        this.fixedPrefix_ = null;
    }

    public UniqueLabeller(UniqueLabeller other) {
        this.existing_ = (TreeSet)other.existing_.clone();
        this.isNumeric_ = other.isNumeric_;
        this.fixedPrefix_ = other.fixedPrefix_;
        this.legacy_ = (HashSet)other.legacy_.clone();
    }

    public void setToStringKeys() {
        if (!this.existing_.isEmpty() || !this.legacy_.isEmpty()) {
            throw new IllegalStateException();
        }
        this.isNumeric_ = false;
    }

    public void setFixedPrefix(String prefix) {
        if (!this.existing_.isEmpty() || !this.legacy_.isEmpty()) {
            throw new IllegalStateException();
        }
        this.isNumeric_ = false;
        this.fixedPrefix_ = prefix;
    }

    public Object clone() {
        try {
            UniqueLabeller retval = (UniqueLabeller)super.clone();
            retval.existing_ = (TreeSet)this.existing_.clone();
            if (!(retval.existing_.comparator() instanceof KeyComparator)) {
                throw new IllegalStateException();
            }
            retval.legacy_ = (HashSet)this.legacy_.clone();
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public UniqueLabeller mappedPrefixCopy(String oldPrefix, String newPrefix) {
        UniqueLabeller retval = (UniqueLabeller)this.clone();
        if (this.fixedPrefix_ == null) {
            throw new IllegalStateException();
        }
        if (!this.legacy_.isEmpty()) {
            throw new IllegalStateException();
        }
        if (!this.fixedPrefix_.equals(oldPrefix)) {
            throw new IllegalArgumentException();
        }
        retval.fixedPrefix_ = newPrefix;
        return retval;
    }

    public boolean addExistingLabel(String label) {
        boolean retval;
        int intval = -1;
        String stringVal = null;
        if (label == null || label.trim().equals("")) {
            System.err.println("bad label " + label);
            throw new IllegalArgumentException();
        }
        if (label.toLowerCase().equals(label.toUpperCase())) {
            try {
                intval = Integer.parseInt(label);
            }
            catch (NumberFormatException nfe) {
                stringVal = label;
            }
        } else {
            stringVal = label;
        }
        if (this.fixedPrefix_ != null) {
            if (label.indexOf(this.fixedPrefix_) != 0) {
                if (!this.legacy_.contains(label)) {
                    System.err.println("label " + label + " fixedPrefix = " + this.fixedPrefix_);
                    throw new IllegalArgumentException();
                }
                return false;
            }
            label = label.substring(this.fixedPrefix_.length());
        }
        if (this.legacy_.contains(label)) {
            return false;
        }
        if (this.isNumeric_) {
            if (stringVal == null) {
                retval = this.existing_.add(new Integer(intval));
            } else {
                this.convertToAlpha();
                retval = this.existing_.add(stringVal);
            }
        } else {
            retval = this.existing_.add(label);
        }
        return retval;
    }

    public boolean addExistingLegacyLabel(String label) {
        Object stringVal = null;
        if (label == null || label.trim().equals("")) {
            System.err.println("bad label " + label);
            throw new IllegalArgumentException();
        }
        if (this.isNumeric_) {
            throw new IllegalStateException();
        }
        boolean retval = this.legacy_.add(label);
        return retval;
    }

    public boolean isEmpty() {
        return this.legacy_.isEmpty() && this.existing_.isEmpty();
    }

    public String getNextLabel() {
        boolean replaced;
        if (this.isNumeric_) {
            Integer newVal = null;
            if (this.existing_.size() == 0) {
                newVal = new Integer(0);
            } else {
                Integer highVal = (Integer)this.existing_.last();
                if (highVal == Integer.MAX_VALUE) {
                    this.convertToAlpha();
                    if (!this.legacy_.isEmpty() || this.fixedPrefix_ != null) {
                        throw new IllegalStateException();
                    }
                    String highStrVal = (String)this.existing_.last();
                    String newStrVal = UniqueLabeller.genNextAlpha(highStrVal);
                    boolean replaced2 = this.existing_.add(newStrVal);
                    if (!replaced2) {
                        throw new IllegalStateException();
                    }
                    return newStrVal;
                }
                newVal = new Integer(highVal + 1);
            }
            boolean replaced3 = this.existing_.add(newVal);
            if (!replaced3) {
                throw new IllegalStateException();
            }
            return newVal.toString();
        }
        String highVal = this.existing_.isEmpty() ? null : (String)this.existing_.last();
        String newVal = null;
        while (true) {
            String checkVal;
            newVal = UniqueLabeller.genNextAlpha(highVal);
            if (this.legacy_.isEmpty()) break;
            String string = checkVal = this.fixedPrefix_ != null ? this.fixedPrefix_ + newVal : newVal;
            if (!this.legacy_.contains(checkVal)) break;
            highVal = newVal;
        }
        if (!(replaced = this.existing_.add(newVal))) {
            System.err.println("Not replaced " + newVal);
            throw new IllegalStateException();
        }
        if (this.fixedPrefix_ != null) {
            newVal = this.fixedPrefix_ + newVal;
        }
        return newVal;
    }

    public void removeLabel(String label) {
        Integer intval;
        block13: {
            if (!this.legacy_.isEmpty() && this.legacy_.contains(label)) {
                this.legacy_.remove(label);
                return;
            }
            if (this.existing_.size() == 0) {
                return;
            }
            Object first = this.existing_.iterator().next();
            if (first instanceof Integer) {
                try {
                    intval = Integer.valueOf(label);
                    if (!this.existing_.contains(intval)) {
                        return;
                    }
                    break block13;
                }
                catch (NumberFormatException nfe) {
                    return;
                }
            }
            if (this.fixedPrefix_ != null) {
                if (label.indexOf(this.fixedPrefix_) != 0) {
                    return;
                }
                label = label.substring(this.fixedPrefix_.length());
            }
            if (!this.existing_.contains(label)) {
                return;
            }
        }
        if (this.isNumeric_) {
            try {
                intval = Integer.valueOf(label);
                this.existing_.remove(intval);
            }
            catch (NumberFormatException nfe) {
                System.err.println(this.existing_ + " " + label);
                throw new IllegalArgumentException();
            }
        } else {
            this.existing_.remove(label);
        }
    }

    public String toString() {
        return "UniqueLabeller: " + this.existing_ + " legacy = " + this.legacy_ + " isNumeric = " + this.isNumeric_ + " fixedPrefix_ = " + this.fixedPrefix_;
    }

    public static String mapKeyPrefix(String key, String oldPrefix, String newPrefix, StringBuffer buf) {
        int index;
        int startIndex = oldPrefix.length();
        if (buf == null) {
            buf = new StringBuffer();
        }
        if ((index = key.indexOf(oldPrefix)) == 0) {
            buf.setLength(0);
            buf.append(newPrefix);
            buf.append(key.substring(startIndex));
            key = buf.toString();
        }
        return key;
    }

    private void convertToAlpha() {
        if (!this.isNumeric_) {
            throw new IllegalStateException();
        }
        TreeSet<String> newSet = new TreeSet<String>(new KeyComparator());
        Iterator eit = this.existing_.iterator();
        while (eit.hasNext()) {
            Integer oldval = (Integer)eit.next();
            boolean replaced = newSet.add(oldval.toString());
            if (replaced) continue;
            throw new IllegalStateException();
        }
        this.isNumeric_ = false;
        this.existing_ = newSet;
    }

    public static String genNextAlpha(String highVal) {
        String newVal;
        if (highVal == null) {
            newVal = "A";
        } else {
            newVal = UniqueLabeller.recursiveCharBump(highVal);
            if (newVal == null) {
                newVal = UniqueLabeller.nextLonger(highVal);
            }
        }
        return newVal;
    }

    public static String nextLonger(String currHigh) {
        int currLen = currHigh.length();
        StringBuffer buf = new StringBuffer();
        for (int j = 0; j <= currLen; ++j) {
            buf.append("A");
        }
        return buf.toString();
    }

    public static String recursiveCharBump(String keyFrag) {
        StringBuffer buf = new StringBuffer();
        int fragLen = keyFrag.length();
        if (fragLen == 0) {
            return null;
        }
        char lastChar = keyFrag.charAt(fragLen - 1);
        char replaceChar = UniqueLabeller.getNextChar(lastChar);
        String currRoot = keyFrag.substring(0, fragLen - 1);
        if (replaceChar == '\u0000') {
            String newRoot = UniqueLabeller.recursiveCharBump(currRoot);
            if (newRoot == null) {
                return null;
            }
            buf.append(newRoot);
            buf.append('A');
        } else {
            buf.append(currRoot);
            buf.append(replaceChar);
        }
        return buf.toString();
    }

    public static char getNextChar(char currChar) {
        if (currChar == 'z') {
            return '\u0000';
        }
        if (currChar == 'Z') {
            return 'a';
        }
        if (!Character.isLetter(currChar)) {
            return '\u0000';
        }
        return (char)(currChar + '\u0001');
    }

    public static void main(String[] argv) {
        try {
            HashSet<String> holdLegLab = new HashSet<String>();
            HashSet<String> holdLabNew = new HashSet<String>();
            BufferedReader in = new BufferedReader(new FileReader("/users/wlongaba/tmp/justColKeys"));
            String line = null;
            while ((line = in.readLine()) != null) {
                holdLegLab.add(line.trim());
            }
            holdLegLab.add("zz_newColor_0z");
            holdLabNew.add("zz_newColor_0d");
            in.close();
            for (int j = 0; j < 80; ++j) {
                System.out.println("Reload " + j);
                UniqueLabeller lab = new UniqueLabeller();
                lab.setFixedPrefix("zz_newColor_0");
                Iterator hlit = holdLegLab.iterator();
                while (hlit.hasNext()) {
                    String nextEx = (String)hlit.next();
                    lab.addExistingLegacyLabel(nextEx);
                }
                Iterator hlnit = holdLabNew.iterator();
                while (hlnit.hasNext()) {
                    String nextEx = (String)hlnit.next();
                    lab.addExistingLabel(nextEx);
                }
                for (int i = 0; i < 50; ++i) {
                    String nextLab = lab.getNextLabel();
                    System.out.println("Next Label " + nextLab);
                    holdLabNew.add(nextLab);
                }
            }
        }
        catch (Exception ex) {
            System.err.println("Exception " + ex);
        }
    }

    static class KeyComparator
    implements Comparator {
        KeyComparator() {
        }

        public int compare(Object o1, Object o2) {
            int len2;
            if (o1 instanceof Integer && o2 instanceof Integer) {
                Integer i1 = (Integer)o1;
                Integer i2 = (Integer)o2;
                return i1.compareTo(i2);
            }
            String key1 = (String)o1;
            String key2 = (String)o2;
            int len1 = key1.length();
            if (len1 != (len2 = key2.length())) {
                return len1 < len2 ? -1 : 1;
            }
            return key1.compareTo(key2);
        }
    }
}

