/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UrlRetrievalWorkerClient;

public class UrlRetrievalWorker
implements Runnable {
    private String myResult_ = "";
    private UrlRetrievalWorkerClient client_;
    private String theUrl_;

    public UrlRetrievalWorker(String theUrl, UrlRetrievalWorkerClient client) {
        this.client_ = client;
        this.theUrl_ = theUrl;
    }

    public void run() {
        try {
            this.myResult_ = this.getStringFromServer(this.theUrl_);
        }
        catch (IOException ex) {
            ResourceManager rMan = ResourceManager.getManager();
            String format = rMan.getString("urlPlug.ioError");
            this.myResult_ = MessageFormat.format(format, this.theUrl_);
        }
        catch (Throwable oom) {
            ResourceManager rMan = ResourceManager.getManager();
            String format = rMan.getString("urlPlug.otherError");
            this.myResult_ = MessageFormat.format(format, this.theUrl_, oom.getMessage());
        }
        this.client_.retrievedResult(this.theUrl_, this.myResult_);
    }

    private String getStringFromServer(String urlString) throws IOException {
        StringBuffer buf = new StringBuffer();
        URL theUrl = new URL(urlString);
        HttpURLConnection urlConnection = (HttpURLConnection)theUrl.openConnection();
        BufferedReader br = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
        String nextLine = null;
        while ((nextLine = br.readLine()) != null) {
            buf.append(nextLine);
        }
        return UiUtil.stripper(buf.toString());
    }
}

