/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.systemsbiology.biotapestry.util.UiUtil;

public class Vector2D
implements Cloneable {
    public static final double TOLERANCE = 1.0E-6;
    public static final int NOT_CANONICAL = -1;
    public static final int NORTH = 0;
    public static final int EAST = 1;
    public static final int SOUTH = 2;
    public static final int WEST = 3;
    private double x_;
    private double y_;

    public Vector2D(double x, double y) {
        this.x_ = x;
        this.y_ = y;
    }

    public Vector2D(Vector2D other) {
        this.x_ = other.x_;
        this.y_ = other.y_;
    }

    public Vector2D(Point2D start, Point2D end) {
        this.x_ = end.getX() - start.getX();
        this.y_ = end.getY() - start.getY();
    }

    public Object clone() {
        try {
            Vector2D retval = (Vector2D)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public double getX() {
        return this.x_;
    }

    public double getY() {
        return this.y_;
    }

    public Vector2D normalized() {
        double len = Math.sqrt(this.dot(this));
        return len == 0.0 ? new Vector2D(0.0, 0.0) : new Vector2D(this.x_ / len, this.y_ / len);
    }

    public Vector2D normal() {
        boolean zy;
        boolean zx = Math.abs(this.x_) < 1.0E-6;
        boolean bl = zy = Math.abs(this.y_) < 1.0E-6;
        if (zx && zy) {
            return null;
        }
        if (zx) {
            return new Vector2D(this.y_ > 0.0 ? -1.0 : 1.0, 0.0);
        }
        if (zy) {
            return new Vector2D(0.0, this.x_ > 0.0 ? 1.0 : -1.0);
        }
        return new Vector2D(-(this.y_ / this.x_), 1.0).normalized();
    }

    public double dot(Vector2D other) {
        return this.x_ * other.x_ + this.y_ * other.y_;
    }

    public double length() {
        return Math.sqrt(this.dot(this));
    }

    public double lengthSq() {
        return this.dot(this);
    }

    public void scale(double factor) {
        this.x_ *= factor;
        this.y_ *= factor;
    }

    public Vector2D scaled(double factor) {
        Vector2D retval = new Vector2D(this);
        retval.scale(factor);
        return retval;
    }

    public Point2D add(Point2D start) {
        return new Point2D.Double(this.x_ + start.getX(), this.y_ + start.getY());
    }

    public Vector2D add(Vector2D start) {
        return new Vector2D(this.x_ + start.x_, this.y_ + start.y_);
    }

    public boolean isZero() {
        boolean zx = Math.abs(this.x_) < 0.01;
        boolean zy = Math.abs(this.y_) < 0.01;
        return zx && zy;
    }

    public Vector2D canonical() {
        if (Math.abs(this.x_) >= Math.abs(this.y_)) {
            return new Vector2D(this.x_, 0.0);
        }
        return new Vector2D(0.0, this.y_);
    }

    public boolean isCanonical() {
        boolean zx = this.x_ == 0.0;
        boolean zy = this.y_ == 0.0;
        return !(!zx && !zy || zx && zy);
    }

    public int canonicalDir() {
        if (!this.isCanonical()) {
            return -1;
        }
        if (this.x_ > 0.0) {
            return 1;
        }
        if (this.x_ < 0.0) {
            return 3;
        }
        if (this.y_ > 0.0) {
            return 2;
        }
        if (this.y_ < 0.0) {
            return 0;
        }
        throw new IllegalStateException();
    }

    public Vector2D quantizeBigger(double gridSize) {
        double x = this.x_ > 0.0 ? Math.ceil(this.x_ / gridSize) : Math.floor(this.x_ / gridSize);
        double y = this.y_ > 0.0 ? Math.ceil(this.y_ / gridSize) : Math.floor(this.y_ / gridSize);
        return new Vector2D(x * gridSize, y * gridSize);
    }

    public String toString() {
        return "Vector2D: x = " + this.x_ + " y = " + this.y_;
    }

    public void forceToGrid(double size) {
        this.x_ = UiUtil.forceToGridValue(this.x_, size);
        this.y_ = UiUtil.forceToGridValue(this.y_, size);
    }

    public void setXY(double x, double y) {
        this.x_ = x;
        this.y_ = y;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Vector2D)) {
            return false;
        }
        Vector2D otherVec = (Vector2D)other;
        return this.x_ == otherVec.x_ && this.y_ == otherVec.y_;
    }

    public int hashCode() {
        return (int)Math.round(this.x_ + this.y_);
    }

    public Vector2D doTransform(AffineTransform trans) {
        Point2D.Double hacko = new Point2D.Double(this.x_, this.y_);
        trans.transform(hacko, hacko);
        return new Vector2D(((Point2D)hacko).getX(), ((Point2D)hacko).getY());
    }

    public static boolean canonicalsAreOrtho(int oneCanon, int twoCanon) {
        if (oneCanon == -1 || twoCanon == -1) {
            throw new IllegalArgumentException();
        }
        switch (oneCanon) {
            case 1: 
            case 3: {
                return twoCanon == 0 || twoCanon == 2;
            }
            case 0: 
            case 2: {
                return twoCanon == 1 || twoCanon == 3;
            }
        }
        throw new IllegalArgumentException();
    }
}

