/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.Rectangle;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.Note;
import org.systemsbiology.biotapestry.nav.NavTree;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.NamedOutputStreamSource;

public class WebPublisher {
    public void printHTML(NamedOutputStreamSource streamSrc, Map boundsMap, boolean skipRoot, String topID) throws IOException {
        OutputStream stream = streamSrc.getNamedStream("BTLauncher.html");
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(stream, "UTF-8")));
        out.println("<html>");
        out.println("<head>");
        out.println("<title>BioTapestry Browser</title>");
        out.println("<script language=\"JavaScript\">");
        out.println(" function getHeight() {");
        out.println("   return window.screen.availHeight * .90;");
        out.println("  }");
        out.println("  function getWidth() {");
        out.println("     return window.screen.availWidth * .95;");
        out.println("   }");
        out.println("  </script>");
        out.println(" </head>");
        out.println(" <body>");
        out.println(" <a href=\"\" onclick=\"brwin = window.open('suIndex.html', 'urchinHtmlWin','width=' + getWidth() + ',height=' + getHeight() + ',resizable=yes,scrollbars=no'); brwin.focus(); return false;\">Browse BioTapestry Network</a>");
        out.println("  </body>");
        out.println("</html>");
        out.close();
        stream = streamSrc.getNamedStream("suIndex.html");
        out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(stream, "UTF-8")));
        out.println("<html>");
        out.println("  <head>");
        out.println("    <title>BioTapestry Browser</title>");
        out.println("  </head>");
        out.println("  <frameset rows=\"38,*,67\">");
        out.println("    <frame src=\"toolbar.html\" scrolling=\"no\" noresize=\"1\" frameborder=\"0\" />");
        out.println("    <frameset cols=\"280, *\">");
        out.println("      <frame src=\"suTreeSmall.html\" name=\"tree_frame\" scrolling=\"yes\" frameborder=\"1\" />");
        out.print("      <frame src=\"");
        out.print(topID);
        out.println("Small.png\" name=\"view_frame\" scrolling=\"yes\" frameborder=\"1\" />");
        out.println("    </frameset>");
        out.print("    <frame src=\"");
        out.print(topID);
        out.println("Message.html\" name=\"msgFrame\" scrolling=\"no\" noresize=\"1\" frameborder=\"0\" />");
        out.println("  </frameset>");
        out.println("</html>");
        out.close();
        this.writeTreeHTML(streamSrc, 0, skipRoot);
        this.writeTreeHTML(streamSrc, 1, skipRoot);
        this.writeTreeHTML(streamSrc, 2, skipRoot);
        this.writeTreeHTML(streamSrc, 3, skipRoot);
        this.writeMessageHTML(streamSrc, skipRoot);
        this.writeImageWrapperHTML(streamSrc, boundsMap, skipRoot);
        this.writeToolbarHTML(streamSrc, topID);
        this.writeNotesHTML(streamSrc, skipRoot);
    }

    private void writeTreeHTML(NamedOutputStreamSource streamSrc, int size, boolean skipRoot) throws IOException {
        OutputStream stream = streamSrc.getNamedStream("suTree" + ModelScale.getSizeTag(size) + ".html");
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(stream, "UTF-8")));
        out.println("<html>");
        out.println("  <head>");
        out.println("    <script Language=\"JavaScript\">");
        out.println("      function getPathRoot() {");
        out.println("        var fullpath = window.location.pathname;");
        out.println("        var pos = fullpath.lastIndexOf('/');");
        out.println("        if (pos < 0) {");
        out.println("          return ('');");
        out.println("        } else {");
        out.println("          return (fullpath.substr(0, pos + 1));");
        out.println("        }");
        out.println("      }");
        out.println("    </script>");
        out.println("  </head>");
        out.println("  <body>");
        out.println("    <font face=\"Arial, Helvetica, sans-serif\" size=\"2\">");
        Database db = Database.getDB();
        NavTree navTree = db.getNavTree();
        List ordered = navTree.getPreorderListing(skipRoot);
        Iterator oit = ordered.iterator();
        boolean first = true;
        while (oit.hasNext()) {
            String gkey = (String)oit.next();
            Genome currGenome = db.getGenome(gkey);
            if (first) {
                first = false;
                out.print("<nobr>&nbsp;&nbsp;");
            } else {
                out.print("<br/><nobr>&nbsp;&nbsp;");
            }
            out.print("<a href=\"");
            out.print(gkey);
            out.print(ModelScale.getSizeTag(size));
            out.print("Image.html\" target=\"view_frame\" ");
            out.print("onclick=\"top.msgFrame.location.pathname = getPathRoot() + '");
            out.print(gkey);
            out.print("Message.html'; ");
            out.print("top.frames[0].currentView='");
            out.print(gkey);
            out.print("'; return true;\">");
            out.print(CharacterEntityMapper.mapEntities(currGenome.getName(), false));
            out.print("</a>");
            out.println("</nobr>");
        }
        out.println("    </font>");
        out.println("  </body>");
        out.println("</html>");
        out.close();
    }

    private void writeMessageHTML(NamedOutputStreamSource streamSrc, boolean skipRoot) throws IOException {
        Database db = Database.getDB();
        NavTree navTree = db.getNavTree();
        List ordered = navTree.getPreorderListing(skipRoot);
        Iterator oit = ordered.iterator();
        while (oit.hasNext()) {
            String gkey = (String)oit.next();
            Genome currGenome = db.getGenome(gkey);
            String description = currGenome.getDescription();
            String show = description == null ? "" : description;
            OutputStream stream = streamSrc.getNamedStream(gkey + "Message.html");
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(stream, "UTF-8")));
            out.println("<html>");
            out.println("  <body>");
            out.println(show);
            out.println("  </body>");
            out.println("</html>");
            out.close();
        }
    }

    private void writeImageWrapperHTML(NamedOutputStreamSource streamSrc, Map boundsMap, boolean skipRoot) throws IOException {
        Database db = Database.getDB();
        NavTree navTree = db.getNavTree();
        List ordered = navTree.getPreorderListing(skipRoot);
        Iterator oit = ordered.iterator();
        while (oit.hasNext()) {
            String gkey = (String)oit.next();
            for (int i = 0; i < 4; ++i) {
                ModelScale key = new ModelScale(gkey, i);
                Map bounds = (Map)boundsMap.get(key);
                OutputStream stream = streamSrc.getNamedStream(gkey + ModelScale.getSizeTag(i) + "Image.html");
                PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(stream, "UTF-8")));
                out.println("<html>");
                out.println("  <head>");
                out.println("    <script Language=\"JavaScript\">");
                out.println("      function getPathRoot() {");
                out.println("        var fullpath = window.location.pathname;");
                out.println("        var pos = fullpath.lastIndexOf('/');");
                out.println("        if (pos < 0) {");
                out.println("          return ('');");
                out.println("        } else {");
                out.println("          return (fullpath.substr(0, pos + 1));");
                out.println("        }");
                out.println("      }");
                out.println("    </script>");
                out.println("  </head>");
                out.println("  <body>");
                out.print("    <img src=\"");
                out.print(key.getFileName());
                out.println("\" usemap=\"#notesMap\" border=0 />");
                out.println("    <map name=\"notesMap\">");
                Iterator noit = bounds.keySet().iterator();
                while (noit.hasNext()) {
                    String name = (String)noit.next();
                    Rectangle rect = (Rectangle)bounds.get(name);
                    int maxX = rect.x + rect.width;
                    int maxY = rect.y + rect.height;
                    out.print("      <area shape=rect coords=\"");
                    out.print(rect.x);
                    out.print(",");
                    out.print(rect.y);
                    out.print(",");
                    out.print(maxX);
                    out.print(",");
                    out.print(maxY);
                    out.print("\" ");
                    out.print("onclick=\"top.msgFrame.location.pathname = getPathRoot() + '");
                    out.print(gkey);
                    out.print("Note");
                    out.print(name);
                    out.print(".html'; return true;\">");
                }
                out.println("    </map>");
                out.println("  </body>");
                out.println("</html>");
                out.close();
            }
        }
    }

    private void writeToolbarHTML(NamedOutputStreamSource streamSrc, String topID) throws IOException {
        OutputStream stream = streamSrc.getNamedStream("toolbar.html");
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(stream, "UTF-8")));
        out.println("<html>");
        out.println("  <head>");
        out.println("    <script Language=\"JavaScript\">");
        out.println("      function getPathRoot() {");
        out.println("        var fullpath = window.location.pathname;");
        out.println("        var pos = fullpath.lastIndexOf('/');");
        out.println("        if (pos < 0) {");
        out.println("          return ('');");
        out.println("        } else {");
        out.println("          return (fullpath.substr(0, pos + 1));");
        out.println("        }");
        out.println("      }");
        out.println();
        out.print("      currentView = \"");
        out.print(topID);
        out.println("\";");
        out.println();
        out.println("      function toSmall() {");
        out.println("        top.frames[3].location.pathname = getPathRoot() + currentView + 'Message.html';");
        out.println("        top.frames[1].location.pathname = getPathRoot() + 'suTreeSmall.html';");
        out.println("        top.frames[2].location.pathname = getPathRoot() + currentView + 'SmallImage.html';");
        out.println("        return true;");
        out.println("      }");
        out.println("      function toMedium() {");
        out.println("        top.frames[3].location.pathname = getPathRoot() + currentView + 'Message.html';");
        out.println("        top.frames[1].location.pathname = getPathRoot() + 'suTreeMedium.html';");
        out.println("        top.frames[2].location.pathname = getPathRoot() + currentView + 'MediumImage.html';");
        out.println("        return true;");
        out.println("      }");
        out.println("      function toLarge() {");
        out.println("        top.frames[3].location.pathname = getPathRoot() + currentView + 'Message.html';");
        out.println("        top.frames[1].location.pathname = getPathRoot() + 'suTreeLarge.html';");
        out.println("        top.frames[2].location.pathname = getPathRoot() + currentView + 'LargeImage.html';");
        out.println("        return true;");
        out.println("      }");
        out.println("      function toJumbo() {");
        out.println("        top.frames[3].location.pathname = getPathRoot() + currentView + 'Message.html';");
        out.println("        top.frames[1].location.pathname = getPathRoot() + 'suTreeJumbo.html';");
        out.println("        top.frames[2].location.pathname = getPathRoot() + currentView + 'JumboImage.html';");
        out.println("        return true;");
        out.println("      }");
        out.println("    </script>");
        out.println("  </head>");
        out.println("  <body bgcolor=\"#CCCCCC\" >");
        out.println("    <form>");
        out.println("     <input type=\"button\" value=\"Small\" onclick=\"toSmall();\" />");
        out.println("     <input type=\"button\" value=\"Medium\"  onclick=\"toMedium();\" />");
        out.println("     <input type=\"button\" value=\"Large\"  onclick=\"toLarge();\" />");
        out.println("     <input type=\"button\" value=\"Extra Large\"  onclick=\"toJumbo();\" />");
        out.println("   </form>");
        out.println("  </body>");
        out.println("</html>");
        out.close();
    }

    private void writeNotesHTML(NamedOutputStreamSource streamSrc, boolean skipRoot) throws IOException {
        Database db = Database.getDB();
        NavTree navTree = db.getNavTree();
        List ordered = navTree.getPreorderListing(skipRoot);
        Iterator oit = ordered.iterator();
        while (oit.hasNext()) {
            String gkey = (String)oit.next();
            Genome currGenome = db.getGenome(gkey);
            if (!(currGenome instanceof GenomeInstance)) continue;
            GenomeInstance gi = (GenomeInstance)currGenome;
            Iterator noit = gi.getNoteIterator();
            while (noit.hasNext()) {
                Note note = (Note)noit.next();
                if (!note.isInteractive()) continue;
                OutputStream stream = streamSrc.getNamedStream(gkey + "Note" + note.getID() + ".html");
                PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(stream, "UTF-8")));
                out.println("<html>");
                out.println("  <body>");
                out.println(CharacterEntityMapper.mapEntities(note.getTextWithBreaksReplaced(), false));
                out.println("  </body>");
                out.println("</html>");
                out.close();
            }
        }
    }

    public static class ModelScale
    implements Cloneable {
        public static final int SMALL = 0;
        public static final int MEDIUM = 1;
        public static final int LARGE = 2;
        public static final int JUMBO = 3;
        public static final int NUM_SIZES = 4;
        private String modelID_;
        private int size_;

        public ModelScale(String modelID, int size) {
            this.modelID_ = modelID;
            this.size_ = size;
        }

        public String getModelID() {
            return this.modelID_;
        }

        public int getSize() {
            return this.size_;
        }

        public Object clone() {
            try {
                ModelScale retval = (ModelScale)super.clone();
                return retval;
            }
            catch (CloneNotSupportedException cnse) {
                throw new IllegalStateException();
            }
        }

        public int hashCode() {
            return this.modelID_.hashCode() + this.size_;
        }

        public String toString() {
            return "ModelScale: modelID = " + this.modelID_ + " size = " + this.size_;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof ModelScale)) {
                return false;
            }
            ModelScale otherMS = (ModelScale)other;
            if (this.size_ != otherMS.size_) {
                return false;
            }
            return this.modelID_.equals(otherMS.modelID_);
        }

        public String getFileName() {
            return this.modelID_ + ModelScale.getSizeTag(this.size_) + ".png";
        }

        public static String getSizeTag(int size) {
            switch (size) {
                case 0: {
                    return "Small";
                }
                case 1: {
                    return "Medium";
                }
                case 2: {
                    return "Large";
                }
                case 3: {
                    return "Jumbo";
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

